

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_isMemberOfGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- ----------------------------------------------------------------------
--
--           Stored procedure to check if an user is part of a
--           user group. Will consider the 3 way association of
--           domain user -> domain user group -> local user group
--           also. This can be called from cpp also.
--
--
--           Authors: saggarwal and jswaminathan
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_isMemberOfGroup <<<'

IF EXISTS (select * from sysobjects where name='sec_isMemberOfGroup')
	drop procedure sec_isMemberOfGroup
IF EXISTS (select * from GxQscripts where name='sec_isMemberOfGroup')
	delete from GxQscripts where name = 'sec_isMemberOfGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_isMemberOfGroup')
	delete from GXDBVersions where aliasname = 'sec_isMemberOfGroup'
GO
print '... Creating Procedure: sec_isMemberOfGroup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_isMemberOfGroup
  @i_userId integer,
  @i_groupId integer,
  @o_isMemberOfGroup integer OUTPUT,
  @shouldReturnValue integer = 0
AS
SET NOCOUNT ON
  DECLARE @outputVariable INT
SET @o_isMemberOfGroup = 0
IF EXISTS ( SELECT     UMGroups.id
				FROM UMGroups INNER JOIN UMUserGroup ON UMGroups.id = UMUserGroup.groupId
				WHERE UMUserGroup.userId = @i_userId  AND UMGroups.id = @i_groupId )
		SET @o_isMemberOfGroup = 1
if(@o_isMemberOfGroup = 0)
BEGIN
	IF EXISTS (	SELECT   DISTINCT  UMGroups.id
				FROM      UMGroups INNER JOIN
						  UMDSGroupMaps ON UMGroups.id = UMDSGroupMaps.umgroupId INNER JOIN
						  UMDSUserGroup ON UMDSGroupMaps.umDSgroupId = UMDSUserGroup.groupId
				WHERE     UMDSUserGroup.userId  = @i_userId  AND UMGroups.id = @i_groupId )
		SET @o_isMemberOfGroup = 1
END
IF @shouldReturnValue <> 0
	SELECT @o_isMemberOfGroup
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sec_isMemberOfGroup')
	delete from GxQscripts where name = 'sec_isMemberOfGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_isMemberOfGroup')
	delete from GXDBVersions where aliasname = 'sec_isMemberOfGroup'
GO

insert into GXDBVersions values(2, 'sec_isMemberOfGroup',  '00000000000000000000', 'sec_isMemberOfGroup', '00000000000000000000')
GO

