

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_isGUILoginDisabled.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- ----------------------------------------------------------------------
--
--          Stored procedure to check if Login is diabled for given user
--          Login can be diabled only for non-admin users.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_isGUILoginDisabled <<<'

IF EXISTS (select * from sysobjects where name='sec_isGUILoginDisabled')
	drop procedure sec_isGUILoginDisabled
IF EXISTS (select * from GxQscripts where name='sec_isGUILoginDisabled')
	delete from GxQscripts where name = 'sec_isGUILoginDisabled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_isGUILoginDisabled')
	delete from GXDBVersions where aliasname = 'sec_isGUILoginDisabled'
GO
print '... Creating Procedure: sec_isGUILoginDisabled'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_isGUILoginDisabled
  @userId INT
AS
  DECLARE @isGUILoginDisabled INT = 0
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @isAdminUser INT = 0
	IF EXISTS(select 1 from APP_AdvanceSettings with (nolock)
        WHERE ((entityId  =   @userId
AND entityType  =   13)
	OR 	(entityId  =   2 -- Commcell Id
AND entityType  =   3))
        AND keyName     =   N'bDisableGUILogin'
        AND relativePath=   N'CommServDB.Console'
        AND deleted     =   0
        AND enabled     =   1
	AND value 	LIKE	N'true')
	BEGIN
EXEC sec_checkPermissionOnEntity @userId, 107, @isAdminUser OUTPUT, 1, 2 -- CommCell Id
        IF @isAdminUser = 0
			SET @isGUILoginDisabled = 1
	END
	SELECT @isGUILoginDisabled AS isGUILOginDisabled
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sec_isGUILoginDisabled')
	delete from GxQscripts where name = 'sec_isGUILoginDisabled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_isGUILoginDisabled')
	delete from GXDBVersions where aliasname = 'sec_isGUILoginDisabled'
GO

insert into GXDBVersions values(2, 'sec_isGUILoginDisabled',  '00000000000000000000', 'sec_isGUILoginDisabled', '00000000000000000000')
GO

