

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_isBlackListedUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- ----------------------------------------------------------------------
--
--           Stored procedure to check if an user is part of a
--           BlackListed user group. Will consider the 3 way association of
--           domain user -> domain user group -> local user group
--           also.
--
--
--           Authors: saggarwal and jswaminathan
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_isBlackListedUser <<<'

IF EXISTS (select * from sysobjects where name='sec_isBlackListedUser')
	drop procedure sec_isBlackListedUser
IF EXISTS (select * from GxQscripts where name='sec_isBlackListedUser')
	delete from GxQscripts where name = 'sec_isBlackListedUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_isBlackListedUser')
	delete from GXDBVersions where aliasname = 'sec_isBlackListedUser'
GO
print '... Creating Procedure: sec_isBlackListedUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_isBlackListedUser
  @i_userId integer,
  @o_isBlackListedUser integer OUTPUT
AS
SET NOCOUNT ON
BEGIN
	SET @o_isBlackListedUser = 0
	IF EXISTS ( SELECT 1 FROM UMUserGroup UG
					INNER JOIN UMGroups G WITH(NOLOCK)
						ON UG.groupId = G.id
WHERE (G.groupFlags & CAST(0x20000 AS INTEGER)) > 0
					AND UG.userId = @i_userId )
			SET @o_isBlackListedUser = 1
	if(@o_isBlackListedUser = 0)
	BEGIN
		IF EXISTS (	SELECT   DISTINCT  UMGroups.id
					FROM      UMGroups INNER JOIN
							  UMDSGroupMaps ON UMGroups.id = UMDSGroupMaps.umgroupId INNER JOIN
							  UMDSUserGroup ON UMDSGroupMaps.umDSgroupId = UMDSUserGroup.groupId
					WHERE     UMDSUserGroup.userId  = @i_userId
AND		(UMGroups.groupFlags & CAST(0x20000 AS INTEGER)) > 0 )
			SET @o_isBlackListedUser = 1
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_isBlackListedUser')
	delete from GxQscripts where name = 'sec_isBlackListedUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_isBlackListedUser')
	delete from GXDBVersions where aliasname = 'sec_isBlackListedUser'
GO

insert into GXDBVersions values(2, 'sec_isBlackListedUser',  '00000000000000000000', 'sec_isBlackListedUser', '00000000000000000000')
GO

