

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_insertSecurityAssociation.sp] ---------- 

-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
--	| 	Procedure : "sec_insertSecurityAssociation.sp"
--	|	Description: This is just to insert a given row into UMSecurityAssociations table. This is written because we dont want
--	|				 any application layer code to insert directly into UMSecurityAssociations table. If they want to do it, they
--	|				 can call this SP - THIS SHOULD NOT BE CALLED FOR CREATORS. This is only for classic security associations.
--	|
--	|
--	|
--	|	Author: saggarwal & jswaminathan
-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_insertSecurityAssociation <<<'

IF EXISTS (select * from sysobjects where name='sec_insertSecurityAssociation')
	drop procedure sec_insertSecurityAssociation
IF EXISTS (select * from GxQscripts where name='sec_insertSecurityAssociation')
	delete from GxQscripts where name = 'sec_insertSecurityAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_insertSecurityAssociation')
	delete from GXDBVersions where aliasname = 'sec_insertSecurityAssociation'
GO
print '... Creating Procedure: sec_insertSecurityAssociation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_insertSecurityAssociation
  @callerId INT,						
  @roleId INT,						
  @permissionsList NVARCHAR(MAX),		
  @userID INT,
  @userGroupId INT,
  @errorCode INT OUTPUT,					
  @errorString NVARCHAR(MAX) OUTPUT,
  @entityType1 INT,							
  @entityId1 INT,
  @entityType2 INT = 0,
  @entityId2 INT = 0,
  @entityType3 INT = 0,
  @entityId3 INT = 0,
  @entityType4 INT = 0,
  @entityId4 INT = 0,
  @entityType5 INT = 0,
  @entityId5 INT = 0
AS
	DECLARE @permissionTable TABLE (permissionId INT)
	IF @permissionsList <> ''
	BEGIN
		IF CHARINDEX(',', @permissionsList, LEN(@permissionsList)) = 0
		SET @permissionsList = @permissionsList + ','
		DECLARE @delimPos INT = CHARINDEX(',', @permissionsList, 1)
		WHILE @delimPos > 0
		BEGIN
			INSERT INTO @permissionTable
				SELECT LTRIM(RTRIM(SUBSTRING(@permissionsList, 1, @delimPos-1)))
			SET @permissionsList = SUBSTRING(@permissionsList, @delimPos+1, LEN(@permissionsList))
			SET @delimPos = CHARINDEX(',', @permissionsList, 1)
		END
	END
	BEGIN TRY
		IF @roleId <> 0
		BEGIN
			IF NOT EXISTS (SELECT roleId
						   FROM UMSecurityAssociations
						   WHERE (((isUser = 1 AND @userId <> 0 AND userOrGroupId = @userId) OR
								  (isUser = 0 AND @userGroupId <> 0 AND userOrGroupId = @userGroupId))
								  AND
								  (roleId = @roleID)
								  AND
								  (entityType1 = @entityType1 AND entityId1 = @entityId1
								  AND entityType2 = @entityType2 AND entityId2 = @entityId2
								  AND entityType3 = @entityType3 AND entityId3 = @entityId3
								  AND entityType4 = @entityType4 AND entityId4 = @entityId4
								  AND entityType5 = @entityType5 AND entityId5 = @entityId5 AND isCreator = 0)))
			BEGIN
				INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, isROleAllowed, propagateToChildObjects, roleValidityDate, timeZone, exclude, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll, iscreator, authorId)
					SELECT @roleId, 0,
						   CASE WHEN @userId <> 0 THEN @userId ELSE @userGroupId END,
						   CASE WHEN @userID <> 0 THEN 1 ELSE 0 END,
						   1, 1, 0, 0, 0,
						   @entityType1, @entityID1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5,
						   0, 0, CASE WHEN @callerID <> 0 THEN @callerId ELSE 1 END
			END
		END
		ELSE
		BEGIN
			INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, isROleAllowed, propagateToChildObjects, roleValidityDate, timeZone, exclude, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll, iscreator, authorId)
				SELECT 0, permissionId,
						   CASE WHEN @userId <> 0 THEN @userId ELSE @userGroupId END,
						   CASE WHEN @userID <> 0 THEN 1 ELSE 0 END,
						   1, 1, 0, 0, 0,
						   @entityType1, @entityID1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5,
						   0, 0, CASE WHEN @callerID <> 0 THEN @callerId ELSE 1 END
				FROM @permissionTable
				WHERE permissionId NOT IN (SELECT permissionId
											FROM UMSecurityAssociations
											WHERE (((isUser = 1 AND @userId <> 0 AND userOrGroupId = @userId) OR
												  (isUser = 0 AND @userGroupId <> 0 AND userOrGroupId = @userGroupId))
												  AND
												  (permissionId <> 0)
												  AND
												  (entityType1 = @entityType1 AND entityId1 = @entityId1
												  AND entityType2 = @entityType2 AND entityId2 = @entityId2
												  AND entityType3 = @entityType3 AND entityId3 = @entityId3
												  AND entityType4 = @entityType4 AND entityId4 = @entityId4
												  AND entityType5 = @entityType5 AND entityId5 = @entityId5 AND isCreator = 0)))
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER()
		SET @errorString = ERROR_MESSAGE()
	END CATCH
EXIT_PROC:
GO

IF EXISTS (select * from GxQscripts where name = 'sec_insertSecurityAssociation')
	delete from GxQscripts where name = 'sec_insertSecurityAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_insertSecurityAssociation')
	delete from GXDBVersions where aliasname = 'sec_insertSecurityAssociation'
GO

insert into GXDBVersions values(2, 'sec_insertSecurityAssociation',  '00000000000000000000', 'sec_insertSecurityAssociation', '00000000000000000000')
GO

