

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_insertAuditSession.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
------------------------------------------------------------------------------
set nocount on
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_insertAuditSession')
BEGIN
	print '>>> Drop Stored Procedure: sec_insertAuditSession <<<'
	drop procedure sec_insertAuditSession
END
IF EXISTS (select * from GxQscripts where name='sec_insertAuditSession')
	delete from GxQscripts where name = 'sec_insertAuditSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_insertAuditSession')
	delete from GXDBVersions where aliasname = 'sec_insertAuditSession'
GO
print '... Creating Procedure: sec_insertAuditSession'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_insertAuditSession
  @i_xml XML
AS
	-- Get values
	DECLARE @sessionId nvarchar(255)
	DECLARE @userId int
	DECLARE @logoutTime bigint
	DECLARE @consoleType int
	DECLARE @host nvarchar(64)
	DECLARE @remark nvarchar(512)
	DECLARE @browserSessionId int
	DECLARE @location nvarchar(2048)
	select @sessionId = Req.ref.value('@sessionId', 'nvarchar(255)') from @i_xml.nodes('/Api_SessionAudit') Req(ref)
	IF @sessionId is NULL or @sessionID = ''
		BEGIN
			set @sessionId =concat('EMC', newID())
		END
	select @userId = Req.ref.value('@userId', 'int') from @i_xml.nodes('/Api_SessionAudit/user') Req(ref)
IF @userId = -20
		RETURN
	select @logoutTime = Req.ref.value('@logoutTime', 'bigint') from @i_xml.nodes('/Api_SessionAudit') Req(ref)
	select @consoleType = Req.ref.value('@consoleType', 'int') from @i_xml.nodes('/Api_SessionAudit') Req(ref)
	select @host = Req.ref.value('@host', 'nvarchar(64)') from @i_xml.nodes('/Api_SessionAudit') Req(ref)
	select @remark = Req.ref.value('@description', 'nvarchar(512)') from @i_xml.nodes('/Api_SessionAudit') Req(ref)
	select @browserSessionId = Req.ref.value('@browserSessionId', 'nvarchar(512)') from @i_xml.nodes('/Api_SessionAudit') Req(ref)
	select @location = Req.ref.value('@location', 'nvarchar(MAX)') from @i_xml.nodes('/Api_SessionAudit') Req(ref)
	-- Insert into table
	Merge UMSessionAudit as target
	Using (select @sessionId, @userId, @logoutTime, @consoleType, @host, @remark, @browserSessionId, @location) as source(sessionId, userId, logoutTime, consoleType, host, remark, browserSessionId, location)
	ON target.sessionId = source.sessionId
	When matched then -- Update broswerSessionId if different.
		update set browserSessionId = source.browserSessionId, location = CASE WHEN source.location is not null and source.location != '' THEN source.location Else target.location END
	when not matched then
		Insert(sessionId, userId, createdTime, logoutTime, consoleType, host, remark, browserSessionId, location, flag)
		values(Source.sessionId, source.userId, dbo.GetUnixTime(GetUTCDate()), source.logoutTime, source.consoleType, source.host, source.remark, source.browserSessionId, source.location,0);
GO


IF EXISTS (select * from GxQscripts where name = 'sec_insertAuditSession')
	delete from GxQscripts where name = 'sec_insertAuditSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_insertAuditSession')
	delete from GXDBVersions where aliasname = 'sec_insertAuditSession'
GO

insert into GXDBVersions values(2, 'sec_insertAuditSession',  '00000000000000000000', 'sec_insertAuditSession', '00000000000000000000')
GO

