

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_impersonateResellerAsCompanyUser.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
--  +===================================================================================+
--  |		Name: sec_impersonateResellerAsCompanyUser.sp
--  |		Description: This is called when operator switches from one company to another.
--	|					 It will get the impersonated company user's details for the original
--	|					 user. It also does a sanity check that the original user is a
--	|					 operator for this company. Just so that no one hacks via REST API.
--	|					 First time, it will generate the company user to impersonate.
--	|					 Output: Company user's Id, name, GUID, host name of original token.
--  |
--  |		Author: jswaminathan
--  +===================================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_impersonateResellerAsCompanyUser')
BEGIN
	print '>>> Drop Stored Procedure: sec_impersonateResellerAsCompanyUser <<<'
	drop procedure sec_impersonateResellerAsCompanyUser
END
IF EXISTS (select * from GxQscripts where name='sec_impersonateResellerAsCompanyUser')
	delete from GxQscripts where name = 'sec_impersonateResellerAsCompanyUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_impersonateResellerAsCompanyUser')
	delete from GXDBVersions where aliasname = 'sec_impersonateResellerAsCompanyUser'
GO
print '... Creating Procedure: sec_impersonateResellerAsCompanyUser'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_impersonateResellerAsCompanyUser
  @originalSessionGUID VARCHAR(MAX),
  @companyId INT,
  @localeId INT = 0
AS
  DECLARE @companyUserId INT = 0
  DECLARE @companyUserLogin VARCHAR(MAX) = ''
  DECLARE @companyUserGUID VARCHAR(1024) = ''
  DECLARE @companyUserEmail VARCHAR(MAX) = ''
  DECLARE @originalTokenHostName VARCHAR(MAX) = ''
  DECLARE @errorCode INT
  DECLARE @errorString VARCHAR(1024) 
SET @errorCode = 0
SET @errorString = ''
DECLARE @originalUserId INT = 0, @companyUserEnabled INT = 0
SELECT @originalUserId = userId
	  ,@originalTokenHostName = hostName
FROM UMQSDKSessions (NOLOCK)
WHERE
	GUID = @originalSessionGUID
-- New design: Different Operators might have different role on their company.
-- See if this user is configured as operator for this company and get his operator roles.
-- Do all this in one call. Do not query once to check if he is operator and then again to get his roles.
BEGIN
	IF @originalUserId = 0
	BEGIN
SET @errorCode = (2741 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = (SELECT message FROM EvLocaleMsgs (NOLOCK) WHERE messageId = @errorCode AND localeId = @localeId)
		GOTO PROC_EXIT
	END
	IF OBJECT_ID('tempdb.dbo.#rolesTbl') IS NOT NULL
		DROP TABLE #rolesTbl
	CREATE TABLE #rolesTbl
	(
		roleId INT PRIMARY KEY
	);
	IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') IS NOT NULL
		DROP TABLE #getMemberUserGroupsHelperOutputTbl
	CREATE TABLE #getMemberUserGroupsHelperOutputTbl
	(
		isUser INT,
		userOrGroupID INT,
		UNIQUE CLUSTERED (isUser, userOrGroupId)
	);
	EXEC sec_getMemberUserGroupsHelper @originalUserId
	-- Check if he is Master group member. If so, he gets Tenant Operator role implicitly on the company.
	DECLARE @masterGroupId INT = dbo.getMasterGroupId()
	IF EXISTS (SELECT 1 FROM #getMemberUserGroupsHelperOutputTbl WHERE isUser = 0 AND userOrGroupId = @masterGroupId)
	BEGIN
DECLARE @tenantOperatorRoleId INT = ISNULL((SELECT TOP 1 id FROM UMRoles (NOLOCK) WHERE (flags & 512 <> 0)), 0)
		IF @tenantOperatorRoleId <> 0
			INSERT INTO #rolesTbl
				VALUES (@tenantOperatorRoleId)
	END
	-- Get all the roles that his / group has on the company via explicit operator association.
	BEGIN
		INSERT INTO #rolesTbl
			SELECT DISTINCT roleId
			FROM UMOperators (NOLOCK) UMO
				INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
					ON UMO.isUser = UG.isUser AND UMO.userOrGroupId = UG.userOrGroupId
			WHERE
				UMO.companyId = @companyId
				AND NOT EXISTS (SELECT TOP 1 roleId FROM #rolesTbl R WHERE R.roleID = UMO.roleId)
	END
	-- User is an operator if there is some role present in this temp table. If not, he is not an operator.
	IF NOT EXISTS (SELECT TOP 1 roleId FROM #rolesTbl)
	BEGIN
SET @errorCode = (3763 | (CAST(POWER(2, 24) AS BIGINT) * 35))					-- User [^1%s] is not configured as operator for company [^2%s].
		SET @errorString = (SELECT message FROM EvLocaleMsgs (NOLOCK) WHERE messageId = @errorCode AND localeId = @localeId)
		SET @errorString = REPLACE(@errorString, '^1%s', (SELECT TOP 1 login FROM UMUsers (NOLOCK) WHERE id = @originalUserId))
		SET @errorString = REPLACE(@errorString, '^2%s', (SELECT TOP 1 domainName FROM UMDSProviders (NOLOCK) WHERE id = @companyId))
		GOTO PROC_EXIT
	END
END
-- Get the impersonation user account for this original commvault use account.
SET @companyUserId = dbo.sec_getImpersonationUserIdForReseller(@originalUserId, @companyId)
IF @companyUserId <> 0 AND @companyUserId IS NOT NULL		-- User already there. Just get his details.
BEGIN
	SELECT @companyUserLogin = login
		   ,@companyUserGUID = userGUID
		   ,@companyUserEmail = email
		   ,@companyUserEnabled = enabled
	FROM UMUsers U (NOLOCK)
	WHERE
		U.id = @companyUserId
	IF @companyUserEnabled = 0		-- Until SP22, when deactivating company, this user got disabled. So enable him.
	BEGIN
		UPDATE UMUsers
		SET enabled = 1
		WHERE
			id = @companyUserId
	END
END
ELSE		-- If this is the first time this user is switching to this company, then the hidden user account is to be created.
BEGIN		-- Moving all this logic from "Set Commvault User as Reseller for Company" stored procedure to here.
	DECLARE @companyName VARCHAR(MAX),
			@companyUserName VARCHAR(MAX),
			@nowTime INT = dbo.getUnixTime(GETUTCDATE())
	SELECT @companyName = domainName
	FROM UMDSProviders (NOLOCK)
	WHERE
		id = @companyID
	-- Pull the original user information and set the same for this new user except login.
	SELECT @companyUserLogin = @companyName + '\' + login + '_Operator'
		   ,@companyUserName = name
		   ,@companyUserEmail = email
	FROM UMUsers (NOLOCK)
	WHERE
		id = @originalUserId
	IF NOT EXISTS (SELECT 1 FROM UMUsers WHERE login = @companyUserLogin)
		INSERT INTO UMUsers (name, description, login, password, email, datePasswordSet, dateExpires, policy, enabled, flags, modified, pVer, pager,
							lastLoginTime, credSetTime, umdsProviderId, userGUID, origUserGUID, origCCID, salt)
				VALUES(@companyUserName		-- name
					,'Reseller user mapped to local user:'+CAST(@originalUserId AS VARCHAR(10))		-- description
					,@companyUserLogin			-- login
					,'9' + CAST(NEWID() AS VARCHAR(512))	-- password
					,@companyUserEmail	-- email
					,@nowTime	-- datePasswordSet
					,0		-- dateExpires
					,0		-- policy
					,1		-- enabled			(When reseller user logs in, we internally login as this user. So he needs to be enabled for logging in. GetUserInfo checks on enabled = 1.)
,CAST(0x8000 AS INT) | CAST(0x004 AS INT) | CAST(0x2000 AS INT)	-- 40964	-- flags
					,0		-- modified
					,50		-- pVer
					,NULL	-- pager
					,0		-- lastLoginTime
					,0		-- credSetTime
					,@companyId		-- umdsProviderId
					,NEWID()		-- userGUID
					,''				-- origUserGUID
					,2				-- origCCID
					,''				-- salt
					)
	ELSE			-- Mostly this case will not be hit. If by any chance, there is already another user with the same name, (say a stale entry which was not properly deleted when his original user deleted)
		UPDATE UMUsers					-- just reuse that Id.
SET flags = flags | (CAST(0x8000 AS INT) | CAST(0x004 AS INT) | CAST(0x2000 AS INT))	-- 40964
		WHERE
			login = @companyUserLogin
	SELECT @companyUserId = id
		   ,@companyUserGUID = userGUID
	FROM UMUsers (NOLOCK)
	WHERE
		login = @companyUserLogin
	-- Link him to the original user.
	IF NOT EXISTS (SELECT 1
				   FROM UMUsersProp (NOLOCK)
				   WHERE
componentNameId = @companyUserId AND attrName = 'Original Reseller User Id' AND modified = 0)					-- 'Original Reseller User Id'
	BEGIN
		INSERT INTO UMUsersProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@companyUserId, 'Original Reseller User Id', 7, @originalUserId, @nowTime, 0)
	END
	ELSE
	BEGIN
		UPDATE UMUsersProp
		SET attrVal = @originalUserId
		WHERE
componentNameId = @companyUserId AND attrName = 'Original Reseller User Id' AND modified = 0								-- 'Original Reseller User Id'
	END
	-- Make him part of tenant operator group.
	DECLARE @tenantOperatorGroupId INT
	SELECT @tenantOperatorGroupId = id
	FROM UMGroups (NOLOCK)
	WHERE
		umdsProviderId = @companyId
AND groupFlags & 0x40000 <> 0				-- 0x40000
	IF NOT EXISTS (SELECT 1
				  FROM UMUserGRoup (NOLOCK)
				  WHERE
					userID = @companyUserID
					AND groupId = @tenantOperatorGroupId)
	INSERT INTO UMUserGroup (userId, groupId, flag)
		VALUES (@companyUserId, @tenantOperatorGroupId, 0)
END
-- Associate the roles (in roles temp table) with this hidden impersonation user on the company.
-- Check once if there is any change before doing so. Operator association is not going to change often.
IF EXISTS (SELECT TOP 1 R.roleID
		   FROM #rolesTbl R
				LEFT JOIN UMSecurityAssociations Sec (NOLOCK)
					ON Sec.roleId = R.roleId
					AND Sec.isUser = 1
					AND Sec.userOrGroupId = @companyUserID
AND Sec.entityType1 = 61
					AND Sec.entityId1 = @companyId
		   WHERE
				Sec.roleId IS NULL)
BEGIN
	INSERT INTO UMSecurityAssociations (isUser, userOrGroupId, roleId, entityType1, entityId1, authorId)
		SELECT 1,
			   @companyUserId,
			   R.roleId,
61,
			   @companyId,
			   @originalUserId
		FROM #rolesTbl R
			LEFT JOIN UMSecurityAssociations Sec (NOLOCK)
				ON Sec.isUser = 1
				AND Sec.userOrGroupId = @companyUserID
				AND Sec.roleId = R.roleId
AND Sec.entityType1 = 61
				AND Sec.entityId1 = @companyId
		WHERE
			Sec.roleId IS NULL
END
-- If there are any other roles apart from the ones in roles temp table, (may be from previous associations?) remove them.
IF EXISTS (SELECT TOP 1 Sec.roleID
		   FROM UMSecurityAssociations Sec (NOLOCK)
				LEFT JOIN #rolesTbl R
					ON Sec.roleId = R.roleId
		   WHERE
				R.roleId IS NULL
				AND Sec.isUser = 1
				AND Sec.userOrGroupId = @companyUserID
AND Sec.entityType1 = 61
				AND Sec.entityId1 = @companyId)
BEGIN
	DELETE Sec
	FROM UMSecurityAssociations Sec
		LEFT JOIN #rolesTbl R
			ON Sec.roleId = R.roleId
	WHERE
		Sec.isUser = 1
		AND Sec.userOrGroupId = @companyUserID
AND Sec.entityType1 = 61
		AND Sec.entityId1 = @companyId
		AND R.roleId IS NULL
END
PROC_EXIT:
	SELECT @companyUserId as companyUserId,
		   @companyUserLogin as companyUserLogin,
		   @companyUserGUID as companyUserGUID,
		   @companyUserEmail as companyUserEmail,
		   @originalTokenHostName as originalTokenHostName,
		   @errorCode as errorCode,
		   @errorString as errorString
GO

IF EXISTS (select * from GxQscripts where name = 'sec_impersonateResellerAsCompanyUser')
	delete from GxQscripts where name = 'sec_impersonateResellerAsCompanyUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_impersonateResellerAsCompanyUser')
	delete from GXDBVersions where aliasname = 'sec_impersonateResellerAsCompanyUser'
GO

insert into GXDBVersions values(2, 'sec_impersonateResellerAsCompanyUser',  '00000000000000000000', 'sec_impersonateResellerAsCompanyUser', '00000000000000000000')
GO

