

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_iDaNodeAccess.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_iDaNodeAccess.sp,v $ $Id: sec_iDaNodeAccess.sp,v 1.19.34.5 2018/03/20 00:30:31 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_iDaNodeAccess()
--  |
--  | Description:  Determines whether a user is associated with a group
--	|				that can see a chosen iDa object.
--  |
--  |       Input:  integer Affiliation: Bit map representation of which
--	|				affiliations are requested
--	|
--  |      Output:  Returns list of groups that can see the object
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--	|	1.1        skatz	Created from getSecurityNodeAccess.cur revision 1.8
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_iDaNodeAccess <<<'

IF EXISTS (select * from sysobjects where name='sec_iDaNodeAccess')
	drop procedure sec_iDaNodeAccess
IF EXISTS (select * from GxQscripts where name='sec_iDaNodeAccess')
	delete from GxQscripts where name = 'sec_iDaNodeAccess'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_iDaNodeAccess')
	delete from GXDBVersions where aliasname = 'sec_iDaNodeAccess'
GO
print '... Creating Procedure: sec_iDaNodeAccess'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_iDaNodeAccess
  @uid integer,
  @commcellParam integer,
  @clientparam integer,
  @appTypeParam integer,
  @instanceParam integer,
  @backupsetParam integer,
  @subClientParam integer
AS
  DECLARE @userId integer
  DECLARE @nodeCapabilites bigint
  DECLARE @childCapabilites bigint
  SET NOCOUNT ON
  declare @returnVal			integer
  declare @nodeCapabilities		bigint
  declare @childCapabilities	bigint
  declare @flag					integer
  SET @returnVal			= 0													-- Assume no Access
  SET @nodeCapabilities		= 0													-- THIS WILL BE WHERE Capability Bits ARE "OR-ED"
  SET @childCapabilities	= 0													-- THIS WILL BE WHERE Capability Bits ARE "OR-ED"
--  ---------------------------------------------------
--	-- Fetch "Scoped" List of Objects for this user --
--  ---------------------------------------------------
IF OBJECT_ID('tempdb.dbo.#sec_iDaNodeAccessTbl') IS NOT NULL
    DROP TABLE #sec_iDaNodeAccessTbl
CREATE TABLE #sec_iDaNodeAccessTbl
(
    permissionId INT
)
IF OBJECT_ID('tempdb.dbo.#sec_iDaNodeAccessChildTbl') IS NOT NULL
    DROP TABLE #sec_iDaNodeAccessChildTbl
CREATE TABLE #sec_iDaNodeAccessChildTbl
(
    permissionId INT
)
DECLARE @entityType1 INT = 3
DECLARE @entityType2 INT =0
DECLARE @entityType3 INT =0
DECLARE @entityType4 INT =0
DECLARE @entityType5 INT =0
IF(@appTypeParam<>0 OR @subclientParam<>0)
SET @entityType2=  4
IF(@instanceParam<>0 OR @subclientParam<>0)
SET @entityType3= 5
IF(@backupsetParam<>0 OR @subclientParam<>0)
SET @entityType4= 6
IF(@subclientParam<>0)
SET @entityType5=7
	if( @subclientParam <>0 )   --IN some REST APIs , instanceId is not set for getting capabiliteis on subclient. So its preventive fix. MR  179831
	BEGIN
		DECLARE @tempclientParam INT
		DECLARE @tempapptypeParam INT
		DECLARE @tempbackupSetParam INT
		DECLARE @tempInstanceParam INT
		IF(@clientParam =0 OR @appTypeParam=0 OR	@instanceParam=0 OR @backupsetParam=0)
			SELECT @tempclientParam=clientId,@tempapptypeParam=appTypeId,@tempbackupSetParam=backupSet, @tempInstanceParam = instance from APP_application WITH(NOLOCK) where id=@subclientParam
		IF(@clientParam=0)
			SET @clientParam=@tempClientParam
		IF(@appTypeParam=0)
			SET @appTypeParam=@tempapptypeParam
		IF(@instanceParam=0)
			SET @instanceParam=@tempInstanceParam
		IF(@backupsetParam=0)
			SET @backupsetParam=@tempbackupSetParam
	END
exec sec_getPermissionsOnEntity  '#sec_iDaNodeAccessTbl',@uid,@entityType1,@clientparam,@entityType2,@apptypeParam,@entityType3,@instanceParam,@entityType4,@backupsetParam,@entityType5,@subclientParam
IF(@subclientParam=0) -- we need to get inhertied associations too.
	exec sec_getPermissionsOnEntity  '#sec_iDaNodeAccessChildTbl',@uid,@entityType1,@clientparam,@entityType2,@apptypeParam,@entityType3,@instanceParam,@entityType4,@backupsetParam,@entityType5,@subclientParam,1
	SET @nodeCapabilities= ISNULL((SELECT SUM(DISTINCT CASE WHEN (permissionId<=64) THEN POWER(2.0,permissionId-1)
ELSE POWER(2.0,31 -1)
													END)
											FROM #sec_iDaNodeAccessTbl),0)
	SET @childCapabilities = ISNULL((SELECT SUM(DISTINCT CASE WHEN (permissionId<=64) THEN POWER(2.0,permissionId-1)
ELSE POWER(2.0,31 -1)
													END)
											FROM #sec_iDaNodeAccessChildTbl),0)
	SET @childCapabilities= @childCapabilities &(~@nodeCapabilities)
	IF EXISTS (Select * from #sec_iDaNodeAccessTbl) OR EXISTS ( SELECT 1 FROM #sec_iDaNodeAccessChildTbl)
	   SET @returnVal = @uid
	 SELECT @returnVal AS 'userId', @nodeCapabilities as 'nodeCapabilities', @childCapabilities as 'childCapabilities'
  SET @nodeCapabilities		= 0													-- THIS WILL BE WHERE Capability Bits ARE "OR-ED"
  SET @childCapabilities	= 0													-- THIS WILL BE WHERE Capability Bits ARE "OR-ED"
-- CLEAN UP!
	DROP TABLE #sec_iDaNodeAccessChildTbl
	DROP TABLE #sec_iDaNodeAccessTbl
	set nocount off
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sec_iDaNodeAccess')
	delete from GxQscripts where name = 'sec_iDaNodeAccess'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_iDaNodeAccess')
	delete from GXDBVersions where aliasname = 'sec_iDaNodeAccess'
GO

insert into GXDBVersions values(2, 'sec_iDaNodeAccess',  '00010019003400050000', 'sec_iDaNodeAccess', '00010019003400050000')
GO

