

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_hideADGroupsInUpgrade.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--		Script for schedule policy permissions upgrade
--		This script assigns all permissions under "schedule policy" category to the
--		creators of schedule policies
--
-- ------------------------------------------------------------------------------------------------------*/
--  +====================================================================================================================================+
--  |   Procedure: sec_hideADGroupsInUpgrade
--  |
--  |	Description: Upgrade script to set GF_GROUP_HIDE_GUI flag for UMDSGroups that are not mapped to local Simpana groups and not Client Owner User Groups
--  |
--  |
--	|	Authors: jswaminathan
--	|
--  +====================================================================================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_hideADGroupsInUpgrade <<<'

IF EXISTS (select * from sysobjects where name='sec_hideADGroupsInUpgrade')
	drop procedure sec_hideADGroupsInUpgrade
IF EXISTS (select * from GxQscripts where name='sec_hideADGroupsInUpgrade')
	delete from GxQscripts where name = 'sec_hideADGroupsInUpgrade'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_hideADGroupsInUpgrade')
	delete from GXDBVersions where aliasname = 'sec_hideADGroupsInUpgrade'
GO
print '... Creating Procedure: sec_hideADGroupsInUpgrade'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_hideADGroupsInUpgrade
  @errorCode INTEGER = 0 OUTPUT,
  @errorString NVARCHAR(1024) = '' OUTPUT
AS
SET NOCOUNT ON
BEGIN TRY
	IF OBJECT_ID ('tempdb.dbo.#visibleExternalGroups') IS NOT NULL
		DROP TABLE #visibleExternalGroups
	CREATE TABLE #visibleExternalGroups (externalGroupId INT)
	INSERT INTO #visibleExternalGroups
		SELECT G.id
		FROM UMGroups G INNER JOIN UMDSGroupMaps GM
		ON G.id = GM.umDSgroupId
		UNION
		SELECT userOrGroupId
		FROM UMOwners
		WHERE isUser = 0
	UPDATE UMGroups
SET groupFlags = groupFlags | 0x0020													--GF_GROUP_HIDE_GUI: 0x0020
	WHERE id NOT IN (SELECT externalGroupId FROM #visibleExternalGroups)
AND umdsProviderId IN (SELECT id FROM UMDSProviders WHERE serviceType = 2)				--UMDS_PROVIDER_ACTIVE_DIR: 2
AND groupFlags & 0x0001 <> 0					--Let us do only for Enabled groups. Deleted groups are anyways deleted.
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = ERROR_MESSAGE()
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_hideADGroupsInUpgrade')
	delete from GxQscripts where name = 'sec_hideADGroupsInUpgrade'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_hideADGroupsInUpgrade')
	delete from GXDBVersions where aliasname = 'sec_hideADGroupsInUpgrade'
GO

insert into GXDBVersions values(2, 'sec_hideADGroupsInUpgrade',  '00000000000000000000', 'sec_hideADGroupsInUpgrade', '00000000000000000000')
GO

