

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getVcloudUserGroupProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2013  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   sec_getVcloudUserGroupProp.sp - Given a login, returns the number of vcloud Groups the user is associated to and the vcloud properties for first user group.
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getVcloudUserGroupProp <<<'

IF EXISTS (select * from sysobjects where name='sec_getVcloudUserGroupProp')
	drop procedure sec_getVcloudUserGroupProp
IF EXISTS (select * from GxQscripts where name='sec_getVcloudUserGroupProp')
	delete from GxQscripts where name = 'sec_getVcloudUserGroupProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getVcloudUserGroupProp')
	delete from GXDBVersions where aliasname = 'sec_getVcloudUserGroupProp'
GO
print '... Creating Procedure: sec_getVcloudUserGroupProp'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getVcloudUserGroupProp
--size for input(i_login) is defined as per the 'login' column in UMUsers table
  @i_login nvarchar(512) = ''
AS
  DECLARE @o_nVcloudGroups integer;
  DECLARE @o_userId integer;
  DECLARE @o_userGuid nvarchar(512);
  DECLARE @o_email nvarchar(512);
  DECLARE @o_externalAuthenticationUrl nvarchar(max);
  DECLARE @o_externalTokenValidationUrl nvarchar(max);
BEGIN
	SET ANSI_NULLS ON
	SET NOCOUNT ON
	SET @o_nVcloudGroups = 0
	SET @o_userGuid = ''
	SET @o_email = ''
	SET @o_externalAuthenticationUrl = ''
	SET @o_externalTokenValidationUrl = ''
	SET @o_userId = ISNULL((SELECT id FROM UMUSers WITH (NOLOCK) WHERE login = @i_login), 0)
	IF @o_userId <> 0
	BEGIN
		SELECT @o_userGuid = ISNULL(userGuid, ''), @o_email = ISNULL(email, '') FROM UMUsers WHERE id = @o_userId
		SET @o_nVcloudGroups = (SELECT COUNT(*) FROM UMUserGroup Grp
													INNER JOIN UMGroupsProp GrpProp
														ON Grp.groupId = GrpProp.componentNameId
													WHERE Grp.userId = @o_userId
														AND GrpProp.attrName = 'Vcloud'
														AND GrpProp.attrVal = '1')
		IF @o_nVcloudGroups > 0
		BEGIN
			DECLARE @vcloudUserGroupId integer = (SELECT TOP 1 Grp.groupId FROM UMUserGroup Grp
																	INNER JOIN UMGroupsProp GrpProp
																		ON Grp.groupId = GrpProp.componentNameId
																	WHERE Grp.userId = @o_userId
																		AND GrpProp.attrName = 'Vcloud'
																		AND GrpProp.attrVal = '1'
																	ORDER BY GrpProp.created)
			SET @o_externalAuthenticationUrl = ISNULL((SELECT attrVal FROM UMGroupsProp WHERE componentNameId = @vcloudUserGroupId
																							AND attrName = 'External Authentication URL'), '')
			SET @o_externalTokenValidationUrl = ISNULL((SELECT attrVal FROM UMGroupsProp WHERE componentNameId = @vcloudUserGroupId
																							AND attrName = 'External Token Validation URL'), '')
		END
	END
	SELECT @o_nVcloudGroups, @o_userId, @o_userGuid, @o_email, @o_externalAuthenticationUrl, @o_externalTokenValidationUrl
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getVcloudUserGroupProp')
	delete from GxQscripts where name = 'sec_getVcloudUserGroupProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getVcloudUserGroupProp')
	delete from GXDBVersions where aliasname = 'sec_getVcloudUserGroupProp'
GO

insert into GXDBVersions values(2, 'sec_getVcloudUserGroupProp',  '00000000000000000000', 'sec_getVcloudUserGroupProp', '00000000000000000000')
GO

