

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getUsersOfGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "sec_getUsersOfGroup"                                   |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getUsersOfGroup <<<'

IF EXISTS (select * from sysobjects where name='sec_getUsersOfGroup')
	drop procedure sec_getUsersOfGroup
IF EXISTS (select * from GxQscripts where name='sec_getUsersOfGroup')
	delete from GxQscripts where name = 'sec_getUsersOfGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUsersOfGroup')
	delete from GXDBVersions where aliasname = 'sec_getUsersOfGroup'
GO
print '... Creating Procedure: sec_getUsersOfGroup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getUsersOfGroup
  @i_groupId integer,
  @i_includeFlags integer,
  @i_excludeFlags integer,
  @i_LocalOrExternalUser integer
AS
  DECLARE @userId integer
SET NOCOUNT ON
if (@i_LocalOrExternalUser <> 1 AND @i_LocalOrExternalUser <> 2)
	SET @i_LocalOrExternalUser = 3
	SELECT U.id userId
	FROM UMUsers U
	WHERE
			U.flags & @i_excludeFlags = 0
		AND U.flags & @i_includeFlags <> 0
		AND (
				(@i_LocalOrExternalUser <> 1 AND @i_LocalOrExternalUser <> 2) --Both Local User and External User
			 OR (@i_LocalOrExternalUser = 1 AND U.umDSproviderId = 0) --Local User Only
			 OR	(@i_LocalOrExternalUser = 2 AND U.umDSproviderId <> 0) --External User Only
			)
		AND (
			U.id IN (
						SELECT  DISTINCT   UMUserGroup.userId
						FROM UMUserGroup WHERE UMUserGroup.groupId = @i_groupId
					)
			OR
			U.id IN (
						SELECT     DISTINCT UMDSUserGroup.userId
										FROM         UMDSGroupMaps INNER JOIN
										UMDSUserGroup ON UMDSGroupMaps.umDSgroupId = UMDSUserGroup.groupId
										WHERE UMDSGroupMaps.umgroupId = @i_groupId
					)
		)
	ORDER BY U.id
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getUsersOfGroup')
	delete from GxQscripts where name = 'sec_getUsersOfGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUsersOfGroup')
	delete from GXDBVersions where aliasname = 'sec_getUsersOfGroup'
GO

insert into GXDBVersions values(2, 'sec_getUsersOfGroup',  '00000000000000000000', 'sec_getUsersOfGroup', '00000000000000000000')
GO

