

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getUsersInCompany.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +===========================================================================+
--  |   Procedure:  sec_getUsersInCompany()
--  |
--  | Description:  If the input userId is a tenant admin,
--	|				gets the list of users in his company.
--  |
--  |       Input:  userId
--  |
--  |      Output:  userId list is populataed in #getUsersInCompanyOutputTbl
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author				Description
--  |   ---------  -------------------	-------------
--  |   1.1        Jawahar Ragunathan   Initial Edit
--  +===========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getUsersInCompany')
BEGIN
	print '>>> Drop Stored Procedure: sec_getUsersInCompany <<<'
	drop procedure sec_getUsersInCompany
END
IF EXISTS (select * from GxQscripts where name='sec_getUsersInCompany')
	delete from GxQscripts where name = 'sec_getUsersInCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUsersInCompany')
	delete from GXDBVersions where aliasname = 'sec_getUsersInCompany'
GO
print '... Creating Procedure: sec_getUsersInCompany'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getUsersInCompany
  @i_userId INT
AS
SET NOCOUNT ON
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	-- Caller should mandatorily pass output table. Else raise exception.
	IF OBJECT_ID('tempdb.dbo.#getUsersInCompanyOutputTbl') IS NULL
	BEGIN
		RAISERROR('Error. Output table for stored proc sec_getUsersInCompany is not yet created',
				16,
				1
				)
		RETURN
	END
	DECLARE @companyId INT = 0
	DECLARE @umGroupId INT = 0
	SELECT @companyId = dbo.AppGetOrganizationForUser(@i_userId)
SELECT @umGroupId = id FROM UMGroups WHERE umdsProviderId = @companyId AND groupFlags & 0x10000 <> 0
	IF (@companyId > 0 AND @umGroupId > 0 AND EXISTS(SELECT 1 FROM UMUserGroup WHERE userId = @i_userId AND groupId = @umGroupId))
	BEGIN
		;WITH tblChild AS
		(
			SELECT id FROM UMDSProviders WHERE id = @companyId
			UNION ALL
			SELECT UMDSProviders.id FROM UMDSProviders INNER JOIN tblChild ON UMDSProviders.ownerCompany = tblChild.Id
		)
		INSERT INTO #getUsersInCompanyOutputTbl
		SELECT DISTINCT U.id FROM UMUsers U INNER JOIN tblChild T ON U.umdsProviderId = T.id
	END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getUsersInCompany')
	delete from GxQscripts where name = 'sec_getUsersInCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUsersInCompany')
	delete from GXDBVersions where aliasname = 'sec_getUsersInCompany'
GO

insert into GXDBVersions values(2, 'sec_getUsersInCompany',  '00000000000000000000', 'sec_getUsersInCompany', '00000000000000000000')
GO

