

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getUsersForUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "sec_getUsersForUser"                                   |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getUsersForUser <<<'

IF EXISTS (select * from sysobjects where name='sec_getUsersForUser')
	drop procedure sec_getUsersForUser
IF EXISTS (select * from GxQscripts where name='sec_getUsersForUser')
	delete from GxQscripts where name = 'sec_getUsersForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUsersForUser')
	delete from GXDBVersions where aliasname = 'sec_getUsersForUser'
GO
print '... Creating Procedure: sec_getUsersForUser'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getUsersForUser
  @i_userId integer,
  @i_isRestrictedViewEnabled integer,
  @i_forModification integer,
  @i_includeFlags integer,
  @i_excludeFlags integer,
  @i_LocalOrExternalUser integer
AS
  DECLARE @userId integer
SET NOCOUNT ON
if (@i_LocalOrExternalUser <> 1 AND @i_LocalOrExternalUser <> 2)
	SET @i_LocalOrExternalUser = 3
DECLARE @canManageAllUsers int = 0
	EXEC sec_canManageAllUsers @i_userId, @canManageAllUsers OUTPUT
DECLARE @IsHideEnabled int = 0
IF @canManageAllUsers = 0 AND @i_forModification = 0
	EXEC sec_isHideEnabled @i_userId, @i_isRestrictedViewEnabled, @IsHideEnabled OUTPUT
IF @canManageAllUsers <> 0	or
	(@i_forModification = 0 AND @IsHideEnabled = 0)
BEGIN
	SELECT U.id
	FROM UMUsers U
	WHERE
			U.flags & @i_excludeFlags = 0
		AND U.flags & @i_includeFlags <> 0
		AND (
				(@i_LocalOrExternalUser <> 1 AND @i_LocalOrExternalUser <> 2) --Both Local User and External User
			 OR (@i_LocalOrExternalUser = 1 AND U.umDSproviderId = 0) --Local User Only
			 OR	(@i_LocalOrExternalUser = 2 AND U.umDSproviderId <> 0) --External User Only
			)
	ORDER BY U.id
END
ELSE
BEGIN
	DECLARE @LocalGroups TABLE (groupId INT)
	INSERT INTO @LocalGroups
		EXEC sec_getLocalUserGroupsOfUser @i_userId
	SELECT U.id
	FROM UMUsers U
	WHERE
			U.flags & @i_excludeFlags = 0
		AND U.flags & @i_includeFlags <> 0
		AND (
				(@i_LocalOrExternalUser <> 1 AND @i_LocalOrExternalUser <> 2) --Both Local User and External User
			 OR (@i_LocalOrExternalUser = 1 AND U.umDSproviderId = 0) --Local User Only
			 OR	(@i_LocalOrExternalUser = 2 AND U.umDSproviderId <> 0) --External User Only
			)
		AND ( U.id = @i_userId
				OR
				U.id IN (
								SELECT  DISTINCT   UMUserGroup.userId
								FROM UMUserGroup
								INNER JOIN @LocalGroups ON UMUserGroup.groupId =[@LocalGroups].groupId
								INNER JOIN
(SELECT groupId FROM UMGroupCapability WHERE capabilityId = 14
								UNION
								SELECT id AS groupId from UMGroups WHERE allCapabilities = 1) T ON T.groupId = UMUserGroup.groupId
							)
				OR U.id IN (
							SELECT     DISTINCT UMDSUserGroup.userId
								FROM         UMDSGroupMaps INNER JOIN
								UMDSUserGroup ON UMDSGroupMaps.umDSgroupId = UMDSUserGroup.groupId
								INNER JOIN @LocalGroups ON UMDSGroupMaps.umgroupId = [@LocalGroups].groupId
								INNER JOIN
(SELECT groupId FROM UMGroupCapability WHERE capabilityId = 14
								UNION
								SELECT id AS groupId from UMGroups WHERE allCapabilities = 1) T ON T.groupId = UMDSGroupMaps.umgroupId
							)
			)
	ORDER BY U.id
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getUsersForUser')
	delete from GxQscripts where name = 'sec_getUsersForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUsersForUser')
	delete from GXDBVersions where aliasname = 'sec_getUsersForUser'
GO

insert into GXDBVersions values(2, 'sec_getUsersForUser',  '00000000000000000000', 'sec_getUsersForUser', '00000000000000000000')
GO

