

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getUsersForThisUserWrapper.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  sec_getUsersForThisUserWrapper()
--  |
--  | Description:   wrapper for sec_getUSersForThisUser
--	|
--  |		Fetches a list of users this callerId can see / edit
--	|
--  |
--  |       Input:  callerId, forModification, localOrExternalUsers, excludeFlags, includeFlags
--	|
--	|		forModification if set to 1, only those users whom the caller can edit will be fetched
--  |		forModification if set to 0, all the users whom the caller is associated will be fetched
--	|
--  |      Output:  List of users
--  |      Return:  xxx
--  |
--  |		THINGS TO DO FURTHER: Handling of restricted view enabled users
--  |
--  |   Author
--  |   ---------
--	|	saggarwal & jswaminathan
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getUsersForThisUserWrapper <<<'

IF EXISTS (select * from sysobjects where name='sec_getUsersForThisUserWrapper')
	drop procedure sec_getUsersForThisUserWrapper
IF EXISTS (select * from GxQscripts where name='sec_getUsersForThisUserWrapper')
	delete from GxQscripts where name = 'sec_getUsersForThisUserWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUsersForThisUserWrapper')
	delete from GXDBVersions where aliasname = 'sec_getUsersForThisUserWrapper'
GO
print '... Creating Procedure: sec_getUsersForThisUserWrapper'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getUsersForThisUserWrapper
  @callerId INT, 
  @forModification INT = 0,						
  @localOrExternalUser INT = 3,					
  @excludeFlags INT = 0,					
  @includeFlags INT = 1
AS
  DECLARE @userId INTEGER
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#sec_getUsersForThisUserWrapperTbl') IS NOT NULL
	DROP TABLE #sec_getUsersForThisUserWrapperTbl
CREATE TABLE #sec_getUsersForThisUserWrapperTbl
(
	userId INT
)
EXEC sec_getUsersForThisUser '#sec_getUsersForThisUserWrapperTbl',@callerId,@forModification,@localOrExternalUser,@excludeFlags,@includeFlags
SELECT userId FROM #sec_getUsersForThisUserWrapperTbl
IF OBJECT_ID('tempdb.dbo.#sec_getUsersForThisUserWrapperTbl') IS NOT NULL
	DROP TABLE #sec_getUsersForThisUserWrapperTbl
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getUsersForThisUserWrapper')
	delete from GxQscripts where name = 'sec_getUsersForThisUserWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUsersForThisUserWrapper')
	delete from GXDBVersions where aliasname = 'sec_getUsersForThisUserWrapper'
GO

insert into GXDBVersions values(2, 'sec_getUsersForThisUserWrapper',  '00000000000000000000', 'sec_getUsersForThisUserWrapper', '00000000000000000000')
GO

