

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getUsersForThisUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  sec_getUsersForThisUser()
--  |
--  | Description:
--  |				Fetches a list of users this callerId can see / edit
--	|
--  |
--  |       Input:  callerId, forModification, localOrExternalUsers, excludeFlags, includeFlags
--	|
--	|		forModification if set to 1, only those users whom the caller can edit will be fetched
--  |		forModification if set to 0, all the users whom the caller is associated will be fetched
--	|
--	|		localOrExternalUsers = 1 - only local users
--	| 							   2 - only AD users,
--	|							   0 or 3 means all,
--  |							   4 - commcell users (local + non-company users who has parentCompanyId = 0)
--	|
--  |      Output:  List of users
--  |      Return:  xxx
--  |
--  |		THINGS TO DO FURTHER: Handling of restricted view enabled users
--  |
--  |   Author
--  |   ---------
--	|	saggarwal & jswaminathan
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getUsersForThisUser')
BEGIN
	print '>>> Drop Stored Procedure: sec_getUsersForThisUser <<<'
	drop procedure sec_getUsersForThisUser
END
IF EXISTS (select * from GxQscripts where name='sec_getUsersForThisUser')
	delete from GxQscripts where name = 'sec_getUsersForThisUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUsersForThisUser')
	delete from GXDBVersions where aliasname = 'sec_getUsersForThisUser'
GO
print '... Creating Procedure: sec_getUsersForThisUser'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getUsersForThisUser
  @tableOutput NVARCHAR(MAX),
  @callerId INT, 
  @forModification INT = 0,						
  @localOrExternalUser INT = 3,					
  @excludeFlags INT = 0,					
  @includeFlags INT = 1
AS
SET NOCOUNT ON
IF @callerId = 0
	RETURN
DECLARE @entityType AS INT
SET @entityType = 13					--CvEntities::EntityType_USER_ENTITY(13)
--Few questions need to check out :
--1. How to handle resticted users
--2. What about peer user concept because now we allow security association of a user to a user group
IF OBJECT_ID('tempdb.dbo.#getUsersForThisUserTable') IS NOT NULL
	DROP TABLE #getUsersForThisUserTable
SET @includeFlags = @includeFlags | CAST (0x001 AS INT)
SET @excludeFlags = @excludeFlags | dbo.sec_getExcludeFlagsForUser()
CREATE TABLE #getUsersForThisUserTable
	(
		userId INT
	)
    create clustered index getUsersForThisUserTable_idx on #getUsersForThisUserTable(userId)
--Security check
IF @forModification = 0					--get all associated users
	EXEC sec_getNonIdaObjectsForThisUser @callerId, @entityType, 0, '#getUsersForThisUserTable'
ELSE									--get all associated users with permission - add, delete, edit commcell users
EXEC sec_getNonIdaObjectsForThisUser @callerId, @entityType, 101, '#getUsersForThisUserTable'
IF @localOrExternalUser IN (0,1,2,3)			-- Existing code.
	--In the list obtained we will filter the entries based on flags and local / domain users
	DELETE Tbl
	FROM #getUsersForThisUserTable Tbl INNER JOIN UMUsers Users with(nolock)
	ON Tbl.userId = Users.id
	WHERE ((@localOrExternalUser = 1 AND Users.umDSproviderId <> 0) OR
		   (@localOrExternalUser = 2 AND Users.umDSproviderId = 0 ) OR
		   (Users.flags & @excludeFlags <> 0)	OR
		   (Users.flags & @includeFlags = 0))
ELSE IF @localOrExternalUser = 4										-- Commcell users. Remove the company users. (Either direct or indirect hierarchy).
	DELETE Tbl
	FROM #getUsersForThisUserTable Tbl
		INNER JOIN UMUsers Users WITH(NOLOCK)
			ON Tbl.userId = Users.id
		INNER JOIN UMDSProviders Providers
			ON Users.umdsProviderId = Providers.id
WHERE (Users.umdsProviderId <> 0 AND (Providers.serviceType = 5 OR Providers.ownerCompany <> 0)) OR
		   (Users.flags & @excludeFlags <> 0) OR
		   (Users.flags & @includeFlags = 0)
IF @forModification = 0						--I can see myself, but can I modify me?
	-- return the caller Id only if he is not an excluded user.
	-- Now that the GetUsersNew stored proc does not do this flag filtering, we need to do it correctly here.
	-- Else if caller is a hidden user, it will return his user Id to him back.
	IF EXISTS (SELECT 1 FROM UMUsers WHERE id = @callerId AND (flags & @excludeFlags = 0) AND (flags & @includeFlags <> 0))
		INSERT INTO #getUsersForThisUserTable
			VALUES (@callerId)
--According to Amey, a name server user can see all other users belonging to the same name server
--even without having explicit security association. Of course, there is a GxGlobalParam to control this behavior
IF (@localOrExternalUser <> 1) AND (@forModification = 0)
BEGIN
	DECLARE @umdsProviderId INT = (SELECT umdsProviderId FROM UMUsers (NOLOCK) WHERE id = @callerId)
	DECLARE @isCallingUserACompanyUser BIT = 0
	SELECT @isCallingUserACompanyUser = 1
	FROM UMDSProviders P (NOLOCK)
	WHERE
		id = @umdsProviderId
AND (serviceType = 5 OR ownerCompany <> 0)
	IF @umdsProviderID > 0
	BEGIN
IF NOT EXISTS (SELECT 1 FROM GxGlobalParam (NOLOCK) WHERE name = 'CanSeePeerNameServerMembers' AND value = '0' AND modified = 0)
		BEGIN
			IF @localOrExternalUser IN (0,2,3)
				OR (@localOrExternalUser = 4 AND @isCallingUserACompanyUser = 0)
				INSERT INTO #getUsersForThisUserTable
					SELECT id
					FROM UMUsers with(NOLOCK)
					WHERE umdsProviderId = @umdsProviderID
						AND flags & @includeFlags <> 0
						AND flags & @excludeFlags = 0
					EXCEPT
					SELECT userId
					FROM #getUsersForThisUserTable
		END
	END
END
DECLARE @outputstatement AS NVARCHAR(MAX)
SET @outputstatement = 'INSERT INTO '+ @tableOutput +
					   ' SELECT userId FROM #getUsersForThisUserTable GROUP BY userId'
EXEC (@outputstatement)
IF OBJECT_ID('tempdb.dbo.#getUsersForThisUserTable') IS NOT NULL
	DROP TABLE #getUsersForThisUserTable
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getUsersForThisUser')
	delete from GxQscripts where name = 'sec_getUsersForThisUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUsersForThisUser')
	delete from GXDBVersions where aliasname = 'sec_getUsersForThisUser'
GO

insert into GXDBVersions values(2, 'sec_getUsersForThisUser',  '00000000000000000000', 'sec_getUsersForThisUser', '00000000000000000000')
GO

