

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getUsersEmailOfGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "sec_getUsersEmailOfGroup"                                   |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getUsersEmailOfGroup <<<'

IF EXISTS (select * from sysobjects where name='sec_getUsersEmailOfGroup')
	drop procedure sec_getUsersEmailOfGroup
IF EXISTS (select * from GxQscripts where name='sec_getUsersEmailOfGroup')
	delete from GxQscripts where name = 'sec_getUsersEmailOfGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUsersEmailOfGroup')
	delete from GXDBVersions where aliasname = 'sec_getUsersEmailOfGroup'
GO
print '... Creating Procedure: sec_getUsersEmailOfGroup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getUsersEmailOfGroup
  @i_groupId integer
AS
  DECLARE @userEmail nvarchar(255)
DECLARE  @i_includeFlags integer = CAST( 0x001 AS INT)
DECLARE @i_excludeFlags integer = CAST(0x200 AS INT)|CAST(0x004 AS INT)|CAST(0x080 AS INT)|CAST(0x100 AS INT)
SET NOCOUNT ON
	SELECT U.email userEmail
	FROM UMUsers U
	WHERE
			U.flags & @i_excludeFlags = 0
		AND U.flags & @i_includeFlags <> 0
		AND U.email <> ''
		AND (
			U.id IN (
						SELECT  DISTINCT   UMUserGroup.userId
						FROM UMUserGroup WHERE UMUserGroup.groupId = @i_groupId
					)
			OR
			U.id IN (
						SELECT     DISTINCT UMDSUserGroup.userId
										FROM         UMDSGroupMaps INNER JOIN
										UMDSUserGroup ON UMDSGroupMaps.umDSgroupId = UMDSUserGroup.groupId
										WHERE UMDSGroupMaps.umgroupId = @i_groupId
					)
		)
	ORDER BY U.id
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getUsersEmailOfGroup')
	delete from GxQscripts where name = 'sec_getUsersEmailOfGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUsersEmailOfGroup')
	delete from GXDBVersions where aliasname = 'sec_getUsersEmailOfGroup'
GO

insert into GXDBVersions values(2, 'sec_getUsersEmailOfGroup',  '00000000000000000000', 'sec_getUsersEmailOfGroup', '00000000000000000000')
GO

