

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getUsersAndGroupsWithPermission.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +====================================================================================================================================+
--  |   Procedure:  sec_getUsersAndGroupsWithPermission
--  |
--  | Description:  getting list of users, user groups and external user groups with a particular permission
--  |				(without checking for the association)
--	|
--  |				Can expand the user groups to external groups and users based on flag
--  |
--  |
--	|	Authors: saggarwal & jswaminathan
--  +====================================================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getUsersAndGroupsWithPermission <<<'

IF EXISTS (select * from sysobjects where name='sec_getUsersAndGroupsWithPermission')
	drop procedure sec_getUsersAndGroupsWithPermission
IF EXISTS (select * from GxQscripts where name='sec_getUsersAndGroupsWithPermission')
	delete from GxQscripts where name = 'sec_getUsersAndGroupsWithPermission'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUsersAndGroupsWithPermission')
	delete from GXDBVersions where aliasname = 'sec_getUsersAndGroupsWithPermission'
GO
print '... Creating Procedure: sec_getUsersAndGroupsWithPermission'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getUsersAndGroupsWithPermission
  @permissionId INT,
  @expandUserGroups INT = 1,
  @honorOwners INT = 1
AS
  DECLARE @userId INT
  DECLARE @userGroupId INT 
  DECLARE @extGroupId INT 
DECLARE @tempTable TABLE (userOrGroupId INT, isUser INT)
DECLARE @outputTable TABLE (userId INT, userGroupId INT, extGroupId INT)
--Normal security associations
INSERT INTO @tempTable
SELECT userOrGroupId, isUser
FROM UMSecurityAssociations
WHERE roleId <> 0 AND roleId IN (SELECT R.id
								FROM UMRolesWithPermissionsExpanded Rpe INNER JOIN UMRoles R
								ON Rpe.roleId = R.id
								WHERE R.disabled = 0 AND (@permissionId = 0 OR RPe.permissionId = @permissionId))
UNION
SELECT userOrGroupId, isUser
FROM UMSecurityAssociations
WHERE permissionId <> 0 AND (@permissionId = 0 OR permissionId = @permissionId)
--Owners handling
IF @honorOwners = 1
BEGIN
	--Get the list of all entities for whom this given permission is applicable on it's owners
	--Then let us get the list of users / user groups who are owners of these entities
	--If the commcell owner role has the specified permission, then get list of all owners of all entities
	IF EXISTS (SELECT ORoles.roleId
			   FROM UMOwnerRoles ORoles INNER JOIN UMRolesWithPermissionsExpanded RPE
			   ON ORoles.roleId = RPE.roleId
			   WHERE ORoles.entityType = 1 AND ORoles.entityId = 2 AND RPE.permissionId = @permissionId)
	BEGIN
		INSERT INTO @tempTable
			SELECT userOrGroupId, isUser
			FROM UMOwners
	END
	ELSE
	BEGIN
		--Case 1: Owner role (Entity) - Owner (Entity)
		--Eg: If a client owner role has given permission, get list of all owners of that client
		INSERT INTO @tempTable
			SELECT Owners.userOrGroupId, Owners.isUser
			FROM UMOwners Owners INNER JOIN UMOwnerRoles ORoles
			ON Owners.entityType = ORoles.entityType AND Owners.entityID = ORoles.entityId
			INNER JOIN UMRolesWithPermissionsExpanded Rpe
			ON ORoles.roleId = RPE.roleID AND RPE.permissionId = @permissionID
		--Case 2: Owner role (Parent) - Owner (Child)
		--Eg: If a client group has owner role with the given permission, get list of owners of clients belonging to that client group
		DECLARE @associationQuery NVARCHAR(MAX) = N''
		DECLARE @localAssociationQuery NVARCHAR(MAX) = N''
		DECLARE @dynamicSQL NVARCHAR(MAX) = N''
		IF OBJECT_ID ('tempdb.dbo.#ownerEntities') IS NOT NULL
			DROP TABLE #ownerEntities
		CREATE TABLE #ownerEntities (entityTYpe INT, entityId INT)
		INSERT INTO #ownerEntities							-- Owners are applicable only for Client. Owner roles for only Clients, Client groups.
SELECT 3, CGA.clientId			-- And there is no plan for supporting Client Group owners, or using this table for other entiites.
			FROM UMOwnerRoles ORoles						-- So instead of framing a complex queries using cursors, let us go with the simple approach.
				INNER JOIN APP_ClientGroupAssoc CGA
ON ORoles.entityType = 28 AND ORoles.entityId = CGA.clientGroupId
				INNER JOIN UMRolesWithPermissionsExpanded RPE
					ON RPE.roleId = ORoles.roleID
					AND RPE.permissionid = @permissionID
		--For case 2, get the owners of the entities in #ownerEntities temp table
		INSERT INTO @tempTable
			SELECT Owners.userOrGroupId, Owners.isUser
			FROM #ownerEntities Tbl INNER JOIN UMOwners Owners
			ON Tbl.entityTYpe = Owners.entityType AND Tbl.entityId = Owners.entityId
		--Case 3: OwnerRole (Any entity) - Owner (Commcell):
		--If any owner role contains this permission, then commcell owners should be included
		IF EXISTS (SELECT ORoles.roleID
				   FROM UMOwnerROles ORoles INNER JOIN UMRolesWithPermissionsExpanded Rpe
				   ON ORoles.roleId = Rpe.roleId
				   WHERE Rpe.permissionId = @PermissionId)
		BEGIN
			INSERT INTO @tempTable
				SELECT Owners.userOrGroupId, Owners.isUser
				FROM UMOwners Owners
				WHERE 1 = Owners.entityType AND 2 = Owners.entityId
		END
	END
END
--Frame the output table from isUser and userOrGroupId column of @temptable
INSERT INTO @outputTable
	SELECT userOrGroupId, 0, 0
	FROM @tempTable
	WHERE isUser = 1
INSERT INTO @outputTable
	SELECT 0,
			CASE WHEN Groups.umdsProviderID = 0 THEN Tbl.userOrGroupId ELSE 0 END,
			CASE WHEN Groups.umdsProviderID <> 0 THEN Tbl.userOrGroupId ELSE 0 END
	FROM @tempTable Tbl INNER JOIN UMGroups Groups
	ON Tbl.userOrGroupId = Groups.id AND Tbl.isUser = 0
	WHERE (Groups.groupFlags & 1 = 1)
--If user groups need to be expanded
IF @expandUserGroups = 1
BEGIN
	--local user groups to AD user groups expansion
	INSERT INTO @outputTable
		SELECT 0, 0, GM.umdsGroupId
		FROM @outputTable Tbl INNER JOIN UMDSGroupMaps GM ON Tbl.userGroupId = GM.umgroupId
							  INNER JOIN UMGroups G ON GM.umdsGroupId = G.id
		WHERE G.groupFlags & 1 = 1
	--all local user groups and external groups to users expansion
	INSERT INTO @OutputTable
		SELECT UG.userId, 0, 0
		FROM @outputTable Tbl INNER JOIN UMUserGroup UG ON Tbl.userGroupId = UG.groupId
	INSERT INTO @OutputTable
		SELECT UG.userId, 0, 0
		FROM @outputTable Tbl INNER JOIN UMUserGroup UG ON Tbl.extGroupId = UG.groupId
END
DELETE Tbl
FROM @outputTable Tbl INNER JOIN UMUsers U
ON Tbl.userId = U.id AND Tbl.userId <> 0
WHERE U.enabled = 0
SELECT DISTINCT *
FROM @outputTable
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getUsersAndGroupsWithPermission')
	delete from GxQscripts where name = 'sec_getUsersAndGroupsWithPermission'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUsersAndGroupsWithPermission')
	delete from GXDBVersions where aliasname = 'sec_getUsersAndGroupsWithPermission'
GO

insert into GXDBVersions values(2, 'sec_getUsersAndGroupsWithPermission',  '00000000000000000000', 'sec_getUsersAndGroupsWithPermission', '00000000000000000000')
GO

