

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getUsersAndGroupsListForSharing.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sec_getUsersAndGroupsListForSharing()
--  | Description:  Gets list of Users and User Groups For compliance or end user site which is used for sharing feature
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_getUsersAndGroupsListForSharing.sp,v $ $Id: sec_getUsersAndGroupsListForSharing.sp,v 1.1.2.6 2020/12/21 14:43:10 jswaminathan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_getUsersAndGroupsListForSharing')
BEGIN
	print '>>> Drop Stored Procedure: sec_getUsersAndGroupsListForSharing <<<'
	drop procedure sec_getUsersAndGroupsListForSharing
END
IF EXISTS (select * from GxQscripts where name='sec_getUsersAndGroupsListForSharing')
	delete from GxQscripts where name = 'sec_getUsersAndGroupsListForSharing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUsersAndGroupsListForSharing')
	delete from GXDBVersions where aliasname = 'sec_getUsersAndGroupsListForSharing'
GO
print '... Creating Procedure: sec_getUsersAndGroupsListForSharing'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_getUsersAndGroupsListForSharing
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_capability INT
AS
  DECLARE @o_xmlText XML
SET NOCOUNT ON
BEGIN
	DECLARE @UserId INT
	DECLARE @userGUID nvarchar(256)
DECLARE @EntityType_USER_ENTITY INT = 13
DECLARE @EntityType_USERGROUP_ENTITY INT = 15
DECLARE @EntityType_EXTERNAL_GROUP_ENTITY INT = 62
	DECLARE @i_hideAdmin		INT
	DECLARE @o_errorCode		INT
	DECLARE @o_errorString		NVARCHAR(MAX)
	DECLARE @viewCapabilityMask bigint = POWER( 2.0, ( 31 - 1 ) )
	SET @o_errorCode = 0
	SET @o_errorString = ''
	--
	SET @i_hideAdmin = ISNULL(( SELECT ref.value('@hideAdmin', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_GetAllUserAndGroupListReq') R ( ref ) ), 0)
	--
	SET @userGUID = ISNULL(( SELECT ref.value('@userGuid', 'nvarchar(256)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_GetAllUserAndGroupListReq/user') R ( ref ) ), '')
	--
	IF LEN(@userGUID) > 0
	BEGIN
		SELECT @UserId = ID FROM UMUSERS WHERE userGuid = @userGUID AND enabled = 1
	END
	--
	DECLARE	@IntAdmGrps	TABLE (id INT)
	DECLARE	@ExtAdmGrps	TABLE (id INT)
	IF @i_hideAdmin = 1
	BEGIN
		INSERT INTO @IntAdmGrps
		values (dbo.GetMasterGroupID())
		INSERT INTO @ExtAdmGrps
		SELECT umDSgroupId FROM UMDSGroupMaps WHERE umgroupId in (
			SELECT id FROM @IntAdmGrps
		)
	END
	-- Fetch the user list
	-- DECLARE @restrictBySomePermission INT = 0
	-- IF EXISTS (SELECT TOP 1 VALUE FROM GXGlobalParam WHERE name = 'MSPStyleSharing' AND value = 'True')
	-- BEGIN
	-- 	SET @restrictBySomePermission = 1
	-- END
	-- IF OBJECT_ID('tempdb.dbo.#secShareUserList') IS NOT NULL  DROP TABLE #secShareUserList
	-- 	CREATE TABLE #secShareUserList (userId INT)
	DECLARE @restrictBySomePermission INT = 1
	IF EXISTS (SELECT TOP 1 VALUE FROM GXGlobalParam WHERE name = 'ShowAllPeerUsersForSharing' AND value = 'True')
	BEGIN
		SET @restrictBySomePermission = 0
	END
	IF OBJECT_ID ( 'tempdb.dbo.#secShareUserList' ) IS NOT NULL   DROP TABLE #secShareUserList
	CREATE TABLE #secShareUserList ( userId INT )
    -- capturing users on which at-least some permission exist for logged in user
    EXEC sec_getUsersForThisUser '#secShareUserList' , @userId
	IF OBJECT_ID ( 'tempdb.dbo.#secShareUserGroupList' ) IS NOT NULL   DROP TABLE #secShareUserGroupList
    CREATE TABLE #secShareUserGroupList ( userGroupId INT )
    -- capturing user groups on which at-least some permission exist for logged in user
    EXEC sec_getUserGroupsForThisUser '#secShareUserGroupList' , @userId , 0 , 1     --local groups only (0 means all - local and external groups, default)
    IF OBJECT_ID ( 'tempdb.dbo.#secShareExternalGroupList' ) IS NOT NULL   DROP TABLE #secShareExternalGroupList
    CREATE TABLE #secShareExternalGroupList ( externalGroupId INT )
    -- capturing extenral groups on which at-least some permission exist for logged in user
    EXEC sec_getUserGroupsForThisUser '#secShareExternalGroupList' , @userId , 0 , 2     --external groups only
	-- all users , groups who have requested (end user or compliance) capability
	DECLARE @usersAndGroupsList TABLE (userId INT, userGroupId INT, extGroupId INT)
	INSERT INTO @usersAndGroupsList
		EXEC sec_getUsersAndGroupsWithPermission @i_capability, 1
	SET @o_xmlText =
	(
		SELECT
		(
			SELECT DISTINCT id '@userId', userGuid '@userGuid' , login '@userName', @viewCapabilityMask '@capabilities'
			FROM UMUsers U
			INNER JOIN @usersAndGroupsList Tbl ON U.id = Tbl.userId
			LEFT JOIN #secShareUserList AU ON Tbl.userId = AU.userId
			WHERE U.enabled = 1 AND (@restrictBySomePermission = 0 OR (@restrictBySomePermission = 1 and AU.userId IS NOT NULL)) and
			id NOT IN
			(
					SELECT userId FROM UMUserGroup WHERE groupId in
					(
						SELECT id FROM @ExtAdmGrps
						UNION
						SELECT id FROM @IntAdmGrps
					)
			)
			order by login
			FOR XML PATH('userDetailsAndCapabilities'), TYPE
			),
			(
			SELECT DISTINCT UG.id '@groupId', UG.name '@groupName' , @viewCapabilityMask '@capabilities'
			FROM UMGroups UG
			INNER JOIN UMDSProviders P ON UG.umdsProviderId = P.id
			INNER JOIN @usersAndGroupsList Tbl ON UG.id = Tbl.userGroupId -- All groups with given capability
			LEFT JOIN #secShareUserGroupList AG ON TBL.userGroupId = AG.userGroupId -- groups on which logged-in user has some permissoin
			WHERE UG.umdsProviderId = 0 AND UG.groupFlags & 1 = 1 AND (@restrictBySomePermission = 0 OR (@restrictBySomePermission = 1 AND AG.userGroupId IS NOT NULL)) AND
			UG.id NOT IN
			(
				SELECT id FROM @IntAdmGrps
			)
			FOR XML PATH('userGroupDetailsAndCapabilities'), TYPE
			),
			(
			SELECT DISTINCT UG.id '@groupId', UG.umdsProviderId '@providerId', (UP.domainName + '\' + UG.name) '@groupName', @viewCapabilityMask '@capabilities'
			FROM UMGroups UG
			INNER JOIN UMDSProviders UP ON UG.umdsProviderId = UP.id
			INNER JOIN @usersAndGroupsList Tbl ON UG.id = Tbl.extGroupId
			LEFT JOIN #secShareExternalGroupList EG ON tbl.extGroupId = EG.externalGroupId
			WHERE UG.umdsProviderId > 0 AND UG.groupFlags & 1 = 1 AND (@restrictBySomePermission = 0 OR (@restrictBySomePermission = 1 AND EG.externalGroupId IS NOT NULL)) AND
			UG.id NOT IN
			(
				SELECT id FROM @ExtAdmGrps
			)
			FOR XML PATH('externalGroupDetailsAndCapabilities'), TYPE
			)
		FOR XML PATH('shareUserAndGroupCapabilityList'), ROOT('DM2ContentIndexing_GetAllUserAndGroupListResp')
	)
		SELECT @o_xmlText
		IF OBJECT_ID('tempdb.dbo.#secShareUserList') IS NOT NULL  DROP TABLE #secShareUserList
		IF OBJECT_ID('tempdb.dbo.#secShareUserGroupList') IS NOT NULL  DROP TABLE #secShareUserGroupList
		IF OBJECT_ID('tempdb.dbo.#secShareExternalGroupList') IS NOT NULL  DROP TABLE #secShareExternalGroupList
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getUsersAndGroupsListForSharing')
	delete from GxQscripts where name = 'sec_getUsersAndGroupsListForSharing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUsersAndGroupsListForSharing')
	delete from GXDBVersions where aliasname = 'sec_getUsersAndGroupsListForSharing'
GO

insert into GXDBVersions values(2, 'sec_getUsersAndGroupsListForSharing',  '00010001000200060000', 'sec_getUsersAndGroupsListForSharing', '00010001000200060000')
GO

