

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getUsers.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "sec_getUsers"
--	|	This Procedure is used to get user(s) details
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getUsers')
BEGIN
	print '>>> Drop Stored Procedure: sec_getUsers <<<'
	drop procedure sec_getUsers
END
IF EXISTS (select * from GxQscripts where name='sec_getUsers')
	delete from GxQscripts where name = 'sec_getUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUsers')
	delete from GXDBVersions where aliasname = 'sec_getUsers'
GO
print '... Creating Procedure: sec_getUsers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getUsers
  @xmlText XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @o_xmlText XML
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = N''
DECLARE @level int = 30
DECLARE @allEntity int = 0
DECLARE @userId int = 0
DECLARE @callerId int = 0
DECLARE @localeId int = 0
DECLARE @forModification int = 0
SET @localeId = ISNULL (( SELECT ref.value('@localeId', 'INT')
                        FROM @xmlText.nodes ('/App_GetUserPropertiesRequest/processinginstructioninfo/locale') R(ref)), 0)
SET @callerId = ISNULL (( SELECT ref.value('@userId', 'INT')
						FROM @xmlText.nodes ('/App_GetUserPropertiesRequest/processinginstructioninfo/user') R(ref)), 0)
IF NOT EXISTS (SELECT 1 FROM UMUsers where id = @callerId)
BEGIN
	--generate error resp
	SET @errorCode = -1
	SET @errorString = 'Invalid Caller'
	SET @o_xmlText = ( SELECT @errorCode '@errorCode', @errorString '@errorString'
					FOR XML PATH('response'), ROOT('App_GenericResponse'))
	GOTO PROC_EXIT
END
SET @forModification = ISNULL (( SELECT ref.value('@forModification', 'INT')
						FROM @xmlText.nodes ('App_GetUserPropertiesRequest') R(ref)), 0)
SET @userId = ISNULL(@xmlText.value('(/App_GetUserPropertiesRequest/user/@userId)[1]', 'int'), 0)
DECLARE @userName NVARCHAR(MAX)
IF @userId IS NULL OR @userId = 0
BEGIN
	SET @userName = @xmlText.value('(/App_GetUserPropertiesRequest/user/@userName)[1]', 'NVARCHAR(MAX)')
	IF @userName IS NOT NULL
	BEGIN
		SET @userId = ISNULL((SELECT id FROM UMUsers where login = @userName), 0)
IF 	@userId = 0
		BEGIN
			--generate error resp
			SET @errorCode = -1
			SET @errorString = 'Invalid userName'
			SET @o_xmlText = ( SELECT @errorCode '@errorCode', @errorString '@errorString'
							FOR XML PATH('response'), ROOT('App_GenericResponse'))
			GOTO PROC_EXIT
		END
	END
END
IF @userId IS NULL
	SET @userId = 0
IF  @userId IS NULL OR	@userId = 0
	SET @allEntity = 1
SET @level = ISNULL(@xmlText.value('(/App_GetUserPropertiesRequest/@level)[1]', 'int'), 30)
DECLARE @Users TABLE ( userId int );
DECLARE @includeUsersFlags int = -1;
DECLARE @excludeUsersFlags int = 0;
SET @includeUsersFlags = ( CAST (0x001 AS INT) )
SET @excludeUsersFlags = ( CAST (0x200 AS INT) | CAST (0x004 AS INT) | CAST (0x080 AS INT) | CAST(0x100 AS INT) )
DECLARE @isRestrictedViewEnabled int = 0
SET @isRestrictedViewEnabled =  ISNULL(CAST( (SELECT TOP (1) value FROM GXGlobalParam WHERE name = 'Restricted View Enabled' AND modified = 0) AS INT), 0)
DECLARE @canManageAllUsers int = 0
    EXEC sec_canManageAllUsers @callerId, @canManageAllUsers OUTPUT
DECLARE @IsHideEnabled int = 0
IF @canManageAllUsers = 0 AND @forModification = 0
    EXEC sec_isHideEnabled @callerId, @isRestrictedViewEnabled, @IsHideEnabled OUTPUT
DECLARE @canGetAllUsers int = 0
IF (@canManageAllUsers <> 0  or (@forModification = 0 AND @IsHideEnabled = 0) )
	SET @canGetAllUsers = 1;
IF @allEntity <> 1
BEGIN
	IF NOT EXISTS (SELECT 1 FROM UMUsers where id = @userId)
	BEGIN
		--generate error resp
		SET @errorCode = -1
		SET @errorString = 'Invalid user'
		SET @o_xmlText = ( SELECT @errorCode '@errorCode', @errorString '@errorString'
						FOR XML PATH('response'), ROOT('App_GenericResponse'))
		GOTO PROC_EXIT
	END
	DECLARE @canGetUser INT = 0
	IF @canGetAllUsers = 1 OR @callerId = @userId
		SET @canGetUser = 1;
	ELSE
	BEGIN
		EXEC sec_isPeerUser @callerId, @userId, @canGetUser OUT
	END
	IF @canGetUser = 0
	BEGIN
		--generate error resp
		SET @errorCode = -1
		SET @errorString = 'Caller do not have permission to get user information or he is not peer user'
		SET @o_xmlText = ( SELECT @errorCode '@errorCode', @errorString '@errorString'
						FOR XML PATH('response'), ROOT('App_GenericResponse'))
		GOTO PROC_EXIT
	END
	IF @canGetUser = 1
	INSERT INTO @Users
		SELECT UMUsers.id FROM UMUsers
		WHERE	(UMUsers.id = @userId)
				AND(UMUsers.flags & @excludeUsersFlags = 0) AND (UMUsers.flags & @includeUsersFlags <> 0)
END
ELSE IF @allEntity = 1
BEGIN
	IF @canGetAllUsers = 1
	BEGIN
		INSERT INTO @Users
			SELECT UMUsers.id FROM UMUsers
			WHERE (UMUsers.flags & @excludeUsersFlags = 0) AND (UMUsers.flags & @includeUsersFlags <> 0)
			ORDER BY UMUsers.id
	END
	ELSE
	BEGIN
		-- be careful 'WITH' caluse may need ; before using it
		WITH LocalGroups(groupId) AS (	SELECT     UMGroups.id AS groupId
										FROM         UMGroups INNER JOIN
															  UMUserGroup AS UMUG ON UMGroups.id = UMUG.groupId
										WHERE     (UMUG.userId = @callerId) AND (UMUG.flag & 0 = 0)
										UNION
										SELECT DISTINCT UMG.id AS groupId
										FROM         UMDSUserGroup INNER JOIN
															  UMDSGroupMaps ON UMDSUserGroup.groupId = UMDSGroupMaps.umDSgroupId INNER JOIN
															  UMGroups AS UMG ON UMDSGroupMaps.umgroupId = UMG.id
										WHERE     (UMDSUserGroup.userId =@callerId) AND (UMG.groupFlags & 0 = 0)
									)
		, AllPeerUsers(userId) AS	(	SELECT @callerId userId
										UNION
										SELECT DISTINCT UMUserGroup.userId userId
											FROM UMUserGroup INNER JOIN LocalGroups ON UMUserGroup.groupId =localGroups.groupId
										UNION
										SELECT     DISTINCT UMDSUserGroup.userId userId
											FROM         UMDSGroupMaps INNER JOIN
											UMDSUserGroup ON UMDSGroupMaps.umDSgroupId = UMDSUserGroup.groupId
											INNER JOIN
											LocalGroups ON UMDSGroupMaps.umgroupId = LocalGroups.groupId
									  )
		INSERT INTO @Users
					SELECT UMUsers.id userId
					FROM UMUsers  INNER JOIN AllPeerUsers ON UMUsers.id = AllPeerUsers.userId
					WHERE (UMUsers.flags & @excludeUsersFlags = 0) AND (UMUsers.flags & @includeUsersFlags <> 0)
					ORDER BY UMUsers.id
	END
END
IF @level = 1
BEGIN
SET @o_xmlText = (	SELECT	(SELECT UMUsers.id AS '@userId', UMUsers.userGuid as '@userGUID', UMUsers.login AS '@userName' FOR XML PATH('userEntity'), TYPE)
					FROM UMUsers  INNER JOIN @Users ON UMUsers.id = [@Users].userId
					FOR XML PATH('users'), ROOT('App_GetUserPropertiesResponse')--TYPE
				 )
END
ELSE IF @level = 10
BEGIN
SET @o_xmlText = (	SELECT UMUsers.description AS '@description'
							, UMUsers.name AS '@fullName'
							, enabled AS '@enableUser'
							, (SELECT TOP 1 attrVal FROM UMUsersProp WHERE componentNameId= UMUsers.id  AND attrName ='Company Name' AND modified = 0) AS '@companyName'
							, (SELECT UMUsers.id AS '@userId', UMUsers.userGuid as '@userGUID', UMUsers.login AS '@userName' FOR XML PATH('userEntity'), TYPE)
					FROM UMUsers  INNER JOIN @Users ON UMUsers.id = [@Users].userId
					FOR XML PATH('users'), ROOT('App_GetUserPropertiesResponse')
				 )
END
ELSE
BEGIN
SET @o_xmlText = (	SELECT UMUsers.description AS '@description'
								, UMUsers.name AS '@fullName'
								, email AS '@email'
								, enabled AS '@enableUser'
								, (SELECT TOP 1 attrVal FROM UMUsersProp WHERE componentNameId= UMUsers.id  AND attrName ='Company Name' AND modified = 0) AS '@companyName'
								, policy AS '@agePasswordDays'
								, (SELECT UMUsers.id AS '@userId', UMUsers.userGuid as '@userGUID', UMUsers.login AS '@userName' FOR XML PATH('userEntity'), TYPE)
								, (		SELECT groupId AS '@userGroupId', UMGroups.name AS '@userGroupName'
										FROM UMUserGroup, UMGroups
										WHERE UMUserGroup.groupId = UMGroups.id  and UMUserGroup.userId = umusers.id for XML PATH('associatedUserGroups'), TYPE
									)
								,(SELECT
                                         CR.keyName as '@keyName',
                                         CR.type as '@type',
                                         (CASE CR.type WHEN 'ENCRYPTED' THEN '********' ELSE CR.value END) as '@value',
                                         CR.relativepath as '@relativepath',
                                         --CR.deleted as '@deleted',
                                         CR.enabled as '@enabled',
                                         ISNULL(AdvEx.details.value('(/App_AdvanceSettingProps/@comment)[1]','NVARCHAR(MAX)'),N'') as '@comment',
                                         NULL as '@isInheritedFromClientGroup',
                                         (SELECT
                                            CASE CR.sourceEntityType WHEN 0 THEN NULL ELSE CR.sourceEntityType END AS '@_type_',
                                            CASE CR.sourceEntityType WHEN 15 THEN CR.sourceId ELSE NULL END AS '@userGroupId',
											CASE CR.sourceEntityType WHEN 61 THEN CR.sourceId ELSE NULL END AS '@providerId',
											CASE CR.sourceEntityType WHEN 189 THEN CR.sourceId ELSE NULL END AS '@companyId'
                                         FOR XML PATH('sourceEntity'),TYPE)
                                         FROM APP_AdvanceSettings as CR WITH(NOLOCK)
                                         LEFT OUTER JOIN APP_AdvanceSettingsEx AdvEx WITH(NOLOCK)
                                         ON CR.id = AdvEx.keyId
                                         WHERE CR.entityId = UMUsers.id AND CR.entityType = 13 --USER_ENTITY
                                         and CR.deleted = 0
                                         FOR XML PATH('additionalSettings'),TYPE)
					FROM UMUsers  INNER JOIN @Users ON UMUsers.id = [@Users].userId
					FOR XML PATH('users') , ROOT('App_GetUserPropertiesResponse')
				 )
END
PROC_EXIT:
IF @o_xmlText is NULL
	SET @o_xmlText = '<App_GetUserPropertiesResponse/>'
SELECT @o_xmlText o_xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getUsers')
	delete from GxQscripts where name = 'sec_getUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUsers')
	delete from GXDBVersions where aliasname = 'sec_getUsers'
GO

insert into GXDBVersions values(2, 'sec_getUsers',  '00000000000000000000', 'sec_getUsers', '00000000000000000000')
GO

