

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getUserRoleDetailsFromGlobalCS.sp] ---------- 

--		ALLOW COMMENTS BELOW HERE!
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_getUserRoleDetailsFromGlobalCS.sp,v $ $Id: sec_getUserRoleDetailsFromGlobalCS.sp,v 1.1.2.12.4.1 2021/01/28 20:05:11 njudge Exp $";
-- =============================================
-- Author:		Seema Aggarwal
-- Creation date: 19/04/2019
-- Description:	GEt user authorization details from GLobalCS for local cs.
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_getUserRoleDetailsFromGlobalCS')
BEGIN
	print '>>> Drop Stored Procedure: sec_getUserRoleDetailsFromGlobalCS <<<'
	drop procedure sec_getUserRoleDetailsFromGlobalCS
END
IF EXISTS (select * from GxQscripts where name='sec_getUserRoleDetailsFromGlobalCS')
	delete from GxQscripts where name = 'sec_getUserRoleDetailsFromGlobalCS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUserRoleDetailsFromGlobalCS')
	delete from GXDBVersions where aliasname = 'sec_getUserRoleDetailsFromGlobalCS'
GO
print '... Creating Procedure: sec_getUserRoleDetailsFromGlobalCS'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_getUserRoleDetailsFromGlobalCS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_login NVARCHAR(2048),
  @i_userId INTEGER =0,
  @i_entityId INTEGER=0
AS
SET NOCOUNT ON
  DECLARE @outputXML XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF (@i_userId=0)
	SET @i_userID=ISNULL((SELECT id from UMUSERs where login = @i_login),0)
-- check if user has administrative mgmt rights at commcell level.
DECLARE @isAdmin INT = 0
DECLARE @userRole INT = 0
DECLARE @ownerCompany INT = 0
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(max) = ''
EXEC DBO.sec_checkPermissionOnEntity @i_userId, 1, @isAdmin OUTPUT, 1, 2
IF(@isAdmin = 0)
BEGIN
IF  EXISTS(SELECT 1 FROM UMUserGroup UU INNER JOIN UMGroups UG ON UU.groupId=UG.id where UG.groupFlags&0x10000 <> 0 and UU.userId=@i_userId)
OR  EXISTS(SELECT 1 FROM UMDSGroupMaps ugm INNER JOIN UMUserGroup uu ON ugm.umDSgroupId = uu.groupId INNER JOIN UMGroups UG ON ug.id=ugm.umgroupId AND UG.groupFlags&0x10000 <> 0 WHERE UU.userId=@i_userId )
			BEGIN
					SET @isAdmin  = 1
			END
END
IF OBJECT_ID('tempdb.dbo.#userGroupId') IS NOT NULL
    DROP TABLE #userGroupId
CREATE TABLE #userGroupId
(
    userGroupId INT
)
EXEC sec_getMemberUserGroups  @i_userId
--We will also need list  AD group, AD user is member of, if any of the group is mapped to
DECLARE @providerId INT
DECLARE @serviceTYPE INT
DECLARE @isSAMLUSer   INT=0
Select @providerId= umDSproviderId ,@serviceTYPE =serviceType from UMUsers JOIN UMDSProviders on umDSproviderId= UMDSProviders.id Where UMUsers.id = @i_userId and umDSproviderId > 0
IF @serviceType=12
 BEGIN
  --check if its SAML APP
    IF EXISTS(SELECT 1 from APP_thirdPArtyApp  app JOIN APP_componentPRop Prop ON PRop.componentType=112 and longVal=app.id JOIN    UMDSproviders PRov on componentId=Prov.id
	WHERE PRov.id=@providerId AND app.apptype=2)
		SET @isSAMLUSer=1
 END
DECLARE @companyId INT = NULL
IF EXISTS (Select 1 from UMDSProviders Where id=@providerId and serviceType = 5)
	BEGIN
	SET @companyId = @providerId
	SET @providerId = NULL
	END
ELSE
BEGIN
	SET @companyId = (select ownerCompany from UMDSProviders where  id=@providerId and ownerCompany <> 0)
END
IF OBJECT_ID('tempdb.dbo.#loginUSerGroupCommcellAssoc') IS NOT NULL
    DROP TABLE #loginUSerGroupCommcellAssoc
CREATE TABLE #loginUSerGroupCommcellAssoc
(
    userORGroupId INT,
       isUSer INT,
      commcellId INT,
	   commcellGUID varchar(MAX),
	   includeAll INT
)
INSERT INTO #loginUSerGroupCommcellAssoc (userORGroupId,isUSer,commcellId,includeALL)
SELECT DISTINCT  userOrGRoupId,isUSer,entityId1,includeALL FROM UMSecurityAssociations
JOIN #userGroupId ON userOrGroupId=userGroupId and isUser=0 AND
( entityType1=194 and (includeALL=1 or @i_entityId=0)
OR (entityType1=194 AND @i_entityId<>0 and entityId1=@i_entityId))
UNION
SELECT DISTINCT userOrGRoupId,isUSer,entityId1,includeALL FROM UMSecurityAssociations
WHERE userOrGroupId=@i_userId and isUser=1
and (( entityType1=194 and (includeALL=1 or @i_entityId=0) )
OR (entityType1=194 AND @i_entityId<>0 and entityId1=@i_entityId))
UNION
SELECT DISTINCT userGroupId,0,entityId1,includeAll
FROM #userGroupId  JOIN UMGroups on userGroupId=id  JOIN UMSecurityAssociations ON userOrGroupId in (@providerId,@companyId) and isuser=2
AND (( entityType1=194 and (includeALL=1 or @i_entityId=0) )
OR (entityType1=194 AND @i_entityId<>0 and entityId1=@i_entityId))
UPDATE TBL
set commcellGUID =csGUID
FROM #loginUSerGroupCommcellAssoc TBL JOIN APP_CommCell ON  TBL.commcellId =APP_commcell.id and includeALL=0
INSERT INTO #loginUSerGroupCommcellAssoc  (userORGroupId,isUSer,commcellGUID)
SELECT DISTINCT userORGroupId,isUSer,csGUID
FROM #loginUSerGroupCommcellAssoc JOIN APP_Commcell ON id>2 and includeALL=1
CREATE TABLE #AdGroupMap
(
       umdsGroupId INT,
	   umdsGroupGUID varchar(256),
	   umdsgroupName varchar(MAX),
	   domainGUID VarchaR(256),
	   domainID  INT,
	   domainName VARCHAR(MAX),
       umGroupId INT,
	   umGroupName VARCHAR(MAX),
	   umGroupGUID VARCHAR(256)
)
INSERT INTO #AdGroupMap (umdsgroupId,umGroupId,umdsGRoupGUID,umdsGRoupName,domainGUID,domainName,umGroupName,umGRoupGUID)
SELECT DISTINCT umDSgroupId,umgroupId,AD.GUID,AD.name,PRov.guid,prov.domainName,local.name,local.guid
FROM UMUserGroup member
JOIN UMDSGRoupMaps Map ON Map.umdsGroupId=member.groupId  and userId=@i_userId
JOIN #loginUSerGroupCommcellAssoc Assoc on Assoc.userORGroupId=Map.umGroupId
JOIN UMGRoups local ON local.id=umgroupId
JOIN UMGroups AD ON AD.id=umdsgRoupId
JOIN UMDSPRoviders Prov ON AD.umdsprovideRId =PRov.id
SELECT
  (SELECT  email as '@email', @isSAMLUser as '@isSAMLUSer', UMUSERS.flags as '@flags',id as 'userEntity/@userId',login as 'userEntity/@userName' ,userGuid as 'userEntity/@userGUID',
  (SELECT G.id as '@userGroupId',case when umdsProviderId=0 THEN G.name ELSE domainName+'\'+G.name END as '@userGroupName' ,G.GUID as '@guid' ,commcellGUID as '@commcellGUID'  ,email as '@email' from UMGroups G JOIN #loginUSerGroupCommcellAssoc on id=userORGroupId AND ISusER=0
								JOIN UMDSProviders P on umdsProviderId=P.id
	FOR XML PATH('associatedUserGroups'),TYPE),
	(Select UMDSD.id as '@providerId' , UMDSD.domainName as '@providerDomainName' from UMDSProviders umdsd where umdsd.id=@providerId for xml path('providerDomain'),type) ,
	(Select UMDSC.id as '@companyId', UMDSC.domainName as '@companyAlias', UMDSC.hostName  as '@companyName',UMDSC.GUID as '@GUID' from UMDSProviders UMDSC where UMDSC.id=@companyId for xml path('company'),type)
	FROM UMUSERS where id=@i_userId
	FOR XML PATH('user'),TYPE),
	( SELECT umgroupId as '@userGroupId',umdsGRoupId as '@externalGroupId',umdsGRoupGUID as '@externalGroupGuid',
	       umdsGRoupName as '@externalGroupName',
		   domainGUID as '@providerGUID',
		   domainName as '@providerName'
		FROM #ADGroupMap FOR XML PATH('ADGroupMap'),TYPE
	),
(SELECT @isAdmin AS '@isAdmin' FOR XML PATH('userRights'), TYPE)
FOR XML PATH('App_GlobalCStoLocalCSUserResponse')
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getUserRoleDetailsFromGlobalCS')
	delete from GxQscripts where name = 'sec_getUserRoleDetailsFromGlobalCS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUserRoleDetailsFromGlobalCS')
	delete from GXDBVersions where aliasname = 'sec_getUserRoleDetailsFromGlobalCS'
GO

insert into GXDBVersions values(2, 'sec_getUserRoleDetailsFromGlobalCS',  'v1.1.2.12.4.1', 'sec_getUserRoleDetailsFromGlobalCS', 'v1.1.2.12.4.1')
GO

