

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getUserObjects.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_getUserObjects.sp,v $ $Id: sec_getUserObjects.sp,v 1.26.2.13 2020/12/23 12:57:06 jswaminathan Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_getUserObjects()
--  |
--  | Description:  Fetches a flattened list of objects the selected user has
--	|			    rights to and puts into passed in table
--  |
--  |        Note:  CODE MOVED TO SEC_GETUSERCREDDENTIALS PROCEDURE .. CALL HERE
--	|				.. FOR Legacy Support Only
--	|
--  |       Input:  userId, nodeType, nodeId, outputTableArg
--	|
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_getUserObjects')
BEGIN
	print '>>> Drop Stored Procedure: sec_getUserObjects <<<'
	drop procedure sec_getUserObjects
END
IF EXISTS (select * from GxQscripts where name='sec_getUserObjects')
	delete from GxQscripts where name = 'sec_getUserObjects'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUserObjects')
	delete from GXDBVersions where aliasname = 'sec_getUserObjects'
GO
print '... Creating Procedure: sec_getUserObjects'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_getUserObjects
  @userId integer,
  @nodeType integer,
  @nodeId integer,
  @outputTableArg varchar(100),
  @getStaticNodeCapabilities integer = 0  -- when this flag is set: Include a row with <<entity>>Id=-10 in output table when user has capabilities on all objects of an entityType . e.g. output table will
															 -- have a row with clientId = -10 when user has capabilities on all clients. [Needed in TM_SecurityCheckForTask.sp, for all clients association check].
AS
SET NOCOUNT ON
declare @instmt			nvarchar(MAX)
declare @stmtbuff		nvarchar(MAX)
	EXEC sec_updateUserCredentials @userId
	IF OBJECT_ID ('tempdb.dbo.#sec_getUserObject') is not null DROP TABLE #sec_getUserObject
create table  #sec_getUserObject ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	--IF (@nodeId <> 0)
	--BEGIN
	--	RAISERROR (N'node id parameter is not supported at this time in procedure sec_getUserObjects', 10, 1)
	--END
	DECLARE @useOldgetUserObjects VARCHAR(5) = '0'
	DECLARE @entityTypeReq INT = 0
	SELECT @useOldgetUserObjects = value FROM GXGlobalParam WITH (NOLOCK) WHERE name = N'useOldgetUserObjects' AND modified = 0
	IF(@useOldgetUserObjects = '0')
	BEGIN
		DECLARE @capsOnCommcellThisUserHas BIGINT = 0
		IF @nodeType IN
						(
2572,					-- clientGroupId
2048,						-- mediaAgentId
2049,							-- libraryId
2231,						-- archGroupId
8107,							-- vtContainerId
8462,							-- vtPolicyId
8180,						-- vtShelfId
9501,						-- reviewSetId
9502,						-- querySetId
9503,					-- downloadSetId
9504,								-- tagId
9505,						-- legalholdId
9506,					-- ermId
9507,						-- cdPolicyId
9508,				-- complianceReportId
4300,							-- taskId
14033,							-- workflowId
9646,				-- logMonitoringPolicyId
9615,								-- arrayId
8464,					-- entityId1
7987,						-- entityId2
9651						-- entityId3
						)
				SET @entityTypeReq = dbo.sec_ObjectTypeToEntitytype(@nodeType)
		IF(@entityTypeReq <> 0)
		BEGIN
			-- Output table.
			IF OBJECT_ID('tempdb.dbo.#nonIdaObjectsV2_OutputTbl ') IS NOT NULL
				DROP TABLE #nonIdaObjectsV2_OutputTbl
			CREATE TABLE #nonIdaObjectsV2_OutputTbl
			(
				entityId INT PRIMARY KEY,
				capabilities BIGINT
			)
			EXEC sec_getNonIdaObjectsForThisUserV2 @userID, @entityTypeReq, @capsOnCommcellThisUserHas OUTPUT
			GOTO PROC_EXIT
		END
	END
	set @instmt = 'INSERT INTO  #sec_getUserObject'
		+ ' SELECT  capabilities, flag, commCellId, clientGroupId, clientId,'
		+ ' appTypeId, instanceId, backupsetId, subClientId, mediaAgentId,   libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,'
		+ ' reviewSetId, querySetId, downloadSetId, ermId, legalHoldId, tagId, cdPolicyId, complianceReportId, taskId, workflowId,'
		+ ' logMonitoringPolicyId, arrayId, cloudId, userGroupId, providerId, entityId1, entityId2, entityId3, entityId4, entityId5,'
		+ ' entityId6, entityId7, entityId8, entityId9'
		+ ' FROM UMUserCredentials WITH(NOLOCK)'
		+ ' WHERE userid = '
		+ convert (varchar(8), @userID)
	-- ADD COMMCELL LEVEL ASSOCIATION
	set @stmtbuff = @instmt
		+ ' AND ((commCellId <> 0 AND clientGroupId = 0 AND appTypeId=0 AND backupsetId=0 AND archGroupId=0'
		+ ' AND clientId=0 AND complianceReportId=0 AND cdPolicyId=0 AND downloadSetId=0'
		+ ' AND ermId=0 AND instanceId=0 AND legalHoldId=0 AND libraryId=0 AND mediaAgentId=0'
		+ ' AND querySetId=0 AND reviewSetId=0 AND subClientId=0 AND tagId=0'
		+ ' AND vtContainerId=0 AND vtPolicyId=0 AND vtShelfId=0 AND taskId=0 AND workflowId=0'
		+ ' AND logMonitoringPolicyId=0 AND arrayId=0 AND cloudId=0 AND userGroupId=0'
		+ ' AND providerId=0 AND entityId1=0 AND entityId2=0 AND entityId3=0 AND entityId4=0'
		+ ' AND entityId5=0 AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0)'
	IF (@nodeType = 2018)		-- COMMCELL_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (entityId6 <> 0))'
	END
	ELSE IF (@nodeType = 2572)		-- SERVER_GROUP_NAME_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (clientGroupId <> 0))'
	END
	ELSE IF (@nodeType = 2009)		-- CLIENT_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR ((clientId <> 0 AND instanceId=0 AND backupsetId=0 AND subClientId=0 AND appTypeId=0) OR (clientGroupId <> 0)))'
	END
	ELSE IF (@nodeType = 2230)		-- APP_TYPE_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR ((clientId <> 0 OR appTypeId <> 0 OR clientGroupId <> 0) AND instanceId=0 AND backupsetId=0 AND subClientId=0))'
	END
	ELSE IF (@nodeType = 2011) 		-- INSTANCE_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR ((instanceId <> 0 OR appTypeId <> 0 OR clientId <> 0 OR clientGroupId <> 0) AND (subClientId = 0 AND backupsetId = 0)))'
	END
	ELSE IF (@nodeType = 2012) 		-- BACKUP_SET_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR ((backupsetId <> 0 OR instanceId <> 0 OR appTypeId <> 0 OR clientId <> 0 OR clientGroupId <> 0) AND (subClientId = 0)))'
	END
	ELSE IF (@nodeType = 2013)		-- SUB_CLIENT_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (subClientId <> 0 OR backupsetId <> 0 OR instanceId <> 0 OR appTypeId <> 0 OR clientId <> 0 OR clientGroupId <> 0))'
	END
	ELSE IF (@nodeType = 2048)		-- MEDIA_AGENT_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (mediaAgentId <> 0) '
IF(  EXISTS ( SELECT 1 FROM App_EntityParentAssociation WHERE childEntityType=11 and parentEntityType=28) )
				set @stmtbuff = @stmtbuff + ' OR (clientGroupId = -10 ) '
		set @stmtbuff = @stmtbuff + ')'
	END
	ELSE IF (@nodeType = 2049)		-- LIBRARY_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (libraryId <> 0))'
	END
	ELSE IF (@nodeType = 2231)		-- ARCHIVE_GROUP_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (archGroupId <> 0))'
	END
	ELSE IF (@nodeType = 8107)		-- CONTAINER_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (vtContainerId <> 0))'
	END
	ELSE IF (@nodeType = 8462)		-- TM_POLICY_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (vtPolicyId <> 0))'
	END
	ELSE IF (@nodeType = 8180)		-- SHELF_LIBRARY_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (vtShelfId <> 0))'
	END
	ELSE IF (@nodeType = 4300)		--SCHEDULE_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (taskId <> 0))'
	END
	ELSE IF (@nodeType = 14033)		--WORKFLOW_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (workflowId <> 0))'
	END
	ELSE IF (@nodeType = 9501)		-- DM2_REVIEW_SET_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (reviewSetId <> 0))'
	END
	ELSE IF (@nodeType = 9502)		-- DM2_QUERY_SET_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (querySetId <> 0))'
	END
	ELSE IF (@nodeType = 9503)		-- DM2_DOWNLOAD_SET_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (downloadSetId <> 0))'
	END
	ELSE IF (@nodeType = 9504)		-- DM2_TAG_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (tagId <> 0))'
	END
	ELSE IF (@nodeType = 9505)		-- DM2_LEGAL_HOLD_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (legalHoldId <> 0))'
	END
	ELSE IF (@nodeType = 9506)		-- DM2_ERM_CONNECTOR_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (ermId <> 0))'
	END
	ELSE IF (@nodeType = 9507)		-- DM2_CD_POLICY_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (cdPolicyId <> 0))'
	END
	ELSE IF (@nodeType = 9508)		-- DM2_COMPLIANCE_REPORT_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (complianceReportId <> 0))'
	END
	ELSE IF (@nodeType = 9615)		-- ARRAY_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (arrayId <> 0))'
	END
	ELSE IF (@nodeType = 8464)		-- TM_DESTINATION_ITEM -- entityId1
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (entityId1 <> 0))'
	END
	ELSE IF(@nodeType=9646)   --Log Monitoring
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (logMonitoringPolicyId <> 0))'
	END
	ELSE IF(@nodeType = 7987)   --SHARE_FOLDER_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (entityId2 <> 0))'
	END
	ELSE  IF (@nodeType = 9651)     -- CUSTOM_QUERY_ITEM
	BEGIN
		set @stmtbuff = @stmtbuff + ' OR (entityId3 <> 0))'
	END
	ELSE IF (@nodeType = 0)			-- ALL ITEMS
	BEGIN
		set @stmtbuff = @instmt
	END
	ELSE
	BEGIN
		-- UNKNOWN NODE TYPE - RAISE ERROR TO CALLER
		RAISERROR (N'invalid nodeType value (%d) passed into stored procedure sec_getUserObjects', 10, 1, @nodeType)
	END
	EXEC (@stmtbuff)
	DECLARE @capabilities bigint=0
	DECLARE @commcellId INTEGER=0
	IF (@nodeType=0 OR @nodeType = 2018)
IF(exists (SELECT 1 from #sec_getUserObject where entityId6=-10)) 		-- COMMCELL_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  entityId6=-10
		INSERT INTO #sec_getUserObject ( capabilities,commCellId,entityId6)
			SELECT @capabilities,@commcellId,id
			FROM APP_CommCell WITH(NOLOCK)
		IF @getStaticNodeCapabilities = 0
DELETE  #sec_getUserObject where commcellId=-10
	END
	IF(@nodeType=0 OR  @nodeType=2009 OR @nodeType=2230 OR  @nodeType=2011 OR  @nodeType=2012 OR @nodeType=2013 OR @nodeType=2572 OR @nodeType=2048)
IF (EXISTS (SELECT 1 from #sec_getUserObject where clientGroupId=-10))		-- SERVER_GROUP_NAME_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  clientGroupId=-10
		MERGE #sec_getUSerObject sec
		USING (SELECT id from APP_ClientGroup WITH(NOLOCK)) as clientGroup
		ON sec.clientGroupId=id
		WHEN MATCHED THEN
			UPDATE SET capabilities=capabilities|@capabilities
		WHEN NOT MATCHED THEN
			INSERT ( capabilities,commCellId,clientGroupId)
			VALUES( @capabilities,@commcellId,clientGroup.id);
		--Since we expand client group client while populating UMUSercredentials on selecting particular client group, we should do expansion of client group to client if input node type is 0 ,IDA types
		IF(@nodeType=0 OR  @nodeType=2009 OR @nodeType=2230 OR  @nodeType=2011 OR  @nodeType=2012 OR @nodeType=2013)
		BEGIN
			MERGE #sec_getUSerObject sec
			USING (SELECT DISTINCT clientId from APP_ClientGroupAssoc WITH(NOLOCK) ) as clientGroupAssoc
			ON sec.clientId=clientGroupAssoc.clientId
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,clientId)
				VALUES( @capabilities,@commcellId,clientGroupAssoc.clientId);
		END
IF(  EXISTS ( SELECT 1 FROM App_EntityParentAssociation WHERE childEntityType=11 and parentEntityType=28) AND (@nodeType=0 OR @nodeType=2048))
		BEGIN
		MERGE #sec_getUSerObject sec
			USING (
					SELECT DISTINCT CGA.clientId
     				FROM APP_ClientGroupAssoc CGA WITH(NOLOCK)
						 INNER JOIN MMHost AS MAList WITH(NOLOCK)
							ON CGA.clientId = MAList.clientId
					WHERE
						MAList.clientId NOT IN (SELECT PMClientID FROM App_VMToPMMap (NOLOCK) WHERE VMclientId = 2)
				  )
				  AS clientGroupAssoc
			ON sec.mediaAgentId=clientGroupAssoc.clientId
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,mediaAgentId)
				VALUES( @capabilities,@commcellId,clientGroupAssoc.clientId);
		END
		IF @getStaticNodeCapabilities = 0
DELETE  #sec_getUserObject where  clientGroupId=-10
	END
	IF(@nodeType=0 OR  @nodeType=2009 OR @nodeType=2230 OR  @nodeType=2011 OR  @nodeType=2012 OR @nodeType=2013)
IF (EXISTS (SELECT 1 from #sec_getUserObject where clientId=-10))	-- CLIENT_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  clientId=-10
		MERGE #sec_getUSerObject sec
			USING (SELECT id from APP_Client WITH(NOLOCK) ) as entityTable
			ON sec.clientId=entityTable.id AND sec.appTypeId=0
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,clientId)
				VALUES( @capabilities,@commcellId,entityTable.id);
		IF @getStaticNodeCapabilities = 0
DELETE FROM  #sec_getUserObject where  clientId=-10
	END
	IF @nodeType=0 OR (@nodeType = 2048)
IF EXISTS (SELECT 1 from #sec_getUserObject where mediaAgentId=-10 )		-- MEDIA_AGENT_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  mediaAgentId=-10
			MERGE #sec_getUSerObject sec
			USING (SELECT MAList.clientId
				  FROM MMHost AS MAList WITH(NOLOCK)
				  WHERE
					MAList.clientId NOT IN (SELECT PMClientID FROM App_VMToPMMap (NOLOCK) WHERE VMclientId = 2)
					AND MAList.clientID > 1
				  ) as entityTable
			ON sec.mediaAgentId=entityTable.clientid
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,mediaAgentId)
				VALUES( @capabilities,@commcellId,entityTable.clientId);
		IF @getStaticNodeCapabilities = 0
DELETE FROM  #sec_getUserObject where mediaAgentId=-10
	END
	IF (@nodeType=0 OR @nodeType = 2049)
IF  EXISTS (SELECT 1 from #sec_getUserObject where LibraryId=-10)		-- LIBRARY_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  libraryId=-10
		MERGE #sec_getUSerObject sec
			USING (SELECT LibraryId
				   FROM MMLibrary WITH(NOLOCK) WHERE LibraryId<>0
				) as entityTable
			ON sec.libraryId=entityTable.LibraryId
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,libraryId)
				VALUES( @capabilities,@commcellId,entityTable.LibraryId);
		IF @getStaticNodeCapabilities = 0
DELETE FROM  #sec_getUserObject where libraryId=-10
	END
	IF (@nodeType=0 OR @nodeType = 2231)      -- ARCHIVE_GROUP_ITEM
IF (EXISTS (SELECT 1 from #sec_getUserObject where archGroupId=-10))		-- ARCHIVE_GROUP_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  archGroupId=-10
		MERGE #sec_getUSerObject sec
			USING (SELECT id FROM archGroup	WITH(NOLOCK) WHERE id<>1
				) as entityTable
			ON sec.archGroupId=entityTable.id
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,archGroupId)
				VALUES( @capabilities,@commcellId,entityTable.id);
		IF @getStaticNodeCapabilities = 0
DELETE FROM  #sec_getUserObject where archGroupId=-10
	END
	IF ( @nodeType =0 OR  @nodeType = 8107)      -- CONTAINER_ITEM
IF EXISTS (SELECT 1 from #sec_getUserObject where vtContainerId=-10)		-- CONTAINER_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  vtContainerId=-10
		MERGE #sec_getUSerObject sec
			USING (SELECT ContainerId
					FROM MMContainer WITH(NOLOCK)
					WHERE ContainerId<>0
				) as entityTable
			ON sec.vtContainerId=entityTable.ContainerId
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,vtContainerId)
				VALUES( @capabilities,@commcellId,entityTable.ContainerId);
		IF @getStaticNodeCapabilities = 0
DELETE   #sec_getUserObject where vtContainerId=-10
	END
	IF ( @nodeType =0 OR  @nodeType = 8462)      -- TM_POLICY_ITEM
IF  EXISTS (SELECT 1 from #sec_getUserObject where vtPolicyId=-10)		-- TM_POLICY_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  vtPolicyId=-10
		MERGE #sec_getUSerObject sec
			USING (SELECT PolicyId 	FROM VTPolicy WITH(NOLOCK)) as entityTable
			ON sec.vtPolicyId=entityTable.PolicyId
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,vtPolicyId)
				VALUES( @capabilities,@commcellId,entityTable.PolicyId);
		IF @getStaticNodeCapabilities = 0
DELETE   #sec_getUserObject where vtPolicyId=-10
	END
	IF ( @nodeType =0 OR  @nodeType = 8180)      -- SHELF_LIBRARY_ITEM
IF EXISTS (SELECT 1 from #sec_getUserObject where vtShelfId=-10)		-- SHELF_LIBRARY_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  vtShelfId=-10
		 MERGE #sec_getUSerObject sec
			USING (SELECT LibraryId
					FROM MMLibrary	WITH(NOLOCK)
					WHERE libraryTypeId = 8
				) as entityTable
			ON sec.vtShelfId=entityTable.LibraryId
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,vtShelfId)
				VALUES( @capabilities,@commcellId,entityTable.LibraryId);
		IF @getStaticNodeCapabilities = 0
DELETE   #sec_getUserObject where vtShelfId=-10
	END
	IF ( @nodeType =0 OR  @nodeType = 4300)      --SCHEDULE_ITEM
IF EXISTS (SELECT 1 from #sec_getUserObject where taskId=-10)		--SCHEDULE_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  taskId=-10
		MERGE #sec_getUSerObject sec
			USING (SELECT taskId
					FROM TM_Task WITH(NOLOCK)
					WHERE taskType=4
				) as entityTable
			ON sec.taskId=entityTable.taskId
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,taskId)
				VALUES( @capabilities,@commcellId,entityTable.taskId);
		IF @getStaticNodeCapabilities = 0
DELETE   #sec_getUserObject where taskId=-10
	END
	IF ( @nodeType =0 OR  @nodeType = 14033)
IF EXISTS (SELECT 1 from #sec_getUserObject where workflowId=-10)		--WORKFLOW_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  workflowId=-10
		MERGE #sec_getUSerObject sec
			USING (SELECT  WorkflowId
					FROM WF_Definition		WITH(NOLOCK)
				) as entityTable
			ON sec.workflowId=entityTable.workflowId
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,workflowId)
				VALUES( @capabilities,@commcellId,entityTable.workflowId);
		IF @getStaticNodeCapabilities = 0
DELETE   #sec_getUserObject where workflowId=-10
	END
	IF ( @nodeType =0 OR  @nodeType = 9501)      -- DM2_REVIEW_SET_ITEM
IF  EXISTS (SELECT 1 from #sec_getUserObject where reviewSetId=-10)		-- DM2_REVIEW_SET_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  reviewSetId=-10
		MERGE #sec_getUSerObject sec
			USING (SELECT  containerId
					FROM DM2Container WITH(NOLOCK)
				WHERE containerType = 9501
				) as entityTable
			ON sec.reviewSetId=entityTable.containerId
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,reviewSetId)
				VALUES( @capabilities,@commcellId,entityTable.containerId);
		IF @getStaticNodeCapabilities = 0
DELETE   #sec_getUserObject where reviewSetId=-10
	END
	IF ( @nodeType =0 OR  @nodeType = 9502)      -- DM2_QUERY_SET_ITEM
IF EXISTS (SELECT 1 from #sec_getUserObject where querySetId=-10)		-- DM2_QUERY_SET_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  querySetId=-10
		MERGE #sec_getUSerObject sec
			USING (SELECT containerId
					FROM DM2Container WITH(NOLOCK)
					WHERE containerType = 9502
				) as entityTable
			ON sec.querySetId=entityTable.containerId
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,querySetId)
				VALUES( @capabilities,@commcellId,entityTable.containerId);
		IF @getStaticNodeCapabilities = 0
DELETE   #sec_getUserObject where querySetId=-10
	END
	IF ( @nodeType =0 OR  @nodeType = 9503)      -- DM2_DOWNLOAD_SET_ITEM
IF EXISTS (SELECT 1 from #sec_getUserObject where downloadSetId=-10)		-- DM2_DOWNLOAD_SET_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  downloadSetId=-10
		MERGE #sec_getUSerObject sec
			USING (SELECT containerId
					FROM DM2Container WITH(NOLOCK)
					WHERE containerType = 9503
				) as entityTable
			ON sec.downloadSetId=entityTable.containerId
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,downloadSetId)
				VALUES( @capabilities,@commcellId,entityTable.containerId);
		IF @getStaticNodeCapabilities = 0
DELETE #sec_getUserObject WHERE downloadSetId=-10
	END
	IF ( @nodeType =0 OR  @nodeType = 9504)      -- DM2_TAG_ITEM
IF (EXISTS (SELECT 1 from #sec_getUserObject where tagId=-10))		-- DM2_TAG_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  tagId=-10
	MERGE #sec_getUSerObject sec
			USING (SELECT containerId 	FROM DM2Container WITH(NOLOCK)
			WHERE containerType = 9504
				) as entityTable
			ON sec.tagId=entityTable.containerId
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,tagId)
				VALUES( @capabilities,@commcellId,entityTable.containerId);
		IF @getStaticNodeCapabilities = 0
DELETE   #sec_getUserObject where tagId=-10
	END
	IF ( @nodeType =0 OR  @nodeType = 9505)      -- DM2_LEGAL_HOLD_ITEM
IF EXISTS (SELECT 1 from #sec_getUserObject where legalHoldId=-10)		-- DM2_LEGAL_HOLD_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  legalHoldId=-10
		 MERGE #sec_getUSerObject sec
			USING (SELECT id 	FROM DM2CompliancePolicy	 WITH(NOLOCK)
				) as entityTable
			ON sec.legalHoldId=entityTable.id
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,legalHoldId)
				VALUES( @capabilities,@commcellId,entityTable.id);
			IF @getStaticNodeCapabilities = 0
DELETE   #sec_getUserObject where legalHoldId=-10
	END
	IF ( @nodeType =0 OR  @nodeType = 9506)      -- DM2_ERM_CONNECTOR_ITEM
IF EXISTS (SELECT 1 from #sec_getUserObject where ermId=-10)	-- DM2_ERM_CONNECTOR_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  ermId=-10
		MERGE #sec_getUSerObject sec
			USING (SELECT id FROM DM2RecordCenterConnector WITH(NOLOCK)	 WHERE id<>1
				) as entityTable
			ON sec.ermId=entityTable.id
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,ermId)
				VALUES( @capabilities,@commcellId,entityTable.id);
		IF @getStaticNodeCapabilities = 0
DELETE   #sec_getUserObject where ermId=-10
	END
	IF ( @nodeType =0 OR  @nodeType = 9507)      -- DM2_CD_POLICY_ITEM
IF EXISTS (SELECT 1 from #sec_getUserObject where cdPolicyId=-10)		-- DM2_CD_POLICY_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  cdPolicyId=-10
	MERGE #sec_getUSerObject sec
			USING (SELECT id FROM SchedAdminComplianceXMLOptions WITH(NOLOCK)	 WHERE id<>1
				) as entityTable
			ON sec.cdPolicyId=entityTable.id
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,cdPolicyId)
				VALUES( @capabilities,@commcellId,entityTable.id);
		IF @getStaticNodeCapabilities = 0
DELETE   #sec_getUserObject where cdPolicyId=-10
	END
	IF ( @nodeType =0 OR  @nodeType = 9508)      -- DM2_COMPLIANCE_REPORT_ITEM
IF EXISTS(SELECT 1 from #sec_getUserObject where complianceReportId=-10)		-- DM2_COMPLIANCE_REPORT_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  complianceReportId=-10
	MERGE #sec_getUSerObject sec
			USING (SELECT containerId
					FROM DM2Container WITH(NOLOCK)
					WHERE containerType = 9508
				) as entityTable
			ON sec.complianceReportId=entityTable.containerId
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,complianceReportId)
				VALUES( @capabilities,@commcellId,entityTable.containerId);
		IF @getStaticNodeCapabilities = 0
DELETE   #sec_getUserObject where complianceReportId=-10
	END
	IF ( @nodeType =0 OR  @nodeType = 9615)      -- ARRAY_ITEM
IF EXISTS (SELECT 1 from #sec_getUserObject where arrayId=-10)		-- ARRAY_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  arrayId=-10
	MERGE #sec_getUSerObject sec
			USING (SELECT ControlHostId
					FROM SMControlHost WITH(NOLOCK)
					WHERE ControlHostId<>0
				) as entityTable
			ON sec.arrayId=entityTable.ControlHostId
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,arrayId)
				VALUES( @capabilities,@commcellId,entityTable.ControlHostId);
		IF @getStaticNodeCapabilities = 0
DELETE   #sec_getUserObject where arrayId=-10
	END
	IF ( @nodeType =0 OR  @nodeType = 8464)      -- TM_DESTINATION_ITEM -- entityId1
IF EXISTS (SELECT 1 from #sec_getUserObject where entityId1=-10)		-- TM_DESTINATION_ITEM -- entityId1
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  entityId1=-10
		MERGE #sec_getUSerObject sec
			USING (SELECT ExportLocationid
					FROM MMExportLocation	WITH(NOLOCK)
				) as entityTable
			ON sec.entityId1=entityTable.ExportLocationid
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,entityId1)
				VALUES( @capabilities,@commcellId,entityTable.ExportLocationid);
		IF @getStaticNodeCapabilities = 0
DELETE   #sec_getUserObject where entityId1=-10
	END
	IF(@nodeType=0 OR @nodeType=9646)   --Log Monitoring
IF EXISTS (SELECT 1 from #sec_getUserObject where logMonitoringPolicyId=-10)   --Log Monitoring
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  logMonitoringPolicyId=-10
		MERGE #sec_getUSerObject sec
			USING (SELECT monitorPolicyId FROM App_MonitoringPolicy	WITH(NOLOCK)
				) as entityTable
			ON sec.logMonitoringPolicyId=entityTable.monitorPolicyId
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,logMonitoringPolicyId)
				VALUES( @capabilities,@commcellId,entityTable.monitorPolicyId);
		IF @getStaticNodeCapabilities = 0
DELETE   #sec_getUserObject where logMonitoringPolicyId=-10
	END
--ELSE IF( @nodeType =0 OR  @nodeType = 7987 AND EXISTS (SELECT 1 from #sec_getUserObject where mediaAgentId=-10))   --SHARE_FOLDER_ITEM
	--BEGIN
--SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  libraryId=-10
	--	INSERT INTO #sec_getUserObject ( capabilities,commCellId,libraryId)
	--		SELECT @capabilities,@commcellId,LibraryId FROM MMLibrary
	--	set @stmtbuff = @stmtbuff + ' OR (entityId2 <> 0))'
	--END
	IF ( @nodeType =0 OR  @nodeType = 9651)     -- CUSTOM_QUERY_ITEM
IF  EXISTS (SELECT 1 from #sec_getUserObject where entityId3=-10)     -- CUSTOM_QUERY_ITEM
	BEGIN
SELECT  @commcellId= commcellId,@capabilities=capabilities from #sec_getUserObject where  entityId3=-10
		MERGE #sec_getUSerObject sec
			USING (SELECT queryId
					FROM NTQueryList WITH(NOLOCK)
				) as entityTable
			ON sec.entityId3=entityTable.queryId
			WHEN MATCHED THEN
				UPDATE SET capabilities=capabilities|@capabilities
			WHEN NOT MATCHED THEN
				INSERT ( capabilities,commCellId,entityId3)
				VALUES( @capabilities,@commcellId,entityTable.queryId);
		IF @getStaticNodeCapabilities = 0
DELETE   #sec_getUserObject where entityId3=-10
	END
PROC_EXIT:
IF(@entityTypeReq <> 0)
BEGIN
	-- commcell permissions
	IF(@capsOnCommcellThisUserHas <> 0)
		INSERT INTO #sec_getUserObject (capabilities, flag, commcellId)
		VALUES  (@capsOnCommcellThisUserHas, 0, 2)
	-- Non IDA
	INSERT INTO #sec_getUserObject
		SELECT
			capabilities,
			0,
			2,
CASE WHEN (@entityTypeReq=28 ) THEN entityId ELSE 0 END,
			0 /*client*/,
			0 /*apptype*/,
			0 /*instance*/,
			0 /*backupset*/,
			0 /*subclient*/,
CASE WHEN (@entityTypeReq=11 ) THEN entityId ELSE 0 END,
CASE WHEN (@entityTypeReq=9 ) THEN entityId ELSE 0 END,
CASE WHEN (@entityTypeReq=17) THEN entityId ELSE 0 END,
CASE WHEN (@entityTypeReq=130) THEN entityId ELSE 0 END,
CASE WHEN (@entityTypeReq=21) THEN entityId ELSE 0 END,
CASE WHEN (@entityTypeReq=57) THEN entityId ELSE 0 END,
CASE WHEN (@entityTypeReq=9501) THEN entityId ELSE 0 END,
CASE WHEN (@entityTypeReq=9502) THEN entityId ELSE 0 END,
CASE WHEN (@entityTypeReq=9503) THEN entityId ELSE 0 END,
CASE WHEN (@entityTypeReq=9504) THEN entityId ELSE 0 END,
CASE WHEN (@entityTypeReq=9505) THEN entityId ELSE 0 END,
CASE WHEN (@entityTypeReq=9506) THEN entityId ELSE 0 END,
CASE WHEN (@entityTypeReq=9507) THEN entityId ELSE 0 END,
CASE WHEN (@entityTypeReq=9508) THEN entityId ELSE 0 END,
CASE WHEN (@entityTypeReq=35) THEN entityId ELSE 0 END,
CASE WHEN (@entityTypeReq=83) THEN entityId ELSE 0 END,
CASE WHEN (@entityTypeReq=90) THEN entityId ELSE 0 END,
CASE WHEN (@entityTypeReq=153) THEN entityId ELSE 0 END,
			0 /*cloudId*/ ,
			0 /*user group*/,
			0 /*provider*/,
CASE WHEN (@entityTypeReq=53) THEN entityId ELSE 0 END,
CASE WHEN (@entityTypeReq=7987) THEN entityId ELSE 0 END,
CASE WHEN (@entityTypeReq=124) THEN entityId ELSE 0 END,
			0 /*EI4*/, 0 /*EI5*/, 0 /*EI6*/, 0 /*EI7*/, 0 /*EI8*/, 0 /*EI9*/
		FROM #nonIdaObjectsV2_OutputTbl
END
DECLARE @finalStmt nvarchar(max)
SET @finalStmt = 'INSERT INTO '+@outputTableArg
				+' SELECT * FROM #sec_getUserObject'
EXEC (@finalStmt)
GO
--#define BUILD_DEBUG_TEST_CODE 1

IF EXISTS (select * from GxQscripts where name = 'sec_getUserObjects')
	delete from GxQscripts where name = 'sec_getUserObjects'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUserObjects')
	delete from GXDBVersions where aliasname = 'sec_getUserObjects'
GO

insert into GXDBVersions values(2, 'sec_getUserObjects',  '00010026000200130000', 'sec_getUserObjects', '00010026000200130000')
GO

