

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getUserGroupsForUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getUserGroupsForUser <<<'

IF EXISTS (select * from sysobjects where name='sec_getUserGroupsForUser')
	drop procedure sec_getUserGroupsForUser
IF EXISTS (select * from GxQscripts where name='sec_getUserGroupsForUser')
	delete from GxQscripts where name = 'sec_getUserGroupsForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUserGroupsForUser')
	delete from GXDBVersions where aliasname = 'sec_getUserGroupsForUser'
GO
print '... Creating Procedure: sec_getUserGroupsForUser'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getUserGroupsForUser
  @i_userId integer,
  @i_isRestrictedViewEnabled integer,
  @i_forModification integer
AS
  DECLARE @groupId integer
SET NOCOUNT ON
DECLARE @GroupIdTbl table (groupIdTbl integer)
DECLARE @canManageAllUsers int = 0
	EXEC sec_canManageAllUsers @i_userId, @canManageAllUsers OUTPUT
DECLARE @IsHideEnabled int = 0
IF @canManageAllUsers = 0 AND @i_forModification = 0
	EXEC sec_isHideEnabled @i_userId, @i_isRestrictedViewEnabled, @IsHideEnabled OUTPUT
DECLARE @userHasUserManagementCap int = 0
DECLARE @ManageUserCapMask bigint = CAST(POWER(2.0, 14 - 1) AS bigint)
	IF @canManageAllUsers = 0 AND @i_forModification <> 0
		EXEC sec_userHasCapability @i_userId, @ManageUserCapMask, @userHasUserManagementCap OUTPUT
DECLARE @ListAllUsers int = 0
IF @canManageAllUsers <> 0	or
	(@i_forModification = 0 AND @IsHideEnabled = 0)
	SET @ListAllUsers = 1
IF @ListAllUsers <> 0
BEGIN
		INSERT INTO @GroupIdTbl
		SELECT UMGroups.id groupId
		FROM UMGroups
		WHERE (	(@i_isRestrictedViewEnabled <> 0 OR UMGroups.name <> 'CV_Restricted_Visibility')
				AND UMGroups.name <> 'Common Outlook Add-Ins'
			)
		ORDER BY UMGroups.id
END
ELSE IF ( @i_forModification = 0 OR @userHasUserManagementCap <> 0  )
BEGIN
		INSERT INTO @GroupIdTbl
		SELECT UMGroups.id groupId
		FROM UMGroups INNER JOIN UMUserGroup ON UMGroups.id = UMUserGroup.groupId
		WHERE	(		UMUserGroup.userId = @i_userId
					AND UMGroups.name <> 'CV_Restricted_Visibility'
					AND UMGroups.name <> 'Common Outlook Add-Ins'
				)
		ORDER BY UMGroups.id
		INSERT INTO @GroupIdTbl
		SELECT  DISTINCT  UMGroups.id groupId
		FROM         UMDSUserGroup INNER JOIN
							  UMDSGroupMaps ON UMDSUserGroup.groupId = UMDSGroupMaps.umDSgroupId INNER JOIN
							  UMGroups ON UMDSGroupMaps.umgroupId = UMGroups.id
		WHERE	(		UMDSUserGroup.userId = @i_userId
					AND UMGroups.name <> 'CV_Restricted_Visibility'
					AND UMGroups.name <> 'Common Outlook Add-Ins'
				)
		ORDER BY UMGroups.id
END
select * from @GroupIdTbl
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getUserGroupsForUser')
	delete from GxQscripts where name = 'sec_getUserGroupsForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUserGroupsForUser')
	delete from GXDBVersions where aliasname = 'sec_getUserGroupsForUser'
GO

insert into GXDBVersions values(2, 'sec_getUserGroupsForUser',  '00000000000000000000', 'sec_getUserGroupsForUser', '00000000000000000000')
GO

