

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getUserGroupsForThisUserWrapper.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  sec_getUserGroupsForThisUserWrapper()
--  |
--  | Description:  Fetches a list of user groups this callerId can see / edit
--	|
--  |
--  |       Input:  callerId, forModification
--	|
--	|		forModification if set to 1, only those user groups whom the caller can edit will be fetched
--  |		forModification if set to 0, all the user groups whom the caller is associated will be fetched
--	|
--  |      Output:  List of user groups
--  |      Return:  xxx
--  |
--  |		THINGS TO DO FURTHER: Handling of restricted view enabled users
--  |
--  |   Author
--  |   ---------
--	|	saggarwal & jswaminathan
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getUserGroupsForThisUserWrapper <<<'

IF EXISTS (select * from sysobjects where name='sec_getUserGroupsForThisUserWrapper')
	drop procedure sec_getUserGroupsForThisUserWrapper
IF EXISTS (select * from GxQscripts where name='sec_getUserGroupsForThisUserWrapper')
	delete from GxQscripts where name = 'sec_getUserGroupsForThisUserWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUserGroupsForThisUserWrapper')
	delete from GXDBVersions where aliasname = 'sec_getUserGroupsForThisUserWrapper'
GO
print '... Creating Procedure: sec_getUserGroupsForThisUserWrapper'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getUserGroupsForThisUserWrapper
  @callerId INT, 
  @forModification INT = 0,							
  @localOrExternalUserGroups INT = 0				
AS
  DECLARE @groupId INTEGER
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#sec_getUserGroupsForThisUserWrapperTbl') IS NOT NULL
	DROP TABLE #sec_getUserGroupsForThisUserWrapperTbl
CREATE TABLE #sec_getUserGroupsForThisUserWrapperTbl
(
	groupId INT
)
EXEC sec_getUserGroupsForThisUser '#sec_getUserGroupsForThisUserWrapperTbl',@callerId,@forModification,@localOrExternalUserGroups
SELECT groupId FROM #sec_getUserGroupsForThisUserWrapperTbl
IF OBJECT_ID('tempdb.dbo.#sec_getUserGroupsForThisUserWrapperTbl') IS NOT NULL
	DROP TABLE #sec_getUserGroupsForThisUserWrapperTbl
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getUserGroupsForThisUserWrapper')
	delete from GxQscripts where name = 'sec_getUserGroupsForThisUserWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUserGroupsForThisUserWrapper')
	delete from GXDBVersions where aliasname = 'sec_getUserGroupsForThisUserWrapper'
GO

insert into GXDBVersions values(2, 'sec_getUserGroupsForThisUserWrapper',  '00000000000000000000', 'sec_getUserGroupsForThisUserWrapper', '00000000000000000000')
GO

