

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getUserGroupsForThisUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  sec_getUserGroupsForThisUser()
--  |
--  | Description:  Fetches a list of user groups this callerId can see / edit
--	|
--  |
--  |       Input:  callerId, forModification
--	|
--	|		forModification if set to 1, only those user groups whom the caller can edit will be fetched
--  |		forModification if set to 0, all the user groups whom the caller is associated will be fetched
--	|
--  |      Output:  List of user groups
--  |      Return:  xxx
--  |
--  |		THINGS TO DO FURTHER: Handling of restricted view enabled users
--  |
--  |   Author
--  |   ---------
--	|	saggarwal & jswaminathan
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_getUserGroupsForThisUser')
BEGIN
	print '>>> Drop Stored Procedure: sec_getUserGroupsForThisUser <<<'
	drop procedure sec_getUserGroupsForThisUser
END
IF EXISTS (select * from GxQscripts where name='sec_getUserGroupsForThisUser')
	delete from GxQscripts where name = 'sec_getUserGroupsForThisUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUserGroupsForThisUser')
	delete from GXDBVersions where aliasname = 'sec_getUserGroupsForThisUser'
GO
print '... Creating Procedure: sec_getUserGroupsForThisUser'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_getUserGroupsForThisUser
  @tableOutput NVARCHAR(MAX),
  @callerId INT, 
  @forModification INT = 0,							
  @localOrExternalUserGroups INT = 0,
  @parentProviderId INT = 0,
  @includeSystemCreated INT = 0,
  @includeAllTenantGroups INT = 0
AS
IF @callerId = 0
	RETURN
DECLARE @entityType AS INT
--@localOrExternalUserGroups = 1 means only local user groups
--@localOrExternalUserGroups = 2 means external user groups and organization groups
--@localOrExternalUserGroups = 3 means only organization user groups
--@localOrExternalUserGroups = 4 means only external user groups (no organization)
--@localOrExternalUserGroups = 5 means local user groups and organization user groups
--@localOrExternalUserGroups = 7 means local user groups + organization user groups of the parent provider + organization user groups of the parent provider's parents (recursively)
--else all user groups
--@parentProviderId = user groups of this domain / org only fetched.
--@includeSystemCreated = includes system created User groups.
--@includeAllTenantGroups = includes all tenant admin and all tenant user groups.
DECLARE @permissionId AS INT
IF @forModification <> 0
SET @permissionId = 102
ELSE
	SET @permissionId = 0
--Few questions need to check out :
--1. How to handle resticted users
--2. If my user is part of a user group but has no association on it, can he see it ?
IF OBJECT_ID('tempdb.dbo.#getUserGroupsForThisUserTable') IS NOT NULL
	DROP TABLE #getUserGroupsForThisUserTable
CREATE TABLE #getUserGroupsForThisUserTable
	(
		userGroupId INT
	)
CREATE CLUSTERED INDEX userGroupId_Idx1 ON #getUserGroupsForThisUserTable(userGroupId)
EXEC sec_getNonIdaObjectsForThisUser @callerId, 15, @permissionId, '#getUserGroupsForThisUserTable'
IF @localOrExternalUserGroups = 1
BEGIN
	DELETE Tbl
	FROM #getUserGroupsForThisUserTable Tbl INNER JOIN UMGroups G
	ON Tbl.userGroupId = G.id
	WHERE G.umdsProviderId <> 0
END
ELSE IF @localOrExternalUserGroups = 2
BEGIN
	DELETE Tbl
	FROM #getUserGroupsForThisUserTable Tbl INNER JOIN UMGroups G
	ON Tbl.userGroupId = G.id
	WHERE G.umdsProviderId = 0
END
ELSE IF @localOrExternalUserGroups = 3
BEGIN
-- means only organization user groups
DELETE Tbl
	FROM #getUserGroupsForThisUserTable Tbl INNER JOIN UMGroups G
	ON Tbl.userGroupId = G.id
	LEFT OUTER JOIN UMDSProviders P ON P.id = G.umdsProviderId
	WHERE G.umdsProviderId = 0 OR (G.umdsProviderId<>0 AND P.serviceType<>5)
END
ELSE IF @localOrExternalUserGroups = 4
BEGIN
--means only AD
	DELETE Tbl
	FROM #getUserGroupsForThisUserTable Tbl INNER JOIN UMGroups G
	ON Tbl.userGroupId = G.id
	LEFT OUTER JOIN UMDSProviders P ON P.id=G.umdsProviderId
	WHERE G.umdsProviderId = 0 OR ( G.umdsProviderId <> 0 AND P.serviceType=5)
END
ELSE IF @localOrExternalUserGroups = 5
BEGIN
--means local user groups and organization user groups
	DELETE Tbl
	FROM #getUserGroupsForThisUserTable Tbl INNER JOIN UMGroups G
	ON Tbl.userGroupId = G.id
	INNER JOIN UMDSProviders P ON P.id=G.umdsProviderId
	WHERE G.umdsProviderId <> 0 AND P.serviceType<>5
END
DECLARE @isRestrictedViewEnabled INT = ISNULL(CAST( (SELECT TOP (1) value FROM GXGlobalParam WHERE name = 'Restricted View Enabled' AND modified = 0) AS INT), 0)
--If the request is only for view, then we can see the user groups that this user belongs to even though he does not have explicit association on it
IF @forModification = 0
BEGIN
	--We can see only these associations
		--1. Normal user groups to whom caller is security associated
		--2. Normal user groups to whom caller belongs to
		--3. Normal user groups mapped to domain group to which caller belongs to
		--4. AD user groups to whom caller is security associated
		--5. AD user groups to whom caller belongs to
	INSERT INTO #getUserGroupsForThisUserTable
		SELECT UMUserGroup.groupId
		FROM UMUserGroup INNER JOIN UMGroups g
		ON UMUserGroup.groupId = g.id
		LEFT OUTER JOIN UMDSProviders p ON p.id = g.umdsProviderId
		WHERE (userId = @callerId) AND
			   ((g.umdsProviderId <> 0 AND (@localOrExternalUserGroups = 0 OR @localOrExternalUserGroups =2  OR (@localOrExternalUserGroups = 4 and p.servicetype<>5) OR ((@localOrExternalUserGroups=3 or @localOrExternalUserGroups=5) and servicetype=5))) OR
			   (g.umdsProviderId = 0 AND (@localOrExternalUserGroups = 0 OR @localOrExternalUserGroups = 1 OR @localOrExternalUserGroups = 5  )))
		UNION
		SELECT UMDSGroupMaps.umGroupId
		FROM UMDSGroupMaps
		WHERE (@localOrExternalUserGroups <> 2 and @localOrExternalUserGroups<>3 and @localOrExternalUserGroups<>4)
			  AND (UMDSGroupMaps.umdsGroupId IN (SELECT UMUserGroup.groupId
												 FROM UMUserGroup
												 WHERE userId = @callerId))
END
--According to Amey, a name server user can see all other user groups belonging to the same name server
--even without having explicit security association. Of course, there is a GxGlobalParam to control this behavior
IF (@localOrExternalUserGroups <> 1) AND (@forModification = 0)
BEGIN
	DECLARE @umdsProviderId INT = (SELECT umdsProviderId FROM UMUsers (NOLOCK) WHERE id = @callerId)
	IF @umdsProviderId > 0
	BEGIN
IF NOT EXISTS (SELECT 1 FROM GxGlobalParam (NOLOCK) WHERE name = 'CanSeePeerNameServerMembers' AND value = '0' AND modified = 0)
		BEGIN
			INSERT INTO #getUserGroupsForThisUserTable
				SELECT g.id
				FROM UMGroups g
				INNER JOIN UMDSProviders p ON p.id = g.umdsProviderId
				WHERE umdsProviderId = @umdsProviderId  and (@localOrExternalUserGroups=0 or ((@localOrExternalUserGroups=3 or @localOrExternalUserGroups=5) and servicetype=5) or  (@localOrExternalUserGroups=4 and servicetype <>5) or @localOrExternalUserGroups=2 )
				EXCEPT
				SELECT userGroupId
				FROM #getUserGroupsForThisUserTable
		END
	END
END
-- For deleting few specific user groups, (like outlook addins, restricted visibility, hidden groups, etc.) get their ids from UMGroups and delete from the temp table in one call.
-- Let us not have individual delete statements for each of them.
DECLARE @allTenantGroupsFlag INT = CAST(0x0040 AS INT) | CAST(0x0080 AS INT)
DECLARE @hiddenFlag INT = CAST(0x0010 AS INT)		-- Using these as variable instead of doing CAST operation in WHERE clause gives better performance.
DECLARE @systemCreatedFlag INT = CAST(536870912 AS INT)
DECLARE @loggedInUserCompanyId INT = dbo.AppGetCompanyForUserOrUserGroup(@callerId, 1)
IF @loggedInUserCompanyId <> 0
	SET @includeAllTenantGroups = 0		-- For a tenant, never return these groups.
IF OBJECT_ID('tempdb.dbo.#toDeleteUserGroupIds') IS NOT NULL
	DROP TABLE #toDeleteUserGroupIds
CREATE TABLE #toDeleteUserGroupIds
(
	id INT PRIMARY KEY
)
INSERT INTO #toDeleteUserGroupIds
	SELECT
		id
	FROM UMGroups (NOLOCK)
	WHERE
		(name = 'Common Outlook Add-Ins')
		OR ((@isRestrictedViewEnabled <= 0) AND (name = 'CV_Restricted_Visibility'))
		OR
		(
			-- Logic is, all hidden groups should be deleted from resultant table.
			-- except:
				-- 1. if include system created = 1, then do not delete system created UGs.
				-- 2. if include all tenant groups = 1, then do not delete all tenant UGs.
			(groupFlags & @hiddenFlag <> 0)
			AND
			(
				((@includeSystemCreated = 0) OR (groupFlags & @systemCreatedFlag = 0))
				AND
				((@includeAllTenantGroups = 0) OR (groupFlags & @allTenantGroupsFlag = 0))
			)
		)
DELETE Sec
FROM #getUserGroupsForThisUserTable Sec
	INNER JOIN #toDeleteUserGroupIds Temp
		ON Sec.userGroupId = Temp.id
-- For deleting groups do not belonging to parent provider, do this way (internally this does a JOIN) rather than a "delete-where-id-in" statement like above.
-- This saves reads from ~35000 to ~200.
IF (@parentProviderID <> 0) AND (@localOrExternalUserGroups <> 7)		-- Retain groups of this parent provider only.
BEGIN
	DELETE Tbl
	FROM #getUserGroupsForThisUserTable Tbl
	WHERE NOT EXISTS (SELECT 1 FROM UMGroups G WHERE G.id = Tbl.userGroupId AND G.umdsProviderId = @parentProviderID )
END
ELSE IF (@parentProviderID <> 0) AND (@localOrExternalUserGroups = 7)		-- Retain local groups and groups of this parent provider or it's parent companies.
BEGIN
	DECLARE @providerIdsTable TABLE
	(
		providerId INT,
		PRIMARY KEY(providerId)
	)
	;WITH tblChild AS
	(
		SELECT id AS childId, ownerCompany AS parentID, serviceType AS serviceType
		FROM UMDSProviders (NOLOCK)
		WHERE
			id = @parentProviderId
		UNION ALL
		SELECT P.id, P.ownerCompany, P.serviceType
		FROM UMDSProviders P (NOLOCK)
			INNER JOIN tblChild T
				ON P.id = T.parentID
		WHERE
			P.id <> 0
	)
	INSERT INTO @providerIdsTable
		SELECT childId
		FROM tblChild
		WHERE
serviceType = 5
	DELETE Tbl
	FROM #getUserGroupsForThisUserTable Tbl
		INNER JOIN UMGroups G
			on tBL.userGroupId = g.ID
		LEFT JOIN @providerIdsTable P
			ON (G.umdsProviderId = P.providerId)
	WHERE
		G.umdsProviderId <> 0 AND P.providerId IS NULL
END
DECLARE @outputstatement AS NVARCHAR(MAX)
SET @outputstatement = 'INSERT INTO '+ @tableOutput +
					   ' SELECT DISTINCT userGroupId FROM #getUserGroupsForThisUserTable'
EXEC (@outputstatement)
IF OBJECT_ID('tempdb.dbo.#getUserGroupsForThisUserTable') IS NOT NULL
	DROP TABLE #getUserGroupsForThisUserTable
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getUserGroupsForThisUser')
	delete from GxQscripts where name = 'sec_getUserGroupsForThisUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUserGroupsForThisUser')
	delete from GXDBVersions where aliasname = 'sec_getUserGroupsForThisUser'
GO

insert into GXDBVersions values(2, 'sec_getUserGroupsForThisUser',  '00000000000000000000', 'sec_getUserGroupsForThisUser', '00000000000000000000')
GO

