

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getUserGroups.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "sec_getUserGroups"
--	|	This Procedure is used to get user(s) details
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getUserGroups')
BEGIN
	print '>>> Drop Stored Procedure: sec_getUserGroups <<<'
	drop procedure sec_getUserGroups
END
IF EXISTS (select * from GxQscripts where name='sec_getUserGroups')
	delete from GxQscripts where name = 'sec_getUserGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUserGroups')
	delete from GXDBVersions where aliasname = 'sec_getUserGroups'
GO
print '... Creating Procedure: sec_getUserGroups'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getUserGroups
  @xmlText XML OUTPUT,
  @returnCursor INT = 1
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
 DECLARE @level int
 SET @level=30
 DECLARE @allEntity int
 DECLARE @userGroupId int
 SET @allEntity = 0
 DECLARE @callerId INT=0
 DECLARE @o_exitVal INT= 1
 DECLARE @o_errorCode INT= 0
 DECLARE @o_errorString  nvarchar(max) = ''
 DECLARE @userSecurityAssocTbl TABLE(groupId INTEGER, secAssocXML XML, groupSecurity XML)
 DECLARE @o_xml XML
 DECLARE @flag INT = 0
 DECLARE @forModification int = 0
DECLARE @isRestrictedViewEnabled INT = ISNULL(CAST( (SELECT TOP (1) value FROM GXGlobalParam WHERE name = 'Restricted View Enabled' AND modified = 0) AS INT), 0)
DECLARE @i_startRowNum INT = 0
DECLARE @i_endRowNum INT = 0
DECLARE @i_limit INT = 0
DECLARE @totalUsers int = 0
DECLARE @localeId INT
DECLARE @includeSystemCreated INT = 0
IF OBJECT_ID('tempdb.dbo.#UserGroupTemp') IS NOT NULL DROP TABLE #UserGroupTemp
IF OBJECT_ID('tempdb.dbo.#UserGroups') IS NOT NULL DROP TABLE #UserGroups
SET @localeId = isnull(@xmlText.value('(//App_GetUserGroupPropertiesRequest/processinginstructioninfo/locale/@localeId)[1]', 'int') , 0)
DECLARE @invitationSentProperty VARCHAR(128) = 'Invitation sent'
DECLARE @preferMachineCentricClient VARCHAR(128) = 'Prefer Machine Centric Client'
DECLARE @parentProviderId INT = 0
SET @i_startRowNum = ISNULL (( SELECT ref.value('@offset', 'INT')
                    FROM  @xmlText.nodes ('App_GetUserGroupPropertiesRequest/pageConfig') R(ref)), 0)
SET @i_limit = ISNULL (( SELECT ref.value('@limit', 'INT')
                    FROM  @xmlText.nodes ('App_GetUserGroupPropertiesRequest/pageConfig') R(ref)), 0)
IF @i_limit <> 0
BEGIN
    SET @i_startRowNum = @i_startRowNum + 1 -- This is done as GUI doesnt want to send 1 as the start :)
    SET @i_endRowNum = @i_startRowNum + @i_limit
END
-- Sort options
DECLARE @sortField VARCHAR(MAX) = ISNULL (( SELECT ref.value('@sortField', 'VARCHAR(MAX)')
                                            FROM  @xmlText.nodes ('App_GetUserGroupPropertiesRequest/pageConfig') R(ref)), 'Id')
DECLARE @sortDirection INT = ISNULL (( SELECT ref.value('@sortDirection', 'INT')
                                            FROM  @xmlText.nodes ('App_GetUserGroupPropertiesRequest/pageConfig') R(ref)), 2)
-- To get around nested case statements for dynamic order by clause.
IF @sortDirection = 1
    SET @sortField = @sortField + 'DESC'
-- Honor these sort tables only if sent in request.
DECLARE @isSortFieldSpecified BIT = 1
IF @xmlText.exist('App_GetUserGroupPropertiesRequest/pageConfig') = 0
	SET @isSortFieldSpecified = 0
IF OBJECT_ID('tempdb.dbo.#userGroupList') IS NOT NULL DROP TABLE #userGroupList
CREATE TABLE #userGroupList(userGroupId INT PRIMARY KEY);
INSERT INTO #userGroupList
SELECT ref.value('@userGroupId', 'INT')
FROM @xmlText.nodes ('App_GetUserGroupPropertiesRequest/userGroups') R(ref)
CREATE TABLE #sec_getUserGroupsTbl
	(
		userGroupId INT PRIMARY KEY
	)
 SET @callerId =ISNULL((SELECT  ref.value('@userId', 'int') AS client
                            FROM    @xmlText.nodes('//App_GetUserGroupPropertiesRequest/processinginstructioninfo/user') R ( ref )),0)
IF(@callerId=0)
BEGIN
	SET @o_exitVal = 1 --GENERIC_ERROR
	SET @o_errorCode=1
	SET @o_errorString='Caller Id is not set'
	GOTO EXIT_ERROR
END
 IF 1 <> @xmlText.exist('//App_GetUserGroupPropertiesRequest/userGroup')
	SET @allEntity = 1
ELSE
BEGIN
	SET @userGroupId = @xmlText.value('(/App_GetUserGroupPropertiesRequest/userGroup/@userGroupId)[1]', 'int')
		IF @userGroupId IS NOT NULL AND @userGroupId > 0
		BEGIN
			--Check whether the userGroup exists
			IF NOT EXISTS(SELECT id FROM UMGroups WHERE id=@userGroupId)
			BEGIN
				SET @o_exitVal = 4 --OBJECT_NOT_FOUND
SET @o_errorCode=((2270 | (CAST(POWER(2, 24) AS BIGINT) * 35)))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = ((2270 | (CAST(POWER(2, 24) AS BIGINT) * 35)))   AND localeId =@localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s',CAST(@userGroupId AS varchar(10)))
				GOTO EXIT_ERROR
			END
		END
		IF @userGroupId IS NULL OR @userGroupId <= 0
		BEGIN
			--For newly created user groups, the input request may have only name. so let us get the id
			DECLARE @userGroupName NVARCHAR(MAX) = @xmlText.value('(/App_GetUserGroupPropertiesRequest/userGroup/@userGroupName)[1]', 'NVARCHAR(MAX)')
			IF @userGroupName IS NOT NULL AND @userGroupName <> ''
			BEGIN
				DECLARE @delimiterPos INT = CHARINDEX('\', @userGroupName, 1)
				IF @delimiterPos > 0
				BEGIN
					DECLARE @umdsProviderName NVARCHAR(MAX) = SUBSTRING(@userGroupName, 1, @delimiterPos-1)
					DECLARE @userGroupNameStripped NVARCHAR(MAX) = SUBSTRING(@userGroupName, @delimiterPos+1, LEN(@userGroupName) - @delimiterPos)
					if not exists (SELECT id FROM UMDSProviders WHERE domainName = @umdsProviderName)
					BEGIN
						SET @o_exitVal = 1 --GENERIC_ERROR
						SET @o_errorCode = 1
						SET @o_errorString = 'Invalid Provider.'
						GOTO EXIT_ERROR
					END
					SET @userGroupId = ISNULL((SELECT id FROM UMGroups WHERE name = @userGroupNameStripped
										AND umdsProviderId in (SELECT id FROM UMDSProviders WHERE domainName = @umdsProviderName) ), 0)
				END
				ELSE
					SET @userGroupId = ISNULL((SELECT id FROM UMGRoups WHERE name = @userGRoupName AND umdsProviderID = 0), 0)
			END
			IF @userGroupId IS NULL OR @userGroupId <= 0
			BEGIN
				SET @o_exitVal = 1 --GENERIC_ERROR
				SET @o_errorCode = 1
				SET @o_errorString = 'User Group does not exists.'
				GOTO EXIT_ERROR
			END
		END
END
SET @forModification =  ISNULL(@xmlText.value('(/App_GetUserGroupPropertiesRequest/@forModification)[1]', 'int'),0)
SET @level = ISNULL(@xmlText.value('(/App_GetUserGroupPropertiesRequest/@level)[1]', 'int'),@level)
SET @flag = ISNULL(@xmlText.value('(/App_GetUserGroupPropertiesRequest/@flag)[1]', 'int'),1)--By default get only local groups
SET @parentProviderId = ISNULL(@xmlText.value('(/App_GetUserGroupPropertiesRequest/parentProvider/@providerId)[1]', 'int'),0)
SET @includeSystemCreated =  ISNULL(@xmlText.value('(/App_GetUserGroupPropertiesRequest/@includeSystemCreated)[1]', 'int'),0)
IF @userGroupID IS NOT NULL AND @userGroupID <> 0
	SET @flag = 0		--all groups. THis group can be a local, AD or an external group. So get all groups and see what it is.
EXEC sec_getUserGroupsForThisUser '#sec_getUserGroupsTbl',@callerId,@forModification,@flag, @parentProviderId,@includeSystemCreated
IF @userGroupId IS NOT NULL AND NOT EXISTS (SELECT * FROM #sec_getUserGroupsTbl where userGroupId=@userGroupId)
BEGIN
	SET @o_exitVal = 5 --ACCESS_DENIED
SET @o_errorCode = (3289 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3289 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId) --'User dont have permissions on userGroup'
	GOTO EXIT_ERROR
END
DECLARE @requestFlags INT = ISNULL(@xmlText.value('(/App_GetUserGroupPropertiesRequest/@getFlags)[1]', 'INT'), 0)
DECLARE @shouldHideV10ADGroups INT = 0
SET @shouldHideV10ADGroups = @requestFlags & 0x001
IF @userGroupId IS NULL AND @shouldHideV10ADGroups = 1
BEGIN
	--Hide the AD groups with GF_GROUP_HIDE_GUI 0x0020 flag set. They were hidden in V10 also.
	DELETE Tbl
	FROM #sec_getUserGroupsTbl Tbl INNER JOIN UMGroups (NOLOCK) G
	ON Tbl.userGroupId = G.id
WHERE G.groupFlags & 0x0020 <> 0
END
CREATE TABLE #UserGroups (
				id int primary key,
				groupId int)
--This table is used for sorting
CREATE TABLE #UserGroupTemp
(
				groupId int primary key, --This will be only used by pageConfig property for sorting purpose
				name nvarchar(255), --This will be only used by pageConfig property  for sorting purpose
				userGroupGuid uniqueidentifier,
				groupFlags int,
				description nvarchar(max),--This will be only used by pageConfig property for sorting purpose
				email nvarchar(255),--This will be only used by pageConfig property for sorting purpose
				umdsProviderId int,
				allCapabilities int,
				allAssociations int,
				umdsproviderName nvarchar(255) default null,
				serviceType int default 0,
				planId int default null,
				planName nvarchar(255) default null,
                planSpecific int default null,
				roleType int default null,
				enableTFA int default 0,
				OwnerCompanyId INT default 0,
				invitationSent int default null,			-- Framing these properties as columns in temp table, rather than querying UMGroupsProp table repeatedly when framing the result XML. Saves ~2 seconds in FC.
				invitationSentTime int default null,
				preferenceMachineCentricClient int default 1,		-- older version has this default as 1.
				enabled int default null,
				isblacklisted int default null,
				isCommCellUserGroup int default null,
				globalGroupName nvarchar(255) default ''
);
IF @userGroupId IS NULL OR @userGroupId = 0			-- Remove this from WHERE clause. Other conditions like Common Outlook Addins or Restricted Visibility are done already in the Security stored proc. No need to duplicate them here.
	INSERT INTO #UserGroupTemp (groupId, name,userGroupGuid, groupFlags, description, email, umdsProviderId, allCapabilities, allAssociations, umdsProviderName, serviceType, ownerCompanyId, planSpecific, enabled, isblacklisted)			-- Framing all these details like enabled, black listed, etc. now itself saves time during XML framing.
		SELECT  UMGroups.id,																	-- groupId
				IIF(UMGroups.umdsProviderID != 0, P.domainName + '\', '') + UMGroups.name,		-- name
				UMGroups.GUID,
				UMGroups.groupFlags,															-- groupFlags
				UMGroups.description,															-- description
				UMGroups.email,																	-- email
				UMGroups.umdsProviderId,														-- umdsProviderId
				UMGroups.allCapabilities,														-- allCapabilities
				UMGroups.allAssociations,														-- allAssociations
				CASE WHEN UMGRoups.umdsProviderId > 0 THEN P.domainName END,					-- umdsProviderName
				CASE WHEN UMGRoups.umdsProviderId > 0 THEN P.serviceType ELSE 0 END,			-- serviceType
				CASE WHEN P.serviceType = 5 THEN P.id ELSE P.ownerCOmpany END,					-- ownerCompanyId
IIF((UMGroups.groupFlags & 536870912) = 0, 0, 1),				-- planSpecific
IIF((UMGroups.groupFlags & 0x0001) = 0, 0, 1),					-- enabled
IIF((UMGroups.groupFlags & 0x20000) = 0, 0, 1)					-- isblacklisted
		FROM UMGroups
			INNER JOIN #sec_getUserGroupsTbl
				ON UMGroups.id = userGroupId
			INNER JOIN UMDSProviders P
				ON UMGroups.umdsProviderId = P.id
			LEFT JOIN #userGroupList inputUG
				ON UMGroups.id = inputUG.userGroupId
			WHERE (NOT EXISTS(SELECT 1 FROM #userGroupList) OR inputUG.userGroupId IS NOT NULL)
ELSE						-- Security check already done if it is a single user group. Separating them, we do not need a join on Security table in this case. Saves ~500ms in FC.
	INSERT INTO #UserGroupTemp (groupId, name,userGroupGuid, groupFlags, description, email, umdsProviderId, allCapabilities, allAssociations, umdsProviderName, serviceType, ownerCompanyId, planSpecific, enabled, isblacklisted, isCommCellUserGroup)			-- Framing all these details like enabled, black listed, etc. now itself saves time during XML framing.
		SELECT  UMGroups.id,																	-- groupId
				IIF(UMGroups.umdsProviderID != 0, P.domainName + '\', '') + UMGroups.name,		-- name
				UMGroups.GUID,
				UMGroups.groupFlags,															-- groupFlags
				UMGroups.description,															-- description
				UMGroups.email,																	-- email
				UMGroups.umdsProviderId,														-- umdsProviderId
				UMGroups.allCapabilities,														-- allCapabilities
				UMGroups.allAssociations,														-- allAssociations
				CASE WHEN UMGRoups.umdsProviderId > 0 THEN P.domainName END,					-- umdsProviderName
				CASE WHEN UMGRoups.umdsProviderId > 0 THEN P.serviceType ELSE 0 END,			-- serviceType
				CASE WHEN P.serviceType = 5 THEN P.id ELSE P.ownerCOmpany END,					-- ownerCompanyId
IIF((UMGroups.groupFlags & 536870912) = 0, 0, 1),				-- planSpecific
IIF((UMGroups.groupFlags & 0x0001) = 0, 0, 1),					-- enabled
IIF((UMGroups.groupFlags & 0x20000) = 0, 0, 1),				-- isblacklisted
				IIF(UMGroups.umdsProviderId > 0, 0, 1)											-- isCommCellUserGroup
		FROM UMGroups
			INNER JOIN UMDSProviders P
				ON UMGroups.umdsProviderId = P.id
		WHERE
			UMGroups.id = @userGroupID
IF (@level >= 10)
BEGIN
    -- if user group was created specifically for the plan then it has corresponded recod in App_PlanProp table. read it frm there and set flag that says
    -- that this a plan assigned user group
	UPDATE  UGT            SET planid = P.id, planName = P.name
FROM    #UserGroupTemp UGT INNER JOIN App_PlanProp PROP WITH(NOLOCK) ON PROP.attrVal = CAST(UGT.groupId AS VARCHAR(32))  AND PROP.attrName = 'Assigned user group'  AND PROP.modified = 0
                               INNER JOIN App_Plan P ON P.id = PROP.componentNameId
    WHERE UGT.planSpecific = 1
    -- for those user group which are not plan assigned and just plan associated read plan associations from user group props table
	UPDATE  UGT            SET planid = P.id, planName = P.name
FROM    #UserGroupTemp UGT INNER JOIN UMGroupsProp PROP WITH(NOLOCK) ON PROP.componentNameId = UGT.groupId AND PROP.attrName = 'Associated Plan' AND PROP.modified = 0
	                           INNER JOIN App_Plan P ON P.id = PROP.attrVal AND P.modified = 0
    WHERE   UGT.planId IS NULL AND UGT.planSpecific = 0
	--UPDATE #UserGroupTemp set roleType=dbo.AppGetUserGroupRoleType(groupId) -- Need to fix this- performance issue. Property is not used so commented out the code.
	-- Cannot merge them into one single call. It is giving wrong data.
	UPDATE #UserGroupTemp
	SET invitationSent = attrVal,
		invitationSentTime = created
	FROM UMGroupsProp
	WHERE
		componentNameId = groupID
		AND (attrName = @invitationSentProperty)
		AND modified = 0
	UPDATE #UserGroupTemp
	SET preferenceMachineCentricClient = attrVal
	FROM UMGroupsProp
	WHERE
		componentNameId = groupID
		AND (attrName = @preferMachineCentricClient)
		AND modified = 0
			UPDATE #UserGroupTemp
	SET globalGroupName = attrVal
	FROM UMGroupsProp
	WHERE
		componentNameId = groupID
		AND (attrName ='Global Group Name')
		AND modified = 0
END
--now sort the table
IF (@isSortFieldSpecified = 1) OR (@level > 10)			-- Sorting and inserting into this table is a costly operation. So let us not do this if not requested: at least for levels 1 and 10. because they are invoked from java GUI.
BEGIN													-- For level >= 10, it is a big XML blob that is being framed. Cannot duplicate it for sort field specified = 0 and 1, so framing the table for level > 10.
	INSERT INTO #UserGroups
		SELECT 	ROW_NUMBER() OVER (ORDER BY
                                    CASE @sortField WHEN 'Id' THEN groupId END,
                                    CASE @sortField WHEN 'IdDESC' THEN groupId END DESC,
                                    CASE @sortField WHEN 'name' THEN umdsproviderName END,
                                    CASE @sortField WHEN 'nameDESC' THEN umdsproviderName  END DESC,
                                    CASE @sortField WHEN 'name' THEN name END,
                                    CASE @sortField WHEN 'nameDESC' THEN name END DESC,
                                    CASE @sortField WHEN 'description' THEN description  END,
                                    CASE @sortField WHEN 'descriptionDESC' THEN description  END DESC,
                                    CASE @sortField WHEN 'enabled' THEN groupFlags  END,
                                    CASE @sortField WHEN 'enabledDESC' THEN groupFlags  END DESC,
                                    CASE @sortField WHEN 'email' THEN email END,
                                    CASE @sortField WHEN 'emailDESC' THEN email END DESC,
                                    CASE @sortField WHEN 'planName' THEN planName END,
                                    CASE @sortField WHEN 'planNameDESC' THEN planName END DESC,
                                    CASE @sortField WHEN 'umdsproviderName' THEN umdsproviderName  END,
                                    CASE @sortField WHEN 'umdsproviderNameDESC' THEN umdsproviderName  END DESC
                                    ),
				groupid
			FROM #UserGroupTemp
		IF (@i_startRowNUM >= 0 AND @i_endRowNum >0)
        BEGIN
            DELETE #UserGroups
            WHERE (id < @i_startRowNUM OR id >= @i_endRowNum)
        END
END
--Get user has rights on user group to see it, pop error , if its not all entity
IF @level = 1
BEGIN
	IF @isSortFieldSpecified = 0			-- When sort field is 0, then we do not even need to JOIN on #User groups table.
	BEGIN
		SET @o_xml = (SELECT
						 (SELECT groupId AS '@userGroupId',
								 name AS '@userGroupName',
								 userGroupGuid AS '@GUID'
						 FOR XML PATH ('userGroupEntity'), TYPE)
					 FROM #UserGroupTemp
					 FOR XML PATH('userGroups'), ROOT('App_GetUserGroupPropertiesResponse'))
	END
	ELSE
	BEGIN
		SET @o_xml = (SELECT
						 (SELECT temp.groupId AS '@userGroupId',
								 temp.name AS '@userGroupName',
								 userGroupGuid AS '@GUID'
						 FOR XML PATH ('userGroupEntity'), TYPE)
					 FROM #UserGroupTemp temp
						INNER JOIN #UserGroups G
							ON temp.groupId = G.groupId
					 ORDER BY G.id				-- This id column already sorted the groups based on the sort condition. So just get it in that order.
					 FOR XML PATH('userGroups'), ROOT('App_GetUserGroupPropertiesResponse'))
	END
END
ELSE
BEGIN
	IF (@level > 10)
	BEGIN
		--Get available userList Too
		IF OBJECT_ID('tempdb.dbo.#GetUsersSec_getGroups') IS NOT NULL
			DROP TABLE #GetUsersSec_getGroups
		CREATE TABLE #GetUsersSec_getGroups (userId INTEGER)
		exec sec_getUsersForThisUser '#GetUsersSec_getGroups',@callerId,0,3
		--Get Security Associations only if all entity is selected
		DECLARE @entityType1 INT
		IF (@allEntity = 1)			-- This case most likely not get hit. So we can bother about the cursor later.
		BEGIN						-- And right now, we do not have an alternate SP or query that could replace this cursor in a single call.
			--For each user in in @User table get securityAssocitions and then join it.
			DECLARE @secAssocXML XML
			DECLARE @groupSecurityXML XML
			DECLARE @groupIdTemp INTEGER
			DECLARE @isAllowed INT
			DECLARE getSecAssocCursor CURSOR
			FOR
			SELECT userGroupId
			FROM #sec_getUserGroupsTbl
			OPEN getSecAssocCursor
			FETCH NEXT FROM getSecAssocCursor INTO @groupIdTemp
			WHILE @@FETCH_STATUS=0
			BEGIN
				exec sec_getSecurityForUserAndUserGroup 0,@groupIdTemp,@callerId,@secAssocXML OUTPUT
SET @entityType1 = 15
				EXEC sec_getSecurityForEntity @callerId, @groupSecurityXML OUTPUT, @entityType1, @groupIdTemp
				SET @isAllowed = 0
				EXEC sec_checkPermissionOnEntity @callerId, 101, @isAllowed OUTPUT, @entityType1, @groupIdTemp
				INSERT INTO @userSecurityAssocTbl
				VALUES (@groupIdTemp,@secAssocXML, @groupSecurityXML)
				FETCH NEXT FROM getSecAssocCursor INTO @groupIdTemp
			END
			CLOSE getSecAssocCursor
			DEALLOCATE getSecAssocCursor
		 END
		 ELSE
		 BEGIN
				exec sec_getSecurityForUserAndUserGroup 0,@userGroupId,@callerId,@secAssocXML OUTPUT
SET @entityType1 = 15
				EXEC sec_getsecurityforentity @callerId, @groupSecurityXML OUTPUT, @entityType1, @userGroupId
				SET @isAllowed = 0
				EXEC sec_checkPermissionOnEntity @callerId, 101, @isAllowed OUTPUT, @entityType1, @userGroupId
				INSERT INTO  @userSecurityAssocTbl
				VALUES(@userGroupId,@secAssocXML, @groupSecurityXML)
		 END
 		 -- Set the owner Company to self in case of local groups and to organization in case of AD groups
		 UPDATE #UserGroupTemp SET ownerCompanyId =  (case temp.serviceType
														when 5 then P.id
														else P.ownerCompany
													end)
		 from #UserGroupTemp temp
		 INNER JOIN UMDSProviders P ON P.id=temp.umdsProviderId
		 -- if enabled at company level, pick val from user group else return disabled at company
		 UPDATE #UserGroupTemp
		 SET enableTFA = G.enableTFA
		 FROM
		 ( (SELECT T.groupId as gId , (CASE ISNULL(attrValInt,0)
									WHEN 0 THEN 2 --disabled at company
									WHEN 2 THEN (case ISNULL((SELECT attrval FROM UMGroupsProp WITH (NOLOCK)
																	WHERE componentNameId = T.groupId
AND attrName = 'DisableTwoFactorAuthentication' and modified =0),'1')
											 when '0' then 1
											 else 0 end)
									ELSE (case ISNULL((SELECT attrval FROM UMGroupsProp WITH (NOLOCK)
																	WHERE componentNameId = T.groupId
AND attrName = 'DisableTwoFactorAuthentication' and modified =0),'0')
											 when '0' then 1
											 else 0 end)
							END) as enableTFA
				FROM APP_COMPANYPROP C WITH (NOLOCK)
				LEFT OUTER JOIN #UserGroupTemp T WITH (NOLOCK) --get the parent company id to fetch the property
				ON  C.componentNameId = T.ownerCompanyId
				and T.umdsproviderId <> 0
WHERE C.attrName='EnableTwoFactorAuthentication' AND C.cs_attrName = checksum('EnableTwoFactorAuthentication')
				and C.modified = 0 )
			UNION
			(SELECT T.groupId , (CASE  ISNULL((C.enableTFA),0)
									WHEN 0 THEN 2 --disabled at global level
									WHEN 2 THEN (case ISNULL((SELECT attrval FROM UMGroupsProp WITH (NOLOCK)
																	WHERE componentNameId = T.groupId
AND attrName = 'DisableTwoFactorAuthentication' and modified =0),'1')
											 when '0' then 1
											 else 0 end)
									ELSE (case ISNULL((SELECT attrval FROM UMGroupsProp WITH (NOLOCK)
																	WHERE componentNameId = T.groupId
AND attrName = 'DisableTwoFactorAuthentication' and modified =0),'0')
											 when '0' then 1
											 else 0 end)
							END) as enableTFA
				FROM #UserGroupTemp T
				LEFT OUTER JOIN
				(
						SELECT value as enableTFA FROM GXGlobalParam C WITH (NOLOCK)
where name='EnableTwoFactorAuthentication'
						and modified = 0
				) C
				ON T.ownerCompanyId=0 --Local belongs to CC
			)
		 ) as G
		 Where groupId = G.gId
	END			-- (@level > 10)
	IF @level = 10				-- This code (level = 10) gets called during User group list loading in Java GUI. Adding any property would cost performance.
	BEGIN						-- So double check if you really need this property at this level.
		IF (@isSortFieldSpecified = 0)
		BEGIN
			SET @o_xml = (
							 SELECT temp.description as '@description',
									   temp.email as '@email',
									   temp.enabled AS '@enabled',
									   temp.allCapabilities '@allCapabilities',
									   temp.allAssociations as '@allAssociations',
									   temp.isblacklisted AS '@isBlackListed',
	   								   temp.serviceType '@serviceType',
									   CASE WHEN ISNULL(temp.planId, 0) > 0 THEN ISNULL(temp.planSpecific, 0) END '@planSpecificGroup',
	      							   temp.invitationSent AS '@inviteSent',
									   temp.invitationSentTime AS '@inviteTime',
									   temp.preferenceMachineCentricClient AS '@preferenceMachineCentricClient',
									   temp.globalGroupName as '@globalGroupName',
									   CASE WHEN temp.roleType >= 0 THEN temp.roleType END AS '@roleType' ,
									   (select temp.groupid as '@userGroupId',temp.name '@userGroupName',temp.userGroupGuid as '@GUID' for XML path('userGroupEntity'),type),
									   (SELECT temp.planId as '@planId', temp.Planname as '@planName' FOR XML PATH ('plan'), TYPE),
									   (SELECT temp.umdsProviderId as '@providerId', temp.umdsproviderName as '@providerDomainName' FOR XML PATH('provider'), TYPE)
							 FROM #UserGroupTemp temp
							 FOR XML PATH('userGroups'), ROOT('App_GetUserGroupPropertiesResponse'))
		END
		ELSE
		BEGIN
			SET @o_xml = (
							 SELECT temp.description as '@description',
									   temp.email as '@email',
									   temp.enabled AS '@enabled',
									   temp.allCapabilities '@allCapabilities',
									   temp.allAssociations as '@allAssociations',
									   temp.isblacklisted AS '@isBlackListed',
	   								   temp.serviceType '@serviceType',
									   CASE WHEN ISNULL(temp.planId, 0) > 0 THEN ISNULL(temp.planSpecific, 0) END '@planSpecificGroup',
	      							   temp.invitationSent AS '@inviteSent',
									   temp.invitationSentTime AS '@inviteTime',
									   temp.preferenceMachineCentricClient AS '@preferenceMachineCentricClient',
									    temp.globalGroupName as '@globalGroupName',
									   CASE WHEN temp.roleType >= 0 THEN temp.roleType END AS '@roleType' ,
									   (select temp.groupid as '@userGroupId',temp.name '@userGroupName',temp.userGroupGuid as '@GUID' for XML path('userGroupEntity'),type),
									   (SELECT temp.planId as '@planId', temp.Planname as '@planName' FOR XML PATH ('plan'), TYPE),
									   (SELECT temp.umdsProviderId as '@providerId', temp.umdsproviderName as '@providerDomainName' FOR XML PATH('provider'), TYPE)
							 FROM #UserGroupTemp temp
								INNER JOIN #UserGroups g
									ON g.groupid=temp.GroupId
							 ORDER BY G.id					-- This id column already sorted the groups based on the sort condition. So just get it in that order.
							 FOR XML PATH('userGroups'), ROOT('App_GetUserGroupPropertiesResponse'))
		END
	END
	ELSE IF @level > 10			-- Most likely, this code will be executed only for one user group. So performance wise we should be good here even if we query UMGroupsProp multiple times.
	BEGIN
		SET @o_xml = (
						SELECT temp.description as '@description',
								temp.email as '@email',
								temp.enabled AS '@enabled',
								temp.allCapabilities '@allCapabilities',
								temp.allAssociations as '@allAssociations',
								temp.isBlackListed AS '@isBlackListed',
								temp.isCommCellUserGroup AS '@isCommCellUserGroup',
								STUFF((select  ','+LTRIM(RTRIM(UMDSProviders.domainName+'\'+ UMGroups.name))  from UMGroups
										inner join  UMUserandGroupEntityAssociation
										on UMGroups.id=UMUserandGroupEntityAssociation.groupId
										inner join UMDSProviders on UMGroups.umdsProviderId=UMDSProviders.id
										inner join #sec_getUserGroupsTbl on #sec_getUserGroupsTbl.userGroupId=UMGroups.id
and UMGroups.umdsProviderId <>0 and UMUserandGroupEntityAssociation.entityType=9509 and UMUserandGroupEntityAssociation.groupId<>0 and UMUserandGroupEntityAssociation.objectId=temp.groupId FOR XML PATH('') ),1,1,'') as  '@complianceDelegationUserGroups',
								STUFF((select  ','+LTRIM(RTRIM(UMUsers.login))   from UMUsers
										inner join  UMUserandGroupEntityAssociation
										on UMUsers.id=UMUserandGroupEntityAssociation.userId
										inner join #GetUsersSec_getGroups on #GetUsersSec_getGroups.userId=UMUsers.id
and UMUserandGroupEntityAssociation.userId<>0 and UMUsers.umDSproviderId<>0   and UMUserandGroupEntityAssociation.entityType=9509 and UMUsers.enabled=1  and UMUserandGroupEntityAssociation.objectId=temp.groupId FOR XML PATH('')),1,1,'') as '@complianceDelegationUsers',
ISNULL((select top 1 attrVal from UMGroupsProp with (nolock) where componentNameId = g.groupId and attrName like 'Quota size' and modified = 0), 100)   as '@quotaLimitInGB',
ISNULL((select attrVal from UMGroupsProp with (nolock) where componentNameId = g.groupId and attrName like 'Enforce quota'  and modified = 0), 0) '@enforceFSQuota',
ISNULL((select top 1 attrVal from UMGroupsProp with (nolock) where componentNameId = g.groupId and attrName like 'Edge Drive Quota Size' and modified = 0), 100) '@edgeDriveQuotaLimitInGB',
ISNULL((select attrVal from UMGroupsProp with (nolock) where componentNameId = g.groupId and attrName like 'Enforce Edge Drive Quota'  and modified = 0), 0) '@enforceEdgeDriveQuota',
ISNULL((select attrVal from UMGroupsProp with (nolock) where componentNameId = g.groupId and attrName = 'Age Password in Days'  and modified = 0), 0) '@agePasswordDays',
ISNULL((select attrVal from UMGroupsProp with (nolock) where componentNameId = g.groupId and attrName = 'Password History Count'  and modified = 0), 0) '@pswdHistoryCount',
								temp.serviceType '@serviceType',
								CASE WHEN ISNULL(temp.planId, 0) > 0 THEN ISNULL(temp.planSpecific, 0) END '@planSpecificGroup',
								temp.preferenceMachineCentricClient '@preferenceMachineCentricClient',
								 temp.globalGroupName as '@globalGroupName',
								temp.enableTFA AS '@enableTwoFactorAuthentication',
								--invite
								temp.invitationSent AS '@inviteSent',
								temp.invitationSentTime	AS '@inviteTime' ,
								CASE WHEN temp.roleType >= 0 THEN temp.roleType END AS '@roleType' ,
								(select temp.groupid as '@userGroupId',temp.name '@userGroupName',temp.userGroupGuid as '@GUID' for XML path('userGroupEntity'),type),
								(
								select UMUsers.id as '@userId' ,UMUsers.login as '@userName'
								from UMUserGroup, UMUsers, #GetUsersSec_getGroups secUserIdTbl where  secUserIdTbl.userId=UMUsers.id and groupId = g.groupId and UMUsers.id = UMUserGroup.userId
								for XML path('users'),type
								),
								--plan
								(
								SELECT temp.planId as '@planId', temp.Planname as '@planName'
								FOR XML PATH ('plan'), TYPE
								),
								--DOMAIN INFORAMTION
								(
								SELECT temp.umdsProviderId as '@providerId', temp.umdsproviderName as '@providerDomainName'
								FOR XML PATH('provider'), TYPE
								),
								(
								SELECT UMDSGroupMaps.umdsGroupId AS '@groupId', UMGroups.name AS '@externalGroupName', UMDSProviders.domainName AS '@providerDomainName'
								FROM UMDSGroupMaps INNER JOIN UMGroups ON UMDSGroupMaps.umdsGroupId = UMGroups.id
								INNER JOIN UMDSProviders ON UMDSProviders.id = UMGroups.umdsProviderId
								WHERE (UMDSGroupMaps.umGroupId = g.groupId) AND (dbo.isExternalLocalGroupSingleList() = 0)
								FOR XML PATH ('externalUserGroups'), TYPE
								),
								(
								SELECT UMDSGroupMaps.umdsGroupId AS '@userGroupId', UMDSProviders.domainName + '\' + UMGroups.name AS '@userGroupName'
								FROM UMDSGroupMaps INNER JOIN UMGroups ON UMDSGroupMaps.umdsGroupId = UMGroups.id
								INNER JOIN UMDSProviders ON UMDSProviders.id = UMGroups.umdsProviderId
								WHERE (UMDSGroupMaps.umGroupId = g.groupId) AND (dbo.isExternalLocalGroupSingleList() = 1)
								FOR XML PATH ('associatedExternalUserGroups'), TYPE
								),
								(
								SELECT UMDSGroupMaps.umGroupId AS '@userGroupId', UMGroups.name AS '@userGroupName'
								FROM UMDSGroupMaps INNER JOIN UMGroups ON UMDSGroupMaps.umGroupId = UMGroups.id
								WHERE (UMDSGroupMaps.umdsGroupId = g.groupId)
								FOR XML PATH ('localUserGroups'), TYPE
								),
								-- V10 associations blob for backward compabitibility
								(
								SELECT dbo.getGenericXMLFromEntityType(entityType1, entityId1, entityType2, entityId2, entityTYpe3, entityId3, entityType4, entityId4, entityType5, entityId5, 0, includeAll, 'associations')
								FROM UMSecurityAssociations Sec INNER JOIN UMGroupsProp Prop
								ON Sec.isUser = 0 AND Sec.userOrGroupId = Prop.componentNameId
WHERE Sec.roleId = CAST(prop.attrVal AS INT) AND Prop.attrName = 'SystemCreatedRole_' AND Sec.userOrGroupId = g.groupId AND Prop.modified = 0
								FOR XML PATH (''), type
								),
								(
								SELECT DISTINCT dbo.sec_permissionToCapability(Rpe.permissionId)
												AS '@capability'
								FROM UMGroupsProp Prop INNER JOIN UMRolesWithPermissionsExpanded Rpe
								ON Rpe.roleId = CAST(Prop.attrVal AS INT)
WHERE Prop.attrName = 'SystemCreatedRole_' AND Prop.modified = 0 AND Prop.componentNameId = g.groupId
								FOR XML PATH ('capabilities'), TYPE
								),
								CASE WHEN @userGroupId is NULL THEN
										(SELECT (SELECT SecTbl.secAssocXML.query('App_SecurityAssociationForUserOrGroupList/associations') FOR XML PATH(''),TYPE),
												(SELECT SecTbl.secAssocXML.query('App_SecurityAssociationForUserOrGroupList/inheritedAssociations') FOR XML PATH(''),TYPE)
												FOR XML PATH ('securityAssociations'), TYPE)
								ELSE
										(SELECT (SELECT @secAssocXML.query('App_SecurityAssociationForUserOrGroupList/associations') FOR XML PATH(''),TYPE),
												(SELECT @secAssocXML.query('App_SecurityAssociationForUserOrGroupList/inheritedAssociations') FOR XML PATH(''),TYPE)
												FOR XML PATH ('securityAssociations'), TYPE)
								END,
								CASE  WHEN @userGroupId is NULL THEN
										(SELECT SecTbl.groupSecurity AS 'groupSecurity' FOR XML PATH (''),TYPE)
								ELSE
										(SELECT @groupSecurityXML AS 'groupSecurity' FOR XML PATH (''),TYPE)
								END,
								(
										(SELECT
																	CR.keyName as '@keyName',
																	CR.type as '@type',
																	(CASE CR.type WHEN 'ENCRYPTED' THEN '********' ELSE CR.value END) as '@value',
																	CR.relativepath as '@relativepath',
																	--CR.deleted as '@deleted',
																	CR.enabled as '@enabled',
																	ISNULL(AdvEx.details.value('(/App_AdvanceSettingProps/@comment)[1]','NVARCHAR(MAX)'),N'') as '@comment',
																	NULL as '@isInheritedFromClientGroup',
																	(SELECT
																	CASE CR.sourceEntityType WHEN 0 THEN NULL ELSE CR.sourceEntityType END AS '@_type_',
																	CASE CR.sourceEntityType WHEN 15 THEN CR.sourceId ELSE NULL END AS '@userGroupId',
																	CASE CR.sourceEntityType WHEN 13 THEN  CR.sourceId ELSE NULL END AS '@userId',
																	CASE CR.sourceEntityType WHEN 189 THEN CR.sourceId ELSE NULL END AS '@companyId'
																	FOR XML PATH('sourceEntity'),TYPE)
																	FROM APP_AdvanceSettings as CR WITH(NOLOCK)
																	LEFT OUTER JOIN APP_AdvanceSettingsEx AdvEx WITH(NOLOCK)
																	ON CR.id = AdvEx.keyId
																	WHERE CR.entityId = g.groupid AND CR.entityType = 15 --USER_ENTITY
																	and CR.deleted = 0
																	FOR XML PATH('additionalSettings'),TYPE)
								),
								(SELECT
									(SELECT attrVal from UMGroupsProp with (nolock) where componentNameId = g.groupId and attrName like 'Vcloud') as '@isVcloud',
									(SELECT  attrVal from UMGroupsProp with (nolock) where componentNameId = g.groupId and attrName like 'External Authentication URL') as '@authenticationURL',
									(SELECT  attrVal from UMGroupsProp with (nolock) where componentNameId = g.groupId and attrName like 'External Token Validation URL') as '@validationURL',
									(CASE WHEN EXISTS(SELECT 1 from APP_InstanceProp (NOLOCK) WHERE attrname = 'Virtual Server Instance Type' and attrVal = 103) THEN 1
										ELSE 0 END) AS '@vCloudDirectorFlag'
								FOR XML PATH ('vcloudGroupProp'), TYPE)
								,
								(SELECT
(SELECT attrVal from UMGroupsProp with (nolock) where componentNameId = g.groupId and attrName = 'API Quota Limit') as '@APILimit',
(SELECT  attrVal from UMGroupsProp with (nolock) where componentNameId = g.groupId and attrName = 'API Quota Time Frame') as '@APItimeFrame'
								FOR XML PATH ('apiQuota'), TYPE)
								FROM #UserGroupTemp temp
									INNER JOIN #UserGroups g
										ON temp.groupId = g.groupId
									LEFT OUTER JOIN @userSecurityAssocTbl SecTbl
										ON g.groupId=SecTbl.groupId
								FOR XML PATH('userGroups'), ROOT('App_GetUserGroupPropertiesResponse'))
			END			-- @level > 10
END
EXIT_ERROR:
IF(@o_xml IS NULL)
        SET @o_xml = '<App_GetUserGroupPropertiesResponse/>'
 IF @o_errorCode <> 0
 BEGIN
 SET @o_xml = (
 SELECT
@o_errorCode AS '@errorCode',
@o_errorString AS '@errorMessage',
'exitval' as 'processinginstructioninfo/attributes/@name',
@o_exitVal as 'processinginstructioninfo/attributes/@value'
FOR xml path('EVGui_GenericResp'))
END
 IF object_id('tempdb.dbo.#GroupsForUser') IS NOT NULL
    BEGIN
        DROP TABLE #GroupsForUser
    END
IF OBJECT_ID('tempdb.dbo.#sec_getUserGroupsTbl') IS NOT NULL DROP TABLE #sec_getUserGroupsTbl
IF OBJECT_ID('tempdb.dbo.#UserGroupTemp') IS NOT NULL DROP TABLE #UserGroupTemp
IF OBJECT_ID('tempdb.dbo.#UserGroups') IS NOT NULL DROP TABLE #UserGroups
IF OBJECT_ID('tempdb.dbo.#userGroupList') IS NOT NULL DROP TABLE #userGroupList
IF @returnCursor = 1
	SELECT @o_xml
ELSE
	SET @xmlText = @o_xml
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getUserGroups')
	delete from GxQscripts where name = 'sec_getUserGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUserGroups')
	delete from GXDBVersions where aliasname = 'sec_getUserGroups'
GO

insert into GXDBVersions values(2, 'sec_getUserGroups',  '00000000000000000000', 'sec_getUserGroups', '00000000000000000000')
GO

