

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getUserCredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_getUserCredentials.sp,v $ $Id: sec_getUserCredentials.sp,v 1.13.86.1 2017/02/10 21:57:48 sjohnson Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_getUserCredentials()
--  |
--  | Description:  Fetches a flattened list of objects the selected user has
--	|			    rights to and puts into passed in table
--  |
--  |        Note:  CODE MOVED TO SEC_GETUSERCREDDENTIALS PROCEDURE .. CALL HERE
--	|				.. FOR Legacy Support Only
--	|
--  |       Input:  userId, scope, scopeId, outputTableArg
--	|
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getUserCredentials <<<'

IF EXISTS (select * from sysobjects where name='sec_getUserCredentials')
	drop procedure sec_getUserCredentials
IF EXISTS (select * from GxQscripts where name='sec_getUserCredentials')
	delete from GxQscripts where name = 'sec_getUserCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUserCredentials')
	delete from GXDBVersions where aliasname = 'sec_getUserCredentials'
GO
print '... Creating Procedure: sec_getUserCredentials'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getUserCredentials
  @userId integer
AS
SET NOCOUNT ON
create table  #getUserCredentialsTmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		EXEC sec_getUserObjects @userId, 0, 0, '#getUserCredentialsTmp'
--
--		Check if user has only capabilities and if so we should allow them to login unless globalparam flag exists not to
		IF NOT EXISTS (SELECT * FROM #getUserCredentialsTmp)
		BEGIN
			IF NOT EXISTS (SELECT * FROM GXGlobalParam WHERE name = 'NotAllowUserWithoutAssocToLogin' AND modified = 0 AND value = 1)
			BEGIN
				DECLARE @caps TABLE (capability BIGINT)
				INSERT INTO @caps
				EXEC sec_checkUserHasCapWithoutAssoc @userId
				IF EXISTS(SELECT * FROM @caps WHERE capability > 0)
				BEGIN
					INSERT INTO #getUserCredentialsTmp(capabilities, flag, commCellId, clientGroupId, clientId,
						appTypeId, instanceId, backupsetId, subClientId, mediaAgentId,   libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
						reviewSetId, querySetId, downloadSetId, ermId, legalHoldId, tagId, cdPolicyId, complianceReportId, taskId, workflowId,
						logMonitoringPolicyId, arrayId, cloudId, userGroupId, providerId, entityId1, entityId2, entityId3, entityId4, entityId5,
						entityId6, entityId7, entityId8, entityId9)
					SELECT capability,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
					FROM @caps
				END
			END
		END
--
		SELECT 	*
		FROM #getUserCredentialsTmp
		DROP Table #getUserCredentialsTmp
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getUserCredentials')
	delete from GxQscripts where name = 'sec_getUserCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUserCredentials')
	delete from GXDBVersions where aliasname = 'sec_getUserCredentials'
GO

insert into GXDBVersions values(2, 'sec_getUserCredentials',  '00010013008600010000', 'sec_getUserCredentials', '00010013008600010000')
GO

