

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getUserCreatedEntitiesCount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_getUserCreatedEntitiesCount.sp,v $ $Id: sec_getUserCreatedEntitiesCount.sp,v 1.1.4.2 2018/11/06 06:17:20 csingh Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_getUserCreatedEntitiesCount()
--  |
--  | Description:  get count of user created entities of a particular entity type.
--  |
--  |       Input:  either userId or userGUID
--	|
--  |      Output:  count of entities of entityType created by the user
--  |      Return:
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--	|
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getUserCreatedEntitiesCount')
BEGIN
	print '>>> Drop Stored Procedure: sec_getUserCreatedEntitiesCount <<<'
	drop procedure sec_getUserCreatedEntitiesCount
END
IF EXISTS (select * from GxQscripts where name='sec_getUserCreatedEntitiesCount')
	delete from GxQscripts where name = 'sec_getUserCreatedEntitiesCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUserCreatedEntitiesCount')
	delete from GXDBVersions where aliasname = 'sec_getUserCreatedEntitiesCount'
GO
print '... Creating Procedure: sec_getUserCreatedEntitiesCount'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getUserCreatedEntitiesCount
  @i_userId INT = 0,
  @i_userGUID VARCHAR(512) = '',
  @i_entityType INT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
BEGIN
    IF ISNULL(@i_userId,0) = 0 AND ISNULL(@i_userGUID,'') <> ''
    BEGIN
        SELECT @i_userId = id FROM UMUsers WHERE userGuid = @i_userGUID and enabled=1
    END
    IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') IS NOT NULL
        DROP TABLE #getMemberUserGroupsHelperOutputTbl
    CREATE TABLE #getMemberUserGroupsHelperOutputTbl
    (
        isUser INT,
        userOrGroupId INT,
        UNIQUE CLUSTERED (isUser, userOrGroupId)
    )
	EXEC sec_getMemberUserGroupsHelper @userId=@i_userId
	SELECT COUNT(DISTINCT entityId1) FROM UMSecurityAssociations US,#getMemberUserGroupsHelperOutputTbl UG
    WHERE US.entityType1 = @i_entityType AND US.isCreator=1 AND US.userOrGroupId = UG.userOrGroupId AND US.isUser = UG.isUser
	IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') IS NOT NULL
        DROP TABLE #getMemberUserGroupsHelperOutputTbl
END
  SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getUserCreatedEntitiesCount')
	delete from GxQscripts where name = 'sec_getUserCreatedEntitiesCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUserCreatedEntitiesCount')
	delete from GXDBVersions where aliasname = 'sec_getUserCreatedEntitiesCount'
GO

insert into GXDBVersions values(2, 'sec_getUserCreatedEntitiesCount',  '00010001000400020000', 'sec_getUserCreatedEntitiesCount', '00010001000400020000')
GO

