

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getUserCapabilitiesForDM2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_getUserCapabilitiesForDM2.sp,v $ $Id: sec_getUserCapabilitiesForDM2.sp,v 1.7.2.6 2020/11/19 09:43:25 jswaminathan Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_getUserCapabilitiesForDM2()
--  |
--  | Description:  Fetches a flattened list of objects the selected user has
--	|			    rights to and puts into passed in table
--  |
--  |        Note:  CODE MOVED TO SEC_GETUSERCREDDENTIALS PROCEDURE .. CALL HERE
--	|				.. FOR Legacy Support Only
--	|
--  |       Input:  userId, scope, scopeId, outputTableArg
--	|
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_getUserCapabilitiesForDM2')
BEGIN
	print '>>> Drop Stored Procedure: sec_getUserCapabilitiesForDM2 <<<'
	drop procedure sec_getUserCapabilitiesForDM2
END
IF EXISTS (select * from GxQscripts where name='sec_getUserCapabilitiesForDM2')
	delete from GxQscripts where name = 'sec_getUserCapabilitiesForDM2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUserCapabilitiesForDM2')
	delete from GXDBVersions where aliasname = 'sec_getUserCapabilitiesForDM2'
GO
print '... Creating Procedure: sec_getUserCapabilitiesForDM2'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_getUserCapabilitiesForDM2
  @i_capability bigint,
  @i_UserName NVARCHAR(255),
  @i_domainName NVARCHAR(255),
  @i_extGroupTableArg VARCHAR(100),
  @o_userObjTableArg VARCHAR(100) OUTPUT
AS
SET NOCOUNT ON
BEGIN
	DECLARE @userId			INT
DECLARE @extGroupList	TABLE( t_groupName	varchar(255) )
	-------------------------------
	--CREATE TEMP TABLE------------
	-------------------------------
	-- None of these temp tables should ever exist when this procedure is called!
	if object_id('tempdb.dbo.#userObjectsTbl') is not null
				DROP TABLE #userObjectsTbl
	CREATE TABLE #userObjectsTbl (	commCellId	integer, clientId	integer, appTypeId	integer,
						instanceId	integer, backupsetId	integer, subClientId	integer, archGroupId	integer )
	IF object_id('tempdb.dbo.#GetUserCapabilitiesForDM2_userObjects') is not null
	   DROP TABLE #GetUserCapabilitiesForDM2_userObjects
create table  #GetUserCapabilitiesForDM2_userObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	INSERT INTO @extGroupList (t_groupName)
	EXEC ('SELECT * FROM ' + @i_extGroupTableArg)
	IF EXISTS (SELECT * FROM @extGroupList)
	BEGIN
		DECLARE @UMDSProvider	INT
		SET @UMDSProvider = (SELECT	TOP 1 umdsproviderId
								FROM	UMDSGroups, @extGroupList
							WHERE	name = t_groupName and umdsProviderId IN (SELECT id FROM UMDSProviders WHERE domainName = @i_domainName) and enabled = 1
							)
		-- CREATE TEMP UM TABLES
		IF object_id('tempdb.dbo.#UMUsers') is not null
			DROP TABLE #UMUsers
		SELECT * INTO #UMUsers FROM UMUsers WHERE 1<>1
		IF object_id('tempdb.dbo.#UMDSUserGroup') is not null
			DROP TABLE #UMDSUserGroup
		SELECT * INTO #UMDSUserGroup FROM UMDSUserGroup WHERE 1<>1
		EXEC sec_getUserObjects @userId, 0, 0, '#GetUserCapabilitiesForDM2_userObjects'
		INSERT INTO #UMUsers
SELECT	'', '', '', '', '', dbo.getUnixTime(getUTCDate()), 0, 0, 1, 0x001, 0, 0, '', dbo.getUnixTime(getUTCDate()), 0, @UMDSProvider, '', ''
		SET @userId = @@IDENTITY
		INSERT INTO #UMDSUserGroup
		SELECT	@userId, id, 1
		FROM	UMDSGroups, @extGroupList
		WHERE	name = t_groupName and umdsProviderId = @UMDSProvider and enabled = 1
-- added CVS ID so that we know what version of the SP Body is included into an SP when installed on a running system.
-- SPBODY:: @(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/SPBodies/sec_updateUserCredentials.spb,v $ $Id: sec_updateUserCredentials.spb,v 1.81.2.9 2018/12/27 16:37:38 vikashkumar Exp $
-- added to improve performance of ADO invocations
SET ARITHABORT ON
DECLARE @allCapabilities  bigint
DECLARE @commcellId	  integer
DECLARE @type1		  integer
DECLARE @type2		  integer
DECLARE @type3		   integer
DECLARE @type4		   integer
DECLARE @id1		   integer
DECLARE @id2		   integer
DECLARE @id3		   integer
DECLARE @id4           integer
DECLARE @capabilities  bigint
DECLARE @instanceId	   int
DECLARE @backupsetId   int
DECLARE @entityOwnerId int
DECLARE @now           integer
DECLARE @error         integer
DECLARE @lastLogInTime integer
DECLARE @credSetTime   integer
DECLARE @expireTimeSecs integer
declare @expireDaysName nvarchar(80)
declare @expireDaysVal nvarchar(80)
DECLARE @providerID    		  integer
DECLARE @providercheckTime    integer
DECLARE @providerEnabled 	  integer
DECLARE @entityId int = 0
DECLARE @providerType integer
DECLARE @systemcaps bigint
--WILL USE THIS FOR ASSOCIATED OBJECTS WERE "ALL CAPABILITIES" ARE SET
set @allCapabilities = (select SUM(POWER(2.0, id-1)) FROM UMCapability)
SET @now             =   dbo.GetUnixTime (GetUTCdate())
--SET @lastLogInTime   = (select lastLogInTime from UMUSERS_TABLE where id = @userId)
--SET @credSetTime     = (select credSetTime   from UMUSERS_TABLE where id = @userId)
--SET @providerID =       (select umDSproviderId FROM UMUSERS_TABLE where id = @userId)
-- only get row once instead of 3 times
SELECT
	@providerID  = u.umDSproviderId,
	@lastLogInTime = u.lastLogInTime,
	@credSetTime = u.credSetTime
FROM #UMUsers u WITH(NOLOCK)
WHERE
	u.id = @userId
set @expireDaysName = 'UMDS User Expiration Days'
set @expireDaysVal = Isnull((select value from gxglobalParam where name = @expireDaysName), '60')
SET @expireTimeSecs      = (60*60*24 * @expireDaysVal)
SET @commcellId      = 2
SET @systemcaps = CONVERT(BIGINT,(ISNULL((SELECT value FROM GXGLOBALPARAM WHERE name  = 'SystemOwnerCapibilities'),'0')))
-------------------------------------------------------------------------------
-- BEFORE WE DO ANY "REAL" WORK HERE, SEE IF THE CONTENTS ALREADY CACHED IN  --
-- THE "UMUSERCREDENTIALS_TABLE" TABLE ARE CURRENT ENOUGH TO USE                   --
-------------------------------------------------------------------------------
IF  @userId = 0
   GOTO GET_USER_CREDENTIALS_EXIT
--SET @providerEnabled   = ISNULL((select enabled from UMDSProviders where id = @providerId), 0)
--SET @providerType	   = ISNULL((select serviceType from UMDSProviders where id = @providerId), UMDS_PROVIDER_ACTIVE_DIR)
--SET @providerChecktime = ISNULL((select checkTime from UMDSProviders where id = @providerId), 0)
-- only get row once instead of 3 times
SELECT
	@providerEnabled = ISNULL(p.enabled, 0),
@providerType = ISNULL(p.serviceType, 2),
	@providerChecktime = ISNULL(p.checkTime, 0)
FROM
	UMDSProviders p
WHERE
	p.id = @providerId
--------------------------------------------------
-- USERS FROM DISABLED PROVIDERS CANNOT LOG IN! --
--------------------------------------------------
IF @providerEnabled = 0
BEGIN
delete #UMUserCredentials Where UserId = @userID
UPDATE #UMUsers SET credSetTime = 0 WHERE id = @userId
	GOTO GET_USER_CREDENTIALS_EXIT
END
IF  @credSetTime = 0
   GOTO GET_USER_CREDENTIALS_UPDATE
IF @credSetTime + @expireTimeSecs < @now
    GOTO  GET_USER_CREDENTIALS_UPDATE
IF @providerChecktime > 0 AND (@credSetTime + @providerChecktime) < @now
    GOTO  GET_USER_CREDENTIALS_UPDATE
IF @credSetTime >= @lastLogInTime
   GOTO GET_USER_CREDENTIALS_EXIT
GET_USER_CREDENTIALS_UPDATE:
DECLARE @tranCount integer = @@TRANCOUNT
DECLARE @isTranStarted INT = 0
BEGIN TRY
--=================================================================
-- Move Temp check / cleanup before transaction begin if started
--=================================================================
-- NOTE: Moved to before the Transaction is started so
--		 they are outside the transaction!
-- None of these temp tables should ever exist when this procedure is called!
if object_id('tempdb.dbo.#shortUserAssocList') is not null
    DROP TABLE #shortUserAssocList
if object_id('tempdb.dbo.#flatView') is not null
    DROP TABLE #flatView
if object_id('tempdb.dbo.#AssociationsWithCapabilites') is not null
    DROP TABLE #AssociationsWithCapabilites
if object_id('tempdb.dbo.#OwnerCapabilites') is not null
    DROP TABLE #OwnerCapabilites
if object_id('tempdb.dbo.#NewOwnerCapabilites') is not null
    DROP TABLE #NewOwnerCapabilites
IF OBJECT_ID('tempdb.dbo.#tempcaps') IS NOT NULL
	DROP TABLE #tempcaps
if object_id('tempdb.dbo.#sharesCaps') is not null
	DROP TABLE #sharesCaps
if object_id('tempdb.dbo.#sharesCaps1') is not null
	DROP TABLE #sharesCaps1
IF (@trancount = 0)
BEGIN
      BEGIN TRAN
	  SET @isTranStarted = 1
END
-- Check if we need to wait due to multiple logins for the same user
UPDATE #UMUsers SET Pager = Pager WHERE id = @userId
IF(dbo.isNewSecurity()=1)
BEGIN
create table  #updateUserCredentials_Cache ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [tagId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [ermId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0, [permissionBitArray] varbinary(2000) default 0x0, [extendedPermissionBitArray] varbinary(2000) default 0x0  )
		exec [sec_populateCache] @userID,'#updateUserCredentials_Cache',0
		--DELETE  UMUserCredentials where  UserId= @userId
		--INSERT INTO UMUserCredentials
		--SELECT @userId,* from #updateUserCredentials_Cache
		-- Fix for TR 180613-37: When inserting bulk rows into UMUserCredentials table, we got error 666. The maximum system-generated unique value for a duplicate group was exceeded for index
		-- Mostly security associations will not change that often. So instead of deleting and re-inserting all, let us just update the entries.
		-- Forward porting this fix, as this could resolve / reduce lock time outs on prodcommserver when running reports.
		DELETE T
		FROM UMUserCredentials T
			LEFT JOIN #updateUserCredentials_Cache S
				ON
				(
					T.capabilities = S.capabilities AND T.flag = S.flag
					AND T.commcellId = S.commcellID AND T.clientGroupId = S.clientGroupId
					AND T.clientId = S.clientId AND T.appTypeId = S.appTypeId AND T.instanceID = S.instanceID AND T.backupsetId = S.backupsetID AND T.subclientId = S.subclientID
					AND T.mediaAgentId = S.mediaAgentId AND T.libraryId = S.libraryId AND T.archgroupId = S.archgroupID
					AND T.vtContainerID = S.vtContainerID AND T.vtPolicyId = S.vtPolicyId AND T.vtShelfId = S.vtShelfId
					AND T.reviewSetID = S.reviewSetID AND T.querySetId = S.querySetID AND T.downloadSetId = S.downloadSetID AND T.tagId = S.tagId AND T.legalHoldId = S.legalHoldID AND T.ermId = S.ermId AND T.cdPolicyId = S.cdPolicyId AND T.complianceReportID = S.complianceReportId
					AND T.taskId = S.taskID
					AND T.workflowId = S.workflowId
					AND T.logMonitoringPolicyId = S.logMonitoringPolicyId
					AND T.arrayId = S.arrayId
					AND T.cloudId = S.cloudID
					AND T.userGroupID = S.userGroupID AND T.providerId = S.providerID
					AND T.entityId1 = S.entityId1 AND T.entityId2 = S.entityId2	AND T.entityId3 = S.entityId3 AND T.entityId4 = S.entityId4	AND T.entityId5 = S.entityId5 AND T.entityId6 = S.entityId6 AND T.entityId7 = S.entityId7	AND T.entityId8 = S.entityId8 AND T.entityId9 = S.entityId9
				)
		WHERE
			T.userID = @userId
			AND S.capabilities IS NULL
		MERGE UMUserCredentials AS T
		USING
			(
				SELECT *
				FROM #updateUserCredentials_Cache
			)S
				ON
				(
					T.userId = @userId AND T.capabilities = S.capabilities AND T.flag = S.flag
					AND T.commcellId = S.commcellID AND T.clientGroupId = S.clientGroupId
					AND T.clientId = S.clientId AND T.appTypeId = S.appTypeId AND T.instanceID = S.instanceID AND T.backupsetId = S.backupsetID AND T.subclientId = S.subclientID
					AND T.mediaAgentId = S.mediaAgentId AND T.libraryId = S.libraryId AND T.archgroupId = S.archgroupID
					AND T.vtContainerID = S.vtContainerID AND T.vtPolicyId = S.vtPolicyId AND T.vtShelfId = S.vtShelfId
					AND T.reviewSetID = S.reviewSetID AND T.querySetId = S.querySetID AND T.downloadSetId = S.downloadSetID AND T.tagId = S.tagId AND T.legalHoldId = S.legalHoldID AND T.ermId = S.ermId AND T.cdPolicyId = S.cdPolicyId AND T.complianceReportID = S.complianceReportId
					AND T.taskId = S.taskID
					AND T.workflowId = S.workflowId
					AND T.logMonitoringPolicyId = S.logMonitoringPolicyId
					AND T.arrayId = S.arrayId
					AND T.cloudId = S.cloudID
					AND T.userGroupID = S.userGroupID AND T.providerId = S.providerID
					AND T.entityId1 = S.entityId1 AND T.entityId2 = S.entityId2	AND T.entityId3 = S.entityId3 AND T.entityId4 = S.entityId4	AND T.entityId5 = S.entityId5 AND T.entityId6 = S.entityId6 AND T.entityId7 = S.entityId7 AND T.entityId8 = S.entityId8 AND T.entityId9 = S.entityId9
				)
		WHEN NOT MATCHED THEN
			INSERT
				VALUES(
						@userId, S.capabilities, S.flag
						,S.commcellId, S.clientGroupId
						,S.clientId, S.appTypeId, S.instanceId, S.backupsetID, S.subclientId
						,S.mediaAgentId, S.libraryId, S.archgroupId
						,S.vtContainerID, S.vtPolicyId, S.vtShelfId
						,S.reviewSetID, S.querySetID, S.downloadSetID, S.tagId, S.legalHoldID, S.ermId, S.cdPolicyId, S.complianceReportId
						,S.taskID
						,S.workflowId
						,S.logMonitoringPolicyId
						,S.arrayId
						,S.cloudID
						,S.userGroupID, S.providerID
						,S.entityId1, S.entityId2, S.entityId3, S.entityId4, S.entityId5, S.entityId6, S.entityId7, S.entityId8, S.entityId9
						,S.permissionBitArray, S.extendedPermissionBitArray
					);
		UPDATE UMUsers
		set credSetTime=@now
		WHERE id = @userId
		IF(@isTranStarted=1)
		BEGIN
			COMMIT TRAN
		END
		GOTO GET_USER_CREDENTIALS_EXIT
END
------------------------------------------------------------------------
-- creating and populating Client Group -> Client association for owners
------------------------------------------------------------------------
CREATE TABLE #tempcaps
(
	ClientId				INT,
	ClientGroupId			INT,
	ClientGroupCapabilities	BIGINT DEFAULT 0
)
CREATE CLUSTERED INDEX [tempcaps_idx] ON #tempcaps (ClientId)
DECLARE @tcCnt INT
SELECT @tcCnt = COUNT(*) FROM UMUserandGroupEntityAssociation WHERE userId = @userId
-- Performance need to tune / pick a value for when to flip selection criteria - 500 works okay for now
IF (@tcCnt > 500)
BEGIN
	-- this block is tuned for heavy data lifting but bad for light data lifting
	INSERT INTO #tempcaps (ClientId, ClientGroupId)
		SELECT DISTINCT --select1
			ACG.clientId,
			ACG.clientGroupId
		FROM
			UMUserandGroupEntityAssociation UUG
			INNER JOIN APP_ClientGroupAssoc ACG ON
				UUG.UserId = @userId		-- select1 OR wclause
				AND UUG.entityType = 2009
				AND UUG.ownerUserId <> 0
				AND UUG.objectId = ACG.clientId
		UNION
		SELECT --select2
			ACG.clientId,
			ACG.clientGroupId
		FROM
			UMUserandGroupEntityAssociation UUG
			INNER JOIN APP_ClientGroupAssoc ACG ON
				UUG.providerId > 0		-- select2 OR wclause
				--AND UUG.groupId IN (SELECT umds1.groupId FROM UMDSUserGroup umds1 WHERE umds1.userId = @userId)
				AND UUG.entityType = 2009
				AND UUG.ownerUserId <> 0
				AND UUG.objectId = ACG.clientId
			INNER JOIN UMDSUserGroup umds ON
				umds.userId = @userId
				AND UUG.groupId = umds.groupId
		UNION
		SELECT --select3
			ACG.clientId,
			ACG.clientGroupId
		FROM
			UMUserandGroupEntityAssociation UUG
			INNER JOIN APP_ClientGroupAssoc ACG ON
				UUG.providerId = 0		-- select3 OR wclause
				--UUG.groupId IN (SELECT groupId FROM UMUserGroup um WHERE um.userId = @userId)
				AND UUG.entityType = 2009
				AND UUG.ownerUserId <> 0
				AND UUG.objectId = ACG.clientId
			INNER JOIN UMUserGroup um ON
				um.userId = @userId
				AND UUG.groupId = um.groupId
		UNION
		SELECT --select4
			ACG.clientId,
			ACG.clientGroupId
		FROM
			UMUserandGroupEntityAssociation UUG
			INNER JOIN APP_ClientGroupAssoc ACG ON
				UUG.providerId = 0		-- select4 OR wclause
				--UUG.groupId IN (SELECT umgroupId FROM UMDSGroupMaps		-- select4 OR
				--							WHERE umDSgroupId IN (SELECT umds.groupId FROM UMDSUserGroup umds WHERE umds.userId = @userId))
				AND UUG.entityType = 2009
				AND UUG.ownerUserId <> 0
				AND UUG.objectId = ACG.clientId
			INNER JOIN UMDSUserGroup umds ON
				umds.userId = @userId
			INNER JOIN UMDSGroupMaps gm ON
				gm.umDSgroupId = umds.groupId
				AND UUG.groupId = gm.umgroupId
	-- Performance no joy adding to the above insert select with outer left join / outer apply / cor select 94ms -> 200ms
	UPDATE ttp
		SET ClientGroupCapabilities = UUG.capabilities
	FROM #tempcaps ttp
		INNER JOIN UMUserandGroupEntityAssociation UUG ON
			ttp.ClientGroupId = UUG.objectId
			AND UUG.entityType = 2572
			AND UUG.userId = 0
			AND UUG.ownerUserId <> 0
END
ELSE
BEGIN
	-- this block is very performance intense because of the multiple "where select in ()" OR'd together
	-- it is fine for light data lifting but heavy it is bad
	INSERT INTO #tempcaps (ClientId,ClientGroupId)
		(SELECT ACG.clientId,ACG.clientGroupId
		FROM UMUserandGroupEntityAssociation UUG
			INNER JOIN APP_ClientGroupAssoc ACG ON
				UUG.objectId = ACG.clientId
		WHERE entityType = 2009
			AND ( UUG.UserId = @userId
			OR (UUG.providerId = 0 AND
				-- user part of internal group which is client owner
				(UUG.groupId IN (SELECT groupId FROM UMUserGroup um WHERE um.userId = @userId)
				-- user part of external group which associated with internal group which is client owner
			   OR UUG.groupId IN (SELECT umgroupId FROM UMDSGroupMaps WHERE umDSgroupId IN (SELECT umds.groupId FROM UMDSUserGroup umds WHERE umds.userId = @userId))))
			-- user part of exteranl group which is client owner
			OR (UUG.providerId > 0 AND UUG.groupId IN (SELECT umds1.groupId FROM UMDSUserGroup umds1 WHERE umds1.userId = @userId))
			)
			AND ownerUserId <> 0)
		UPDATE #tempcaps
			SET ClientGroupCapabilities = UUG.capabilities
		FROM #tempcaps ttp
			INNER JOIN UMUserandGroupEntityAssociation UUG ON
				UUG.objectId = ttp.ClientGroupId
				AND UUG.entityType = 2572
				AND UUG.userId = 0
				AND UUG.ownerUserId <> 0
END
--------------------------------------------------------
-- UPDATE UMOwnerCredentials                --
-- by checking all possible association for this user --
--------------------------------------------------------
CREATE TABLE #OwnerCapabilites (
	clientId		INT,
	[userId]		INT,
	capabilities	BIGINT
)
--CREATE UNIQUE CLUSTERED INDEX OwnerCapabilites_idx ON #OwnerCapabilites(clientId)
CREATE TABLE #NewOwnerCapabilites (
	objectId		INT,
	[userId]		INT,
	capabilities	BIGINT
)
--CREATE UNIQUE CLUSTERED INDEX NewOwnerCapabilites_idx ON #NewOwnerCapabilites(objectId)
INSERT INTO #OwnerCapabilites
	SELECT
		clientId, [userId], capabilities
	FROM
		UMOwnerCredentials (NOLOCK)
	WHERE
		[userId] = @userId
-- Performance broke the original select OR Clause into a insert union select set
INSERT INTO #NewOwnerCapabilites
	-- adding all client owners capabilities + system owner capabilities
	SELECT DISTINCT --select1
		objectId, [userId] = @userId, capabilities = capabilities | @systemcaps
	FROM
		UMUserandGroupEntityAssociation
	WHERE
		UserId = @userId		-- select1 OR wclause
		AND entityType = 2009
	UNION
	SELECT --select2
		objectId, [userId] = @userId, capabilities = capabilities | @systemcaps
	FROM
		UMUserandGroupEntityAssociation UUG
		INNER JOIN UMDSUserGroup umds ON
			UUG.entityType = 2009
			AND UUG.providerId > 0		-- select2 OR wclause
			AND umds.userId = @userId
			AND UUG.groupId = umds.groupId
			--AND groupId IN (SELECT umds1.groupId FROM UMDSUSERGROUPS_TABLE umds1 WHERE umds1.userId = @userId)L
	UNION
	SELECT --select3
		objectId, [userId] = @userId, capabilities = capabilities | @systemcaps
	FROM
		UMUserandGroupEntityAssociation UUG
		INNER JOIN UMUserGroup um ON
			UUG.entityType = 2009
			AND UUG.providerId = 0		-- select3 OR wclause
			AND um.userId = @userId
			AND UUG.groupId = um.groupId
			--AND groupId IN (SELECT groupId FROM UMUserGroup um WHERE um.userId = @userId)	-- select3 OR wclause
	UNION
	SELECT --select4
		objectId, [userId] = @userId, capabilities = capabilities | @systemcaps
	FROM
		UMUserandGroupEntityAssociation UUG
		INNER JOIN UMDSUserGroup umds ON
			UUG.entityType = 2009
			AND UUG.providerId = 0      -- select3 OR wclause
			AND umds.userId = @userId
		INNER JOIN UMDSGroupMaps gm ON
			gm.umDSgroupId = umds.groupId
			AND UUG.groupId = gm.umgroupId
-- adding client group owner capabilities associated with clients from #NewOwnerCapabilites
UPDATE #NewOwnerCapabilites
	SET capabilities = capabilities | (tp.inheritedcaps)
FROM  #NewOwnerCapabilites NOC
	INNER JOIN (SELECT dbo.BitwiseOR(clientgroupcapabilities) AS inheritedcaps, clientid FROM #tempcaps GROUP BY clientid) tp
		ON NOC.objectId = tp.clientid
-- Performance MONSTER - IF EXISTS(query) 1.4 seconds to execute to determine if rows exists! Setting variable 31ms, moral of the story do not perform OUTER JOIN in EXISTS
DECLARE @ncFound INT = 0
SELECT @ncFound = 1
FROM #OwnerCapabilites OC
	RIGHT OUTER JOIN #NewOwnerCapabilites NC ON
		NC.objectId = OC.clientId
		AND NC.userId = OC.userId
WHERE
	OC.capabilities IS NULL
	OR NC.capabilities <> OC.capabilities
--CHECK IF THERE ANY CHANGE TO OWNER CAPABILTIES BEFORE TRYING TO UPDATE TABLE
IF (@ncFound = 1)
BEGIN
	MERGE UMOwnerCredentials AS UMO
	USING (
			SELECT --DISTINCT	-- Performance insert union select only inserts distinct rows
				objectId, [userId], capabilities
			FROM #NewOwnerCapabilites
		) TMP ON
			TMP.userId = UMO.userId
			AND TMP.objectId = UMO.clientId
	WHEN MATCHED THEN	--FOUND OWNER IN UMOwnerCredentials FOR CLIENT.  UPDATE CAPABILITIES
			UPDATE SET UMO.capabilities = TMP.capabilities
	WHEN NOT MATCHED THEN	--CLIENT NOT FOUND IN UMOwnerCredentials. INSERT NEW ENTRY
			INSERT (clientId, [userId], capabilities)
			VALUES( TMP.objectId, TMP.userId, TMP.capabilities);
END
-- Performance MONSTER - IF EXISTS(query) to determine if rows exists for outer joins! Setting variable 31ms, moral of the story do not perform OUTER JOIN in EXISTS
DECLARE @ocFound INT = 0
SELECT @ocFound = 1
FROM #OwnerCapabilites OC
	LEFT OUTER JOIN #NewOwnerCapabilites NC ON
		NC.objectId = OC.clientId
		AND NC.userId = OC.userId
WHERE
	NC.capabilities IS NULL
--REMOVE ENTRIES FROM UMOwnerCredentials NOT IN #NewOwnerCapabilites. USER HAS LOST RIGHTS TO THESE CLIENTS
IF ( @ocFound = 1 )
BEGIN
	DELETE UMOwnerCredentials
	FROM UMOwnerCredentials UMO
		LEFT OUTER JOIN #NewOwnerCapabilites NC ON
			UMO.userId = NC.userId
			AND UMO.clientId = NC.objectId
	WHERE
		NC.objectId IS NULL
		AND UMO.userId = @userId
END
create table  #flatView ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
create table #shortUserAssocList (
			groupId int NOT Null,
			type1   int NOT Null,
			id1     int NOT Null,
			type2   int NOT Null,
			id2     int NOT Null,
			type3   int NOT Null,
			id3     int NOT Null,
			type4   int NOT Null,
			id4     int NOT Null
		)
--AEB2: Performance improvement
CREATE CLUSTERED INDEX [shortUserAssocList_idx] ON #shortUserAssocList (groupId, type1, id1)
if(@providerType  = 3 OR @providerType   = 4)
BEGIN
    -- FOR LDD AND HOSTED EXCHANGE PROVIDER  ONLY ENDUSER CAPABILITY IS APPLICABLE
    SELECT @capabilities = CAST((POWER(2.0, id-1)) AS bigint)  FROM UMCapability where id=24 -- this is enduser search
    INSERT #flatView
    SELECT distinct @capabilities, 0, @commcellId, 0, A.clientId, A.AppTypeId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    FROM APP_Application A
WHERE A.appTypeId in (90, 52)
END
-- A number of operations combine into one very are large set operation that was many steps previously for performance reasons
-- Combined Steps:
--		1 - insert first all Simpana groups associated with this user as of now AD user could be part of Simpana user group
--		2 - now insert all groups from  UMDSUserGroup associated with this user as of now AD user could be part of Simpana user group
--		3 - delete ANY GROUPS THAT ARE CURRENTLY DISABLED!
--		4 - insert first all Simpana groups associated with this user as of now AD user could be part of Simpana user group
--		5 - now insert all groups from  UMDSUserGroup associated with this user as of now AD user could be part of Simpana user group
INSERT INTO #shortUserAssocList
	SELECT DISTINCT
			UG.groupId, Type1, id1, type2, id2, type3, id3, type4, id4
		FROM
			UMGroupAssociation AS GA
			INNER JOIN UMUserGroup AS UG ON
				UG.userid = @userId
				AND UG.groupId = GA.groupId
			INNER JOIN UMGroups as GR ON	-- remove ANY GROUPS THAT ARE CURRENTLY DISABLED!
				GR.id = UG.groupId
				AND GR.groupFlags NOT IN (0, 2)
		UNION
		SELECT DISTINCT
			UG.groupId, 2009,  AGA.clientId, 0, 0,  0, 0, 0, 0
		FROM
			UMUserGroup AS UG
			INNER JOIN UMGroupAssociation AS GA ON
				UG.userId = @userId
				AND UG.groupId = GA.groupId
				AND GA.type1 = 2572
			INNER JOIN APP_ClientGroupAssoc AS AGA ON
				( AGA.clientGroupId = GA.id1 OR GA.id1 = -10 )
			INNER JOIN UMGroups as GR ON	-- remove ANY GROUPS THAT ARE CURRENTLY DISABLED!
				GR.id = UG.groupId
				AND GR.groupFlags NOT IN (0, 2)
		UNION
		SELECT
			UG.groupId,UUG.entityType, UUG.objectId, 0, 0,  0, 0, 0, 0
		FROM
			UMUserGroup UG
			INNER JOIN UMUserandGroupEntityAssociation UUG 	ON
				UG.userId = @userId
				AND UG.groupId = UUG.groupId
 				AND UUG.providerId = 0
 			INNER JOIN UMGroups as GR ON	-- remove ANY GROUPS THAT ARE CURRENTLY DISABLED!
				GR.id = UG.groupId
				AND GR.groupFlags NOT IN (0, 2)
 		UNION
		SELECT DISTINCT
			GM.umgroupId, GA.type1, GA.id1, GA.type2, GA.id2, GA.type3, GA.id3, GA.type4, GA.id4
FROM #UMDSUserGroup AS UG
			INNER JOIN UMDSGroupMaps AS GM ON
				UG.userId = @userId
				AND UG.groupId = GM.umdsGroupId
			INNER JOIN UMGroupAssociation AS GA ON
				GA.GroupId = GM.umgroupId
			INNER JOIN UMGroups as GR ON	-- remove ANY GROUPS THAT ARE CURRENTLY DISABLED!
				GR.id = GM.umgroupId
				AND GR.groupFlags NOT IN (0, 2)
		UNION
		SELECT DISTINCT
			GM.umgroupId, 2009, AGA.clientId, 0, 0, 0, 0, 0, 0
FROM #UMDSUserGroup AS UG
			INNER JOIN UMDSGroupMaps AS GM ON
				UG.userId = @userId
				AND UG.groupId = GM.umdsGroupId
			INNER JOIN UMGroupAssociation AS GA ON
				GA.GroupId = GM.umgroupId
				AND GA.type1 = 2572
			INNER JOIN APP_ClientGroupAssoc AS AGA ON
				( AGA.clientGroupId = GA.id1 OR GA.id1 = -10 )
			INNER JOIN UMGroups as GR ON	-- remove ANY GROUPS THAT ARE CURRENTLY DISABLED!
				GR.id = GM.umgroupId
				AND GR.groupFlags NOT IN (0, 2)
		UNION
		SELECT
			GM.umGroupId,UUG.entityType, UUG.objectId, 0, 0, 0, 0, 0, 0
FROM #UMDSUserGroup AS UG
			INNER JOIN UMDSGroupMaps AS GM ON
				UG.userId = @userId
		AND  UG.groupId = GM.umdsGroupId
			INNER JOIN UMUserandGroupEntityAssociation UUG 	ON
				(
					(GM.umdsGroupId = UUG.groupId AND UUG.providerId <> 0)
					OR (GM.umGroupId = UUG.groupId AND UUG.providerId = 0)
				)
			INNER JOIN UMGroups as GR ON	-- remove ANY GROUPS THAT ARE CURRENTLY DISABLED!
				GR.id = GM.umgroupId
				AND GR.groupFlags NOT IN (0, 2)
		UNION
		SELECT DISTINCT
			UG.groupId, 2018, @commcellId, 0, 0, 0, 0, 0, 0
		FROM
			UMUserGroup as UG
			INNER JOIN UMGroups AS G ON
				UG.userid=@userId
       AND  UG.groupId = G.id
	   AND G.allassociations <> 0
				AND (G.groupFlags & 1) = 1
		UNION
		SELECT
			groupId=GM.umgroupId, 2018, @commcellId, 0, 0, 0, 0, 0, 0
FROM #UMDSUserGroup AS UG
			INNER JOIN UMDSGroupMaps AS GM ON
				UG.userid=@userId
       AND  UG.groupId = GM.umDSgroupId
			INNER JOIN UMGroups AS G ON
				G.id = GM.umgroupId
	   AND G.allassociations <> 0
				AND (G.groupFlags & 1) = 1
--	+-------------------------------------------------------------------------------------------------------+
--	| CREATE A TABLE WITH DISTINCT COMMCELL TREE OBJECTS AND AGGREGATE CAPABILITIES				|
--	+-------------------------------------------------------------------------------------------------------+
	--AEB2: Performance for possible lock blocking added clause WITH(NOLOCK) to CS Tables
	--AEB2: Performance directly create table with index, instead of select into table creation
	--AEB2: created actual table instead of using select into to possibly add indexes to the temp table
	create table #AssociationsWithCapabilites (
			capabilities	bigint NOT Null,
			type1			int NOT Null,
			id1				int NOT Null,
			type2			int NOT Null,
			id2				int NOT Null,
			type3			int NOT Null,
			id3				int NOT Null,
			type4			int NOT Null,
			id4				int NOT Null,
			entityOwnerId	int NOT Null
		)
	--AEB2: index cost more time overall for some users then others in cursor processing - index not implemented
	--CREATE CLUSTERED INDEX [AssociationsWithCapabilites_idx] ON #AssociationsWithCapabilites (type1, id1, entityOwnerId)
	--CREATE CLUSTERED INDEX [AssociationsWithCapabilites_idx] ON #AssociationsWithCapabilites (type1, id1, type2, id2, type3, id3, type4, id4)
	INSERT INTO #AssociationsWithCapabilites
		SELECT capabilities=cast(SUM(DISTINCT POWER(2.0, GC.capabilityId -1)) AS bigint), SL.type1, SL.id1, SL.type2, SL.id2, SL.type3, SL.id3, SL.type4, SL.id4, 0 AS entityOwnerId
		FROM #shortUserAssocList AS SL,  UMGroupCapability AS GC WITH(NOLOCK)
		WHERE
	  		SL.groupId = GC.groupId
		GROUP BY SL.type1, SL.id1, SL.type2, SL.id2, SL.type3, SL.id3, SL.type4, SL.id4
	INSERT  #AssociationsWithCapabilites
	SELECT 0, SL.type1, SL.id1, SL.type2, SL.id2, SL.type3, SL.id3, SL.type4, SL.id4, 0
	FROM #shortUserAssocList AS SL
	WHERE NOT EXISTS (select * from #AssociationsWithCapabilites AS AWC
					 WHERE SL.type1 = AWC.type1 AND SL.id1 = AWC.id1
					   AND SL.type2=  AWC.type2 AND SL.id2 = AWC.id2
					   AND SL.type3=  AWC.type3 AND SL.id3 = AWC.id3
					   AND SL.type4 = AWC.type4 AND SL.id4 = AWC.id4)
--	+-------------------------------------------------------------------------------------------------------+
--	| NOW TAKE CARE OF GROUPS THAT MAY HAVE HAD "ALL CAPABILITIES" SET.  THESE SHOULD NOT HAVE ENTRIES IN	|
--	| .. GROUPCAPABILITY TABLE, BUT SOME MAY BE LEFT BEHIND FROM BEFORE ALL CAPS WAS SELECTED FOR THE GROUP	|
--	+-------------------------------------------------------------------------------------------------------+
	delete #AssociationsWithCapabilites
	   FROM #shortUserAssocList AS SL,  UMGroups AS G WITH(NOLOCK), #AssociationsWithCapabilites AS AC
	   WHERE SL.groupId = G.Id
	     AND SL.type1 = AC.type1 AND SL.id1 = AC.id1
	     AND SL.type2 = AC.type2 AND SL.id2 = AC.id2
	     AND SL.type3 = AC.type3 AND SL.id3 = AC.id3
	     AND SL.type4 = AC.type4 AND SL.id4 = AC.id4
             AND G.allcapabilities <> 0
--select "DEBUG", * from #shortUserAssocList
--	+-----------------------------------------------------------------------+
--	| ACCOUNT FOR ASSOCIATIONS WITH GROUPS THAT DON'T HAVE CAPABILITIES	|
--	+-----------------------------------------------------------------------+
	INSERT #AssociationsWithCapabilites
	   SELECT @allCapabilities, SL.type1, SL.id1, SL.type2, SL.id2, SL.type3, SL.id3, SL.type4, SL.id4, 0
	   FROM #shortUserAssocList AS SL,  UMGroups AS G WITH(NOLOCK)
	   WHERE SL.groupId = G.Id
             AND G.allcapabilities <> 0
--	+------------------------------------------------------------------------+
--	| ACCOUNT FOR CAPABILITIES ON DM2 ENTITIES FOR DIRECT USER ASSOCIATIONS  |
--	+------------------------------------------------------------------------+
	MERGE #AssociationsWithCapabilites AS AWC
	USING ( SELECT capabilities, entityType, objectId, ownerUserId FROM UMUserandGroupEntityAssociation WITH(NOLOCK)	WHERE UserId = @userId ) TMP
			ON TMP.entityType = AWC.type1 AND TMP.objectId = AWC.id1
	WHEN MATCHED THEN
			UPDATE SET AWC.capabilities =  AWC.capabilities | TMP.capabilities,
					   AWC.entityOwnerId = ownerUserId
	WHEN NOT MATCHED THEN
			INSERT VALUES( TMP.capabilities, TMP.entityType, TMP.objectId, 0, 0, 0, 0, 0, 0, TMP.ownerUserId);
--	+---------------------------------------------------------------------+
--	| ACCOUNT FOR OWNER CAPABILITIES FOR USER ASSOCIATIONS VIA AD GROUP   |
--  | in case AD user group is not associated to any internal group       |
--	+---------------------------------------------------------------------+
	MERGE #AssociationsWithCapabilites AS AWC
	USING ( SELECT capabilities, entityType = 2009, objectId=clientId, ownerUserId=1 FROM UMOwnerCredentials WITH(NOLOCK) WHERE UserId = @userId ) TMP
			ON TMP.entityType = AWC.type1 AND TMP.objectId = AWC.id1
			AND AWC.type2 = 0 AND AWC.id2 = 0 AND AWC.type3 = 0 AND AWC.id3 = 0 AND AWC.type4 = 0 AND AWC.id4 = 0
	WHEN MATCHED THEN
			UPDATE SET AWC.capabilities =  AWC.capabilities | TMP.capabilities,
					   AWC.entityOwnerId = ownerUserId
	WHEN NOT MATCHED THEN
			INSERT VALUES( TMP.capabilities, TMP.entityType, TMP.objectId, 0, 0, 0, 0, 0, 0, TMP.ownerUserId);
-- For client owners, check for the client's group's capabilities and also sytem owner capabilities
--------------
	UPDATE #AssociationsWithCapabilites
	set capabilities = capabilities | @systemcaps | (tp.inheritedcaps)
	from #AssociationsWithCapabilites awc inner join (select dbo.BitwiseOR(clientgroupcapabilities) as inheritedcaps,clientid from #tempcaps group by clientid) tp
	on awc.id1 = tp.clientid and awc.type1 = 2009
---------------------
-- Capabilities of client group creator should extend to clients
---------------------------------------------------------------------------------------
	DELETE FROM #tempcaps
	INSERT INTO #tempcaps
		SELECT
			CG.clientId,
			CG.clientGroupId,
			UUG.capabilities
		FROM
			APP_ClientGroupAssoc CG  WITH(NOLOCK)
			INNER JOIN UMUserandGroupEntityAssociation UUG WITH(NOLOCK) ON
				UUG.objectId = CG.clientGroupId
				AND UUG.entityType = 2572
				AND UUG.userId = @userId
				AND UUG.ownerUserId = 0
	-- Performance bypass merge if nothing in table
	IF EXISTS(SELECT * FROM #tempcaps)
	BEGIN
	MERGE #AssociationsWithCapabilites AS AWC
			USING
				(
					SELECT
						dbo.BitwiseOR(ClientGroupCapabilities) AS capabilities,
						2009 AS entityType,
						ClientId AS objectId,
						0 as ownerUserId
					FROM #tempcaps
					GROUP BY ClientId
				) TMP ON
					TMP.entityType = AWC.type1
					AND TMP.objectId = AWC.id1
	WHEN MATCHED THEN
			UPDATE SET AWC.capabilities =  AWC.capabilities | TMP.capabilities,
					   AWC.entityOwnerId = TMP.ownerUserId
	WHEN NOT MATCHED THEN
			INSERT VALUES( TMP.capabilities, TMP.entityType, TMP.objectId, 0, 0, 0, 0, 0, 0, TMP.ownerUserId);
	END
------------------------------------------------------------------------
-- select "DEBUG 6", * from #shortUserAssocList
--SELECT "debug 6 associations" , * FROM #AssociationsWithCapabilites
--	+-----------------------------------------------------------------------------------+
--	| ACCOUNT FOR CAPABILITIES ON DM2 ENTITIES FOR USER AND AD USER GROUP ASSOCIATIONS  |
--	+-----------------------------------------------------------------------------------+
	-- insert first CAPABILITIES of all Simpana groups associated with this user as of now AD user could be part of Simpana user group
	MERGE #AssociationsWithCapabilites AWC
		USING
			(
				SELECT
					dbo.BitwiseOR(capabilities) AS capabilities,
					entityType,
					objectId,
					ownerUserId
				FROM #shortUserAssocList AS SL
					INNER JOIN UMUserandGroupEntityAssociation AS UUG WITH(NOLOCK) ON
						SL.groupId = UUG.groupId
						AND SL.type1 = UUG.entityType
						AND SL.id1 = UUG.objectId
				WHERE
					UUG.providerId = 0
				GROUP BY entityType, objectId, ownerUserId
			) TMP ON
				TMP.entityType = AWC.type1
				AND TMP.objectId = AWC.id1
	WHEN MATCHED THEN
				UPDATE SET AWC.capabilities =  AWC.capabilities | TMP.capabilities,
				AWC.entityOwnerId = TMP.ownerUserId
	WHEN NOT MATCHED THEN
			INSERT VALUES( TMP.capabilities, TMP.entityType, TMP.objectId, 0, 0, 0, 0, 0, 0, TMP.ownerUserId);
	--now insert CAPABILITIES of all groups from UMDSUserGroup associated with this user as of now AD user could be part of Simpana user group
	--AEB2: Peformance goes into the can every so often with the original merge operation with OR Clause conditionals.
	--AEB2: It was determine that the OR Conditionals for providerId = 0 have already been processed
	--		and could be removed from these queries to improve the performance.
	MERGE #AssociationsWithCapabilites AWC
		USING
			(
				SELECT
					dbo.BitwiseOR(capabilities) AS capabilities,
					entityType,
					objectId,
					ownerUserId
				FROM (
						SELECT
							capabilities,
							entityType,
							objectId,
							ownerUserId
						FROM #shortUserAssocList AS SL
							INNER JOIN  umdsGroupMaps AS GM WITH(NOLOCK) ON
								SL.groupId = GM.umGroupId
							INNER JOIN UMUserandGroupEntityAssociation AS UUG WITH(NOLOCK) ON
								(
									(GM.umdsGroupId = UUG.groupId AND UUG.providerId <> 0)
--AEB2									OR (GM.umGroupId = UUG.groupId AND UUG.providerId = 0)
								)
								AND SL.type1 = UUG.entityType
								AND SL.id1 = UUG.objectId
						UNION
						SELECT
							UUG.capabilities,
							UUG.entityType,
							UUG.objectId,
							UUG.ownerUserId
FROM #UMDSUserGroup AS UG WITH(NOLOCK)
							INNER JOIN UMDSGroupMaps AS UGM WITH(NOLOCK) ON
								UGM.umdsGroupId = UG.groupId
							INNER JOIN UMUserandGroupEntityAssociation AS UUG WITH(NOLOCK) ON
								(
									(UG.groupId = UUG.groupId AND UUG.providerId <> 0 )
--AEB2									OR (UGM.umGroupId = UUG.groupId AND UUG.providerId = 0 )
								)
						WHERE
							UG.userId = @userid
				) T
				GROUP BY entityType, objectId, ownerUserId
			) TMP ON
				TMP.entityType = AWC.type1
				AND TMP.objectId = AWC.id1
		WHEN MATCHED THEN
					UPDATE SET AWC.capabilities =  AWC.capabilities | TMP.capabilities,
							   AWC.entityOwnerId = ownerUserId
		WHEN NOT MATCHED THEN
			INSERT VALUES( TMP.capabilities, TMP.entityType, TMP.objectId, 0, 0, 0, 0, 0, 0, TMP.ownerUserId);
--
		-- Update security table when edge drive association is present
		UPDATE #AssociationsWithCapabilites
		SET type4=type1,type1 = 2009,type2=2230,type3=2012,id4=id1,id1=A.clientId,id2=A.appTypeId,id3=A.backupSet
		FROM APP_Application A WITH(NOLOCK)
		WHERE type1=2013 AND A.id = id1
		UPDATE #AssociationsWithCapabilites
		SET type3=type1,type1 = 2009,type2=2230,type4=0,id1=A.clientId,id2=A.appTypeId,id3=A.backupSet,id4=0
		FROM APP_Application A,#AssociationsWithCapabilites
		WHERE type1=2012 AND A.backupSet=id1
--
--select * from #AssociationsWithCapabilites
--	+-------------------------------------------------------------------------------------------------------+
--	| Now that we've Aggregated Capabilities on all objects, flatten out the model for easier "joining"	|
--	+-------------------------------------------------------------------------------------------------------+
			-- Storage Array with id = 0 incorrectly associated to group results in commcell level association.
			-- Added where condition to filter such incorrect associations
            DECLARE   asscap CURSOR FOR
            SELECT    capabilities, type1, id1, type2, id2, type3, id3, type4, id4, entityOwnerId
            FROM      #AssociationsWithCapabilites
			where id1<>0 or id2<>0 or id3<>0 or id4<>0
            ORDER BY  type1, id1, type2, id2, type3, id3, type4, id4
            OPEN  asscap
            FETCH NEXT FROM asscap
			INTO @capabilities, @type1, @id1, @type2, @id2, @type3, @id3, @type4, @id4, @entityOwnerId
            WHILE @@FETCH_STATUS = 0
            BEGIN
		IF (@type1 = 2018)		-- COMM_CELL_ITEM
			BEGIN
			--	+-------------------------------------------------------------------------------------------------------+
			-- ENTITYID2 IS RESERVED FOR SHARE FOLDERS
			-- ENTITYID6 IS RESERVED FOR FOREIGN COMMCELLID(OTHER THAN DEFAULT)
			--	+-------------------------------------------------------------------------------------------------------+
		IF(@id1=2)
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId)
			VALUES(@capabilities, @id1, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000)
			ELSE
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,entityId6)
			VALUES(@capabilities, 2, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,@id1)
		END
		ELSE IF (@type1 = 9615)		-- ARRAY_ITEM
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
								   reviewSetId, querySetId, downloadSetId, ermId, legalHoldId, tagId, cdPolicyId,
								   complianceReportId, taskId, workflowId, logMonitoringPolicyId, arrayId)
			VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
									000, 000, 000, 000, 000, 000,
									000, 000, 000, 000, 000, @id1)
		ELSE IF (@type1 = 2572)		-- SERVER_GROUP_NAME_ITEM
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId)
			VALUES(@capabilities, @commcellId, @id1, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000)
		ELSE IF (@type1 = 2048)		-- MEDIA_AGENT_ITEM
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId)
			VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, @id1, 000, 000, 000, 000, 000)
		ELSE IF (@type1 = 2049)		-- LIBRARY_ITEM
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId)
			VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, @id1, 000, 000, 000, 000)
		ELSE IF (@type1 = 2231)		-- ARCHIVE_GROUP_ITEM
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId)
			VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, @id1, 000, 000, 000)
		ELSE IF (@type1 = 8107)		-- CONTAINER_ITEM
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId)
			VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, @id1, 000, 000)
		ELSE IF (@type1 = 8464)		-- TM_DESTINATION_ITEM
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId, entityId1)
			VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, @id1)
		ELSE IF (@type1 = 8462)		-- TM_POLICY_ITEM
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId)
			VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, @id1, 000)
		ELSE IF (@type1 = 8180)		-- SHELF_LIBRARY_ITEM
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId)
			VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, @id1)
		ELSE IF (@type1 = 4300)		--SCHEDULE_ITEM
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
							subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
							reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId, taskId)
			VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
							000, 000, 000, 000, 000, 000, 000, 000, @id1)
		ELSE IF (@type1 = 14033)	--WORKFLOW_ITEM
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
							subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
							reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId, workflowId)
			VALUES(@capabilities, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
							000, 000, 000, 000, 000, 000, 000, 000, @id1)
		ELSE IF (@type1 = 9651)		-- CUSTOM_QUERY_ITEM
            INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                            subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
                            reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId, workflowId,entityId3)
            VALUES(@capabilities,  @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
                            000, 000, 000, 000, 000, 000, 000, 000,000, @id1)
		ELSE IF (@type1 = 9674)		-- LM_SHARED_ENTITY_INFO
            INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                            subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
                            reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId, workflowId,entityId4)
            VALUES(@capabilities,  @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
                            000, 000, 000, 000, 000, 000, 000, 000,000, @id1)
        ELSE IF(@type1=9646)     --LOG_MONITORING_POLICY_ITEM
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
							subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
							reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId, workflowId,logMonitoringPolicyId)
			VALUES(@capabilities,  @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
							000, 000, 000, 000, 000, 000, 000, 000,000, @id1)
		ELSE IF (@type1 = 2009)		-- CLIENT_ITEM
		BEGIN
			set @instanceId = -1
			set @backupsetId = -1
			IF (@type3 = 0)
			BEGIN
				set @instanceId = 0		-- (smudge)
				set @backupsetid = 0
			END
			ELSE IF (@type3 =  2011) 		-- INSTANCE_ITEM
			BEGIN
				set @instanceId = @id3
-- START 95870
--				set @backupsetid = 1
				IF  @type4 = 2013			-- SUB_CLIENT_ITEM
					SET @backupSetId = ISNULL ((SELECT TOP 1 backupSet FROM [APP_Application] WHERE id = @id4 ), 1)
				ELSE if @type4 = 2012
				begin
					SET @backupsetid = @id4
					set @id4 = 0
				end
				else
				begin
					SET @backupsetid = 0
				end
--  END, 95870
			END
			ELSE IF (@type3 =  2012) 		-- BACKUP_SET_ITEM
			BEGIN
				set @instanceId =  1
				set @backupsetid = @id3
			END
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId)
			VALUES(@capabilities, @commcellId, 000, @id1, @id2, @instanceId, @backupsetId, @id4, 000, 000, 000, 000, 000, 000)
		END
		ELSE IF (@type1 = 9501)		-- DM2_REVIEW_SET_ITEM
		BEGIN
IF ( @id1 = -10  AND @entityOwnerId <> 0 )
			BEGIN
				-- get all the owners entities
				DECLARE  reviewSetIds CURSOR FOR
				SELECT containerId
				FROM DM2Container
				WHERE containerType = @type1 AND DM2Container.userId = @entityOwnerId
				OPEN reviewSetIds
				FETCH next FROM reviewSetIds
				INTO @entityId
				WHILE @@FETCH_STATUS = 0
				BEGIN
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
                                  reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId)
				VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
								@entityId,000,000,000,000,000,000,000)
				FETCH NEXT FROM reviewSetIds
      			INTO @entityId
				END
				CLOSE       reviewSetIds
				DEALLOCATE  reviewSetIds
			END
			ELSE
				INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                  subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
                                  reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId)
			VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
								@id1,000,000,000,000,000,000,000)
		END
		ELSE IF (@type1 = 9502)		-- DM2_QUERY_SET_ITEM
		BEGIN
IF ( @id1 = -10 AND @entityOwnerId <> 0 )
			BEGIN
				-- get all the owners entities
				DECLARE   querySetIds CURSOR FOR
				SELECT containerId
				FROM DM2Container
				WHERE containerType = @type1 AND DM2Container.userId = @entityOwnerId
				OPEN querySetIds
				FETCH next FROM querySetIds
				INTO @entityId
				WHILE @@FETCH_STATUS = 0
				BEGIN
					INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                  subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
                                  reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId)
					VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
								  000,@entityId,000,000,000,000,000,000)
				FETCH NEXT FROM querySetIds
      			INTO @entityId
				END
				CLOSE       querySetIds
				DEALLOCATE  querySetIds
			END
			ELSE
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
                                  reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId)
			VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
								  000,@id1,000,000,000,000,000,000)
		END
		ELSE IF (@type1 = 9503)		-- DM2_DOWNLOAD_SET_ITEM
		BEGIN
IF ( @id1 = -10 AND @entityOwnerId <> 0 )
			BEGIN
				-- get all the owners entities
				DECLARE  downloadSetIds CURSOR FOR
				SELECT containerId
				FROM DM2Container
				WHERE containerType = @type1 AND DM2Container.userId = @entityOwnerId
				OPEN downloadSetIds
				FETCH next FROM downloadSetIds
				INTO @entityId
				WHILE @@FETCH_STATUS = 0
				BEGIN
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
                                  reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId)
					VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
								000,000,@entityId,000,000,000,000,000)
				FETCH NEXT FROM downloadSetIds
      			INTO @entityId
				END
				CLOSE       downloadSetIds
				DEALLOCATE  downloadSetIds
			END
			ELSE
				INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                  subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
                                  reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId)
			VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
								000,000,@id1,000,000,000,000,000)
		END
		ELSE IF (@type1 = 9504)		-- DM2_TAG_ITEM
		BEGIN
IF ( @id1 = -10 AND @entityOwnerId <> 0 )
			BEGIN
				-- get all the owners entities
				DECLARE   tagIds CURSOR FOR
				SELECT containerId
				FROM DM2DocTags INNER JOIN DM2Container ON DM2DocTags.containerGuid = DM2Container.containerGuid
				WHERE ownerUserId = @entityOwnerId
				OPEN tagIds
				FETCH next FROM tagIds
				INTO @entityId
				WHILE @@FETCH_STATUS = 0
				BEGIN
					INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                  subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
                                  reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId)
					VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
								000,000,000,@entityId,000,000,000,000)
				FETCH NEXT FROM tagIds
      			INTO @entityId
				END
				CLOSE       tagIds
				DEALLOCATE  tagIds
			END
			ELSE
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
                                   reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId)
			VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
								000,000,000,@id1,000,000,000,000)
		END
		ELSE IF (@type1 = 9505)		-- DM2_LEGAL_HOLD_ITEM
		BEGIN
IF ( @id1 = -10 AND @entityOwnerId <> 0 )
			BEGIN
				-- get all the owners entities
				DECLARE   legalHoldIds CURSOR FOR
				SELECT id
				FROM DM2CompliancePolicy
				WHERE ownerUserId = @entityOwnerId
				OPEN legalHoldIds
				FETCH next FROM legalHoldIds
				INTO @entityId
				WHILE @@FETCH_STATUS = 0
				BEGIN
					INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                  subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
                                  reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId)
					VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
								  000,000,000,000,@entityId,000,000,000)
				FETCH NEXT FROM legalHoldIds
      			INTO @entityId
				END
				CLOSE       legalHoldIds
				DEALLOCATE  legalHoldIds
			END
			ELSE
				INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
                                   reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId)
				VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
								   000,000,000,000,@id1,000,000,000)
		END
		ELSE IF (@type1 = 9506)		-- DM2_ERM_CONNECTOR_ITEM
		BEGIN
IF ( @id1 = -10 AND @entityOwnerId <> 0 )
			BEGIN
				-- get all the owners entities
				DECLARE   ermIds CURSOR FOR
				SELECT id
				FROM DM2RecordCenterConnector
				WHERE ownerUserId = @entityOwnerId
				OPEN ermIds
				FETCH next FROM ermIds
				INTO @entityId
				WHILE @@FETCH_STATUS = 0
				BEGIN
					INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                  subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
                                  reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId)
					VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
								000,000,000,000,000,@entityId,000,000)
				FETCH NEXT FROM ermIds
      			INTO @entityId
				END
				CLOSE       ermIds
				DEALLOCATE  ermIds
			END
			ELSE
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
                                   reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId)
			VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
								000,000,000,000,000,@id1,000,000)
		END
		ELSE IF (@type1 = 9507)		-- DM2_CD_POLICY_ITEM
		BEGIN
IF ( @id1 = -10 AND @entityOwnerId <> 0 )
			BEGIN
				-- get all the owners entities
				DECLARE   cdPolicyIds CURSOR FOR
				SELECT id
				FROM SchedAdminComplianceXMLOptions
				WHERE ownerUserId = @entityOwnerId
				OPEN cdPolicyIds
				FETCH next FROM cdPolicyIds
				INTO @entityId
				WHILE @@FETCH_STATUS = 0
				BEGIN
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
                                  reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId)
			VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
								  000,000,000,000,000,000,@entityId,000)
				FETCH NEXT FROM cdPolicyIds
      			INTO @entityId
				END
				CLOSE       cdPolicyIds
				DEALLOCATE  cdPolicyIds
			END
			ELSE
			INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
                                   reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId)
			VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
								000,000,000,000,000,000,@id1,000)
		END
		ELSE IF (@type1 = 9508)		-- DM2_COMPLIANCE_REPORT_ITEM
		BEGIN
IF ( @id1 = -10 AND @entityOwnerId <> 0 )
			BEGIN
				-- get all the owners entities
				DECLARE compReportIds CURSOR FOR
				SELECT containerId
				FROM DM2Container
				WHERE containerType = @type1 AND DM2Container.userId = @entityOwnerId
				OPEN compReportIds
				FETCH next FROM compReportIds
				INTO @entityId
				WHILE @@FETCH_STATUS = 0
				BEGIN
					INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
                                   reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId)
					VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
								000,000,000,000,000,000,000,@entityId)
				FETCH NEXT FROM compReportIds
      			INTO @entityId
				END
				CLOSE       compReportIds
				DEALLOCATE  compReportIds
			END
			ELSE
				INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                                   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
                                   reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId)
				VALUES(@capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
								000,000,000,000,000,000,000,@id1)
		END
                FETCH NEXT FROM asscap
      		INTO @capabilities, @type1, @id1, @type2, @id2, @type3, @id3, @type4, @id4, @entityOwnerId
            END
            CLOSE       asscap
            DEALLOCATE  asscap
		--ADD SHARE FOLDER SECURITY
		INSERT #flatView (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                           subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
                           reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId, entityId2)
        SELECT DISTINCT permission =
			CASE
WHEN SU.permission = 1 OR SU.permission = (1&4) THEN POWER(2.0, 31 -1)	--EV_VISIBILITY
WHEN SU.permission = 2 OR SU.permission = (2&4) OR SU.permission = (2&1&4) THEN CONVERT(BIGINT, POWER(2.0, 34 -1))|CONVERT(BIGINT, POWER(2.0, 31 -1))	--EV_EDIT ALSO HAS VIEW CAP
				ELSE 0
			END,
        @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
        000,000,000,000,000,000,000,000, SU.shareId
			FROM
				-- changed join ordering for performance
				UMUsers U WITH (NOLOCK)
				INNER JOIN App_SharingUserInfo SU WITH (NOLOCK) ON
					U.id = @userId
					AND
					(
						CAST(U.id AS NVARCHAR(MAX)) = SU.sharedTo AND SU.userType = 1	--SHARE TYPE FOR USERS
						OR
						U.email = SU.sharedTo AND SU.userType = 2	--SHARE TYPE FOR EMAILS
					)
				JOIN App_SyncCloudConfig SC WITH (NOLOCK) ON
					SC.syncWebFolderId = SU.shareId
				JOIN App_SyncCloudFolder SF WITH (NOLOCK) ON
					SF.syncWebFolderId = SC.syncWebFolderId
				JOIN UMUserCredentials UC WITH (NOLOCK) ON
					UC.clientId = SC.clientId
					AND UC.userId = SF.ownerId
			WHERE
				SU.deleted = 0
		AND SU.enabled = 1
		AND SU.excluded = 0
	-- performance create share caps and if any exist then do a merge
	SELECT
		dbo.BitwiseOR(T.capabilities) AS capabilities,
		T.shareId AS shareId
	INTO #sharesCaps
	FROM
		(SELECT DISTINCT capabilities =
					CASE
WHEN SU.permission = 1 OR SU.permission = (1&4) THEN POWER(2.0, 31 -1)	--EV_VISIBILITY
WHEN SU.permission = 2 OR SU.permission = (2&4) OR SU.permission = (2&1&4) THEN CONVERT(BIGINT, POWER(2.0, 34 -1))|CONVERT(BIGINT, POWER(2.0, 31 -1))	--EV_EDIT ALSO HAS VIEW CAP
						ELSE 0
					END,
					SU.shareId
		FROM
			UMUserGroup UG WITH (NOLOCK)
			INNER JOIN App_SharingUserInfo SU WITH (NOLOCK) ON
				UG.userId = @userId
				AND SU.userType = 3 	--SHARE TYPE FOR CS GROUPS
				AND CAST(UG.groupId AS NVARCHAR(MAX)) = SU.sharedTo
			JOIN App_SyncCloudConfig SC WITH (NOLOCK) ON
				SC.syncWebFolderId = SU.shareId
			JOIN App_SyncCloudFolder SF WITH (NOLOCK) ON
				SF.syncWebFolderId = SC.syncWebFolderId
			JOIN UMUserCredentials UC WITH (NOLOCK) ON
				UC.clientId = SC.clientId
				AND UC.userId = SF.ownerId
		WHERE
			SU.deleted = 0
				AND SU.enabled = 1
			AND SU.excluded = 0) AS T
			GROUP BY shareId
		IF EXISTS(SELECT * FROM #sharesCaps)
		BEGIN
			MERGE #flatView AS FW
				USING (SELECT capabilities, shareId FROM #sharesCaps) AS SF ON
					(FW.entityId2 = SF.shareId)
		WHEN MATCHED THEN
			UPDATE SET FW.capabilities = (FW.capabilities | CAST(SF.capabilities AS BIGINT))
		WHEN NOT MATCHED THEN
			INSERT (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
                           subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
                           reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId, entityId2)
					   VALUES (SF.capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
								000,000,000,000,000,000,000,000, SF.shareId);
		END
	-- performance create share caps and if any exist then do a merge saved 70ms
	SELECT
		dbo.BitwiseOR(T.capabilities) AS capabilities,
		T.shareId AS shareId
	INTO #sharesCaps1
	FROM
		(SELECT DISTINCT capabilities =
					CASE
WHEN SU.permission = 1 OR SU.permission = (1&4) THEN POWER(2.0, 31 -1)	--EV_VISIBILITY
WHEN SU.permission = 2 OR SU.permission = (2&4) OR SU.permission = (2&1&4) THEN CONVERT(BIGINT, POWER(2.0, 34 -1))|CONVERT(BIGINT, POWER(2.0, 31 -1))	--EV_EDIT ALSO HAS VIEW CAP
						ELSE 0
					END,
					SU.shareId
		FROM
			UMDSUserGroup EG WITH (NOLOCK)
			INNER JOIN App_SharingUserInfo SU WITH (NOLOCK) ON
				EG.userId = @userId
				AND SU.userType = 4		--SHARE TYPE FOR EXTERNAL GROUPS
				AND CAST(EG.groupId AS NVARCHAR(MAX)) = SU.sharedTo
			JOIN App_SyncCloudConfig SC WITH (NOLOCK) ON
				SC.syncWebFolderId = SU.shareId
			JOIN App_SyncCloudFolder SF WITH (NOLOCK) ON
				SF.syncWebFolderId = SC.syncWebFolderId
			JOIN UMUserCredentials UC WITH (NOLOCK) ON
				UC.clientId = SC.clientId
				AND UC.userId = SF.ownerId
		WHERE
			SU.deleted = 0
				AND SU.enabled = 1
			AND SU.excluded = 0) AS T
			GROUP BY shareId
	IF EXISTS(SELECT * FROM #sharesCaps1)
	BEGIN
		MERGE #flatView AS FW
			USING (SELECT capabilities, shareId FROM #sharesCaps1) AS SF ON
				(FW.entityId2 = SF.shareId)
		WHEN MATCHED THEN
			UPDATE SET FW.capabilities = (FW.capabilities | CAST(SF.capabilities AS BIGINT))
		WHEN NOT MATCHED THEN
			INSERT (capabilities, commCellId,  clientGroupId, clientId, appTypeId, instanceId, backupsetId,
					   subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId,
					   reviewSetId,querySetId,downloadSetId,tagId,legalHoldId,ermId,cdPolicyId,complianceReportId, entityId2)
					   VALUES (SF.capabilities, @commcellId, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000, 000,
								000,000,000,000,000,000,000,000, SF.shareId);
	END
	--	COPY TO OUTPUT TABLE --
delete #UMUserCredentials Where UserId = @userID
INSERT INTO #UMUserCredentials (UserId,capabilities,flag,commCellId,clientGroupId,clientId,appTypeId,instanceId,backupsetId,subClientId,mediaAgentId,libraryId,archGroupId,
			vtContainerId,vtPolicyId,vtShelfId,reviewSetId,querySetId,downloadSetId,ermId,legalHoldId,tagId,cdPolicyId,complianceReportId, taskId, workflowId,logMonitoringPolicyId,
			arrayId,cloudId,userGroupId,providerId,entityId1,entityId2,entityId3,entityId4,entityId5,entityId6,entityId7,entityId8,entityId9)
						select distinct @userId, capabilities,flag,commCellId,clientGroupId,clientId,appTypeId,instanceId,backupsetId,subClientId,mediaAgentId,libraryId,archGroupId,
			vtContainerId,vtPolicyId,vtShelfId,reviewSetId,querySetId,downloadSetId,ermId,legalHoldId,tagId,cdPolicyId,complianceReportId, taskId, workflowId,logMonitoringPolicyId,
			arrayId,cloudId,userGroupId,providerId,entityId1,entityId2,entityId3,entityId4,entityId5,entityId6,entityId7,entityId8,entityId9 from #flatview
UPDATE #UMUsers SET credSetTime = @now WHERE id = @userId
	--	EXEC ( 'INSERT INTO ' + @OutputTableArg + ' SELECT * FROM #flatview' )
		--UPDATE THE INSTANCEID where instance was not set correctly.
UPDATE #UMUserCredentials SET instanceId = ISNULL((SELECT TOP 1 instance FROM [APP_Application] WHERE BACKUPSET = BACKUPSETID ), 1) WHERE [instanceId] = 1 AND [backupsetId] > 0 AND UserId = @userID
	if @isTranStarted =1
	BEGIN
		COMMIT TRAN
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	IF @isTranStarted =1
	BEGIN
		ROLLBACK TRAN
	END
	DECLARE @sev INT = ERROR_SEVERITY()
	DECLARE @state INT = ERROR_STATE()
	RAISERROR ('Exception Trapped in sec_updateUserCredentials SP', @sev, @state)
END CATCH
GET_USER_CREDENTIALS_EXIT:
-- NOTE: Moved to after the Transaction is either committed or rolled back so
--		 they are outside this transaction!
-- Drop any temp tables created during the processing of this SP
if object_id('tempdb.dbo.#shortUserAssocList') is not null
    DROP TABLE #shortUserAssocList
if object_id('tempdb.dbo.#flatView') is not null
    DROP TABLE #flatView
if object_id('tempdb.dbo.#AssociationsWithCapabilites') is not null
    DROP TABLE #AssociationsWithCapabilites
if object_id('tempdb.dbo.#OwnerCapabilites') is not null
    DROP TABLE #OwnerCapabilites
if object_id('tempdb.dbo.#NewOwnerCapabilites') is not null
    DROP TABLE #NewOwnerCapabilites
IF OBJECT_ID('tempdb.dbo.#tempcaps') IS NOT NULL
	DROP TABLE #tempcaps
if object_id('tempdb.dbo.#sharesCaps') is not null
	DROP TABLE #sharesCaps
if object_id('tempdb.dbo.#sharesCaps1') is not null
	DROP TABLE #sharesCaps1
		INSERT INTO #userObjectsTbl
		SELECT DISTINCT commCellId, clientId, appTypeId, instanceId, backupsetId, subClientId, archGroupId
		FROM	#GetUserCapabilitiesForDM2_userObjects
		WHERE   clientGroupId = 0 AND mediaAgentId = 0 AND libraryID = 0
			AND reviewSetId = 0 AND querySetId = 0 AND downloadSetId = 0 AND tagId = 0
			AND legalHoldId = 0 AND ermId = 0 AND cdPolicyId = 0 AND complianceReportId = 0
			AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0
			AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0
			AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0
			AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0
			AND (@i_capability = 0 OR (capabilities & POWER(2, @i_capability-1)) > 0)
		DROP TABLE #UMUsers
		DROP TABLE #UMDSUserGroup
	END
	ELSE
	BEGIN
		SET @userId = (SELECT id FROM UMUsers WHERE login = @i_UserName)
		EXEC sec_updateUserCredentials @userId
		EXEC sec_getUserObjects @userId, 0, 0, '#GetUserCapabilitiesForDM2_userObjects'
		INSERT INTO #userObjectsTbl
		SELECT DISTINCT commCellId, clientId, appTypeId, instanceId, backupsetId, subClientId, archGroupId
		FROM	#GetUserCapabilitiesForDM2_userObjects
		WHERE	clientGroupId = 0 AND mediaAgentId = 0 AND libraryID = 0
			AND reviewSetId = 0 AND querySetId = 0 AND downloadSetId = 0 AND tagId = 0
			AND legalHoldId = 0 AND ermId = 0 AND cdPolicyId = 0 AND complianceReportId = 0
			AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0
			AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0
			AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0
			AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0
			AND (@i_capability = 0 OR (capabilities & POWER(2, @i_capability-1)) > 0)
	END
	EXEC ( 'INSERT INTO ' + @o_userObjTableArg + ' SELECT * FROM #userObjectsTbl' )
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getUserCapabilitiesForDM2')
	delete from GxQscripts where name = 'sec_getUserCapabilitiesForDM2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUserCapabilitiesForDM2')
	delete from GXDBVersions where aliasname = 'sec_getUserCapabilitiesForDM2'
GO

insert into GXDBVersions values(2, 'sec_getUserCapabilitiesForDM2',  '00010007000200060000', 'sec_getUserCapabilitiesForDM2', '00010007000200060000')
GO

