

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getUMEntityandPermissionOnEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +====================================================================================================================================+
--  |   Procedure:  sec_getUsersAndGroupsWithPermission
--  |
--  | Description:  getting list of users, user groups and external user groups with a particular permission
--  |				(without checking for the association)
--	|
--  |				Can expand the user groups to external groups and users based on flag
--  |
--  |
--	|	Authors: saggarwal & jswaminathan
--  +====================================================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getUMEntityandPermissionOnEntity <<<'

IF EXISTS (select * from sysobjects where name='sec_getUMEntityandPermissionOnEntity')
	drop procedure sec_getUMEntityandPermissionOnEntity
IF EXISTS (select * from GxQscripts where name='sec_getUMEntityandPermissionOnEntity')
	delete from GxQscripts where name = 'sec_getUMEntityandPermissionOnEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUMEntityandPermissionOnEntity')
	delete from GXDBVersions where aliasname = 'sec_getUMEntityandPermissionOnEntity'
GO
print '... Creating Procedure: sec_getUMEntityandPermissionOnEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getUMEntityandPermissionOnEntity
  @outputTableArg varchar(128),
  @i_entitytype integer,
  @i_entityListXML XML,
  @expandRole INTEGER =1,
  @expandUserGroup INTEGER =0,
  @permissionId INTEGER =0,
  @isReturn INTEGER =0 
AS
  DECLARE @o_userOrGroup integer
  DECLARE @o_isUser integer
  DECLARE @roleId integer
  DECLARE @o_permissionId integer
  DECLARE @o_entityType1 integer
  DECLARE @o_entityId1 integer
  DECLARE @o_entityType2 integer
  DECLARE @o_entityId2 integer
  DECLARE @o_entityType3 integer
  DECLARE @o_entityId3 integer
  DECLARE @o_entityType4 integer
  DECLARE @o_entityId4 integer
  DECLARE @o_entityType5 integer
  DECLARE @o_entityId5 integer
--XML = <Associations>
	 --<entity entityId1=2/>
	 --<entity entityId2=3/>
	 --</Associations>
 BEGIN TRY
	 if(@permissionId<>0 and @expandRole<>0)
	 BEGIN
		RAISERROR (  N'Invalid inputs. permissionID check and expand Roles to give all permission can be process in singel request together ', 11,1)
		RETURN
	 END
	 IF OBJECT_ID('tempdb.dbo.#OutputUserRoleAssociation') IS NOT NULL
		DROP TABLE #OutputUserRoleAssociation
CREATE TABLE #OutputUserRoleAssociation ([userORGroupId] integer, [isUSer] integer, [roleId] integer, [permissionId] integer, [entitytype1]	 integer, [entityId1] integer, [entityType2] integer DEFAULT 0, [entityId2] integer DEFAULT 0, [entityType3] integer DEFAULT 0, [entityId3] integer DEFAULT 0, [entityType4] integer DEFAULT 0, [entityId4] integer DEFAULT 0, [entityType5] integer DEFAULT 0,  [entityId5] integer DEFAULT 0)
	IF OBJECT_ID('tempdb.dbo.#parentEntityTable') IS NOT NULL
		DROP TABLE #parentEntityTable
	CREATE TABLE #parentEntityTable (parentEntityType INT, parentEntityId INT, childEntityType INT, childEntityId INT)
	IF OBJECT_ID('tempdb.dbo.#inputEntityTable') IS NOT NULL
		DROP TABLE #inputEntityTable
	CREATE TABLE #inputEntityTable  (entitytype1 integer,entityId1 integer,entityType2 integer DEFAULT 0,entityId2 integer DEFAULT 0,entityType3 integer DEFAULT 0,
	entityId3 integer DEFAULT 0,
	entityType4 integer DEFAULT 0,
	entityId4 integer DEFAULT 0,
	entityType5 integer DEFAULT 0,
	entityId5 integer DEFAULT 0)
	INSERT INTO #inputEntityTable (entitytype1,entityId1,entitytype2,entityId2,entitytype3,entityId3,entitytype4,entityId4,entitytype5,entityId5)
		 SELECT ref.value('(@entityType1)','int'),
				ref.value('(@entityId1)','int'),
				ISNULL(ref.value('(@entityType2)','int'),0),
				ISNULL(ref.value('(@entityId2)','int'),0),
				ISNULL(ref.value('(@entityType3)','int'),0),
				ISNULL(ref.value('(@entityId3)','int'),0),
				ISNULL(ref.value('(@entityType4)','int'),0),
				ISNULL(ref.value('(@entityId4)','int'),0),
				ISNULL(ref.value('(@entityType5)','int'),0),
				ISNULL(ref.value('(@entityId5)','int'),0)
	FROM @i_entityListXML.nodes('//*/entity') as R(ref)
	DECLARE @outputStmt nvarchar(max)
	--1. Get all parents of entityIds passed.
	DECLARE @associationsQuery nvarchar(max)
	SET @associationsQuery = 'INSERT INTO #parentEntityTable'
                                + CHAR(10)
                                + 'SELECT Tbl.parentEntityType, Tbl.parentId, Tbl.childEntityType, Tbl.childId '
                                + CHAR(10)
                                + 'FROM ('
                                + CHAR(10)
                                + SUBSTRING
                                    (
                                        (
                                            SELECT          'UNION'
                                                            + CHAR(10)          -- New line character
                                                            + CAST(associationQuery AS VARCHAR(MAX))
                                                            + CHAR(10)
                                            FROM App_EntityParentAssociation PE
                                            WHERE
                                                PE.childEntityType = @i_entitytype
                                            FOR XML PATH (''), TYPE
                                        ).value('.','NVARCHAR(MAX)'),               -- There may be < or > symbols that are XML encoded into &lt; and &gt; Doing a .value removes that encoding.
                                        6,              -- Exclude the first UNION
                                        2147483647      -- MAX
                                    )
                                + ')Tbl'
                                + CHAR(10)
                                + 'INNER JOIN #inputEntityTable Input
                                    ON Tbl.childId = Input.entityId1'
     EXEC (@associationsQuery)
	--permissionId passed is 0. So get all roles/permissions association.
	IF(@permissionId=0)
	BEGIN
		--Commcell level association
			INSERT INTO #OutputUserRoleAssociation
			SELECT DISTINCT userORGroupId,isUser ,roleId,permissionId,input.entitytype1,input.entityId1,input.entityType2,input.entityId2,input.entityType3,input.entityId3,input.entityType4,input.entityId4,input.entitytype5,input.entityId5
			FROM UMSecurityAssociations Sec CROSS JOIN #inputEntityTable input
			WHERE Sec.entityType1 = 1 AND Sec.entityId1 = 2
			UNION
			--include all level association
			SELECT DISTINCT userORGroupId,isUser ,roleId,permissionId,input.entitytype1,input.entityId1,input.entityType2,input.entityId2,input.entityType3,input.entityId3,input.entityType4,input.entityId4,input.entitytype5,input.entityId5
			FROM UMSecurityAssociations Sec CROSS JOIN #inputEntityTable input
			WHERE Sec.includeAll = 1 AND Sec.entityType1 = @i_entitytype
			UNION
			SELECT DISTINCT userORGroupId,isUser ,roleId,permissionId, input.entitytype1,input.entityId1,0,0,0,0,0,0,0,0
			FROM UMSecurityAssociations Sec
			INNER JOIN #parentEntityTable Parent
			ON Sec.entityType1 = Parent.parentEntityType AND Sec.entityId1 = Parent.parentEntityId
			JOIN #inputEntityTable  input ON input.entitytype1=Parent.childEntityType and input.entityId1=childEntityId
			UNION
			--all parents are selected
			SELECT DISTINCT userORGroupId,isUser ,roleId,permissionId,childEntityType,childEntityId,0,0,0,0,0,0,0,0
			FROM UMSecurityAssociations Sec
			INNER JOIN #parentEntityTable Parent
			ON Sec.entityType1 = Parent.parentEntityType
			WHERE Sec.includeAll = 1
			UNION
			--entity level association
			SELECT DISTINCT userORGroupId,isUser ,roleId,permissionId ,Sec.entitytype1,Sec.entityId1,Sec.entityType2,Sec.entityId2,Sec.entityType3,Sec.entityId3,Sec.entityType4,Sec.entityId4,Sec.entitytype5,Sec.entityId5
		   FROM UMSecurityAssociations Sec
		   INNER JOIN #inputEntityTable input ON (Sec.entityType1 = input.entityType1 AND Sec.entityId1 = input.entityID1) AND
												 (Sec.entityType2 = 0 OR (Sec.entityType2 = input.entityType2 AND Sec.entityId2 = input.entityId2)) AND
												 (Sec.entityType3 = 0 OR (Sec.entityType3 = input.entityType3 AND Sec.entityId3 = input.entityId3)) AND
												 (Sec.entityType4 = 0 OR (Sec.entityType4 = input.entityType4 AND Sec.entityId4 = input.entityId4)) AND
												 (Sec.entityType5 = 0 OR (Sec.entityType5 = input.entityType5 AND Sec.entityId5 = input.entityId5))
			--owners. Now this is independent of permission so first get all users, than outer join with permissions.
			DECLARE @OwnerUserTable TABLE (userOrGroupId int, isUser int,entitytype integer,entityId integer)
			INSERT INTO @OwnerUserTable
			SELECT DISTINCT userOrGroupId,isUser,entity.entityType1,entity.entityId1
			FROM UMOwners O CROSS JOIN #inputEntityTable entity
			WHERE O.entityType=1 and O.entityId=2
			UNION
			SELECT DISTINCT userOrGroupId,isUser,entity.entityType1,entity.entityId1
			FROM UMOwners OwnerUser  INNER JOIN #parentEntityTable Parent
			ON OwnerUser.entityType = Parent.parentEntityType AND OwnerUser.entityId = Parent.parententityId
			JOIN #inputEntityTable entity ON entity.entitytype1=Parent.childEntityType and entity.entityId1=childEntityId
			UNION
			SELECT DISTINCT userOrGroupId,isUser,entity.entityType1,entity.entityId1
			FROM UMOwners OwnerUser
			JOIN #inputEntityTable entity ON entity.entitytype1=OwnerUser.entityType and entity.entityId1=OwnerUser.entityId
			--now get permission list
			INSERT INTO #OutputUserRoleAssociation (userOrGroupId,isUser,roleId,permissionId,entitytype1,entityId1)
			SELECT DISTINCT userOrGroupId,isUser,ISNULL(roleId,0),ISNULL(permissionId,0),userEntity.entitytype,userEntity.entityId
			FROM @OwnerUserTable userEntity CROSS JOIN
			UMOwnerRoles perm
			WHERE perm.entityType=1 and perm.entityType=2
			UNION
			SELECT DISTINCT userOrGroupId,isUser,ISNULL(roleId,0),ISNULL(permissionId,0),userEntity.entitytype,userEntity.entityId
			FROM @OwnerUserTable userEntity
				LEFT OUTER JOIN ( SELECT roleId,permissionId,childEntityType as entitytype,childEntityId  as entityId
								  FROM UMOwnerRoles JOIN #parentEntityTable ON entityType=parentEntityType and entityId=parentEntityId
								  UNION
								  SELECT roleId,permissionId ,entityType,entityId
								  FROM UMOwnerRoles JOIN #inputEntityTable ON entityType=entityType1 and entityId=entityId1
								  ) as OwnerPermission
								  ON  OwnerPermission.entitytype=userEntity.entitytype and OwnerPermission.entityId=userEntity.entityId
	END
	ELSE
	BEGIN
		DECLARE  @rolePermissionId TABLE ( roleIdTemp integer,permissionIdTemp integer)
		INSERT INTO @rolePermissionId
		SELECT R.id as roleId, 0 as permissionId
		FROM UMRolesWithPermissionsExpanded  RPE INNER JOIN UMROles R ON R.id = RPE.roleId
		WHERE R.disabled=0 and RPE.permissionId=@permissionId
		UNION
		SELECT 0 as roleId, @permissionId as permissionId
		INSERT INTO #OutputUserRoleAssociation
		SELECT DISTINCT userORGroupId,isUser ,roleId,permissionId,input.entitytype1,input.entityId1,input.entityType2,input.entityId2,input.entityType3,input.entityId3,input.entityType4,input.entityId4,input.entitytype5,input.entityId5
		FROM UMSecurityAssociations Sec  JOIN @rolePermissionId role ON  Sec.roleId=roleIdTemp and permissionId=permissionIdTemp
		CROSS JOIN #inputEntityTable input
		WHERE Sec.entityType1 = 1 AND Sec.entityId1 = 2
		UNION
		--include all level association
		SELECT DISTINCT userORGroupId,isUser ,roleId,permissionId,input.entitytype1,input.entityId1,input.entityType2,input.entityId2,input.entityType3,input.entityId3,input.entityType4,input.entityId4,input.entitytype5,input.entityId5
		FROM UMSecurityAssociations Sec  JOIN @rolePermissionId role ON  Sec.roleId=roleIdTemp and permissionId=permissionIdTemp
		 JOIN #inputEntityTable input ON  Sec.entityType1 = input.entitytype1 AND Sec.includeAll = 1
		UNION
		--parent level association
		SELECT DISTINCT userORGroupId,isUser ,roleId,permissionId ,childEntityType,childEntityId,0,0,0,0,0,0,0,0
		FROM UMSecurityAssociations Sec  JOIN @rolePermissionId role ON  Sec.roleId=roleIdTemp and permissionId=permissionIdTemp
		INNER JOIN #parentEntityTable Parent
		ON Sec.entityType1 = Parent.parentEntityType AND Sec.entityId1 = Parent.parentEntityId
		UNION
		--all parents are selected
		SELECT DISTINCT userORGroupId,isUser ,roleId,permissionId,childEntityType,childEntityId,0,0,0,0,0,0,0,0
		FROM UMSecurityAssociations Sec    JOIN @rolePermissionId role ON  Sec.roleId=roleIdTemp and permissionId=permissionIdTemp
		INNER JOIN #parentEntityTable Parent
		ON Sec.entityType1 = Parent.parentEntityType
		WHERE Sec.includeAll = 1
		UNION
		--entity level association
		SELECT DISTINCT userORGroupId,isUser ,roleId,permissionId ,Sec.entitytype1,Sec.entityId1,Sec.entityType2,Sec.entityId2,Sec.entityType3,Sec.entityId3,Sec.entityType4,Sec.entityId4,Sec.entitytype5,Sec.entityId5
		FROM UMSecurityAssociations Sec JOIN @rolePermissionId role ON  Sec.roleId=roleIdTemp and permissionId=permissionIdTemp
		  INNER JOIN #inputEntityTable input ON (Sec.entityType1 = input.entityType1 AND Sec.entityId1 = input.entityID1) AND
												 (Sec.entityType2 = 0 OR (Sec.entityType2 = input.entityType2 AND Sec.entityId2 = input.entityId2)) AND
												 (Sec.entityType3 = 0 OR (Sec.entityType3 = input.entityType3 AND Sec.entityId3 = input.entityId3)) AND
												 (Sec.entityType4 = 0 OR (Sec.entityType4 = input.entityType4 AND Sec.entityId4 = input.entityId4)) AND
												 (Sec.entityType5 = 0 OR (Sec.entityType5 = input.entityType5 AND Sec.entityId5 = input.entityId5))
	--owners handling
		--get list of applicable owners,than join it with applicable permissions
		DECLARE @ownersTable TABLE (entitytype integer, entityId integer,roleId integer,permissionId integer)
		INSERT INTO @ownersTable
		SELECT DISTINCT entityType1,entityId1,roleId,permissionId
		FROM UMOwnerRoles JOIN @rolePermissionId role ON  roleId=roleIdTemp and permissionId=permissionIdTemp
		CROSS JOIN #inputEntityTable
		WHERE entityType=1 and entityId=2
		UNION
		SELECT DISTINCT childEntityType,childEntityId,ISNULL(roleID,0),ISNULL(permissionId,0)
		FROM UMOwnerRoles perm
			JOIN @rolePermissionId role ON  roleId=roleIdTemp and permissionId=permissionIdTemp
			INNER JOIN #parentEntityTable Parent
			ON perm.entityType = Parent.parentEntityType AND perm.entityId = Parent.parententityId
		UNION
		SELECT DISTINCT entityType1,entityId1,roleId,permissionId
		FROM UMOwnerRoles JOIN @rolePermissionId role ON  roleId=roleIdTemp and permissionId=permissionIdTemp
		 JOIN #inputEntityTable ON entityType=entitytype1 and entityId=entityId1
		INSERT INTO #OutputUserRoleAssociation(userOrGroupId,isUser,roleId,permissionId,entitytype1,entityId1)
		SELECT userOrGroupId,isUser,roleId,permissionId,entity.entityType,entity.entityId
		FROM UMOwners O CROSS JOIN @ownersTable entity
		WHERE O.entityType=1 and O.entityId=2
		UNION
		SELECT userOrGroupId,isUser,roleId,permissionId,entity.entityType,entity.entityId
		FROM UMOwners OwnerUser  INNER JOIN #parentEntityTable Parent
			ON OwnerUser.entityType = Parent.parentEntityType AND OwnerUser.entityId = Parent.parententityId
			JOIN @ownersTable entity ON entity.entitytype=Parent.childEntityType and entity.entityId=childEntityId
		UNION
		SELECT userOrGroupId,isUser,roleId,permissionId,entity.entityType,entity.entityId
		FROM UMOwners OwnerUser
			JOIN @ownersTable entity ON entity.entitytype=OwnerUser.entityType and entity.entityId=OwnerUser.entityId
	END
	IF(@expandUserGroup<>0)
	BEGIN
		INSERT INTO #OutputUserRoleAssociation
		SELECT userId,1,roleId,permissionId,entitytype1,entityId1,entitytype2,entityId2,entitytype3,entityId3,entitytype4,entityId4,entitytype5,entityId5
		FROM #OutputUserRoleAssociation JOIN UMUserGroup ON userOrGroupId=groupId and isUser=0
	END
	IF(@isReturn<>0)
		BEGIN
			IF(@expandRole<>0)
			BEGIN
				SELECT DISTINCT userOrGroupId,isUSer,RPE.roleId,RPE.permissionId,entitytype1,entityId1,entitytype2,entityId2,entitytype3,entityId3,entitytype4,entityId4,entitytype5,entityId5
				FROM #OutputUserRoleAssociation output JOIN UMRolesWithPermissionsExpanded RPE ON output.roleId=RPE.roleId INNER JOIN UMROles R ON R.id = RPE.roleId
				WHERE R.disabled = 0
				UNION
				SELECT DISTINCT userOrGroupId,isUSer,roleId,permissionId,entitytype1,entityId1,entitytype2,entityId2,entitytype3,entityId3,entitytype4,entityId4,entitytype5,entityId5
				FROM #OutputUserRoleAssociation output WHERE permissionId<>0
			END
			ELSE
			BEGIN
				SELECT DISTINCT userOrGroupId,isUSer,roleId,permissionId,entitytype1,entityId1,entitytype2,entityId2,entitytype3,entityId3,entitytype4,entityId4,entitytype5,entityId5
				FROM #OutputUserRoleAssociation output
			END
		END
		ELSE BEGIN
				IF(@expandRole<>0)
				BEGIN
					SET @outputStmt = 'INSERT INTO ' + @outputTableArg
										+ ' SELECT DISTINCT userOrGroupId,isUSer,RPE.roleId,RPE.permissionId,entitytype1,entityId1,entitytype2,entityId2,entitytype3,entityId3,entitytype4,entityId4,entitytype5,entityId5
										FROM #OutputUserRoleAssociation output JOIN UMRolesWithPermissionsExpanded RPE ON output.roleId=RPE.roleId INNER JOIN UMROles R ON R.id = RPE.roleId
										WHERE R.disabled = 0
										UNION
										SELECT DISTINCT userOrGroupId,isUSer,roleId,permissionId,entitytype1,entityId1,entitytype2,entityId2,entitytype3,entityId3,entitytype4,entityId4,entitytype5,entityId5
										FROM #OutputUserRoleAssociation output WHERE permissionId<>0'
				END
				ELSE
				BEGIN
						SET @outputStmt = 'INSERT INTO ' + @outputTableArg
										   +'   SELECT DISTINCT userOrGroupId,isUSer,roleId,permissionId,entitytype1,entityId1,entitytype2,entityId2,entitytype3,entityId3,entitytype4,entityId4,entitytype5,entityId5
											 FROM #OutputUserRoleAssociation output'
				END
				EXEC (@outputStmt)
		END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	IF (SELECT CURSOR_STATUS('global','parentEntityCursor')) >= -1
	BEGIN
		IF (SELECT CURSOR_STATUS('global','parentEntityCursor')) > -1
				CLOSE parentEntityCursor
		DEALLOCATE parentEntityCursor
	END
	 IF OBJECT_ID('tempdb.dbo.#OutputUserRoleAssociation') IS NOT NULL
		DROP TABLE #OutputUserRoleAssociation
	IF OBJECT_ID('tempdb.dbo.#parentEntityTable') IS NOT NULL
		DROP TABLE #parentEntityTable
	IF OBJECT_ID('tempdb.dbo.#inputEntityTable') IS NOT NULL
		DROP TABLE #inputEntityTable
END CATCH
IF OBJECT_ID('tempdb.dbo.#OutputUserRoleAssociation') IS NOT NULL
	DROP TABLE #OutputUserRoleAssociation
IF OBJECT_ID('tempdb.dbo.#parentEntityTable') IS NOT NULL
	DROP TABLE #parentEntityTable
IF OBJECT_ID('tempdb.dbo.#inputEntityTable') IS NOT NULL
	DROP TABLE #inputEntityTable
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getUMEntityandPermissionOnEntity')
	delete from GxQscripts where name = 'sec_getUMEntityandPermissionOnEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getUMEntityandPermissionOnEntity')
	delete from GXDBVersions where aliasname = 'sec_getUMEntityandPermissionOnEntity'
GO

insert into GXDBVersions values(2, 'sec_getUMEntityandPermissionOnEntity',  '00000000000000000000', 'sec_getUMEntityandPermissionOnEntity', '00000000000000000000')
GO

