

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getStaleExternalObjects.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_getStaleExternalObjects.sp,v $ $Id: sec_getStaleExternalObjects.sp,v 1.6.34.10 2019/08/06 12:47:07 jswaminathan Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_getStaleExternalObjects()
--  |
--  | Description:  Gets a list of External Users and their providers that have
--	|				not been 'updated' for a specified amount of time.
--	|				that can see a chosen iDa object.
--  |
--  |      Inputs:  1. Provider Type (initial, only AD=2 (UMDS_PROVIDER_ACTIVE_DIR)
--	|				     supported (from EvAppUMDS.h)
--	|               2. Max rows to return (0 == ALL)
--	|
--	|
--  |     Returns:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--	|	1.1        skatz	Initial Edit
--	|   1.2		   skatz	Expanded to return external groups too
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getStaleExternalObjects')
BEGIN
	print '>>> Drop Stored Procedure: sec_getStaleExternalObjects <<<'
	drop procedure sec_getStaleExternalObjects
END
IF EXISTS (select * from GxQscripts where name='sec_getStaleExternalObjects')
	delete from GxQscripts where name = 'sec_getStaleExternalObjects'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getStaleExternalObjects')
	delete from GXDBVersions where aliasname = 'sec_getStaleExternalObjects'
GO
print '... Creating Procedure: sec_getStaleExternalObjects'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getStaleExternalObjects
  @iServiceType integer,
  @iMaxCount integer
AS
  DECLARE @pId integer
  DECLARE @objId integer
  DECLARE @name varchar(255)
  DECLARE @checkTime integer
  DECLARE @isGroup integer
  DECLARE @guid nvarchar(255) 
  DECLARE @isClientOwner integer
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @nowTime        integer
SET     @nowTime        = dbo.GetUnixTime (GetUTCdate())
DECLARE @numOfDays		INT = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='NumberOfDaysForADCredentialCheck'), 7)
IF @iMaxCount = 0								-- always want to restrict size of return set even if caller
	SET @iMaxCount = 500						-- .. specified 0 for (infinite)!
SELECT TOP (@iMaxCount) P.id, U.id, U.name, U.credSetTime,  0, U.userGuid,
	   CASE WHEN O.userOrGroupId IS NULL THEN 0 ELSE 1 END			-- isClientOwner
	FROM 	UMDSProviders AS P, UmUsers AS U
		LEFT JOIN UMOwners O (NOLOCK)
			ON O.isUser = 1 AND O.userOrGroupId = U.id
		WHERE
		  (    (  P.serviceType = @iServiceType AND  @iServiceType <> 0 )
		       OR
(P.serviceType IN (2, 6 ,  7 , 8, 9, 10 ) AND @iServiceType = 0 )
		  ) -- @iServiceType = 0  means select for all required serviceType.
		  AND   P.enabled <> 0
		  AND 	P.checkTime <> 0
		  AND	P.Id = U.umDSproviderId
AND	(U.flags <> 0 AND (U.flags & CAST(0x800 AS INT) = 0))				-- Ignore the system created user for each user group from being stale deleted.
		  AND 	U.enabled <> 0
		  AND   (U.credSetTime + (P.checkTime*@numOfDays)) < @nowTime
AND   P.serviceType <> 5				--currently the caller itself is calling it only for AD. This check is just for safer side
UNION ALL
SELECT TOP (@iMaxCount) P.id, G.id, G.name, G.lastCredSetTime,  1, '',
	   CASE WHEN O.userOrGroupId IS NULL THEN 0 ELSE 1 END			-- isClientOwner
	FROM 	UMDSProviders AS P, UMDSGroups AS G
		LEFT JOIN UMOwners O (NOLOCK)
			ON O.isUser = 0 AND O.userOrGroupId = G.id
		WHERE
		  (    (  P.serviceType = @iServiceType AND  @iServiceType <> 0 )
		       OR
(P.serviceType IN (2, 6 ,  7 , 8, 9, 10  ) AND @iServiceType = 0 )
		  ) -- @iServiceType = 0  means select for all required serviceType.
		  AND   P.enabled <> 0
		  AND 	P.checkTime <> 0
		  AND	P.Id = G.umDSproviderId
--		  AND	P.flags <> 0
		  AND 	P.enabled <> 0
		  AND   (G.lastCredSetTime + (P.checkTime*@numOfDays)) < @nowTime
AND   P.serviceType <> 5			--currently the caller itself is calling it only for AD. This check is just for safer side
ORDER by p.Id            -- Allows us to skip over bad provider when rows are returned in provider order
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getStaleExternalObjects')
	delete from GxQscripts where name = 'sec_getStaleExternalObjects'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getStaleExternalObjects')
	delete from GXDBVersions where aliasname = 'sec_getStaleExternalObjects'
GO

insert into GXDBVersions values(2, 'sec_getStaleExternalObjects',  '00010006003400100000', 'sec_getStaleExternalObjects', '00010006003400100000')
GO

