

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getShareFolderCredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_getShareFolderCredentials.sp,v $ $Id: sec_getShareFolderCredentials.sp,v 1.5.36.13 2018/12/22 12:36:13 gpattabiraman Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_getShareFolderCredentials()
--  |
--  | Description:  Fetches capabilities for a share folder
--  |
--  |       Input:  userId, shareId
--	|
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getShareFolderCredentials')
BEGIN
	print '>>> Drop Stored Procedure: sec_getShareFolderCredentials <<<'
	drop procedure sec_getShareFolderCredentials
END
IF EXISTS (select * from GxQscripts where name='sec_getShareFolderCredentials')
	delete from GxQscripts where name = 'sec_getShareFolderCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getShareFolderCredentials')
	delete from GXDBVersions where aliasname = 'sec_getShareFolderCredentials'
GO
print '... Creating Procedure: sec_getShareFolderCredentials'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getShareFolderCredentials
  @userId integer,
  @iCommcellId integer,
  @shareId integer,
  @includeExcludedShares integer = NULL
AS
SET NOCOUNT ON
	DECLARE @shareCapabilities BIGINT = 0
DECLARE @DoNotBrowseFlag INT = 0x100
	IF NOT EXISTS(SELECT 1 FROM APP_AdvanceSettings WITH(NOLOCK)
				  WHERE entityType = 13 --User entity
				  AND entityid = @userId
				  AND keyName = 'ShowFileStoreShares' AND CONVERT(NVARCHAR(10), value) = 'true'
				  AND enabled = 1 AND deleted = 0
				 )
	BEGIN
SET @DoNotBrowseFlag = @DoNotBrowseFlag | 0x400
	END
	-- If its the owner, assign him all the rights
	IF EXISTS (SELECT 1 FROM App_SyncCloudFolder INNER JOIN App_SharingUserInfo ON syncWebFolderId = shareId WHERE syncWebFolderId = @shareId AND ownerId = @userId)
	BEGIN
SET @shareCapabilities = POWER(2.0, 1 -1)	--EV_VISIBILITY
SET @shareCapabilities = @shareCapabilities | CAST(POWER(2.0, 2 -1) AS INT)	--EV_EDIT
		SELECT 	@shareCapabilities AS 'capabilities', @shareId AS 'shareId'
	END
	ELSE
	BEGIN
		DECLARE @t_userShares		TABLE(capabilities bigint, sharedTo NVARCHAR(MAX), userType int)
		DECLARE @shareFlag INT = 0
		SELECT @shareFlag = flag FROM App_SyncCloudFolder WHERE syncWebFolderId = @shareId
		-- If its the public folder assign only view rights for now
IF (@shareFlag & (CAST(0x8 AS INT)|CAST(0x80 AS INT)) <> 0)
		BEGIN
SET @shareCapabilities = POWER(2.0, 1 -1)	--EV_VISIBILITY
If @shareFlag & 0x80 = 0x80
SET @shareCapabilities = @shareCapabilities | CAST(POWER(2.0, 2 -1) AS INT) --EV_EDIT
			INSERT @t_userShares (capabilities, sharedTo, userType)
			SELECT 	@shareCapabilities AS 'capabilities', '' AS 'sharedTo', 0 AS 'userType'
		END
	--
		ELSE
		BEGIN
			DECLARE @t_sharedToUsers		TABLE
			(capabilities bigint,
			 sharedTo NVARCHAR(255),
			 userType int
			 primary key (userType, sharedTo)
			 )
			INSERT INTO @t_sharedToUsers select DISTINCT permission, sharedTo, userType FROM App_SharingUserInfo WITH(NOLOCK) WHERE shareId = @shareId AND deleted = 0
			INSERT INTO @t_userShares
				-- GET SHARES SHARED BY THE USER OR SHARED TO THE USER
				SELECT 	CASE dbo.BitwiseOR(SU.capabilities)
WHEN 1 THEN POWER(2.0, 1 -1)	--SHARE_CAN_VIEW
WHEN 2 THEN CASE
WHEN MAX(SH.flag) & @DoNotBrowseFlag = 0 THEN POWER(2, 2 -1)  | POWER(2, 1 -1)	--SHARE_CAN_EDIT + SHARE_CAN_VIEW
ELSE POWER(2, 2 -1) --EV_EDIT only
									END
WHEN 1|2 THEN CASE
WHEN MAX(SH.flag) & @DoNotBrowseFlag = 0 THEN POWER(2, 2 -1)  | POWER(2, 1 -1)	--SHARE_CAN_EDIT + SHARE_CAN_VIEW
ELSE POWER(2, 2 -1) --EV_EDIT only
									END
WHEN 5 THEN POWER(2, 1 -1) | POWER(2, 4 -1)	--SHARE_CAN_VIEW + SHARE_CAN_SET_PERMISSIONS
						WHEN 6 THEN
									CASE
WHEN MAX(SH.flag) & @DoNotBrowseFlag = 0 THEN POWER(2, 2 -1)  | POWER(2, 1 -1) | POWER(2, 4 -1)	--SHARE_CAN_EDIT + SHARE_CAN_VIEW + SHARE_CAN_SET_PERMISSION
ELSE POWER(2, 2 -1) | POWER(2, 4 -1) --SHARE_CAN_EDIT + SHARE_CAN_SET_PERMISSIONS
									END
						ELSE 0
						END,
				SU.sharedTo,
				SU.userType
				FROM @t_sharedToUsers SU
JOIN App_SyncCloudFolder SH WITH (NOLOCK) ON SH.syncWebFolderId = @shareId AND SU.userType = 1
				WHERE SU.sharedTo = CAST(@userId AS NVARCHAR(10))
				GROUP BY SU.sharedTo, SU.userType
				-- GET SHARES SHARED TO A GROUP
				UNION ALL
				SELECT 	CASE dbo.BitwiseOR(SU.capabilities)
WHEN 1 THEN POWER(2.0, 1 -1)	--SHARE_CAN_VIEW
WHEN 2 THEN CASE
WHEN MAX(SH.flag) & @DoNotBrowseFlag = 0 THEN POWER(2, 2 -1)  | POWER(2, 1 -1)	--SHARE_CAN_EDIT + SHARE_CAN_VIEW
ELSE POWER(2, 2 -1) --EV_EDIT only
									END
WHEN 1|2 THEN CASE
WHEN MAX(SH.flag) & @DoNotBrowseFlag = 0 THEN POWER(2, 2 -1)  | POWER(2, 1 -1)	--SHARE_CAN_EDIT + SHARE_CAN_VIEW
ELSE POWER(2, 2 -1) --EV_EDIT only
									END
WHEN 5 THEN POWER(2, 1 -1) | POWER(2, 4 -1)	--SHARE_CAN_VIEW + SHARE_CAN_SET_PERMISSIONS
						WHEN 6 THEN
									CASE
WHEN MAX(SH.flag) & @DoNotBrowseFlag = 0 THEN POWER(2, 2 -1)  | POWER(2, 1 -1) | POWER(2, 4 -1)	--SHARE_CAN_EDIT + SHARE_CAN_VIEW + SHARE_CAN_SET_PERMISSION
ELSE POWER(2, 2 -1) | POWER(2, 4 -1) --SHARE_CAN_EDIT + SHARE_CAN_SET_PERMISSIONS
									END
						ELSE 0
						END,
				SU.sharedTo,
				SU.userType
				FROM @t_sharedToUsers SU
JOIN App_SyncCloudFolder SH WITH (NOLOCK) ON SH.syncWebFolderId = @shareId AND (userType = 3 OR userType = 4)
				JOIN UMUserGroup UG WITH (NOLOCK) ON UG.userId = @userId
				WHERE SU.sharedTo = CAST(UG.groupId AS NVARCHAR(10))
				GROUP BY SU.sharedTo, SU.userType
				-- GET SHARES SHARED USING GROUP'S EMAIL
				UNION ALL
				SELECT 	CASE dbo.BitwiseOR(SU.capabilities)
WHEN 1 THEN POWER(2.0, 1 -1)	--SHARE_CAN_VIEW
WHEN 2 THEN CASE
WHEN MAX(SH.flag) & @DoNotBrowseFlag = 0 THEN POWER(2, 2 -1)  | POWER(2, 1 -1)	--SHARE_CAN_EDIT + SHARE_CAN_VIEW
ELSE POWER(2, 2 -1) --EV_EDIT only
									END
WHEN 1|2 THEN CASE
WHEN MAX(SH.flag) & @DoNotBrowseFlag = 0 THEN POWER(2, 2 -1)  | POWER(2, 1 -1)	--SHARE_CAN_EDIT + SHARE_CAN_VIEW
ELSE POWER(2, 2 -1) --EV_EDIT only
									END
WHEN 5 THEN POWER(2, 1 -1) | POWER(2, 4 -1)	--SHARE_CAN_VIEW + SHARE_CAN_SET_PERMISSIONS
						WHEN 6 THEN
									CASE
WHEN MAX(SH.flag) & @DoNotBrowseFlag = 0 THEN POWER(2, 2 -1)  | POWER(2, 1 -1) | POWER(2, 4 -1)	--SHARE_CAN_EDIT + SHARE_CAN_VIEW + SHARE_CAN_SET_PERMISSION
ELSE POWER(2, 2 -1) | POWER(2, 4 -1) --SHARE_CAN_EDIT + SHARE_CAN_SET_PERMISSIONS
									END
						ELSE 0
						END,
				SU.sharedTo,
				SU.userType
				FROM @t_sharedToUsers SU
JOIN App_SyncCloudFolder SH WITH (NOLOCK) ON SH.syncWebFolderId = @shareId AND SU.userType = 2
				JOIN UMGroups G (NOLOCK) ON G.email = SU.sharedTo --AND SU.sharedTo <> ''
				JOIN UMUserGroup UG (NOLOCK) ON UG.userId = @userId AND UG.groupId = G.id
				GROUP BY SU.sharedTo, SU.userType
				-- GET SHARES SHARED USING USER'S EMAIL
				UNION ALL
				SELECT 	CASE dbo.BitwiseOR(SU.capabilities)
WHEN 1 THEN POWER(2.0, 1 -1)	--SHARE_CAN_VIEW
WHEN 2 THEN CASE
WHEN MAX(SH.flag) & @DoNotBrowseFlag = 0 THEN POWER(2, 2 -1)  | POWER(2, 1 -1)	--SHARE_CAN_EDIT + SHARE_CAN_VIEW
ELSE POWER(2, 2 -1) --EV_EDIT only
									END
WHEN 1|2 THEN CASE
WHEN MAX(SH.flag) & @DoNotBrowseFlag = 0 THEN POWER(2, 2 -1)  | POWER(2, 1 -1)	--SHARE_CAN_EDIT + SHARE_CAN_VIEW
ELSE POWER(2, 2 -1) --EV_EDIT only
									END
WHEN 5 THEN POWER(2, 1 -1) | POWER(2, 4 -1)	--SHARE_CAN_VIEW + SHARE_CAN_SET_PERMISSIONS
						WHEN 6 THEN
									CASE
WHEN MAX(SH.flag) & @DoNotBrowseFlag = 0 THEN POWER(2, 2 -1)  | POWER(2, 1 -1) | POWER(2, 4 -1)	--SHARE_CAN_EDIT + SHARE_CAN_VIEW + SHARE_CAN_SET_PERMISSION
ELSE POWER(2, 2 -1) | POWER(2, 4 -1) --SHARE_CAN_EDIT + SHARE_CAN_SET_PERMISSIONS
									END
						ELSE 0
						END,
				SU.sharedTo,
				SU.userType
				FROM @t_sharedToUsers SU
JOIN App_SyncCloudFolder SH WITH (NOLOCK) ON SH.syncWebFolderId = @shareId AND SU.userType = 2
				JOIN UMUsers U WITH(NOLOCK) ON U.email = SU.sharedTo AND U.id = @userId
				GROUP BY SU.sharedTo, SU.userType
		END
		SELECT dbo.BitwiseOR(capabilities), @shareId AS 'shareId'
		FROM @t_userShares SU
		JOIN App_SyncCloudConfig SC WITH (NOLOCK) ON SC.syncWebFolderId = @shareId AND SC.flag & 0x1 <> 0x1	-- SHARED FOLDER ARE MARKED PAUSED WHEN OWNER LOOSES RIGHTS TO CLIENT
		JOIN App_SyncCloudFolders SFV ON SC.syncWebFolderId = SFV.SyncWebFolderId AND SFV.FLAG <> 0	--CHECK THAT FOLDER IS A SHARE
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getShareFolderCredentials')
	delete from GxQscripts where name = 'sec_getShareFolderCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getShareFolderCredentials')
	delete from GXDBVersions where aliasname = 'sec_getShareFolderCredentials'
GO

insert into GXDBVersions values(2, 'sec_getShareFolderCredentials',  '00010005003600130000', 'sec_getShareFolderCredentials', '00010005003600130000')
GO

