

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getSecurityForUserAndUserGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--        Input: getEffectivePermissions=0 means associations done at entity level
--										=1 associations done only at parent level
--										=2  associtions done at both entity and parent level
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getSecurityForUserAndUserGroup')
BEGIN
	print '>>> Drop Stored Procedure: sec_getSecurityForUserAndUserGroup <<<'
	drop procedure sec_getSecurityForUserAndUserGroup
END
IF EXISTS (select * from GxQscripts where name='sec_getSecurityForUserAndUserGroup')
	delete from GxQscripts where name = 'sec_getSecurityForUserAndUserGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getSecurityForUserAndUserGroup')
	delete from GXDBVersions where aliasname = 'sec_getSecurityForUserAndUserGroup'
GO
print '... Creating Procedure: sec_getSecurityForUserAndUserGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getSecurityForUserAndUserGroup
  @userId INT,
  @userGroupId INT,
  @callerId INT,
  @xmlOut XML OUTPUT,
  @returnHiddenPermission INT=0,
  @getEffectivePermissions INT =0,  
  @isReturn INT= 0
AS
IF OBJECT_ID('tempdb.dbo.#outputTable') IS NOT NULL
	DROP TABLE #outputTable
CREATE TABLE #outputTable
(
	entityType1 INT,
	entityId1 INT,
	entityType2 INT,
	entityId2 INT,
	entityType3 INT,
	entityId3 INT,
	entityType4 INT,
	entityId4 INT,
	entityType5 INT,
	entityId5 INT,
	genericEntityAssociated XML,
	roleId INT DEFAULT 0,
	roleName NVARCHAR(MAX) DEFAULT N'',
	permissionId INT DEFAULT 0,
	categoryPermissionXML NVARCHAR(MAX) DEFAULT N'',
	includeAll INT,
	isCreator INT
)
DECLARE @isUser INTEGER
DECLARE @userORGroupId INTEGER
DECLARE @UMEntityType integer=0
IF(@userId<>0)
BEGIN
	SET @isUser=1
	SET @userOrGroupId=@userId
SET @UMEntityType=13
END
ELSE
BEGIN
	SET @isUser=0
	SET @userOrGroupId=@userGroupId
	IF EXISTS (SELECT 1 FROM UMGroups where id=@userOrGroupId and umdsProviderID=0)
SET @UMEntityType=15
	ELSE
SET @UMEntityType=62
END
if(@getEffectivePermissions=0 OR @getEffectivePermissions=2)
INSERT INTO #outputTable (entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, roleId, permissionId, includeAll, isCreator)
	SELECT DISTINCT entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, roleId, permissionId, includeAll, isCreator
	FROM UMSecurityAssociations
	WHERE isUser = @isUser AND userOrGroupId = @userOrGroupId
DECLARE @tempentitytype INT
--SELECT DISTINCT userOrGroupId,isUSer,RPE.roleId,RPE.permissionId,entitytype1,entityId1,entitytype2,entityId2,entitytype3,entityId3,entitytype4,entityId4,entitytype5,entityId5
IF OBJECT_ID('tempdb.dbo.#entityVisibleNonIda') IS NOT NULL
	DROP TABLE #entityVisibleNonIda
CREATE TABLE #entityVisibleNonIda (entityId INT)
IF OBJECT_ID('tempdb.dbo.#entityVisibleIda') IS NOT NULL
	DROP TABLE #entityVisibleIda
CREATE TABLE #entityVisibleIda (clientId INT, appTypeId INT, instanceID INT, backupsetId INT, subclientId INT)
DECLARE tempcursor CURSOR FOR
	SELECT DISTINCT dbo.getEntityLevelFromEntityHierarchy(entityType1, entityType2, entityType3, entityTYpe4, entityType5)
	FROM #outputTable
OPEN tempcursor
FETCH NEXT FROM tempcursor INTO @tempentitytype
WHILE @@FETCH_STATUS = 0
BEGIN
	DELETE FROM #entityVisibleNonIda
	DELETE FROM #entityVisibleIda
IF (@tempentitytype NOT IN (3, 4, 5, 6, 7))
	BEGIN
		EXEC sec_getNonIdaObjectsForThisUser @callerID, @tempentitytype, 0, '#entityVisibleNonIda'
		DELETE tbl
		FROM #outputTable tbl LEFT OUTER JOIN #entityVisibleNonIda sec
		ON tbl.entityType1 = @tempentitytype AND tbl.entityId1 = sec.entityId
		WHERE tbl.entityType1 = @tempentityType AND sec.entityId IS NULL AND includeAll = 0
	END
	ELSE
	BEGIN
		EXEC sec_getIdaObjectsForUser @callerId, @tempentitytype, 0, 0, '#entityVisibleIda'
		--Note that sec_getIdaObjectsForUser.sp will always "expand" the results and give. If you are asking for list of "backupset", then it will get you only backupset rows.
		--No client or appType or instance rows with backupsetId as 0 will be returned. So all we have to do is just do a ID mapping between tempTable and entityVisibleIda
		DELETE tbl
		FROM #outputTable Tbl LEFT OUTER JOIN #entityVisibleIda Sec
ON (tbl.entityType1 = 3 AND tbl.entityID1 = Sec.clientID)
AND (@tempEntityType < 4 OR (tbl.entityType2 = 4 AND tbl.entityId2 = Sec.appTypeId))
AND (@tempEntityType < 5 OR (tbl.entityType3 = 5 AND tbl.entityId3 = Sec.instanceId))
AND (@tempEntityType < 6 OR (tbl.entityType4 = 6 AND tbl.entityId4 = Sec.backupsetid))
AND (@tempEntityType < 7 OR (tbl.entityType5 = 7 AND tbl.entityId5 = Sec.subclientId))
		WHERE dbo.getEntityLevelFromEntityHierarchy(entityType1, entityType2, entityType3, entityTYpe4, entityType5) = @tempentitytype AND Sec.clientId IS NULL AND includeAll = 0
	END
	FETCH NEXT FROM tempcursor INTO @tempentitytype
END
CLOSE tempcursor
DEALLOCATE tempcursor
--We should not send role that are hidden back to GUI
DELETE Tbl
FROM #outputTable Tbl INNER JOIN UMROles Roles
ON Tbl.roleId = Roles.id
WHERE Tbl.roleId <> 0 AND Roles.flags & 4 <> 0  AND Roles.flags & 32=0
IF(@returnHiddenPermission=0)
BEGIN
	-- We do not even need to send associations for hidden permissions back to GUI. If needed they will send returnHiddenPermission = 1.
	DELETE Perm
	FROM #outputTable Perm INNER JOIN UMPermissions
			ON Perm.permissionId = UMPermissions.id
AND flags&2<>0
END
IF dbo.isExternalLocalGroupSingleList() = 0
BEGIN
	UPDATE #outputTable
SET entityTYpe1 = 62
WHERE entityType1 = 15 AND entityID1 IN (SELECT id FROM UMGroups WHERE umdsProviderId <> 0)
END
--remove 2nd insert of permissionid once we have migrated all calls to categoryPermission
INSERT INTO #outputTable (categoryPermissionXML, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll, isCreator)
	SELECT (
			SELECT( SELECT Perm.permissionid AS '@permissionId',
					UMPermissions.permissionName AS '@permissionName',
					UMPermissions.categoryId as '@categoryId',
122 AS '@_type_'
			 FROM #outputTable Perm INNER JOIN UMPermissions
			 ON Perm.permissionId = UMPermissions.id and UMPermissions.id<>0
			 WHERE Perm.entityType1 = Entity.entityType1 AND Perm.entityID1 = Entity.entityId1
				  AND Perm.entityType2 = Entity.entityType2 AND Perm.entityID2 = Entity.entityId2
				  AND Perm.entityType3 = Entity.entityType3 AND Perm.entityID3 = Entity.entityId3
				  AND perm.entityType4 = Entity.entityType4 AND Perm.entityID4 = Entity.entityId4
				  AND Perm.entityType5 = Entity.entityType5 AND Perm.entityID5 = Entity.entityId5
				  AND Perm.permissionId <> 0 AND Perm.isCreator = Entity.isCreator
			 FOR XML PATH ('categoriesPermissionList'),TYPE)
			FOR XML PATH('categoryPermission')),
			 Entity.entityType1,
			 Entity.entityId1,
			 Entity.entityType2,
			 Entity.entityId2,
			 Entity.entityType3,
			 Entity.entityID3,
			 Entity.entityTYpe4,
			 Entity.entityId4,
			 Entity.entityType5,
			 Entity.entityId5,
			 Entity.includeAll,
			 Entity.isCreator
	FROM (SELECT DISTINCT entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeALl, isCreator FROM #outputTable WHERE roleId =0) Entity
	DELETE					-- We do not want individual permissions. They come under categoryPermissionsList
	FROM #outputTable
	WHERE
		permissionId <> 0
IF EXISTS(SELECT 1 FROM    #outputTable JOIN UMRoles R ON R.id=roleId and R.flags& 32<>0)
	BEGIN
		DECLARE @customRoleXmlIn XML = (SELECT 20 AS '@listPropertyLevel',
										 (SELECT roleId AS '@roleId'
FROM #outputTable JOIN UMRoles R ON R.id=roleId and R.flags& 32<>0
										  FOR XML PATH ('roleEntity'),TYPE)
									FOR XML PATH('Security_GetRolesPropertiesRequest'))
 			EXEC sec_getRoleDetailList @customRoleXmlIn OUTPUT, 1, 0
			UPDATE TBL
			SET categoryPermissionXML = CAST(roleXML as nvarchar(max)),roleId=0
			FROM #outputTable Tbl JOIN ( SELECT R.value('(role/@roleId)[1]','INT') as roleId,R.query('categoryPermission') as roleXML
										 FROM @customRoleXmlIn.nodes('Security_GetRolesPropertiesResponse/roleProperties') AS Input(R)  ) Role
								 ON Role.roleId=Tbl.roleId
	END
UPDATE Tbl
SET roleName = Role.name
FROM #outputTable Tbl INNER JOIN UMRoles Role
ON Tbl.roleId = Role.id
EXEC EntityIdToNameConverterDynamic '#outputTable', 'entity'
DECLARE @inheritedAssociation XML =''
IF(@getEffectivePermissions=1 OR @getEffectivePermissions=2)
	EXEC sec_getInheritedSecurityForUserOrGroup @callerId,@inheritedAssociation OUTPUT,@UMEntityType,@userORGroupId,@returnHiddenPermission
-- Modifying this XML frame response to suit for GAT. Earlier it used to bundle-up list of entities that have same role / custom role into one single record.
-- If one role was used for 2 clients, and 2 more clients got added, it ended up auditing 2 records removed and 4 added. (instead of just 2 got added).
-- So lets make this XML return simple by returning one record for each entity & role / custom role combination. No consumer code breaks as we are just splitting
-- multiple records into individual ones. Java GUI, Admin console continue to work fine.
SET @xmlOut =
ISNULL(
			(SELECT
				(SELECT
	     			(SELECT
						RP.genericEntityAssociated.query('.')
					FOR XML PATH ('entities'), TYPE),
					(SELECT
						CASE WHEN isCreator <> 0 THEN 1 ELSE 0 END AS '@isCreatorAssociation',
						CASE WHEN RP.roleId <> 0 THEN
								(SELECT RP.roleId AS '@roleId',
										RP.roleName AS '@roleName',
										120 AS '@_type_'
								FOR XML PATH ('role'), TYPE)
						ELSE
								(SELECT CAST(RP.categoryPermissionXML AS XML)
								FOR XML PATH (''), TYPE)
						END
					FOR XML PATH ('properties'), TYPE)
					FROM #outputTable RP
				FOR XML PATH ('associations'), TYPE),
				(SELECT @inheritedAssociation FOR XML PATH(''),TYPE)
			FOR XML PATH ('App_SecurityAssociationForUserOrGroupList')), '<App_SecurityAssociationForUserOrGroupList/>')
IF(@isReturn<>0)
	SELECT @xmlOut
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getSecurityForUserAndUserGroup')
	delete from GxQscripts where name = 'sec_getSecurityForUserAndUserGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getSecurityForUserAndUserGroup')
	delete from GXDBVersions where aliasname = 'sec_getSecurityForUserAndUserGroup'
GO

insert into GXDBVersions values(2, 'sec_getSecurityForUserAndUserGroup',  '00000000000000000000', 'sec_getSecurityForUserAndUserGroup', '00000000000000000000')
GO

