

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getSecurityForEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_getSecurityForEntity')
BEGIN
	print '>>> Drop Stored Procedure: sec_getSecurityForEntity <<<'
	drop procedure sec_getSecurityForEntity
END
IF EXISTS (select * from GxQscripts where name='sec_getSecurityForEntity')
	delete from GxQscripts where name = 'sec_getSecurityForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getSecurityForEntity')
	delete from GXDBVersions where aliasname = 'sec_getSecurityForEntity'
GO
print '... Creating Procedure: sec_getSecurityForEntity'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_getSecurityForEntity
  @userId INT,
  @xmlOut XML OUTPUT,
  @entityType1 INT,
  @entityId1 INT,
  @entityType2 INT = 0,
  @entityId2 INT = 0,
  @entityType3 INT = 0,
  @entityId3 INT = 0,
  @entityType4 INT = 0,
  @entityId4 INT = 0,
  @entityType5 INT = 0,
  @entityId5 INT = 0,
  @returnHiddenPermission INT =0,
  @getAssociationTypeFilter INT =39,
  @skipIdToNameConversion INT = 0
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
IF @entityId1 IS NULL
	RETURN
IF OBJECT_ID ('tempdb.dbo.#getSecurityForEntity_SecurityAssociations') IS NOT NULL
	DROP TABLE #getSecurityForEntity_SecurityAssociations
CREATE TABLE #getSecurityForEntity_SecurityAssociations
(
	roleId INT,
	permissionId INT,
	userId INT DEFAULT 0,
	userGroupId INT DEFAULT 0,
	isCreator INT
)
CREATE CLUSTERED INDEX getSecurityForEntity_SecurityAssociations_idx ON #getSecurityForEntity_SecurityAssociations (roleId)
DECLARE @outputTable TABLE
(
	roleId INT,
	roleName NVARCHAR(MAX),
	permissionsXML XML,
	userId INT DEFAULT 0,
	userName NVARCHAR(MAX),
	userGroupId INT DEFAULT 0,
	userGroupName NVARCHAR(MAX),
	externalGroupId INT DEFAULT 0,
	externalGroupName NVARCHAR(MAX),
	providerId INT,
	providerName NVARCHAR(MAX),
	isCreator INT
)
DECLARE @ownersTable TABLE
(
	userId INT DEFAULT 0,
	userName NVARCHAR(MAX),
	userGroupId INT DEFAULT 0,
	userGroupName NVARCHAR(MAX),
	externalGroupId INT DEFAULT 0,
	externalGroupName NVARCHAR(MAX),
	providerId INT,
	providerName NVARCHAR(MAX),
	flags INT
)
DECLARE @ownerPermissionParentTable TABLE
    (
        permissionId INT ,
        entityType INT,
        entityId INT,
        genericEntityXML XML DEFAULT  ''
    )
DECLARE @ownerPermissionsXML XML
-- Performance change to avoid re-computing the same user information if SP called in a CURSOR Loop with same userId
-- Well Known External Temp Table - #sec_getSecurityForEntity_usersAndGroupsVisible
DECLARE @isLocalUsersAndGroupsVisible		TINYINT = 0		-- identifies it as being created locally for later cleanup if 1
DECLARE @isPopulatedUsersAndGroupsVisible	INT = 0			-- identifies if table already contains data
IF OBJECT_ID ('tempdb.dbo.#sec_getSecurityForEntity_usersAndGroupsVisible') IS NULL
BEGIN
	-- Create Well Known External Temp Table for local use
	CREATE TABLE #sec_getSecurityForEntity_usersAndGroupsVisible  (
		userOrGroupId INT,
		isUser INT,
		PRIMARY KEY (isUser, userOrGroupId)
	)
	SET @isLocalUsersAndGroupsVisible = 1
END
ELSE
BEGIN
	-- Well Known External Temp Table exist, does it contain data?
	IF EXISTS (SELECT 1 FROM #sec_getSecurityForEntity_usersAndGroupsVisible)
	BEGIN
		SET @isPopulatedUsersAndGroupsVisible = 1
	END
END
DECLARE @isExtLclGrpSL INT = dbo.isExternalLocalGroupSingleList()
if(@getAssociationTypeFilter&1<>0 OR @getAssociationTypeFilter&2<>0)
BEGIN
	IF (@isPopulatedUsersAndGroupsVisible = 0)	-- could be a Well Known External Temp Table that was created empty and needs to be populated the first time thru
	BEGIN
		IF OBJECT_ID ('tempdb.dbo.#VisibleUsersAndUserGroups') IS NOT NULL
			DROP TABLE #VisibleUsersAndUserGroups
		CREATE TABLE #VisibleUsersAndUserGroups (
			userOrGroupId INT
		)
		IF OBJECT_ID ('tempdb.dbo.#VisibleUsersAndUserGroups2') IS NOT NULL
			DROP TABLE #VisibleUsersAndUserGroups2
		CREATE TABLE #VisibleUsersAndUserGroups2 (
			userOrGroupId INT
		)
		EXEC sec_getUsersForThisUser '#VisibleUsersAndUserGroups', @userId
		EXEC sec_getUserGroupsForThisUser '#VisibleUsersAndUserGroups2', @userId, @includeAllTenantGroups = 1
		INSERT INTO #sec_getSecurityForEntity_usersAndGroupsVisible
			SELECT userOrGroupId, 0
			FROM #VisibleUsersAndUserGroups2
			UNION ALL
			SELECT userOrGroupId, 1
			FROM #VisibleUsersAndUserGroups
		DROP TABLE #VisibleUsersAndUserGroups
		DROP TABLE #VisibleUsersAndUserGroups2
	END
END
IF(@getAssociationTypeFilter&1<>0)
BEGIN
	INSERT INTO #getSecurityForEntity_SecurityAssociations
		SELECT DISTINCT roleId, permissionId,
			   CASE WHEN Sec.isUser = 1 THEN Sec.userOrGroupId ELSE 0 END,
			   CASE WHEN Sec.isUser = 0 THEN Sec.userOrGroupId ELSE 0 END,
			   isCreator
		FROM UMSecurityAssociations Sec INNER JOIN #sec_getSecurityForEntity_usersAndGroupsVisible Tbl
		ON Sec.isUser = Tbl.isUser AND Sec.userOrGroupId = Tbl.userOrGroupId
		WHERE entityTYpe1 = @entityType1 AND entityId1 = @entityId1
			  AND entityTYpe2 = @entityType2 AND entityId2 = @entityId2
			  AND entityTYpe3 = @entityType3 AND entityId3 = @entityId3
			  AND entityTYpe4 = @entityType4 AND entityId4 = @entityId4
			  AND entityTYpe5 = @entityType5 AND entityId5 = @entityId5
	--We should not send role that are hidden back to GUI
	DELETE Tbl
	FROM #getSecurityForEntity_SecurityAssociations Tbl INNER JOIN UMROles Roles
	ON Tbl.roleId = Roles.id
WHERE (Tbl.roleId <> 0 AND Roles.flags & 4 <> 0 AND Roles.flags & 32=0)
OR Roles.flags&2048<>0
	INSERT INTO @outputTable (roleId, userId, userGroupId, isCreator)
		SELECT roleId, userId, userGroupId, isCreator
		FROM #getSecurityForEntity_SecurityAssociations
		WHERE roleId <> 0
IF EXISTS(SELECT 1 FROM   @outPutTable JOIN UMRoles R ON R.id=roleId and R.flags& 32<>0)
	BEGIN
		DECLARE @customRoleXmlIn XML = (SELECT 20 AS '@listPropertyLevel',
									 (SELECT roleId AS '@roleId'
FROM @outPutTable JOIN UMRoles R ON R.id=roleId and R.flags& 32<>0
									  FOR XML PATH ('roleEntity'),TYPE)
								FOR XML PATH('Security_GetRolesPropertiesRequest'))
 		EXEC sec_getRoleDetailList @customRoleXmlIn OUTPUT, 1, 0
		UPDATE TBL
		SET permissionsXML = roleXML,roleId=0
		FROM @outputTable Tbl JOIN ( SELECT R.value('(role/@roleId)[1]','INT') as roleId,R.query('categoryPermission') as roleXML
									 FROM @customRoleXmlIn.nodes('Security_GetRolesPropertiesResponse/roleProperties') AS Input(R)  ) Role
							 ON Role.roleId=Tbl.roleId
	END
	IF(@returnHiddenPermission=0)
	BEGIN
		UPDATE Perm
		SET Perm.permissionId=0
		FROM #getSecurityForEntity_SecurityAssociations Perm INNER JOIN UMPermissions
				ON Perm.permissionId = UMPermissions.id
AND flags&2<>0
	END
--We need to populate both categoryPermission (for new modified gui) and permissionList for application layer. We need to delete 2nd insert once all applciationlayer code is move to new xml
	INSERT INTO @outputTable (permissionsXML, userId, userGroupId, isCreator)
	SELECT (
			SELECT(SELECT Perm.permissionId AS '@permissionId',
				   UMPermissions.permissionName AS '@permissionName',
				   UMPermissions.categoryId AS '@categoryId',
122 AS '@_type_'
			FROM #getSecurityForEntity_SecurityAssociations Perm INNER JOIN UMPermissions
			ON Perm.permissionId = UMPermissions.id and UMPermissions.id<>0
			WHERE Perm.userId = UG.userId AND Perm.userGroupId = UG.userGroupId AND Perm.permissionId <> 0 AND UG.isCreator = Perm.isCreator
			FOR XML PATH ('categoriesPermissionList'),TYPE)
			FOR XML PATH('categoryPermission')),
			UG.userId,
			UG.userGroupId,
			UG.isCreator
    FROM (SELECT DISTINCT userId, userGroupId, isCreator FROM #getSecurityForEntity_SecurityAssociations WHERE roleId=0) UG
IF @isExtLclGrpSL = 0
	UPDATE Tbl
	SET userGroupId = CASE WHEN Groups.umdsproviderId <> 0 THEN 0 ELSE Groups.id END,
		externalGroupId = CASE WHEN Groups.umdsproviderId <> 0 THEN Groups.id ELSE 0 END,
		userGroupName = CASE WHEN Groups.umdsproviderId <> 0 THEN '' ELSE Groups.name END,
		externalGroupName = CASE WHEN Groups.umdsproviderId <> 0 THEN Groups.name ELSE '' END,
		providerId = Groups.umdsProviderId
	FROM @outputTable Tbl INNER JOIN UMGroups Groups
	ON Tbl.userGroupId = Groups.id
	WHERE Tbl.userGroupId <> 0
ELSE
	UPDATE Tbl
	SET userGroupId = Groups.id,
		userGroupName = CASE WHEN Groups.umdsproviderId = 0 THEN Groups.name ELSE Prov.domainName + '\' + Groups.name END,
		providerId = Groups.umdsProviderId
	FROM @outputTable Tbl INNER JOIN UMGroups Groups
	ON Tbl.userGroupId = Groups.id
	LEFT OUTER JOIN UMDSProviders Prov ON Groups.umdsProviderId = Prov.id
	WHERE Tbl.userGroupId <> 0
	UPDATE Tbl
	SET userName = Users.login,								--GUI needs the login name like 'commvault-nj\gbuilder', 'admin', etc
		providerId = Users.umDSproviderId
	FROM @outputTable Tbl INNER JOIN UMUsers Users
	ON Tbl.userId = Users.id
	WHERE Tbl.userId <> 0
	UPDATE Tbl
	SET providerName = Prov.domainName
	FROM @outputTable Tbl INNER JOIN UMDSProviders Prov
	ON Tbl.providerId = Prov.id
	WHERE Tbl.providerId <> 0
	UPDATE Tbl
	SET roleName = Roles.name
	FROM @outputTable Tbl INNER JOIN UMRoles Roles
	ON Tbl.roleId = Roles.id
	WHERE Tbl.roleId <> 0
	END
IF @entityType2 = 0				--we should not fetch the owner information for app type and below entities
BEGIN
IF(@getAssociationTypeFilter&2<>0)
	BEGIN
		INSERT INTO @ownersTable (userId, userGroupId, flags)
			SELECT CASE WHEN Sec.isUser = 1 THEN Sec.userOrGroupid ELSE 0 END,
				   CASE WHEN Sec.isUser = 0 THEN Sec.userOrGroupId ELSE 0 END,
				   Sec.flags
			FROM UMOwners Sec INNER JOIN #sec_getSecurityForEntity_usersAndGroupsVisible Tbl
			ON Sec.isUser = Tbl.isUser AND Sec.userOrGroupId = Tbl.userOrGroupId
			WHERE Sec.entityType = @entityType1 AND Sec.entityId = @entityId1
		IF @isExtLclGrpSL = 0
				UPDATE Tbl
				SET userGroupId = CASE WHEN Groups.umdsproviderId <> 0 THEN 0 ELSE Groups.id END,
					externalGroupId = CASE WHEN Groups.umdsproviderId <> 0 THEN Groups.id ELSE 0 END,
					userGroupName = CASE WHEN Groups.umdsproviderId <> 0 THEN '' ELSE Groups.name END,
					externalGroupName = CASE WHEN Groups.umdsproviderId <> 0 THEN Groups.name ELSE '' END,
					providerId = Groups.umdsProviderId
				FROM @ownersTable Tbl INNER JOIN UMGroups Groups
				ON Tbl.userGroupId = Groups.id
				WHERE Tbl.userGroupId <> 0
		ELSE
			UPDATE Tbl
			SET userGroupId = Groups.id,
				userGroupName = CASE WHEN Groups.umdsproviderId = 0 THEN Groups.name ELSE Prov.domainName + '\' + Groups.name END
			FROM @ownersTable Tbl INNER JOIN UMGroups Groups
			ON Tbl.userGroupId = Groups.id
			LEFT OUTER JOIN UMDSProviders Prov ON Groups.umdsProviderId = Prov.id
			WHERE Tbl.userGroupId <> 0
		UPDATE Tbl
		SET userName = Users.login,								--GUI needs the login name like 'commvault-nj\gbuilder', 'admin', etc
			providerId = Users.umDSproviderId
		FROM @ownersTable Tbl INNER JOIN UMUsers Users
		ON Tbl.userId = Users.id
		WHERE Tbl.userId <> 0
		UPDATE Tbl
		SET providerName = Prov.domainName
		FROM @ownersTable Tbl INNER JOIN UMDSProviders Prov
		ON Tbl.providerId = Prov.id
		WHERE Tbl.providerId <> 0
	END
IF(@getAssociationTypeFilter&4<>0)
	BEGIN
		DECLARE @ownerRoleId INT = ISNULL((SELECT roleId FROM UMOwnerROles WHERE entityType = @entityType1 AND entityID = @entityId1), 0)
		IF @ownerRoleId <> 0
		BEGIN
			DECLARE @xmlIn XML = (SELECT 20 AS '@listPropertyLevel',
										(SELECT @ownerROleId AS '@roleId'
										 FOR XML PATH ('roleEntity'), TYPE)
								 FOR XML PATH('Security_GetRolesPropertiesRequest'))
			EXEC sec_getRoleDetailList @xmlIn OUTPUT, 1, 0
			SET @ownerPermissionsXML = (SELECT @xmlIn.query('Security_GetRolesPropertiesResponse/roleProperties/categoryPermission'))
		END
	END
END
DECLARE @inheritedSecurityAssocitionXML XML =''
DECLARE @inheritedOwnerXMl XML =''
--dont return inhertied associations by default
IF(@entityType1<>1  OR @entityId1 <> 2) AND ((@getAssociationTypeFilter & 8<>0) OR  (@getAssociationTypeFilter & 32<>0))
	EXEC sec_getInheritedSecurityForEntity @userId,@inheritedSecurityAssocitionXML OUTPUT,@inheritedOwnerXMl OUTPUT,@entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5,0,@returnHiddenPermission,@getAssociationTypeFilter,@skipIdToNameConversion
IF @isExtLclGrpSL = 0
SET @xmlOut = (SELECT
						(SELECT
						   (SELECT CASE WHEN userId <> 0 THEN userId END AS '@userId',
								   CASE WHEN userGroupId <> 0 THEN userGroupId END AS '@userGroupId',
								   CASE WHEN externalGroupId <> 0 THEN externalGroupId END AS '@groupId',
								   CASE WHEN userId <> 0 THEN userName END AS '@userName',
								   CASE WHEN userGroupId <> 0 THEN userGroupName END AS '@userGroupName',
								   CASE WHEN externalGroupId <> 0 THEN externalGroupName END AS '@externalGroupName',
								   CASE WHEN providerId <> 0 THEN providerId END AS '@providerId',
								   CASE WHEN providerId <> 0 THEN providerName END AS '@providerDomainName',
CASE WHEN userId <> 0 THEN 13 WHEN userGroupId <> 0 THEN 15 ELSE 62 END AS '@_type_'
							FOR XML PATH ('userOrGroup'), TYPE),
							(SELECT CASE WHEN isCreator <> 0 THEN 1 ELSE 0 END AS '@isCreatorAssociation',
								CASE WHEN roleId <> 0 THEN
								(SELECT roleId AS '@roleId',
										roleName AS '@roleName',
120 AS '@_type_'
								FOR XML PATH ('role'), TYPE)
								ELSE
								(SELECT permissionsXML.query('.')
								FOR XML PATH (''), TYPE)
								END
							FOR XML PATH ('properties'), TYPE)
						FROM @outputTable
						FOR XML PATH ('associations'), TYPE),
						(SELECT
								(SELECT CASE WHEN userId <> 0 THEN userId END AS '@userId',
										   CASE WHEN userGroupId <> 0 THEN userGroupId END AS '@userGroupId',
										   CASE WHEN externalGroupId <> 0 THEN externalGroupId END AS '@groupId',
										   CASE WHEN userId <> 0 THEN userName END AS '@userName',
										   CASE WHEN userGroupId <> 0 THEN userGroupName END AS '@userGroupName',
										   CASE WHEN externalGroupId <> 0 THEN externalGroupName END AS '@externalGroupName',
										   CASE WHEN providerId <> 0 THEN providerId END AS '@providerId',
										   CASE WHEN providerId <> 0 THEN providerName END AS '@providerDomainName',
CASE WHEN userId <> 0 THEN 13 WHEN userGroupId <> 0 THEN 15 ELSE 62 END AS '@_type_'
							FROM @ownersTable
								WHERE flags & 1 <> 0
								FOR XML PATH('owners'), TYPE),
								(SELECT @ownerPermissionsXML.query('.')
								FOR XML PATH (''), TYPE),
								(SELECT @inheritedOwnerXMl.query('.')
								FOR XML PATH(''),TYPE),
								(SELECT flags AS '@flags',
CASE WHEN userId <> 0 THEN (SELECT userId AS '@userId', userName AS '@userName', 13 AS '@_type_' FOR XML PATH ('ownerUser'), TYPE) END,
CASE WHEN userGroupId <> 0 THEN (SELECT userGroupId AS '@userGroupId', userGroupName AS '@userGroupName', 15 AS '@_type_' FOR XML PATH ('ownerUserGroup'), TYPE) END,
CASE WHEN externalGroupId <> 0 THEN (SELECT externalGroupId AS '@userGroupId', providerName + '\' + externalGroupName AS '@userGroupName', 15 AS '@_type_' FOR XML PATH ('ownerUserGroup'), TYPE) END
								FROM @ownersTable
								FOR XML PATH('entityOwners'), TYPE)
							FOR XML PATH ('ownerAssociations'), TYPE),
							(SELECT @inheritedSecurityAssocitionXML.query('.')
							 FOR XML PATH(''),TYPE)
						FOR XML PATH (''))
ELSE
	SET @xmlOut = (SELECT
							(SELECT
							   (SELECT CASE WHEN userId <> 0 THEN userId END AS '@userId',
									   CASE WHEN userGroupId <> 0 THEN userGroupId END AS '@userGroupId',
									   CASE WHEN userId <> 0 THEN userName END AS '@userName',
									   CASE WHEN userGroupId <> 0 THEN userGroupName END AS '@userGroupName',
CASE WHEN userId <> 0 THEN 13 ELSE 15 END AS '@_type_'
								FOR XML PATH ('userOrGroup'), TYPE),
								(SELECT CASE WHEN isCreator <> 0 THEN 1 ELSE 0 END AS '@isCreatorAssociation',
									CASE WHEN roleId <> 0 THEN
									(SELECT roleId AS '@roleId',
											roleName AS '@roleName',
120 AS '@_type_'
									FOR XML PATH ('role'), TYPE)
									ELSE
									(SELECT permissionsXML.query('.')
									FOR XML PATH (''), TYPE)
									END
								FOR XML PATH ('properties'), TYPE)
							FROM @outputTable
							FOR XML PATH ('associations'), TYPE),
							(SELECT
									(SELECT CASE WHEN userId <> 0 THEN userId END AS '@userId',
											   CASE WHEN userGroupId <> 0 THEN userGroupId END AS '@userGroupId',
											   CASE WHEN userId <> 0 THEN userName END AS '@userName',
											   CASE WHEN userGroupId <> 0 THEN userGroupName END AS '@userGroupName',
											   CASE WHEN userId <> 0 THEN 13 ELSE 15 END AS '@_type_'
							FROM @ownersTable
							WHERE flags & 1 <> 0
							FOR XML PATH('owners'), TYPE),
							(SELECT @ownerPermissionsXML.query('.')
							FOR XML PATH (''), TYPE),
							(SELECT @inheritedOwnerXMl.query('.')
							FOR XML PATH(''),TYPE),
							(SELECT flags AS '@flags',
CASE WHEN userId <> 0 THEN (SELECT userId AS '@userId', userName AS '@userName', 13 AS '@_type_' FOR XML PATH ('ownerUser'), TYPE) END,
CASE WHEN userGroupId <> 0 THEN (SELECT userGroupId AS '@userGroupId', userGroupName AS '@userGroupName', 15 AS '@_type_' FOR XML PATH ('ownerUserGroup'), TYPE) END
							FROM @ownersTable
							FOR XML PATH('entityOwners'), TYPE)
						FOR XML PATH ('ownerAssociations'), TYPE),
						(SELECT @inheritedSecurityAssocitionXML.query('.')
						 FOR XML PATH(''),TYPE)
					FOR XML PATH (''))
	IF @xmlOut IS NULL
	BEGIN
		SET @xmlOut = ''
	END
IF (@isLocalUsersAndGroupsVisible > 0 AND OBJECT_ID ('tempdb.dbo.#sec_getSecurityForEntity_usersAndGroupsVisible') IS NOT NULL)
BEGIN
	-- Drop Well Known External Temp Table if created for local use
	DROP TABLE #sec_getSecurityForEntity_usersAndGroupsVisible
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getSecurityForEntity')
	delete from GxQscripts where name = 'sec_getSecurityForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getSecurityForEntity')
	delete from GXDBVersions where aliasname = 'sec_getSecurityForEntity'
GO

insert into GXDBVersions values(2, 'sec_getSecurityForEntity',  '00000000000000000000', 'sec_getSecurityForEntity', '00000000000000000000')
GO

