

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getSecurityAssociationsForMultiCommCell.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getSecurityAssociationsForMultiCommCell')
BEGIN
	print '>>> Drop Stored Procedure: sec_getSecurityAssociationsForMultiCommCell <<<'
	drop procedure sec_getSecurityAssociationsForMultiCommCell
END
IF EXISTS (select * from GxQscripts where name='sec_getSecurityAssociationsForMultiCommCell')
	delete from GxQscripts where name = 'sec_getSecurityAssociationsForMultiCommCell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getSecurityAssociationsForMultiCommCell')
	delete from GXDBVersions where aliasname = 'sec_getSecurityAssociationsForMultiCommCell'
GO
print '... Creating Procedure: sec_getSecurityAssociationsForMultiCommCell'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getSecurityAssociationsForMultiCommCell
  @inXML XML,
  @userId INT,
  @isCmdLine INT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--Output
  DECLARE @xmlOut XML 
DECLARE @serviceCommcellId INT = ISNULL((select R.ref.value('@entityId','integer') from @inXml.nodes('App_GetSecurityAssociationThreeWayRequest') R(ref)),0)
--get list of commcell on which user has rights on.
IF OBJECT_ID('tempdb.dbo.#getServiceCommcell') IS NOT NULL
    DROP TABLE #getServiceCommcell
CREATE TABLE #getServiceCommcell
(
    servieCommcellId INT
)
IF @serviceCommcellId <> 0
BEGIN
	DECLARE @canSee INT = 0
exec sec_checkPermissionOnEntity @userId,0,@canSee OUTPUT,194,@serviceCommcellId
	if @canSee = 1
	BEGIN
		INSERT INTO #getServiceCommcell Select @serviceCommcellId
	END
END
ELSE
BEGIN
EXEC sec_getNonIdaObjectsForThisUser @userId, 194,0,'#getServiceCommcell'
END
		IF OBJECT_ID ('tempdb.dbo.#VisibleUsersAndUserGroups') IS NOT NULL
			DROP TABLE #VisibleUsersAndUserGroups
		CREATE TABLE #VisibleUsersAndUserGroups (
			userOrGroupId INT
		)
		IF OBJECT_ID ('tempdb.dbo.#VisibleUsersAndUserGroups2') IS NOT NULL
			DROP TABLE #VisibleUsersAndUserGroups2
		CREATE TABLE #VisibleUsersAndUserGroups2 (
			userOrGroupId INT
		)
IF OBJECT_ID ('tempdb.dbo.#sec_getSecurityForMultiCommcell_usersAndGroupsVisible') IS  NOT NULL DROP TABLE #sec_getSecurityForMultiCommcell_usersAndGroupsVisible
BEGIN
	-- Create Well Known External Temp Table for local use
	CREATE TABLE #sec_getSecurityForMultiCommcell_usersAndGroupsVisible  (
		userOrGroupId INT,
		isUser INT,
		PRIMARY KEY (isUser, userOrGroupId)
	)
END
IF OBJECT_ID('tempdb.dbo.#VisibleProviders')  IS NOT NULL
                 DROP TABLE #VisibleProviders
             CREATE TABLE  #VisibleProviders  (
                 providerId  INT PRIMARY KEY
             )
		EXEC sec_getUsersForThisUser '#VisibleUsersAndUserGroups', @userId
		EXEC sec_getUserGroupsForThisUser '#VisibleUsersAndUserGroups2', @userId
		EXEC sec_getNameServersForThisUser '#VisibleProviders', @userId, 0 ,1
		INSERT INTO #sec_getSecurityForMultiCommcell_usersAndGroupsVisible
			SELECT userOrGroupId, 0
			FROM #VisibleUsersAndUserGroups2
			UNION ALL
			SELECT userOrGroupId, 1
			FROM #VisibleUsersAndUserGroups
			UNION ALL
			SELECT providerId ,2
			FROM #VisibleProviders
		DROP TABLE #VisibleUsersAndUserGroups
		DROP TABLE #VisibleUsersAndUserGroups2
DECLARE @outputTable TABLE
(
	roleId INT,
	roleName NVARCHAR(MAX),
	permissionsXML XML,
	userId INT DEFAULT 0,
	userName NVARCHAR(MAX),
	userGroupId INT DEFAULT 0,
	userGroupName NVARCHAR(MAX),
	externalGroupId INT DEFAULT 0,
	externalGroupName NVARCHAR(MAX),
	providerId INT,
	providerName NVARCHAR(MAX),
	associatedProviderId INT,
	associatedproviderName NVARCHAR(MAX),
	isCreator INT,
	includeAll INT,
	entityId INT,
	providerType INT,
	serviceCommcellName NVARCHAR(MAX)
)
INSERT INTO @outputTable(roleID,userID,userGRoupId,associatedProviderId,includeAll,entityId,isCreator)
SELECT  roleId,CASE WHEN SecurityAssoc.isUSer=1 THEN SecurityAssoc.userORGRoupId ELSE 0 END,CASE WHEN SecurityAssoc.isUSer=0 THEN SecurityAssoc.userORGRoupId ELSE 0 END,CASE WHEN SecurityAssoc.isUSer=2 THEN SecurityAssoc.userORGRoupId ELSE 0 END,includeALl,entityId1,isCreator
FROM   UMSEcurityAssociations SecurityAssoc  JOIN #sec_getSecurityForMultiCommcell_usersAndGroupsVisible umentity
		ON securityAssoc.userOrGroupId=umentity.userORGroupId and securityAssoc.isUSer=umEntity.isUSer
JOIN  #getServiceCommcell ON SecurityAssoc.entityType1=194 and (includeALl=1 or entityID1=servieCommcellId)
UPDATE Tbl
	SET userGroupId = Groups.id,
		userGroupName = CASE WHEN Groups.umdsproviderId = 0 THEN Groups.name ELSE Prov.domainName + '\' + Groups.name END,
		providerId = Groups.umdsProviderId
	FROM @outputTable Tbl INNER JOIN UMGroups Groups
	ON Tbl.userGroupId = Groups.id
	LEFT OUTER JOIN UMDSProviders Prov ON Groups.umdsProviderId = Prov.id
	WHERE Tbl.userGroupId <> 0
UPDATE Tbl
	SET userName = Users.login,								--GUI needs the login name like 'commvault-nj\gbuilder', 'admin', etc
		providerId = Users.umDSproviderId
	FROM @outputTable Tbl INNER JOIN UMUsers Users
	ON Tbl.userId = Users.id
	WHERE Tbl.userId <> 0
UPDATE Tbl
	SET providerName = Prov.domainName
	FROM @outputTable Tbl INNER JOIN UMDSProviders Prov
	ON Tbl.providerId = Prov.id
	WHERE Tbl.providerId <> 0
	UPDATE Tbl
	SET associatedproviderName = Prov.domainName,
	providerTYpe= serviceType
	FROM @outputTable Tbl INNER JOIN UMDSProviders Prov
	ON Tbl.associatedproviderId = Prov.id
	WHERE Tbl.associatedproviderId <> 0
	UPDATE Tbl
	SET roleName = Roles.name
	FROM @outputTable Tbl INNER JOIN UMRoles Roles
	ON Tbl.roleId = Roles.id
	WHERE Tbl.roleId <> 0
UPDATE TBL
Set serviceCommcellName=aliasName
FROM @outputTable TBL INNER JOIN APP_commcell on TBL.entityID=id where entityID<>0
--3. Frame the output XML
SET @xmlOut = (ISNULL(( SELECT providerType as '@providerType',serviceCommcellName as 'entity/@entityName' ,194 as 'entity/@entityType',entityId as'entity/@entityId',150 as'entity/@_type_',
						includeALl as 'entity/flags/@includeAll',
						roleName AS 'properties/role/@roleName',
120 AS 'properties/role/@_type_',
						roleId as 'properties/role/@roleId',
					 CASE WHEN userId <> 0 THEN userId END AS 'userOrGroup/@userId',
									   CASE WHEN userGroupId <> 0 THEN userGroupId END AS 'userOrGroup/@userGroupId',
									   CASE WHEN userId <> 0 THEN userName END AS 'userOrGroup/@userName',
									   CASE WHEN userGroupId <> 0 THEN userGroupName END AS 'userOrGroup/@userGroupName',
					CASE WHEN associatedproviderId<>0 THEN associatedproviderId  END AS 'userOrGroup/@providerId',
					CASE WHEN associatedproviderId<>0 THEN associatedproviderName  END AS 'userOrGroup/@providerDomainName',
CASE WHEN userId <> 0 THEN 13
ELSE CASE WHEN userGroupId<>0 THEN 15
ELSE CASE WHEN associatedProviderID<>0 THEN 61 END END END AS 'userOrGroup/@_type_'
						FROM @outputTable
					   FOR XML PATH('associations'), ROOT('App_GetSecurityAssociationThreeWayResponse')), '<App_GetSecurityAssociationThreeWayResponse/>'))
SELECT @xmlOut
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getSecurityAssociationsForMultiCommCell')
	delete from GxQscripts where name = 'sec_getSecurityAssociationsForMultiCommCell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getSecurityAssociationsForMultiCommCell')
	delete from GXDBVersions where aliasname = 'sec_getSecurityAssociationsForMultiCommCell'
GO

insert into GXDBVersions values(2, 'sec_getSecurityAssociationsForMultiCommCell',  '00000000000000000000', 'sec_getSecurityAssociationsForMultiCommCell', '00000000000000000000')
GO

