

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getSecurityAssociationsForItemBasedEntities.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getSecurityAssociationsForItemBasedEntities <<<'

IF EXISTS (select * from sysobjects where name='sec_getSecurityAssociationsForItemBasedEntities')
	drop procedure sec_getSecurityAssociationsForItemBasedEntities
IF EXISTS (select * from GxQscripts where name='sec_getSecurityAssociationsForItemBasedEntities')
	delete from GxQscripts where name = 'sec_getSecurityAssociationsForItemBasedEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getSecurityAssociationsForItemBasedEntities')
	delete from GXDBVersions where aliasname = 'sec_getSecurityAssociationsForItemBasedEntities'
GO
print '... Creating Procedure: sec_getSecurityAssociationsForItemBasedEntities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getSecurityAssociationsForItemBasedEntities
  @inXML XML,
  @userId INT,
  @isCmdLine INT
AS
/*DECLARE @inXML AS XML = '<App_GetSecurityAssociationListForEntityRequest>
							<entityAssociated _type_="7" clientId="2" applicationId="33" instanceId="1" backupsetId="6" subclientId="5"/>
						 </App_GetSecurityAssociationListForEntityRequest>'
DECLARE @userId AS INT */
--Output
  DECLARE @xmlOut XML 
DECLARE @entityType1 AS INT = 0
DECLARE @entityId1 AS INT = 0
DECLARE @entityType2 AS INT = 0
DECLARE @entityId2 AS INT = 0
DECLARE @entityType3 AS INT = 0
DECLARE @entityId3 AS INT = 0
DECLARE @entityType4 AS INT = 0
DECLARE @entityId4 AS INT = 0
DECLARE @entityType5 AS INT = 0
DECLARE @entityId5 AS INT = 0
DECLARE @entityAssociatedBlob AS XML
DECLARE @entityAssociatedModifiedBlob AS XML
DECLARE @outputTable TABLE(entityAssociated XML, securityAssociations XML)
DECLARE @returnHiddenPermission INT =0
DECLARE @getAssociationTypeFilter INT =0
SET @getAssociationTypeFilter = ISNULL((SELECT ref.value('@getAssociationTypeFilter','INT') AS getAssociationTypeFilter
										FROM @inXML.nodes('App_GetSecurityAssociationRequest') R (ref)),39)  -- ClassicSecurity(1)|Owners(4)|OwnerPermissions (21)|onwer inherited permissions
SET @returnHiddenPermission = ISNULL((SELECT ref.value('@processHiddenPermission', 'INT') AS returnHiddenPermission
						   FROM @inXML.nodes('App_GetSecurityAssociationRequest') R (ref)),0)
--1. Get the input entities
DECLARE @inputEntitiesTable TABLE (entityAssociatedBlob XML, entityAssociatedModifiedBlob XML)
INSERT INTO @inputEntitiesTable (entityAssociatedBlob)
	SELECT T.C.query('.')
	FROM @inXML.nodes('App_GetSecurityAssociationRequest/entityAssociated/entity') T(C)
UPDATE @inputEntitiesTable
SET entityAssociatedModifiedBlob = dbo.getEntityTypeHirearchyXMLFromGenericEntityXML(entityAssociatedBlob)
--2. For each entity get the security associations blob individually and populate the output table as entity - security associations
DECLARE inputEntitiesCursor CURSOR STATIC FOR
	SELECT entityAssociatedBlob, entityAssociatedModifiedBlob
	FROM @inputEntitiesTable
OPEN inputEntitiesCursor
FETCH NEXT FROM inputEntitiesCursor INTO @entityAssociatedBlob, @entityAssociatedModifiedBlob
WHILE @@FETCH_STATUS = 0
BEGIN
	DECLARE @securityAssociationsXML XML
	DECLARE @entityAssociatedXML XML
	SET @entityType1 = (SELECT ref.value('@entityType1', 'INT') AS entityType1
						   FROM @entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	SET @entityId1 = (SELECT ref.value('@entityId1', 'INT') AS entityId1
						   FROM @entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	SET	@entityType2 = (SELECT ref.value('@entityType2', 'INT') AS entityType2
						   FROM @entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	SET	@entityId2 = (SELECT ref.value('@entityId2', 'INT') AS entityId2
						   FROM @entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	SET	@entityType3 = (SELECT ref.value('@entityType3', 'INT') AS entityType3
						   FROM @entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	SET	@entityId3 = (SELECT ref.value('@entityId3', 'INT') AS entityId3
						   FROM @entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	SET	@entityType4 = (SELECT ref.value('@entityType4', 'INT') AS entityType4
						   FROM @entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	SET	@entityId4 = (SELECT ref.value('@entityId4', 'INT') AS entityId4
						   FROM @entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	SET	@entityType5 = (SELECT ref.value('@entityType5', 'INT') AS entityType5
						   FROM @entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	SET	@entityId5 = (SELECT ref.value('@entityId5', 'INT') AS entityId5
						   FROM @entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	EXEC dbo.sec_getSecurityForEntity @userId, @securityAssociationsXML OUTPUT, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5,@returnHiddenPermission,@getAssociationTypeFilter
	SET @entityAssociatedXML = dbo.getGenericXMLFromEntityType (@entityType1, @entityID1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5, 0, 0, 'entityAssociated')
	INSERT INTO @outputTable
		VALUES(@entityAssociatedXML, @securityAssociationsXML)
	FETCH NEXT FROM inputEntitiesCursor INTO @entityAssociatedBlob, @entityAssociatedModifiedBlob
END
CLOSE inputEntitiesCursor
DEALLOCATE inputEntitiesCursor
--3. Frame the output XML
SET @xmlOut = (ISNULL((SELECT
						(SELECT
							(SELECT entityAssociated.query('.')
							FOR XML PATH (''), TYPE),
							(SELECT securityAssociations.query('.') AS 'securityAssociations'
							FOR XML PATH (''), TYPE)
						FOR XML PATH ('securityAssociations'), TYPE)
						FROM @outputTable
					   FOR XML PATH(''), ROOT('App_GetSecurityAssociationResponse')), '<App_GetSecurityAssociationResponse/>'))
SELECT @xmlOut
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getSecurityAssociationsForItemBasedEntities')
	delete from GxQscripts where name = 'sec_getSecurityAssociationsForItemBasedEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getSecurityAssociationsForItemBasedEntities')
	delete from GXDBVersions where aliasname = 'sec_getSecurityAssociationsForItemBasedEntities'
GO

insert into GXDBVersions values(2, 'sec_getSecurityAssociationsForItemBasedEntities',  '00000000000000000000', 'sec_getSecurityAssociationsForItemBasedEntities', '00000000000000000000')
GO

