

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getSecureComplianceUsersAndGroupsList.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sec_getSecureComplianceUsersAndGroupsList()
--  | Description:  Gets list of Compliance Users and User Groups
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_getSecureComplianceUsersAndGroupsList.sp,v $ $Id: sec_getSecureComplianceUsersAndGroupsList.sp,v 1.5.62.5 2019/02/12 19:53:25 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getSecureComplianceUsersAndGroupsList')
BEGIN
	print '>>> Drop Stored Procedure: sec_getSecureComplianceUsersAndGroupsList <<<'
	drop procedure sec_getSecureComplianceUsersAndGroupsList
END
IF EXISTS (select * from GxQscripts where name='sec_getSecureComplianceUsersAndGroupsList')
	delete from GxQscripts where name = 'sec_getSecureComplianceUsersAndGroupsList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getSecureComplianceUsersAndGroupsList')
	delete from GXDBVersions where aliasname = 'sec_getSecureComplianceUsersAndGroupsList'
GO
print '... Creating Procedure: sec_getSecureComplianceUsersAndGroupsList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getSecureComplianceUsersAndGroupsList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
  DECLARE @o_xmlText XML
SET NOCOUNT ON
BEGIN
	DECLARE @userGuid			VARCHAR(36)
	DECLARE @userId 			INT = 0
	DECLARE @domainName			NVARCHAR(MAX)
	DECLARE @isCS			INT = 0
	DECLARE @providerId 		INT
	DECLARE @i_capability		INT = 25 -- Compliance Search capability Id
	DECLARE @entityType 		INT = 9509 -- Entity type for compliance user and group items
	DECLARE @o_errorCode		INT
	DECLARE @o_errorString		VARCHAR(MAX)
	DECLARE @viewCapabilityMask bigint = POWER( 2.0, ( 31 - 1 ) )
	DECLARE @tmpGroupTbl 		TABLE ([objectId] INT)
	DECLARE @delimPos			integer
	DECLARE	@delim				char
	SET @delim = ','
	SET @o_errorCode = 0
	SET @o_errorString = ''
	SET @userGuid = ISNULL(( SELECT ref.value('@userGuid', 'VARCHAR(36)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_GetAllUserAndGroupListReq/user') R ( ref ) ), '')
	SET @domainName = ISNULL(( SELECT ref.value('@domainName', 'NVARCHAR(MAX)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_GetAllUserAndGroupListReq/user/domain') R ( ref ) ), N'')
	SET @isCS = ISNULL(( SELECT ref.value('@isCS', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_GetAllUserAndGroupListReq/user/domain') R ( ref ) ),0)
	IF ( @userGUID IS NOT null  AND @userGUID <> N'' )
	BEGIN
		SET @userId = ISNULL(( SELECT id FROM UMUsers  WITH(NOLOCK) WHERE userGuid = @userGUID and enabled=1 ), 0)
		IF (@userId = 0)
		BEGIN
			SET @o_errorCode = -2
			SET @o_errorString = 'Could not find user ID for user GUID :' + @userGuid
			GOTO EXIT_ERROR
		END
	END
	ELSE
	BEGIN
		SET @o_errorCode = -1
		SET @o_errorString = 'User GUID not specified.'
		GOTO EXIT_ERROR
	END
	IF OBJECT_ID('tempdb.dbo.#usersAndGroupsList') IS NOT NULL
		DROP TABLE #usersAndGroupsList
	CREATE TABLE #usersAndGroupsList (userId INT, userGroupId INT, extGroupId INT)
	INSERT INTO #usersAndGroupsList
	EXEC sec_getUsersAndGroupsWithPermission @i_capability, 1
	-- If domain name is not empty, AD user is specified
	IF ( @domainName IS NOT null AND @domainName <> N'' AND @isCS = 0)
	BEGIN
		SET @providerId = ISNULL((select id from UMDSProviders  WITH(NOLOCK) where domainName = @domainName), 0)
		IF ( @providerId = 0)
		BEGIN
			SET @o_errorCode = -4
			SET @o_errorString = 'Domain name not found.'
			GOTO EXIT_ERROR
		END
	END
	IF(ISNULL(@providerId, 0) != 0)
	BEGIN
		INSERT INTO @tmpGroupTbl
		SELECT extGroupId
		FROM #usersAndGroupsList Sec JOIN UMUserGroup U WITH(NOLOCK) On Sec.extGroupId = U.groupId AND U.userID = @userID
	END
	INSERT INTO @tmpGroupTbl
	SELECT Sec.userGroupId
	FROM #usersAndGroupsList Sec JOIN UMUserGroup U  WITH(NOLOCK) On Sec.userGroupId = U.groupId AND U.userID = @userID
	IF OBJECT_ID('tempdb.dbo.#getSecureComplianceUsers') IS NOT NULL
		DROP TABLE #getSecureComplianceUsers
CREATE TABLE #getSecureComplianceUsers (userId INT, userGuid nvarchar(256), userName nvarchar(255), exclude INT )
	INSERT INTO #getSecureComplianceUsers
	SELECT id ,userGuid , login , 0
		 FROM UMUsers WITH(NOLOCK)
		 WHERE id in (
			SELECT DISTINCT userId AS Id FROM UMUserAndGroupEntityAssociation WITH(NOLOCK)
			WHERE entityType = @entityType AND userId <> 0 AND objectId in (
				SELECT objectId FROM @tmpGroupTbl
			)
		 )
	DECLARE @excludeUsers NVARCHAR(MAX)
	SET @excludeUsers = ( SELECT value FROM GXGlobalParam where name ='ExcludeMailboxFromComplianceSearch')
	IF ISNULL(@excludeUsers,'') <> ''
	BEGIN
		INSERT INTO #getSecureComplianceUsers  (userName, exclude)  SELECT Data, 1 from dbo.SplitString(@excludeUsers, ';')
	END
	IF OBJECT_ID('tempdb.dbo.#getSecureComplianceGroups') IS NOT NULL
		DROP TABLE #getSecureComplianceGroups
CREATE TABLE #getSecureComplianceGroups (groupId INT, providerId INT, groupName nvarchar(255), exclude INT)
	INSERT INTO #getSecureComplianceGroups
	 SELECT UG.id , umdsProviderId , UP.domainName + '\' + UG.name , 0
		 FROM UMDSgroups UG  WITH(NOLOCK) INNER JOIN UMDSProviders UP  WITH(NOLOCK) ON UG.umdsProviderId = UP.id
		 WHERE UG.id in (
			SELECT DISTINCT groupId AS Id FROM UMUserAndGroupEntityAssociation WITH(NOLOCK)
			WHERE entityType = @entityType AND groupId <> 0 AND objectId in (
				SELECT objectId FROM @tmpGroupTbl
			)
		 )
	SET @o_xmlText =
	(
	 SELECT
		(
		 SELECT userId '@userId', userGuid '@userGuid' , userName '@userName', @viewCapabilityMask '@capabilities', exclude '@exclude'
		 FROM #getSecureComplianceUsers
		 FOR XML PATH('userDetailsAndCapabilities'), TYPE
		 ),
		 (
		 SELECT groupId '@groupId', providerId '@providerId' , groupName '@groupName', @viewCapabilityMask '@capabilities', exclude '@exclude'
		 FROM #getSecureComplianceGroups
		 FOR XML PATH('externalGroupDetailsAndCapabilities'), TYPE
		 )
	 FOR XML PATH('shareUserAndGroupCapabilityList'), ROOT('DM2ContentIndexing_GetAllUserAndGroupListResp')
	)
	IF @o_xmlText IS NULL
	BEGIN
		SET @o_xmlText = N'<DM2ContentIndexing_GetAllUserAndGroupListResp/>'
	END
	SELECT @o_xmlText
EXIT_ERROR:
	IF OBJECT_ID('tempdb.dbo.#usersAndGroupsList') IS NOT NULL
	BEGIN
		DROP TABLE #usersAndGroupsList
	END
	IF @o_errorCode <> 0
	BEGIN
		SET @o_xmlText =
		(
		SELECT @o_errorCode '@errorCode', @o_errorString '@errLogMessage'
		FOR XML PATH('errlist'), ROOT('DM2ContentIndexing_GetAllUserAndGroupListResp')
		)
		SELECT @o_xmlText
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getSecureComplianceUsersAndGroupsList')
	delete from GxQscripts where name = 'sec_getSecureComplianceUsersAndGroupsList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getSecureComplianceUsersAndGroupsList')
	delete from GXDBVersions where aliasname = 'sec_getSecureComplianceUsersAndGroupsList'
GO

insert into GXDBVersions values(2, 'sec_getSecureComplianceUsersAndGroupsList',  '00010005006200050000', 'sec_getSecureComplianceUsersAndGroupsList', '00010005006200050000')
GO

