

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getRolePermissionDetail.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_getRolePermissionDetail.sp,v $ $Id: sec_getRolePermissionDetail.sp,v 1.1.2.1 2019/09/30 16:54:23 saggarwal Exp $";
--
--  +========================================================================+
--  | Stored Procedure: sec_getRolePermissionDetail
--  |
--  | Description:
--  |  Called for getting properties of a role , it will give expanded permissions of roles and basic properties.
--  |	properties
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Seema  Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getRolePermissionDetail')
BEGIN
	print '>>> Drop Stored Procedure: sec_getRolePermissionDetail <<<'
	drop procedure sec_getRolePermissionDetail
END
IF EXISTS (select * from GxQscripts where name='sec_getRolePermissionDetail')
	delete from GxQscripts where name = 'sec_getRolePermissionDetail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getRolePermissionDetail')
	delete from GXDBVersions where aliasname = 'sec_getRolePermissionDetail'
GO
print '... Creating Procedure: sec_getRolePermissionDetail'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getRolePermissionDetail
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML OUTPUT
AS
  DECLARE @oRolesXMLText XML 
DECLARE @allRoles INT=0
DECLARE @propertyLevel INT =0;
DECLARE @roleTbl TABLE (roleId integer, roleName nvarchar(max), associationsXML XML, securityAssociationsXML XML)
DECLARE @errorXML XML
DECLARE @callerId INT
DECLARE @localeId INT
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = N''
SET @propertyLevel =(ISNULL((SELECT @i_xmlText.value('(/Security_GetRolesPropertiesRequest/@listPropertyLevel)[1]','int')),1))
SET @localeId = ISNULL((SELECT @i_xmlText.value('(/Security_GetRolesPropertiesRequest/processinginstructioninfo/locale/@localeId)[1]', 'int')), 0)
--If roleId is populate validate that role id is valid
DECLARE @roleId int=0
SET @roleId = ISNULL((SELECT @i_xmlText.value('(/Security_GetRolesPropertiesRequest/roleEntity/@roleId)[1]', 'int')), 0)
IF(@roleId > 0)
BEGIN
	IF NOT EXISTS(SELECT 1 FROM UMROLES WHERE id = @roleId)
	BEGIN
SET @errorCode = (3760 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3760 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @oRolesXMLText = (SELECT
									(SELECT
										(SELECT @errorCode as '@errorCode',
												@errorString as '@errorString'
										FOR XML PATH ('response'), TYPE)
									FOR XML PATH ('errorResponse'), TYPE)
								FOR XML PATH (''), ROOT('Security_GetRolesPropertiesResponse')
							)
	GOTO END_PROCESSING
END
END
DECLARE @securityOnRolesEnabled INT = 0
	--If security on roles is enabled, to view role list or role detail user should have visibility rights on role
	--Getting list of roles visible to caller.
	SET @securityOnRolesEnabled = 1
	if object_id('tempdb.dbo.#roleList') is not null
	BEGIN
		DROP TABLE #roleList
	END
	IF(1<> @i_xmlText.exist('//Security_GetRolesPropertiesRequest/roleEntity'))
	BEGIN
		INSERT INTO @roleTbl(roleId, roleName)
		SELECT id, name
		FROM UMRoles Tbl
	END
	ELSE
	BEGIN
		INSERT INTO @roleTbl(roleId, roleName)
		SELECT ISNULL(ref.value('@roleId','int'), 0),
			   ISNULL(ref.value('@roleName','nvarchar(max)'), N'')
		FROM @i_xmlText.nodes('(Security_GetRolesPropertiesRequest/roleEntity)')R (ref)
		UPDATE @roleTbl set roleId = UR.id from @roleTbl JOIN UMRoles UR on UR.name = roleName where roleId = 0
	END
--When this SP is called immediately after creating a role for audit purposes,
--the role Id wont be filled in input XML. So get it from name
UPDATE Tbl
SET Tbl.roleId = R.id
FROM @roleTbl Tbl INNER JOIN UMRoles R
ON Tbl.roleName = R.name
WHERE Tbl.roleId = 0
IF @propertyLevel =1   --List Only
BEGIN
SET @oRolesXMLText =	(SELECT
							(SELECT
								(SELECT id as '@roleId',
									   name as '@roleName',
									   disabled as 'flags/@disabled'
								FOR XML PATH ('role'), TYPE)
							FROM UMRoles  R JOIN @roleTbl  ON R.id= roleId
							FOR XML PATH ('roleProperties'), TYPE)
						FOR XML PATH ('Security_GetRolesPropertiesResponse'))
END
ELSE IF @propertyLevel =10   --BasicProp Only
BEGIN
SET @oRolesXMLText =	(SELECT(SELECT(SELECT description as '@description',
						isPrivate^1 as '@visibility',
					(	SELECT id as '@roleId',
								name AS '@roleName',
								disabled AS 'flags/@disabled'
						FOR	XML PATH('role'),TYPE
					)
				FROM UMRoles  R join @roleTbl  ON R.id= roleId
				FOR XML PATH('roleProperties'),TYPE),
				@errorXML
				FOR XML PATH(''),TYPE)
				FOR XML PATH('Security_GetRolesPropertiesResponse'))
END
ELSE IF(@propertyLevel=20)
BEGIN
	SET @oRolesXMLText =(SELECT(SELECT(	SELECT
								description as '@description',
								isPrivate^1 as '@visibility',
								(SELECT	id as '@roleId' ,
										UMRoles.name as '@roleName',
										disabled AS 'flags/@disabled'
									FOR XML PATH ('role'),TYPE
								),
								(SELECT
									(	SELECT
												categoryId as '@categoryId',
												permissionId as '@permissionId'
										FROM UMRolesWithPermissionsExpanded WITH (NOLOCK)
										WHERE UMRolesWithPermissionsExpanded.roleId=UMRoles.id
										FOR XML PATH ('categoriesPermissionList'), TYPE
									)
								FOR XML PATH('categoryPermission'),TYPE),
								(SELECT associationsXML.query('.') FOR XML PATH(''), TYPE)
						FROM UMRoles WITH (NOLOCK)
INNER JOIN @roleTbl ON UMRoles.id= roleId
						FOR XML PATH('roleProperties'),TYPE),
						@errorXML
						FOR XML PATH(''),TYPE)
					FOR XML PATH(''), ROOT('Security_GetRolesPropertiesResponse')
				)
END
ELSE
	SET @oRolesXMLText = '<Security_GetRolesPropertiesResponse/>'
END_PROCESSING:
if object_id('tempdb.dbo.#roleList') is not null
BEGIN
	DROP TABLE #roleList
END
SET @i_xmlText = @oRolesXMLText
	SELECT @oRolesXMLText as 'oRolesXMLText'
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getRolePermissionDetail')
	delete from GxQscripts where name = 'sec_getRolePermissionDetail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getRolePermissionDetail')
	delete from GXDBVersions where aliasname = 'sec_getRolePermissionDetail'
GO

insert into GXDBVersions values(2, 'sec_getRolePermissionDetail',  '00010001000200010000', 'sec_getRolePermissionDetail', '00010001000200010000')
GO

