

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getRoleDetailList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_getRoleDetailList.sp,v $ $Id: sec_getRoleDetailList.sp,v 1.6.14.13 2020/09/10 04:25:18 jswaminathan Exp $";
--
--  +========================================================================+
--  | Stored Procedure: sec_getRoleDetailList
--  |
--  | Description:
--  |  Called for getting properties of a role - can be list, basic or all
--  |	properties
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Jagadeesh & Seema  Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getRoleDetailList')
BEGIN
	print '>>> Drop Stored Procedure: sec_getRoleDetailList <<<'
	drop procedure sec_getRoleDetailList
END
IF EXISTS (select * from GxQscripts where name='sec_getRoleDetailList')
	delete from GxQscripts where name = 'sec_getRoleDetailList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getRoleDetailList')
	delete from GXDBVersions where aliasname = 'sec_getRoleDetailList'
GO
print '... Creating Procedure: sec_getRoleDetailList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getRoleDetailList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML OUTPUT,
  @includeHiddenRoles INT = 0,
  @returnCursor INT = 0
AS
  DECLARE @oRolesXMLText XML 
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @allRoles INT=0
DECLARE @propertyLevel INT =0;
DECLARE @roleTbl TABLE (roleId integer, roleName nvarchar(max), associationsXML XML, securityAssociationsXML XML)
DECLARE @errorXML XML
DECLARE @callerId INT
DECLARE @localeId INT
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = N''
SET @propertyLevel =(ISNULL((SELECT @i_xmlText.value('(/Security_GetRolesPropertiesRequest/@listPropertyLevel)[1]','int')),1))
SET @callerId = ISNULL((SELECT @i_xmlText.value('(/Security_GetRolesPropertiesRequest/processinginstructioninfo/user/@userId)[1]', 'int')), 1)
SET @localeId = ISNULL((SELECT @i_xmlText.value('(/Security_GetRolesPropertiesRequest/processinginstructioninfo/locale/@localeId)[1]', 'int')), 0)
--If roleId is populate validate that role id is valid
DECLARE @roleId int=0
SET @roleId = ISNULL((SELECT @i_xmlText.value('(/Security_GetRolesPropertiesRequest/roleEntity/@roleId)[1]', 'int')), 0)
IF(@roleId > 0)
BEGIN
	IF NOT EXISTS(SELECT 1 FROM UMROLES WHERE id = @roleId)
	BEGIN
SET @errorCode = (3760 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3760 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @oRolesXMLText = (SELECT
									(SELECT
										(SELECT @errorCode as '@errorCode',
												@errorString as '@errorString'
										FOR XML PATH ('response'), TYPE)
									FOR XML PATH ('errorResponse'), TYPE)
								FOR XML PATH (''), ROOT('Security_GetRolesPropertiesResponse')
							)
	GOTO END_PROCESSING
END
END
DECLARE @securityOnRolesEnabled INT = 0
DECLARE @skipPublicRoles INT = 0
-- For the impersonation user Ids that we use to get the Company owned entities, we should not return public (Commcell) roles.
SELECT @skipPublicRoles = 1 FROM UMUsers (NOLOCK) WHERE ((id = @callerID) AND ((flags & 0x20000) <> 0))
IF @skipPublicRoles IS NULL
	SET @skipPublicRoles = 0
	--If security on roles is enabled, to view role list or role detail user should have visibility rights on role
	--Getting list of roles visible to caller.
	SET @securityOnRolesEnabled = 1
	if object_id('tempdb.dbo.#roleList') is not null
	BEGIN
		DROP TABLE #roleList
	END
	CREATE TABLE #roleList (roleId integer NOT NULL)
EXEC sec_getNonIdaObjectsForThisUser @callerId, 120, 0, '#roleList'
	IF(1<> @i_xmlText.exist('//Security_GetRolesPropertiesRequest/roleEntity'))
	BEGIN
		INSERT INTO @roleTbl(roleId, roleName)
		SELECT id, name
		FROM UMRoles Tbl
		INNER JOIN #roleList List
ON Tbl.id = List.roleId and (@includeHiddenRoles = 1 OR flags & 4=0)
		UNION
		SELECT id,name
		FROM UMRoles
		WHERE (isPrivate = 0 AND @skipPublicRoles = 0)
AND (@includeHiddenRoles = 1 OR flags & 4=0)
	END
	ELSE
	BEGIN
		INSERT INTO @roleTbl(roleId, roleName)
		SELECT ISNULL(ref.value('@roleId','int'), 0),
			   ISNULL(ref.value('@roleName','nvarchar(max)'), N'')
		FROM @i_xmlText.nodes('(Security_GetRolesPropertiesRequest/roleEntity)')R (ref)
		UPDATE @roleTbl set roleId = UR.id from @roleTbl JOIN UMRoles UR on UR.name = roleName where roleId = 0
		--If user do not have visibility rights on any role sent in xml, throw error
		IF EXISTS (SELECT 1 FROM @roleTbl JOIN UMRoles on id = roleId
					WHERE roleId NOT IN (SELECT roleId FROM #roleList)
							AND isPrivate=1)
		BEGIN
SET @errorCode = (2829 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2829 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
			SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WHERE id = @callerId),''))
SET @errorString = REPLACE(@errorString, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (3075 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId))
			SET @oRolesXMLText = (SELECT
									(SELECT
										(SELECT @errorCode as '@errorCode',
												@errorString as '@errorString',
												(SELECT roleId as '@roleId',
														roleName as '@roleName'
												FOR XML PATH ('entity'), TYPE)
										FROM @roleTbl WHERE roleId NOT IN (SELECT roleId FROM #roleList)
										FOR XML PATH ('response'), TYPE)
									FOR XML PATH ('errorResponse'), TYPE)
								FOR XML PATH (''), ROOT('Security_GetRolesPropertiesResponse')
							)
			GOTO END_PROCESSING
		END
	END
--ADD SECURITY CHECK HERE and ERROR MESSAGE IF PARTIAL RIGHTS ARE THERE. and Visibility etc. Delete from table
--Populate @eeror_tbl and merge it below
--SET @errorXML = '<errorResponse>
--                     <response errorCode="1" errorString="Security Fail">
--						<entity roleId="4" roleName="Test"/>
--					</response>
--					<response errorCode="1" errorString="Security Fail">
--						<entity roleId="5" roleName="Test1"/>
--					</response>
--				</errorResponse>'
--When this SP is called immediately after creating a role for audit purposes,
--the role Id wont be filled in input XML. So get it from name
UPDATE Tbl
SET Tbl.roleId = R.id
FROM @roleTbl Tbl INNER JOIN UMRoles R
ON Tbl.roleName = R.name
WHERE Tbl.roleId = 0
DECLARE @flags INT = 0
SET @flags = (ISNULL((SELECT @i_xmlText.value('(/Security_GetRolesPropertiesRequest/@flags)[1]','int')),0))
IF @flags & (1) <> 0			--get the individual role associations for all these roles
BEGIN
	DECLARE @tempRoleID INT
	DECLARE roleAssociationsCursor CURSOR FOR
		SELECT DISTINCT roleID FROM @roleTbl
	OPEN roleAssociationsCursor
	FETCH NEXT FROM roleAssociationsCursor INTO @tempRoleID
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DECLARE @roleAssociationsXML XML
		EXEC sec_getRoleAssociations @tempRoleID, @callerID, @roleAssociationsXML OUTPUT
		UPDATE @roleTbl
		SET associationsXML = @roleAssociationsXML
		WHERE roleID = @tempRoleID
		FETCH NEXT FROM roleAssociationsCursor INTO @tempRoleID
	END
	CLOSE roleAssociationsCursor
	DEALLOCATE roleAssociationsCursor
END
IF @propertyLevel =1   --List Only
BEGIN
SET @oRolesXMLText =	(SELECT
							(SELECT
								(SELECT id as '@roleId',
									   name as '@roleName',
									   disabled as 'flags/@disabled'
								FOR XML PATH ('role'), TYPE)
							FROM UMRoles  R JOIN @roleTbl  ON R.id= roleId
WHERE (@includeHiddenRoles = 1 OR flags & 4 = 0)
							FOR XML PATH ('roleProperties'), TYPE)
						FOR XML PATH ('Security_GetRolesPropertiesResponse'))
END
ELSE IF @propertyLevel =10   --BasicProp Only
BEGIN
SET @oRolesXMLText =	(SELECT(SELECT(SELECT description as '@description',
						isPrivate^1 as '@visibility',
					(	SELECT id as '@roleId',
								name AS '@roleName',
								disabled AS 'flags/@disabled'
						FOR	XML PATH('role'),TYPE
					)
				FROM UMRoles  R join @roleTbl  ON R.id= roleId
WHERE (@includeHiddenRoles = 1 OR flags & 4=0)
				FOR XML PATH('roleProperties'),TYPE),
				@errorXML
				FOR XML PATH(''),TYPE)
				FOR XML PATH('Security_GetRolesPropertiesResponse'))
END
ELSE IF(@propertyLevel=20)
BEGIN
	SET @oRolesXMLText =(SELECT(SELECT(	SELECT
								description as '@description',
								isPrivate^1 as '@visibility',
								(SELECT	id as '@roleId' ,
										UMRoles.name as '@roleName',
										disabled AS 'flags/@disabled'
									FOR XML PATH ('role'),TYPE
								),
								(SELECT
									(	SELECT UMRolesPermissions.hierarchyLevel as  '@_type_',
												UMcategories.id as '@categoryId',
												UMPermissions.id as '@permissionId',
												CASE WHEN Ecategories.messageId > 0 THEN ECategories.Message ELSE UMCategories.categoryName END as '@categoryName',
												CASE WHEN EPermissions.messageId > 0 THEN EPermissions.Message ELSE UMPermissions.permissionName END as '@permissionName',
												'flags/@exclude' =
												CASE
WHEN UMRolesPermissions.hierarchyLevel=122 AND excludePermission<>0 THEN excludePermission
WHEN UMRolesPermissions.hierarchyLevel=121 AND excludeCategory<>0 THEN excludeCategory
												END
										FROM UMRolesPermissions WITH (NOLOCK)
										LEFT OUTER JOIN UMCategories WITH (NOLOCK) ON UMRolesPermissions.categoryId = UMCategories.id AND UMRolesPermissions.categoryId <> 0
										LEFT OUTER JOIN UMPermissions WITH (NOLOCK) ON UMRolesPermissions.permissionId = UMPermissions.id AND UMRolesPermissions.permissionId <> 0
										LEFT OUTER JOIN EvLocaleMsgs ECategories WITH (NOLOCK) ON UMRolesPermissions.categoryID <> 0 AND UMCategories.messageId = ECategories.messageId AND ECategories.localeId = @localeId
										LEFT OUTER JOIN EvLocaleMsgs EPermissions WITH (NOLOCK) ON UMRolesPermissions.permissionId <> 0 AND UMPermissions.messageId = EPermissions.messageId AND EPermissions.localeId = @localeId
										WHERE UMRolesPermissions.roleId=UMRoles.id
										FOR XML PATH ('categoriesPermissionList'), TYPE
									)
								FOR XML PATH('categoryPermission'),TYPE),
								(SELECT associationsXML.query('.') FOR XML PATH(''), TYPE)
						FROM UMRoles WITH (NOLOCK)
INNER JOIN @roleTbl ON UMRoles.id= roleId and (@includeHiddenRoles = 1 OR flags & 4=0)
						FOR XML PATH('roleProperties'),TYPE),
						@errorXML
						FOR XML PATH(''),TYPE)
					FOR XML PATH(''), ROOT('Security_GetRolesPropertiesResponse')
				)
END
ELSE IF(@propertyLevel>=30)
BEGIN
	IF (@securityOnRolesEnabled = 1)
	BEGIN
		DECLARE @currentRoleId INT
		DECLARE roleSecurityCursor CURSOR FOR
			SELECT DISTINCT roleID FROM @roleTbl
		OPEN roleSecurityCursor
		FETCH NEXT FROM roleSecurityCursor INTO @currentRoleId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			DECLARE @roleSecurityAssociationsXML XML
EXEC sec_getSecurityForEntity @callerId, @roleSecurityAssociationsXML OUTPUT, 120, @currentRoleId
			UPDATE @roleTbl
			SET securityAssociationsXML = @roleSecurityAssociationsXML
			WHERE roleID = @currentRoleId
			FETCH NEXT FROM roleSecurityCursor INTO @currentRoleId
		END
		CLOSE roleSecurityCursor
		DEALLOCATE roleSecurityCursor
	END
	SET @oRolesXMLText =(SELECT(SELECT(	SELECT
								description as '@description',
								isPrivate^1 as '@visibility',
								(SELECT	id as '@roleId' ,
										UMRoles.name as '@roleName',
										disabled AS 'flags/@disabled'
									FOR XML PATH ('role'),TYPE
								),
								(SELECT
									(	SELECT UMRolesPermissions.hierarchyLevel as  '@_type_',
												UMcategories.id as '@categoryId',
												UMPermissions.id as '@permissionId',
												CASE WHEN Ecategories.messageId > 0 THEN ECategories.Message ELSE UMCategories.categoryName END as '@categoryName',
												CASE WHEN EPermissions.messageId > 0 THEN EPermissions.Message ELSE UMPermissions.permissionName END as '@permissionName',
												'flags/@exclude' =
												CASE
WHEN UMRolesPermissions.hierarchyLevel=122 AND excludePermission<>0 THEN excludePermission
WHEN UMRolesPermissions.hierarchyLevel=121 AND excludeCategory<>0 THEN excludeCategory
												END
										FROM UMRolesPermissions WITH (NOLOCK)
										LEFT OUTER JOIN UMCategories WITH (NOLOCK) ON UMRolesPermissions.categoryId = UMCategories.id AND UMRolesPermissions.categoryId <> 0
										LEFT OUTER JOIN UMPermissions WITH (NOLOCK) ON UMRolesPermissions.permissionId = UMPermissions.id AND UMRolesPermissions.permissionId <> 0
										LEFT OUTER JOIN EvLocaleMsgs ECategories WITH (NOLOCK) ON UMRolesPermissions.categoryID <> 0 AND UMCategories.messageId = ECategories.messageId AND ECategories.localeId = @localeId
										LEFT OUTER JOIN EvLocaleMsgs EPermissions WITH (NOLOCK) ON UMRolesPermissions.permissionId <> 0 AND UMPermissions.messageId = EPermissions.messageId AND EPermissions.localeId = @localeId
										WHERE UMRolesPermissions.roleId=UMRoles.id
										FOR XML PATH ('categoriesPermissionList'), TYPE
									)
								FOR XML PATH('categoryPermission'),TYPE),
								(SELECT associationsXML.query('.') FOR XML PATH(''), TYPE),
								(SELECT securityAssociationsXML AS 'securityAssociations' FOR XML PATH(''), TYPE)
						FROM UMRoles WITH (NOLOCK)
INNER JOIN @roleTbl ON UMRoles.id= roleId and (@includeHiddenRoles = 1 OR flags & 4=0)
						FOR XML PATH('roleProperties'),TYPE),
						@errorXML
						FOR XML PATH(''),TYPE)
					FOR XML PATH(''), ROOT('Security_GetRolesPropertiesResponse')
				)
END
ELSE
	SET @oRolesXMLText = '<Security_GetRolesPropertiesResponse/>'
END_PROCESSING:
if object_id('tempdb.dbo.#roleList') is not null
BEGIN
	DROP TABLE #roleList
END
SET @i_xmlText = @oRolesXMLText
IF(@returnCursor<>0)
	SELECT @oRolesXMLText
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getRoleDetailList')
	delete from GxQscripts where name = 'sec_getRoleDetailList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getRoleDetailList')
	delete from GXDBVersions where aliasname = 'sec_getRoleDetailList'
GO

insert into GXDBVersions values(2, 'sec_getRoleDetailList',  '00010006001400130000', 'sec_getRoleDetailList', '00010006001400130000')
GO

