

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getRoleAssociations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +====================================================================================================+
--  | Stored Precedure: sec_getRoleAssociations()
--  |
--  | For a given roleId, this stored procedure fetches the list of user/user group - entities that are
--  | associated to it.
--  |
--	| It does security filtering of entities and user/user group for the given caller id.
--	|
--	|
--	| Authors: jswaminathan & saggarwal
--  +====================================================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getRoleAssociations <<<'

IF EXISTS (select * from sysobjects where name='sec_getRoleAssociations')
	drop procedure sec_getRoleAssociations
IF EXISTS (select * from GxQscripts where name='sec_getRoleAssociations')
	delete from GxQscripts where name = 'sec_getRoleAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getRoleAssociations')
	delete from GXDBVersions where aliasname = 'sec_getRoleAssociations'
GO
print '... Creating Procedure: sec_getRoleAssociations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getRoleAssociations
  @roleId int, 
  @callerId int,
  @outputXML xml output,
  @isReturnCursor int = 0 
AS
--inputs
--declare @roleID int = 6
--declare @callerID int = 17
--list of users and groups visible to this caller
if object_id('tempdb.dbo.#userAndGroupsVisible') is not null
	drop table #userAndGroupsVisible
create table #userAndGroupsVisible  (userOrGroupId int, isUser int)
if object_id('tempdb.dbo.#usersVisible') is not null
	drop table #usersVisible
create table #usersVisible (userId int)
exec sec_getUsersForThisUser '#usersVisible', @callerId
insert into #userAndGroupsVisible
	select userId, 1
	from #usersVisible
if object_id('tempdb.dbo.#userGroupsVisible') is not null
	drop table #userGroupsVisible
create table #userGroupsVisible (userGroupId int)
exec sec_getUserGroupsForThisUser '#userGroupsVisible', @callerId
insert into #userAndGroupsVisible
	select userGroupId, 0
	from #userGroupsVisible
if object_id('tempdb.dbo.#entityAssociated') is not null
	drop table #entityAssociated
create table #entityAssociated (userId int, userName nvarchar(max), userGroupId int, userGroupName nvarchar(max), entityType1 int, entityId1 int, entityType2 int, entityId2 int, entityType3 int, entityId3 int, entityType4 int, entityId4 int, entityType5 int, entityId5 int, includeAll int, genericEntityAssociated xml)
--list of entity types this role is associated to. Better to call sec_get*Objects for these entity types than checking on individual entities
declare @tempEntityTYpes table (entityTYpe int)
insert into @tempEntityTYpes
	select distinct dbo.getEntityLevelFromEntityHierarchy(entityType1, entityType2, entityType3, entityType4, entityType5)
	from UMSecurityAssociations (nolock)
	where roleID = @roleID
declare @tempENtityType int
declare entityTypeCursor cursor static for
	select entityType from @tempEntityTYpes
open entityTypeCursor
fetch next from entityTYpeCursor into @tempEntityTYpe
while @@FETCH_STATUS = 0
begin
if @tempENtityType not in (3, 4, 5, 6, 7)						--(3, 4, 5, 6, 7)
	begin
		if object_id('tempdb.dbo.#nonIdaObjects') is not null
			drop table #nonIdaObjects
		create table #nonIdaObjects (entityId int)
		exec sec_getNonIdaObjectsForThisUser @callerId, @tempEntityType, 0, '#nonIdaObjects'
		--entities - user / group that caller can see that are associated to this role
		insert into #entityAssociated (userId, userGroupId, entityType1, entityId1, entityTYpe2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll)
			select case when sec.isUser = 1 then sec.userOrGroupId else 0 end,
				   case when sec.isUser = 0 then sec.userOrGroupId else 0 end,
				   sec.entityTYpe1,
				   sec.entityId1,
				   0, 0, 0, 0, 0, 0, 0, 0, sec.includeAll
			from UMSecurityAssociations (nolock) sec inner join #userAndGroupsVisible ug
			on sec.isUser = ug.isUser and sec.userOrGroupId = ug.userOrGroupId
			inner join #nonIdaObjects nia on
			sec.entityTYpe1 = @tempEntityTYpe and (sec.entityId1 = nia.entityId)
			where sec.roleid = @roleID
		--includeAll is fine no need of any security checks here. Caller is just going to "see" this association
		insert into #entityAssociated (userId, userGroupId, entityType1, entityId1, entityTYpe2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll)
			select case when sec.isUser = 1 then sec.userOrGroupId else 0 end,
				   case when sec.isUser = 0 then sec.userOrGroupId else 0 end,
				   sec.entityTYpe1,
				   sec.entityId1,
				   0, 0, 0, 0, 0, 0, 0, 0, sec.includeAll
			from UMSecurityAssociations (nolock) sec inner join #userAndGroupsVisible ug
			on sec.isUser = ug.isUser and sec.userOrGroupId = ug.userOrGroupId
			where sec.entityTYpe1 = @tempEntityTYpe and sec.includeAll = 1 and sec.roleid = @roleID
	end
	else
	begin
		if object_id('tempdb.dbo.#idaObjects') is not null
			drop table #idaObjects
		create table #idaObjects (clientId int, appTypeId int, instanceId int, backupsetId int, subclientId int)
		exec sec_getIdaObjectsForUser @callerId, @tempEntityType, 0, 0, '#idaObjects'
		--entities - user / group that caller can see that are associated to this role
		--having separate handlers for Client, apptype, instance, backupset and subclient
		--is giving better performance against writing one single "WHERE" clause with "OR" of
		--all conditions
if @tempENtityType = 3					--3
		begin
			insert into #entityAssociated (userId, userGroupId, entityType1, entityId1, entityTYpe2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll)
				select distinct case when sec.isUser = 1 then sec.userOrGroupId else 0 end,
					   case when sec.isUser = 0 then sec.userOrGroupId else 0 end,
					   sec.entityTYpe1,
					   sec.entityId1,
					   sec.entityTYpe2,
					   sec.entityId2,
					   sec.entityType3,
					   sec.entityId3,
					   sec.entityTYpe4,
					   sec.entityId4,
					   sec.entityTYpe5,
					   sec.entityId5,
					   sec.includeAll
				from UMSecurityAssociations (nolock) sec inner join #userAndGroupsVisible ug
				on sec.isUser = ug.isUser and sec.userOrGroupId = ug.userOrGroupId
				inner join #idaobjects ia
				on sec.entityTYpe1 = @tempENtityType and sec.entityId1 = ia.clientId and sec.entityTYpe2 = 0
				where sec.roleID = @roleID
			--includeAll is fine no need of any security checks here. Caller is just going to "see" this association
			insert into #entityAssociated (userId, userGroupId, entityType1, entityId1, entityTYpe2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll)
				select case when sec.isUser = 1 then sec.userOrGroupId else 0 end,
					   case when sec.isUser = 0 then sec.userOrGroupId else 0 end,
					   sec.entityTYpe1,
					   sec.entityId1,
					   sec.entityTYpe2,
					   sec.entityId2,
					   sec.entityType3,
					   sec.entityId3,
					   sec.entityTYpe4,
					   sec.entityId4,
					   sec.entityTYpe5,
					   sec.entityId5,
					   sec.includeAll
				from UMSecurityAssociations (nolock) sec inner join #userAndGroupsVisible ug
				on sec.isUser = ug.isUser and sec.userOrGroupId = ug.userOrGroupId
				where sec.entityTYpe1 = @tempENtityType and sec.includeAll = 1 and sec.entityTYpe2 = 0 and sec.roleID = @roleID
		end
else if @tempENtityType = 4					--4
		begin
			insert into #entityAssociated (userId, userGroupId, entityType1, entityId1, entityTYpe2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll)
				select distinct case when sec.isUser = 1 then sec.userOrGroupId else 0 end,
					   case when sec.isUser = 0 then sec.userOrGroupId else 0 end,
					   sec.entityTYpe1,
					   sec.entityId1,
					   sec.entityTYpe2,
					   sec.entityId2,
					   sec.entityType3,
					   sec.entityId3,
					   sec.entityTYpe4,
					   sec.entityId4,
					   sec.entityTYpe5,
					   sec.entityId5,
					   sec.includeAll
				from UMSecurityAssociations (nolock) sec inner join #userAndGroupsVisible ug
				on sec.isUser = ug.isUser and sec.userOrGroupId = ug.userOrGroupId
				inner join #idaobjects ia
on sec.entityTYpe1 = 3 and sec.entityId1 = ia.clientId and sec.entityTYpe2 = 4 and sec.entityId2 = ia.appTypeID and sec.entityType3 = 0
				where sec.roleID = @roleID
		end
else if @tempENtityType = 5			--5
		begin
			insert into #entityAssociated (userId, userGroupId, entityType1, entityId1, entityTYpe2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll)
				select distinct case when sec.isUser = 1 then sec.userOrGroupId else 0 end,
					   case when sec.isUser = 0 then sec.userOrGroupId else 0 end,
					   sec.entityTYpe1,
					   sec.entityId1,
					   sec.entityTYpe2,
					   sec.entityId2,
					   sec.entityType3,
					   sec.entityId3,
					   sec.entityTYpe4,
					   sec.entityId4,
					   sec.entityTYpe5,
					   sec.entityId5,
					   sec.includeAll
				from UMSecurityAssociations (nolock) sec inner join #userAndGroupsVisible ug
				on sec.isUser = ug.isUser and sec.userOrGroupId = ug.userOrGroupId
				inner join #idaobjects ia
on sec.entityTYpe1 = 3 and sec.entityId1 = ia.clientId and sec.entityTYpe2 = 4 and sec.entityId2 = ia.appTypeID and sec.entityType3 = 5 and sec.entityId3 = ia.instanceId and sec.entityType4 = 0
				where sec.roleID = @roleID
		end
else if @tempENtityType = 6				--6
		begin
			insert into #entityAssociated (userId, userGroupId, entityType1, entityId1, entityTYpe2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll)
				select distinct case when sec.isUser = 1 then sec.userOrGroupId else 0 end,
					   case when sec.isUser = 0 then sec.userOrGroupId else 0 end,
					   sec.entityTYpe1,
					   sec.entityId1,
					   sec.entityTYpe2,
					   sec.entityId2,
					   sec.entityType3,
					   sec.entityId3,
					   sec.entityTYpe4,
					   sec.entityId4,
					   sec.entityTYpe5,
					   sec.entityId5,
					   sec.includeAll
				from UMSecurityAssociations (nolock) sec inner join #userAndGroupsVisible ug
				on sec.isUser = ug.isUser and sec.userOrGroupId = ug.userOrGroupId
				inner join #idaobjects ia
on sec.entityTYpe1 = 3 and sec.entityId1 = ia.clientId and sec.entityTYpe2 = 4 and sec.entityId2 = ia.appTypeID and sec.entityType3 = 5 and sec.entityId3 = ia.instanceId and sec.entityType4 = 6 and sec.entityId4 = ia.backupsetId and sec.entityType5 = 0
				where sec.roleID = @roleID
		end
else if @tempENtityType = 7				--7
		begin
			insert into #entityAssociated (userId, userGroupId, entityType1, entityId1, entityTYpe2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll)
				select distinct case when sec.isUser = 1 then sec.userOrGroupId else 0 end,
					   case when sec.isUser = 0 then sec.userOrGroupId else 0 end,
					   sec.entityTYpe1,
					   sec.entityId1,
					   sec.entityTYpe2,
					   sec.entityId2,
					   sec.entityType3,
					   sec.entityId3,
					   sec.entityTYpe4,
					   sec.entityId4,
					   sec.entityTYpe5,
					   sec.entityId5,
					   sec.includeAll
				from UMSecurityAssociations sec inner join #userAndGroupsVisible ug
				on sec.isUser = ug.isUser and sec.userOrGroupId = ug.userOrGroupId
				inner join #idaobjects ia
on sec.entityTYpe1 = 3 and sec.entityId1 = ia.clientId and sec.entityTYpe2 = 4 and sec.entityId2 = ia.apptypeid and sec.entityType3 = 5 and sec.entityId3 = ia.instanceId and sec.entityType4 = 6 and sec.entityId4 = ia.backupsetId and sec.entityType5 = 7 and sec.entityId5 = ia.subclientId
				where sec.roleID = @roleID
		end
	end
	fetch next from entityTYpeCursor into @tempEntityTYpe
end
close entityTYpeCursor
deallocate entityTYpeCursor
--call id to name converter dynamic to convert the each entity id to its names
exec EntityIdToNameConverterDynamic '#entityAssociated', 'entity'
--user and user group names
update #entityAssociated
set userName = UMUsers.login
from UMUsers
where id = #entityAssociated.userID and #entityAssociated.userID > 0
update #entityAssociated
set userGroupName = case when UMGroups.umdsProviderId > 0 then (select domainName from UMDSProviders where id = UMGroups.umdsProviderId)  + '\' + UMGroups.name else UMGroups.name end
from UMGroups
where id = #entityAssociated.userGroupId and #entityAssociated.userGroupId > 0
set @outputXML = (select genericEntityAssociated.query('.'),
case when userId <> 0 then (select userID as '@userId', userName as '@userName', 13 as '@_type_' for xml path ('user'), type) end,
case when userGroupid <> 0 then (select userGroupId as '@userGroupId', userGroupName as '@userGroupName', 15 as '@_type_' for xml path ('userGroup'), type) end
				  from #entityAssociated
				  for xml path ('associations'))
if @isReturnCursor = 1
	select @outputXML
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getRoleAssociations')
	delete from GxQscripts where name = 'sec_getRoleAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getRoleAssociations')
	delete from GXDBVersions where aliasname = 'sec_getRoleAssociations'
GO

insert into GXDBVersions values(2, 'sec_getRoleAssociations',  '00000000000000000000', 'sec_getRoleAssociations', '00000000000000000000')
GO

