

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getResellerCompaniesForUserForUI.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
--  +================================================================================================+
--  |		Name: sec_getResellerCompaniesForUserForUI.sp
--  |		Description: This is to load reseller companies for UI.
--	|					 It will get list of companies on which userId has tenant operator role on.
--	|					 If the user ID passed is a impersonated user, then it will send all
--  |					 companies on which the Original user has tenant operator role.
--	|					 Because it is needed on UI to allow switch over to another company from this
--	|					 company view.
--  |		Author: jswaminathan
--  +================================================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getResellerCompaniesForUserForUI')
BEGIN
	print '>>> Drop Stored Procedure: sec_getResellerCompaniesForUserForUI <<<'
	drop procedure sec_getResellerCompaniesForUserForUI
END
IF EXISTS (select * from GxQscripts where name='sec_getResellerCompaniesForUserForUI')
	delete from GxQscripts where name = 'sec_getResellerCompaniesForUserForUI'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getResellerCompaniesForUserForUI')
	delete from GXDBVersions where aliasname = 'sec_getResellerCompaniesForUserForUI'
GO
print '... Creating Procedure: sec_getResellerCompaniesForUserForUI'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getResellerCompaniesForUserForUI
  @UserId INT,
  @outputXML XML OUTPUT,
  @outputXML1 XML OUTPUT,
  @o_deactivatedCompanyXML XML OUTPUT,
  @returnCursor INT = 0
AS
  DECLARE @returnXML XML 
  DECLARE @returnXML1 XML
IF OBJECT_ID('tempdb.dbo.#operatorCompanies') IS NOT NULL
	DROP TABLE #operatorCompanies
CREATE TABLE #operatorCompanies
(
	companyId INT PRIMARY KEY,
	companyName NVARCHAR(MAX),
	ownerCompany INT,
	canCreateCompanies INT DEFAULT 0,
	isDeletedOrDeactivated INT DEFAULT 0
)
IF EXISTS (SELECT 1 FROM UMUsers WHERE id = @UserId AND flags & 0x8000 <> 0)
BEGIN
	-- He is a impersonated user. Get the operator companies for his original user and send to UI.
	-- That way end user can switch to another company in the UI from this company view.
	SELECT @UserId = CAST(attrVal AS INT)
    FROM UMUsersProp (NOLOCK)
    WHERE
        componentNameId = @UserId
AND attrName = 'Original Reseller User Id'
        AND modified = 0
END
-- Handling Master users as default operators for all companies.
DECLARE @masterGroupId INT = dbo.GetMasterGroupId()
IF EXISTS (SELECT 1
		   FROM UMUserGroup (NOLOCK)
		   WHERE
				userId = @UserId AND groupId = @masterGroupId
		   UNION ALL
		   SELECT 1
		   FROM UMUserGroup (NOLOCK)
				INNER JOIN UMDSGroupMaps (NOLOCK)
					ON umdsGroupId = groupId
		   WHERE
				userId = @userId AND umGroupId = @masterGroupId)
BEGIN
	INSERT INTO #operatorCompanies (companyId, companyName, ownerCompany, isDeletedOrDeactivated)
		SELECT id, hostName, ownerCompany,
IIF(flags & 0x0002 = 0x0002  OR flags & 0x0010 = 0x0010, 1, 0 )
		FROM UMDSProviders (NOLOCK)
		WHERE
serviceType = 5
END
ELSE
BEGIN
-- Get all the companies for whom this user / his group is configured as an operator.
	INSERT INTO #operatorCompanies (companyId, companyName, ownerCompany, isDeletedOrDeactivated)
		SELECT UMO.companyId, P.hostName, ownerCompany,
IIF(P.flags & 0x0002 = 0x0002  OR P.flags & 0x0010 = 0x0010, 1, 0 )
		FROM UMOperators UMO (NOLOCK)
			INNER JOIN UMDSProviders P (NOLOCK)
				ON UMO.companyId = P.id
		WHERE
			UMO.isUser = 1
			AND UMO.userOrGroupId = @UserId
		UNION
			SELECT UMO.companyId, P.hostName, ownerCompany,
IIF(P.flags & 0x0002 = 0x0002  OR P.flags & 0x0010 = 0x0010, 1, 0 )
		FROM UMOperators UMO (NOLOCK)
			INNER JOIN UMDSProviders P (NOLOCK)
				ON UMO.companyId = P.id
			INNER JOIN UMUserGroup UG (NOLOCK)
				ON UMO.isUser = 0 AND UG.groupId = UMO.userOrGroupId
			INNER JOIN UMGroups G (NOLOCK)
				ON G.id = UG.groupId
		WHERE
			UG.userId = @UserID
AND G.groupFlags & 0x0001 <> 0
		UNION
			SELECT UMO.companyId, P.hostName, ownerCompany,
IIF(P.flags & 0x0002 = 0x0002  OR P.flags & 0x0010 = 0x0010, 1, 0 )
		FROM UMOperators UMO (NOLOCK)
			INNER JOIN UMDSProviders P (NOLOCK)
				ON UMO.companyId = P.id
			INNER JOIN UMDSGroupMaps GM (NOLOCK)
				ON UMO.isUser = 0 AND UMO.userOrGroupId = GM.umGroupId
			INNER JOIN UMUserGroup UG (NOLOCK)
				ON GM.umdsGroupId = UG.groupId
			INNER JOIN UMGroups (NOLOCK) G1					-- local group
				ON G1.id = GM.umGroupId
			INNER JOIN UMGroups (NOLOCK) G2					-- AD group
				ON G2.id = GM.umdsGroupId
		WHERE
			UG.userId = @UserID
AND G1.groupFlags & 0x0001 <> 0		-- Both local and AD group should be enabled.
AND G2.groupFlags & 0x0001 <> 0
END
-- This is returned just for backward compatibility. Web console / command center might be running on a older Service pack
-- and CommServer might be upgraded to a new service pack. So the older UI will be expecting the old response.
-- We can eventually remove this after three service packs. (around SP22 timeframe).
SET @outputXML = (
					SELECT
					(
						SELECT companyId AS '@providerId'
							   ,companyName AS '@providerDomainName'
						FROM #operatorCompanies OC
						WHERE isDeletedOrDeactivated = 0
						FOR XML PATH ('operatorCompanies'), TYPE
					)
				 )
SET @o_deactivatedCompanyXML = (
					SELECT
					(
						SELECT companyId AS '@providerId'
							   ,companyName AS '@providerDomainName'
						FROM #operatorCompanies OC
						WHERE isDeletedOrDeactivated = 1
						FOR XML PATH ('deactivatedOperatorCompanies'), TYPE
					)
				 )
UPDATE #operatorCompanies
SET canCreateCompanies = 1
FROM App_CompanyProp (NOLOCK)
WHERE
	componentNameId = companyId
AND attrName = 'Allow to Manage Other Companies'
	AND attrVal = '1'
	AND modified = 0
AND cs_attrName = CHECKSUM('Allow to Manage Other Companies')
IF OBJECT_ID('tempdb.dbo.#operatorCompaniesOutputTbl') IS NOT NULL
	DROP TABLE #operatorCompaniesOutputTbl
CREATE TABLE #operatorCompaniesOutputTbl
(
	tag INT,										-- Needed for xml explicit statement.
	companyId INT,
	ownerCompany INT,
	companyName NVARCHAR(MAX),
	isReseller INT,
	Sort VARBINARY(30),								-- This column is to sort the respective children after their parent entries before framing XML.
	parent INT										-- Needed for xml explicit statement.
)
;WITH Tbl1
AS
(
	SELECT	1 AS Tag,														-- Starting level. These are the root level entries.
			companyId AS companyId,
			0 AS ownerCompany,
			companyName AS companyName,
			canCreateCompanies AS isReseller,
			CAST(companyId AS VARBINARY) AS Sort,							-- Default length for Varbinary is 30. Company Id is integer column, would not need that much. We need it for the second one after UNION.
			NULL AS parent
	FROM #operatorCompanies
	WHERE
		isDeletedOrDeactivated = 0 AND(
		ownerCompany = 0													-- All companies who have parent set as 0
		OR ownerCompany NOT IN (											-- or whose parents are not in table
									SELECT companyId						-- are considered as root level entries.
									FROM #operatorCompanies
							   ))
	UNION ALL
	SELECT	Tag + 1,
			Child.companyId,
			Child.ownerCompany,
			Child.companyName,
			Child.canCreateCompanies,
			CAST(Sort + CAST(Child.companyId AS BINARY(4)) AS VARBINARY),	-- Company Id is integer column, so will need only 4 bytes max. When framing it along with parent, it could increase, but would not exceed 30.
			Parent.Tag
	FROM #operatorCompanies Child
		INNER JOIN Tbl1 Parent ON Child.ownerCompany = Parent.CompanyId
		AND Child.isDeletedOrDeactivated = 0
)
INSERT INTO #operatorCompaniesOutputTbl
	SELECT Tag, companyId, ownerCompany, companyName, isReseller, Sort, parent
	FROM Tbl1
SET @outputXML1 =
					(
						SELECT  Tag,
								Parent,
								CASE WHEN tag = 1 THEN [companyId] ELSE NULL END AS 'operatorCompaniesNew!1!companyId', CASE WHEN tag = 1 THEN [companyName] ELSE NULL END AS 'operatorCompaniesNew!1!companyName', CASE WHEN tag = 1 THEN [isReseller] ELSE NULL END AS 'operatorCompaniesNew!1!isReseller',
								CASE WHEN tag = 2 THEN [companyId] ELSE NULL END AS 'operatorCompaniesNew!2!companyId', CASE WHEN tag = 2 THEN [companyName] ELSE NULL END AS 'operatorCompaniesNew!2!companyName', CASE WHEN tag = 2 THEN [isReseller] ELSE NULL END AS 'operatorCompaniesNew!2!isReseller',
								CASE WHEN tag = 3 THEN [companyId] ELSE NULL END AS 'operatorCompaniesNew!3!companyId', CASE WHEN tag = 3 THEN [companyName] ELSE NULL END AS 'operatorCompaniesNew!3!companyName', CASE WHEN tag = 3 THEN [isReseller] ELSE NULL END AS 'operatorCompaniesNew!3!isReseller',
								CASE WHEN tag = 4 THEN [companyId] ELSE NULL END AS 'operatorCompaniesNew!4!companyId', CASE WHEN tag = 4 THEN [companyName] ELSE NULL END AS 'operatorCompaniesNew!4!companyName', CASE WHEN tag = 4 THEN [isReseller] ELSE NULL END AS 'operatorCompaniesNew!4!isReseller',
								CASE WHEN tag = 5 THEN [companyId] ELSE NULL END AS 'operatorCompaniesNew!5!companyId', CASE WHEN tag = 5 THEN [companyName] ELSE NULL END AS 'operatorCompaniesNew!5!companyName', CASE WHEN tag = 5 THEN [isReseller] ELSE NULL END AS 'operatorCompaniesNew!5!isReseller'
								-- We are getting till nested level 5. Most of the cases this should be sufficient. Can extend it later, if needed.
						FROM #operatorCompaniesOutputTbl
						ORDER BY sort
						FOR XML EXPLICIT
					)
IF @returnCursor = 1
	SELECT @outputXML AS returnXML, @outputXML1 AS returnXML1, @o_deactivatedCompanyXML as returnXML2
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getResellerCompaniesForUserForUI')
	delete from GxQscripts where name = 'sec_getResellerCompaniesForUserForUI'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getResellerCompaniesForUserForUI')
	delete from GXDBVersions where aliasname = 'sec_getResellerCompaniesForUserForUI'
GO

insert into GXDBVersions values(2, 'sec_getResellerCompaniesForUserForUI',  '00000000000000000000', 'sec_getResellerCompaniesForUserForUI', '00000000000000000000')
GO

