

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getProviderListAttributeMap.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  | Stored Procedure: sec_CustomProviderOp
--  |
--  | Description:
--  |  Called for custom provider operation
--  |
--  |   Revisions  Author   	Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0         Seema  Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getProviderListAttributeMap')
BEGIN
	print '>>> Drop Stored Procedure: sec_getProviderListAttributeMap <<<'
	drop procedure sec_getProviderListAttributeMap
END
IF EXISTS (select * from GxQscripts where name='sec_getProviderListAttributeMap')
	delete from GxQscripts where name = 'sec_getProviderListAttributeMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getProviderListAttributeMap')
	delete from GXDBVersions where aliasname = 'sec_getProviderListAttributeMap'
GO
print '... Creating Procedure: sec_getProviderListAttributeMap'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getProviderListAttributeMap
AS
  DECLARE @providerId INT
  DECLARE @staticAttributeString varchar(MAX)
  DECLARE @customAttibuteString varchar(MAX)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT U.id  as 'providerId',STAT.attributeString as 'staticAttributeString', ISNULL(ISNULL(Map.attributeString,DEfaultMap.attributeString),STAT.attributeString) as 'customAttibuteString'
    FROM UMDSProviders U
     JOIN UMDSProviderProp  PROP
ON PROP.componentNameId = U.id AND PROP.attrName='Dynamic Provider Type' and PROP.modified=0
	JOIN UMProviderSTaticAttribute STAT  ON PROP.attrVal IS NOT NULL
	LEFT JOIN UMPROviderTypeAttributeMap MAP ON PROP.attrVAl=providerTypeId  and MAp.attributeId=STAT.id
	LEFT JOIN UMPROviderTypeAttributeMap DEfaultMap ON DEfaultMap.providerTypeId=-1 and DEfaultMap.attributeId = STAT.id
WHERE U.id > 0 AND U.serviceType=14
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getProviderListAttributeMap')
	delete from GxQscripts where name = 'sec_getProviderListAttributeMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getProviderListAttributeMap')
	delete from GXDBVersions where aliasname = 'sec_getProviderListAttributeMap'
GO

insert into GXDBVersions values(2, 'sec_getProviderListAttributeMap',  '00000000000000000000', 'sec_getProviderListAttributeMap', '00000000000000000000')
GO

