

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getProviderList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_getProviderList.sp,v $ $Id: sec_getProviderList.sp,v 1.7.42.6 2020/04/20 16:59:24 njudge Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_getProviderList()
--  |
--  | Description:  Determines whether a user is associated with a group
--	|				that can see a chosen iDa object.
--  |
--  |       Input:  integer Affiliation: Bit map representation of which
--	|				affiliations are requested
--	|
--  |      Output:  Returns list of groups that can see the object
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--	|	1.1        skatz	Created from getSecurityNodeAccess.cur revision 1.8
--  +========================================================================+
--
/*
If this commcell is configured as a service commcell and has an IDP then we dont want to allow AD SSO for the domains
on this commcell hence we'll unset the SSO flag.
*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getProviderList')
BEGIN
	print '>>> Drop Stored Procedure: sec_getProviderList <<<'
	drop procedure sec_getProviderList
END
IF EXISTS (select * from GxQscripts where name='sec_getProviderList')
	delete from GxQscripts where name = 'sec_getProviderList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getProviderList')
	delete from GXDBVersions where aliasname = 'sec_getProviderList'
GO
print '... Creating Procedure: sec_getProviderList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getProviderList
  @uid integer
AS
  DECLARE @id integer
  DECLARE @domainName nvarchar(255)
  DECLARE @hostName nvarchar(255)
  DECLARE @description nvarchar(255)
  DECLARE @login nvarchar(255)
  DECLARE @password nvarchar(400)
  DECLARE @flags integer
  DECLARE @enabled integer
  DECLARE @serviceType integer
  DECLARE @modified integer
  DECLARE @useSecureLdap integer
  DECLARE @port integer
  DECLARE @proxyClient nvarchar(255)
  DECLARE @isGLobalIDPConfigured integer = ISNULL((select top 1 longlongVal from APP_ComponentProp where componentId = 2 and componentType = 1048 and propertyTypeId = 2 and longVal=1 and longlongVal = 1),0)
SET NOCOUNT ON
SELECT U.id,
		U.domainName,
		U.hostName,
		U.description,
		U.login,
		U.password,
		CASE
		WHEN @isGLobalIDPConfigured <> 1 THEN U.flags
WHEN @isGLobalIDPConfigured = 1 THEN U.flags & ~1
		END as 'flags',
		U.enabled,
		U.serviceType,
		U.modified,
		U.useSecureLdap,
		U.port,
		U.resourceId,
		ISNULL(
                STUFF((SELECT   ',' + b. name  AS 'data()'  FROM APP_FirewallTPPM F WITH(NOLOCK )
                JOIN APP_CLIENT B WITH (NOLOCK) ON F .toEntityId = B.id
                WHERE U. serviceType in (2,6,9) AND F. tppmParams = U .id AND F.tppmType = 4 AND F. status = 1 FOR XML PATH ('')), 1,1 ,''),
            '') AS proxyClient
FROM UMDSProviders U WITH(NOLOCK)
WHERE U.id >= 0
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getProviderList')
	delete from GxQscripts where name = 'sec_getProviderList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getProviderList')
	delete from GXDBVersions where aliasname = 'sec_getProviderList'
GO

insert into GXDBVersions values(2, 'sec_getProviderList',  '00010007004200060000', 'sec_getProviderList', '00010007004200060000')
GO

