

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getPermissionsOnEntity_old.sp] ---------- 

--  +-----------------------------------------------------------------------+
--  |           Procedure : "sec_GetPermissionsOnEntity_old.sp"
--  |   This Procedure is used to get all permissions for a user on a entity
--  +-----------------------------------------------------------------------+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getPermissionsOnEntity_old')
BEGIN
	print '>>> Drop Stored Procedure: sec_getPermissionsOnEntity_old <<<'
	drop procedure sec_getPermissionsOnEntity_old
END
IF EXISTS (select * from GxQscripts where name='sec_getPermissionsOnEntity_old')
	delete from GxQscripts where name = 'sec_getPermissionsOnEntity_old'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getPermissionsOnEntity_old')
	delete from GXDBVersions where aliasname = 'sec_getPermissionsOnEntity_old'
GO
print '... Creating Procedure: sec_getPermissionsOnEntity_old'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getPermissionsOnEntity_old
  @tableOutput NVARCHAR(MAX),
  @userId INTEGER,
  @entityType1 INTEGER,
  @entityId1 INTEGER,
  @entityType2 INTEGER = 0,
  @entityId2 INTEGER = 0,
  @entityType3 INTEGER = 0,
  @entityId3 INTEGER = 0,
  @entityType4 INTEGER = 0,
  @entityId4 INTEGER = 0,
  @entityType5 INTEGER = 0,
  @entityId5 INTEGER = 0,
  @inheritFromChildren INTEGER = 0,
  @includeNotMappedPermission INT = 0,
  @skipClassicPermissions INT = 0,
  @skipOwnerPermissions INT = 0
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF OBJECT_ID ('tempdb.dbo.#getPermissionsOnEntity_tempOutputTable') IS NOT NULL
    DROP TABLE #getPermissionsOnEntity_tempOutputTable
CREATE TABLE #getPermissionsOnEntity_tempOutputTable
(
    roleID INT,
    permissionID INT
)
DECLARE @dynamicSQLStr NVARCHAR(MAX) = ''
-- Read metadata for this entity.
BEGIN
    DECLARE @entityTypeReq INT = dbo.getEntityLevelFromEntityHierarchy (@entityType1, @entityType2, @entityType3, @entityType4, @entityType5)
            ,@isIdaEntity BIT = 0           -- For these entities, need to query entity2-5.
            ,@entityFlags INT = 0
            ,@skipCommcellSecurityCheck BIT = 0
	DECLARE @companyIdOfUser INT = 0
	SET @companyIdOfUser = dbo.AppGetCompanyForUserOrUserGroup(@userId, 1)
IF OBJECT_ID('tempdb.dbo.#validCompaniesOfCompanyUser') IS NOT NULL
    DROP TABLE #validCompaniesOfCompanyUser
CREATE TABLE #validCompaniesOfCompanyUser
    (
        companyId INT NOT NULL
        primary key (companyId)
    )
DECLARE @doNotUseCompanyEntitiesTableForFiltering INTEGER  = 0
SET @doNotUseCompanyEntitiesTableForFiltering =  ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'DoNotUseCompanyEntitiesTableForFiltering' AND modified = 0), 0)
IF @doNotUseCompanyEntitiesTableForFiltering = 1
BEGIN
	SET @companyIdOfUser = 0
END
IF @companyIdOfUser <> 0
BEGIN
    declare @parentCompanyId int = @companyIdOfUser
        ;with parentCompany as
        (
            select id as childCompanyId from UMDSproviders WITH(NOLOCK) where ownerCompany = @parentCompanyId and serviceType = 5
            union all
            select P.id as childCompanyId from UMDSProviders P inner join parentCompany P1 on P.ownerCompany = P1.childCompanyId and P.serviceType = 5
        )
        INSERT INTO #validCompaniesOfCompanyUser(companyId)
        select childCompanyId
        from parentCompany
    declare @childCompanyId int = @companyIdOfUser
        ;with childCompany as
        (
            select ownerCompany as parentCompanyId from UMDSproviders WITH(NOLOCK) where id = @childCompanyId and serviceType = 5 and ownerCompany != 0
            union all
            select P.ownerCompany as parentCompanyId from UMDSProviders P inner join childCompany P1 on P.id = P1.parentCompanyId and P.serviceType = 5 and  P.ownerCompany != 0
        )
        INSERT INTO #validCompaniesOfCompanyUser(companyId)
        select parentCompanyId
        from childCompany
    INSERT INTO #validCompaniesOfCompanyUser values (@companyIdOfUser) , (0)   -- Company Id 0 For MSP entities
END
	IF @companyIdOfUser <> 0
	BEGIN
		DECLARE @entityIdReq INTEGER = 0
		IF @entityId5 <> 0
			SET @entityIdReq = @entityId5
		ELSE IF @entityId4 <> 0
			SET @entityIdReq = @entityId4
		ELSE IF @entityId3 <> 0
			SET @entityIdReq = @entityId3
		ELSE IF @entityId1 <> 0
			SET @entityIdReq = @entityId1
		IF (SELECT count(0)
			FROM App_CompanyEntities App
			LEFT JOIN #validCompaniesOfCompanyUser C
				ON C.companyId = App.companyId
			WHERE App.entityType = @entityTypeReq
				AND App.entityId = @entityIdReq
				AND C.companyId IS NULL) > 0
		BEGIN
			GOTO PROC_EXIT
		END
	END
    SELECT @entityFlags = flags
    FROM APP_Entity
    WHERE
        entityType = @entityTypeReq
    IF @entityFlags & 4 <> 0            -- SKIP_COMMCELL_SECURITY_CHECK
        SET @skipCommcellSecurityCheck = 1
    IF @entityType1 = 3
        SET @isIdaEntity = 1
END
-- Get user groups.
BEGIN
    IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') IS NOT NULL
        DROP TABLE #getMemberUserGroupsHelperOutputTbl
    CREATE TABLE #getMemberUserGroupsHelperOutputTbl
    (
        isUser INT,
        userOrGroupId INT,
        UNIQUE CLUSTERED (isUser, userOrGroupId)
    )
    EXEC sec_getMemberUserGroupsHelper @userID
END
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntity_dynamicParentEntities') IS NOT NULL
    DROP TABLE #getPermissionsOnEntity_dynamicParentEntities
CREATE TABLE #getPermissionsOnEntity_dynamicParentEntities
(
    entityType INT,
    entityId INT,
    includeAll INT DEFAULT 0
)
CREATE CLUSTERED INDEX getPermissionsOnEntity_dynamicParentEntities_Idx ON #getPermissionsOnEntity_dynamicParentEntities(entityType) --INCLUDE (entityId,includeAll)
-- VSA Subclient expansion
-- If input entity is a VM client, then we need to inherit permissions from its hypervisor client and its parents as well.
-- This table to contain all the parent entities of this VM client.
IF OBJECT_ID('tempdb.dbo.#VSAEntities') IS NOT NULL
    DROP TABLE #vsaEntities
CREATE TABLE #VSAEntities
(
    entityType1 INT, entityId1 INT,
    entityType2 INT DEFAULT 0, entityID2 INT DEFAULT 0,
    entityType3 INT DEFAULT 0, entityId3 INT DEFAULT 0,
    entityType4 INT DEFAULT 0, entityId4 INT DEFAULT 0,
    entityType5 INT DEFAULT 0, entityId5 INT DEFAULT 0
)
CREATE CLUSTERED INDEX VSAEntities_Idx1 ON #VSAEntities (entityType1, entityId1);;
DECLARE @vsaClientId INT = 0, @vsaAppTypeId INT = 0, @vsaInstanceId INT = 0, @vsaBackupsetID INT = 0, @vsaSubclientId INT = 0
IF @entityType1 = 3
BEGIN
    SELECT @vsaClientId = clientId, @vsaAppTypeId = appTypeId, @vsaInstanceId = instance, @vsaBackupsetID = backupSet, @vsaSubclientId = a.id
    FROM App_ClientProp CP
        INNER JOIN APP_Application A
            ON CAST(CP.attrVal AS INT) = A.id
    WHERE
        componentNameId = @entityId1
AND attrName = 'Last Backup Subclient'
        AND CP.modified = 0
    IF @vsaClientId > 0             -- Push all the VSA related entities into this one table. since we do not have code to compute parent of parent in a hierarchical manner.
    BEGIN
        INSERT INTO #VSAEntities
VALUES (3, @vsaClientId, 4, @vsaAppTypeId, 5, @vsaInstanceId, 6, @vsaBackupsetId, 7, @vsaSubclientId)
        INSERT INTO #VSAEntities (entityType1, entityId1)
SELECT 61, companyId
            FROM UMOwners
            WHERE
entityTYpe = 3
                AND entityId = @vsaClientID
        INSERT INTO #VSAEntities (entityType1, entityId1)
SELECT 28, clientGroupId
            FROM APP_ClientGRoupAssoc
            WHERE
                clientId = @vsaClientId
    END
END
-- Having index only on entity type gives reads ~2000, than including all columns and reads ~55000.
-- Input userId:88, entityType1:13, entityId1:536
-- Framing parent entities, include all parents to consider.
IF EXISTS (SELECT TOP 1 1 FROM App_EntityParentAssociation WHERE childEntityType = @entityTypeReq)
BEGIN
    -- Individual parents.
    SET @dynamicSQLStr = 'INSERT INTO #getPermissionsOnEntity_dynamicParentEntities (entityType, entityID)'
                                + CHAR(10)
                                + SUBSTRING
                                    (
                                        (
                                            SELECT 'UNION'
                                                + CHAR(10)
                                                + 'SELECT Tbl.parentEntityType, Tbl.parentId '
                                                + CHAR(10)
                                                + 'FROM ('
                                                + CHAR(10)
                                                + CAST(associationQuery AS VARCHAR(MAX))
                                                + CHAR(10)
                                                + ')Tbl'
                                                + CHAR(10)
                                                + CASE WHEN childEntityType NOT IN (4,5,6,7) THEN 'WHERE Tbl.childId = ' + CAST(@entityId1 AS VARCHAR(10))
                                                        WHEN childEntityType = 4 THEN 'WHERE Tbl.childId = ' + CAST(@entityId1 AS VARCHAR(10)) + ' AND Tbl.childId2 = ' + CAST(@entityId2 AS VARCHAR(10))
                                                        WHEN childEntityType = 5 THEN 'WHERE Tbl.childId3 = ' + CAST(@entityId3 AS VARCHAR(10))
                                                        WHEN childEntityType = 6 THEN 'WHERE Tbl.childId4 = ' + CAST(@entityId4 AS VARCHAR(10))
                                                        WHEN childEntityType = 7 THEN 'WHERE Tbl.childId5 = ' + CAST(@entityId5 AS VARCHAR(10))
                                                              END
                                                + CHAR(10)
                                            FROM App_EntityParentAssociation
                                            WHERE
                                                (childEntityType = @entityTypeReq)
                                            FOR XML PATH (''), TYPE
                                        ).value('.','NVARCHAR(MAX)'),               -- There may be < or > symbols that are XML encoded into &lt; and &gt; Doing a .value removes that encoding.
                                        6,              -- Exclude the first UNION
                                        2147483647      -- MAX
                                )
    EXEC (@dynamicSQLStr)
    -- Till SP12, for iDA entity types, we consider only Client entity type's parents from Entity Parent Association table (like Client Group, Plan, Company, etc.).
    -- With parent child inheritance support for Subclient Policy, we needed to consider parent type for Backupset entity as well from the table. (Subclient Policy is Backupset in Security layer)
    -- So to make queries easier and optimized, we expanded Client Group, Plan, Company inheritance individually into AppType, Instance, Backupset and Subclient entities and saved in Entity Parent Association Table.
    -- Then in Security SPs, we just query for inputted entity's parents. So if input entity is a Subclient entity, then just query for Subclient's parents - which will give Client Group, Plan, etc. as well.
    -- But this logic broke in few places:
    --      1. When restore is launched from GUI, subclient ID comes as -1. We cannot get parents of Subclient Id -1, instead we need to get the parents for the Client Id.
    --      2. CloudApps, OneDrive, etc. do not store client - apptype information in App_IdaName. So the associations expansion query from Entity Parent Association table did not return Client group
    --         as parent of these appTypes.
    -- So bringing back the same logic of SP12: Get Client parents also for iDA entities. This will fix the issue.
    -- We shall revisit this entire implementation of Parent child inheritance on SP14/15 and see if we can improvise it.
IF @entityTypeReq IN (4, 5, 6, 7)
        INSERT INTO #getPermissionsOnEntity_dynamicParentEntities (entityType, entityId)
SELECT 28, clientGroupId
            FROM APP_ClientGroupAssoc CGA
            WHERE
                clientId = @entityId1
            UNION
SELECT 61, companyId
            FROM UMOwners
            WHERE
                entityType = @entityTYpe1
                AND entityId = @entityId1
			UNION
SELECT 61, CAST(CP.attrVal AS INT)			-- Company - client relationship is saved in Client Properties table. Look for that one too.
			FROM APP_ClientProp CP
			WHERE
				componentNameId = @entityId1
AND attrName = 'Installation Company ID'
				AND attrVal <> '0'
				AND modified = 0
            EXCEPT
            SELECT entityType,entityId
            FROM #getPermissionsOnEntity_dynamicParentEntities
    INSERT INTO #getPermissionsOnEntity_dynamicParentEntities (entityType, entityId, includeAll)
        SELECT DISTINCT entityType,0,1              -- Include all of parents.
        FROM #getPermissionsOnEntity_dynamicParentEntities
    IF @skipClassicPermissions = 0
    BEGIN
        -- Querying separately for parent and then on the entity reduce reads to ~1500 than ~4000.
        INSERT INTO #getPermissionsOnEntity_tempOutputTable
            SELECT DISTINCT Sec.roleId, Sec.permissionId
            FROM UMSecurityAssociations Sec
                INNER JOIN #getPermissionsOnEntity_dynamicParentEntities E
                    ON Sec.entityType1 = E.entityType AND Sec.entityId1 = E.entityId AND Sec.includeAll = E.includeAll
                INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
                    ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
    END
END
IF @skipClassicPermissions = 0
BEGIN
    -- Security associations on the entity, commcell, include all of that entity type.
    IF (@isIdaEntity = 0)
    BEGIN
        -- Query UMSecurityAssociations only once brings reads down to ~1000 than ~2500 if queried thrice for commcell,include all,entity.
        INSERT INTO #getPermissionsOnEntity_tempOutputTable
            SELECT DISTINCT Sec.roleId, Sec.permissionID
            FROM UMSecurityAssociations Sec
                INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
                    ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
            WHERE
                (@skipCommcellSecurityCheck = 0 AND entityType1 = 1 AND entityId1 = 2)
                OR (entityType1 = @entityType1 AND Sec.includeAll = 1)
                OR (entityType1 = @entityType1 AND entityId1 = @entityId1)
    END
    ELSE            -- Special handling for iDA entities.
    BEGIN
        -- We need parent from hierarchy, on the entity and inherit from children.
        IF @inheritFromChildren = 0
            INSERT INTO #getPermissionsOnEntity_tempOutputTable
                SELECT DISTINCT Sec.roleId,Sec.permissionID
                FROM UMSecurityAssociations Sec
                    INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
                        ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
                WHERE
                    (@skipCommcellSecurityCheck = 0 AND Sec.entityType1 = 1 AND Sec.entityId1 = 2)
                    OR (Sec.entityType1 = @entityType1 AND Sec.includeAll = 1)
                    OR (Sec.entityType1 = @entityType1 AND Sec.entityId1 = @entityId1
                        AND (Sec.entityType2 = 0 OR (@entityTypeReq > 3 AND Sec.entityType2 = @entityType2 AND Sec.entityId2 = @entityId2))
                        AND (Sec.entityType3 = 0 OR (@entityTypeReq > 4 AND Sec.entityType3 = @entityType3 AND Sec.entityId3 = @entityId3))
                        AND (Sec.entityType4 = 0 OR (@entityTypeReq > 5 AND Sec.entityType4 = @entityType4 AND Sec.entityId4 = @entityId4))
                        AND (Sec.entityType5 = 0 OR (@entityTypeReq > 6 AND Sec.entityType5 = @entityType5 AND Sec.entityId5 = @entityId5))
                        )
        ELSE
        BEGIN
        -- Special handling for clientId=2 and inheritFromChildren=1. Should not consider entityType2<>1030.
            IF @entityTypeReq = 3 AND @entityId1 = 2
                INSERT INTO #getPermissionsOnEntity_tempOutputTable
                    SELECT DISTINCT Sec.roleId, Sec.permissionID
                    FROM UMSecurityAssociations Sec
                        INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
                            ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
                    WHERE
                        (@skipCommcellSecurityCheck = 0 AND Sec.entityType1 = 1 AND Sec.entityId1 = 2)
                        OR (Sec.entityType1 = @entityType1 AND Sec.includeAll = 1)
                        OR (Sec.entityType1 = @entityType1 AND Sec.entityId1 = @entityId1 AND Sec.entityId2 <> 1030)
            ELSE
                INSERT INTO #getPermissionsOnEntity_tempOutputTable
                    SELECT DISTINCT Sec.roleId,Sec.permissionID
                    FROM UMSecurityAssociations Sec
                        INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
                            ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
                    WHERE
                        (@skipCommcellSecurityCheck = 0 AND Sec.entityType1 = 1 AND Sec.entityId1 = 2)
                        OR (Sec.entityType1 = @entityType1 AND Sec.includeAll = 1)
                        OR (Sec.entityType1 = @entityType1 AND Sec.entityId1 = @entityId1
                            AND (Sec.entityType2 = 0 OR @entityTypeReq < 4 OR (Sec.entityType2 = @entityType2 AND Sec.entityId2 = @entityId2))
                            AND (Sec.entityType3 = 0 OR @entityTypeReq < 5 OR (Sec.entityType3 = @entityType3 AND Sec.entityId3 = @entityId3))
                            AND (Sec.entityType4 = 0 OR @entityTypeReq < 6 OR (Sec.entityType4 = @entityType4 AND Sec.entityId4 = @entityId4))
                            AND (Sec.entityType5 = 0 OR @entityTypeReq < 7 OR (Sec.entityType5 = @entityType5 AND Sec.entityId5 = @entityId5))
                            )
        END
        -- VSA Subclient expansion.
        -- Get permissions from hypervisor client and its parents as well.
        IF @vsaClientID <> 0
        BEGIN
            INSERT INTO #getPermissionsOnEntity_tempOutputTable
                SELECT DISTINCT Sec.roleId, Sec.permissionId
                FROM UMSecurityAssociations Sec
                    INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
                        ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
                    INNER JOIN #VSAEntities VSA
                        ON Sec.entityType1 = VSA.entityType1 AND Sec.entityId1 = VSA.entityId1
                            AND (Sec.entityType2 = 0 OR Sec.entityId2 = VSA.entityId2)
                            AND (Sec.entityType3 = 0 OR Sec.entityId3 = VSA.entityId3)
                            AND (Sec.entityType4 = 0 OR Sec.entityId4 = VSA.entityId4)
                            AND (Sec.entityType5 = 0 OR Sec.entityId5 = VSA.entityId5)
        END
    END
END
IF @skipOwnerPermissions = 0
BEGIN
    -- Owners handling.
    BEGIN
        DECLARE @isUserOwner BIT = 0
        SELECT @isUserOwner = 1
        FROM UMOwners O
                INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
                    ON O.isUser = UG.isUser AND O.userOrGroupId = UG.userOrGroupId
        WHERE
            entityType = @entityType1 AND entityId = @entityID1
        IF @isUserOwner = 1
            INSERT INTO #getPermissionsOnEntity_tempOutputTable
                SELECT R.roleId,R.permissionId
                FROM UMOwnerRoles R
                        INNER JOIN #getPermissionsOnEntity_dynamicParentEntities E
                            ON R.entityType = E.entityType AND R.entityId = E.entityId
                UNION
                SELECT R.roleId, R.permissionId
                FROM UMOwnerRoles R
                WHERE
                    entityType = @entityType1 AND entityId = @entityId1
                    OR (entityType = 1 AND entityId = 2)
        -- VSA subclient expansion
        -- Get permissions from hypervisor client and its parents as well. (if user is owner of hypervisor client).
        BEGIN
            IF EXISTS (SELECT TOP 1 1
                        FROM UMOwners Sec
                            INNER JOIN #getMemberUserGroupsHelperOutputTbl U
                                ON Sec.isUser = U.isUser AND Sec.userORGroupId = U.userOrGroupId
                            INNER JOIN #VSAEntities VSA
                                ON Sec.entityTYpe = VSA.entityTYpe1 AND Sec.entityId = VSA.entityID1)
            BEGIN
                INSERT INTO #getPermissionsOnEntity_tempOutputTable
                    SELECT Sec.roleId, Sec.permissionId
                    FROM UMOwnerRoles Sec
                        INNER JOIN #VSAEntities VSA         -- This tabe already has parents.
                            ON Sec.entityType = VSA.entityType1 AND Sec.entityId = VSA.entityId1
            END
        END
    END
END
PROC_EXIT:
IF @includeNotMappedPermission = 0
    SET @dynamicSQLStr = 'INSERT INTO ' + @tableOutput
                        + CHAR(10)
                        + ' SELECT RPE.permissionId
                            FROM #getPermissionsOnEntity_tempOutputTable T
                                    INNER JOIN UMRolesWithPermissionsExpanded RPE
                                        ON T.roleID = RPE.roleId
                                    INNER JOIN UMPermissionEntityTypeMap UPE
                                        ON RPE.permissionId = UPE.permissionId
                                    INNER JOIN UMRoles R
                                        ON R.id = RPE.roleID
                            WHERE
                                UPE.entityType IN (0,' + CAST(@entityTypeReq AS VARCHAR(10)) + ')
                                AND R.disabled = 0
                            UNION
                            SELECT T.permissionID
                            FROM #getPermissionsOnEntity_tempOutputTable T
                                INNER JOIN UMPermissionEntityTypeMap UPE
                                    ON T.permissionId = UPE.permissionId
                            WHERE
                                UPE.entityType IN (0, ' + CAST(@entityTypeReq AS VARCHAR(10)) + ')'
ELSE
    SET @dynamicSQLStr = 'INSERT INTO ' + @tableOutput
                        + CHAR(10)
                        + ' SELECT RPE.permissionId
                            FROM #getPermissionsOnEntity_tempOutputTable T
                                    INNER JOIN UMRolesWithPermissionsExpanded RPE
                                        ON T.roleID = RPE.roleId
                                    INNER JOIN UMRoles R
                                        ON R.id = RPE.roleID
                            WHERE
                                R.disabled = 0
                            UNION
                            SELECT T.permissionID
                            FROM #getPermissionsOnEntity_tempOutputTable T
                            WHERE T.permissionId <> 0'
EXEC (@dynamicSQLStr)
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getPermissionsOnEntity_old')
	delete from GxQscripts where name = 'sec_getPermissionsOnEntity_old'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getPermissionsOnEntity_old')
	delete from GXDBVersions where aliasname = 'sec_getPermissionsOnEntity_old'
GO

insert into GXDBVersions values(2, 'sec_getPermissionsOnEntity_old',  '00000000000000000000', 'sec_getPermissionsOnEntity_old', '00000000000000000000')
GO

