

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getPermissionsOnEntityType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- -----------------------------------------------------------------------------------------------------
--
--	SP: sec_getPermissionsOnEntityType
--
--	Description: Gets list of permissions that user has on given entity type.
--				 Appln layer code can either pass one entity type in @entityType
--				 or can send a list of entity types in external table
--				 #getPermissionOnEntityType_entityType.
--
--				Output will be a list of entity types and permissions.
--				(entityTYpe INT, permissionId INT)
--	Author:	jswaminathan
-- -----------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getPermissionsOnEntityType')
BEGIN
	print '>>> Drop Stored Procedure: sec_getPermissionsOnEntityType <<<'
	drop procedure sec_getPermissionsOnEntityType
END
IF EXISTS (select * from GxQscripts where name='sec_getPermissionsOnEntityType')
	delete from GxQscripts where name = 'sec_getPermissionsOnEntityType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getPermissionsOnEntityType')
	delete from GXDBVersions where aliasname = 'sec_getPermissionsOnEntityType'
GO
print '... Creating Procedure: sec_getPermissionsOnEntityType'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getPermissionsOnEntityType
  @userId INT,
  @entityType INT = -1	
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @extTableProvided TINYINT = 1
IF @entityType <> -1
BEGIN
	IF OBJECT_ID('tempdb.dbo.#getPermissionOnEntityType_entityType') IS NOT NULL
		DROP TABLE #getPermissionOnEntityType_entityType
	CREATE TABLE #getPermissionOnEntityType_entityType (entityType INT)
	INSERT INTO #getPermissionOnEntityType_entityType (entityType)
		SELECT @entityType
	SET @extTableProvided = 0
END
--User groups this user belongs to.
DECLARE @userAndGroupId TABLE (userOrGroupId INT, isUser INT)
IF OBJECT_ID('tempdb.dbo.#userGroupId') IS NOT NULL
	DROP TABLE #usergroupId
CREATE TABLE #userGroupId (userGroupId INT)
EXEC sec_getMemberUserGroups @userId
INSERT INTO @userAndGroupId
	SELECT userGroupId, 0
	FROM #userGroupId
	UNION
	SELECT @userId, 1
DROP TABLE #userGroupId
--Output table.
IF OBJECT_ID('tempdb.dbo.#getPermissionOnEntityType_permissionIdsOutput') IS NOT NULL
	DROP TABLE #getPermissionOnEntityType_permissionIdsOutput
CREATE TABLE #getPermissionOnEntityType_permissionIdsOutput (entityTYpe INT, permissionId INT)
-- Special handling for entityType = 0. If entityType = 0, then we just need to get list of permissions
-- that this user has on any entity.
DECLARE @requestToGetAllPermissionsAcrossCommcell TINYINT = 0
SELECT @requestToGetAllPermissionsAcrossCommcell = 1
FROM #getPermissionOnEntityType_entityType
WHERE
	entityType = 0
IF @requestToGetAllPermissionsAcrossCommcell = 1
BEGIN
	INSERT INTO #getPermissionOnEntityType_permissionIdsOutput
		SELECT DISTINCT 0, Sec.permissionId
		FROM UMSecurityAssociations Sec
				INNER JOIN @userAndGroupId UG
					ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
		WHERE
			Sec.permissionId > 0
	INSERT INTO #getPermissionOnEntityType_permissionIdsOutput
		SELECT DISTINCT 0, RPE.permissionId
		FROM UMSecurityAssociations Sec
				INNER JOIN @userAndGroupId UG
					ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
				INNER JOIN UMRolesWithPermissionsExpanded RPE
					ON Sec.roleId = RPE.roleId
		WHERE
			Sec.roleId > 0
END
ELSE
BEGIN
	--Commcell.
	INSERT INTO #getPermissionOnEntityType_permissionIdsOutput
		SELECT DISTINCT ET.entityType, Sec.permissionId
		FROM UMSecurityAssociations Sec
				INNER JOIN @userAndGroupId UG
					ON Sec.isUser = Ug.isUser AND Sec.userOrGroupId = UG.userOrGroupId
				INNER JOIN #getPermissionOnEntityType_entityType ET
					ON 1 = 1				-- Permission on commcell is applicable on all entity types.
		WHERE
			Sec.entityType1 = 1 AND Sec.entityId1 = 2							--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
			AND Sec.permissionId > 0
	INSERT INTO #getPermissionOnEntityType_permissionIdsOutput
		SELECT DISTINCT ET.entityType, RPE.permissionId
		FROM UMSecurityAssociations Sec
				INNER JOIN @userAndGroupId UG
					ON Sec.isUser = Ug.isUser AND Sec.userOrGroupId = UG.userOrGroupId
				INNER JOIN UMRolesWithPermissionsExpanded RPE
					ON Sec.roleID = RPE.roleID
				INNER JOIN #getPermissionOnEntityType_entityType ET
					ON 1 = 1
		WHERE
			Sec.entityType1 = 1 AND Sec.entityId1 = 2							--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
			AND Sec.roleID > 0
	--Entity.
	DECLARE @isIdaEntityPresent TINYINT = 0
	DECLARE @isIdaEntityPresentWithoutClient TINYINT = 0
	SELECT @isIdaEntityPresent = 1
	FROM #getPermissionOnEntityType_entityType
	WHERE
		entityType IN (4,5,6,7)												--APPTYPE_ENTITY, INSTANCE_ENTITY, BACKUPSET_ENTITY, SUBCLIENT_ENTITY
	IF @isIdaEntityPresent = 1
		AND NOT EXISTS (
						SELECT 1
						FROM #getPermissionOnEntityType_entityType ET
						WHERE
							entityType = 3									--CLIENT_ENTITY
						)
	BEGIN
		INSERT INTO #getPermissionOnEntityType_entityType
			SELECT 3	-- Done for easy calculations.						--CLIENT_ENTITY
		SET @isIdaEntityPresentWithoutClient = 1
	END
	INSERT INTO #getPermissionOnEntityType_permissionIdsOutput
		SELECT DISTINCT ET.entityType, permissionId
		FROM UMSecurityAssociations Sec
				INNER JOIN #getPermissionOnEntityType_entityType ET
					ON Sec.entityType1 = ET.entityType AND Sec.entityTYpe2 = 0
				INNER JOIN @userAndGroupId UG
					ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
		WHERE
			Sec.permissionId > 0
	INSERT INTO #getPermissionOnEntityType_permissionIdsOutput
		SELECT DISTINCT ET.entityTYpe, RPE.permissionId
		FROM UMSecurityAssociations Sec
				INNER JOIN #getPermissionOnEntityType_entityType ET
					ON Sec.entityType1 = ET.entityType AND Sec.entityTYpe2 = 0
				INNER JOIN @userAndGroupId UG
					ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
				INNER JOIN UMRolesWithPermissionsExpanded RPE
					ON Sec.roleID = RPE.roleID
		WHERE
			Sec.roleId > 0
	IF @isIdaEntityPresent = 1
	BEGIN
		INSERT INTO #getPermissionOnEntityType_permissionIdsOutput
			SELECT DISTINCT ET.entityTYpe, permissionId
			FROM UMSecurityAssociations Sec
					INNER JOIN #getPermissionOnEntityType_entityType ET
						ON Sec.entityType1 = 3																	--CLIENT_ENTITY
						AND (Sec.entityType2 > 0)			-- Client rows are already processed. We are querying only from apptype now.
						AND (Sec.entityType3 = 0 OR ET.entityType >= 5)											--INSTANCE_ENTITY
						AND (Sec.entityType4 = 0 OR ET.entityType >= 6)											--BACKUPSET_ENTITY
						AND (Sec.entityTYpe5 = 0 OR ET.entityTYpe >= 7)											--SUBCLIENT_ENTITY
					INNER JOIN @userAndGroupId UG
						ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
			WHERE
				Sec.permissionId > 0
				AND ET.entityType IN (4,5,6,7)																	--APPTYPE_ENTITY,INSTANCE_ENTITY,BACKUPSET_ENTITY,SUBCLIENT_ENTITY
		INSERT INTO #getPermissionOnEntityType_permissionIdsOutput
			SELECT DISTINCT ET.entityTYpe, RPe.permissionId
			FROM UMSecurityAssociations Sec
					INNER JOIN #getPermissionOnEntityType_entityType ET
						ON Sec.entityType1 = 3																	--CLIENT_ENTITY
						AND (Sec.entityType2 > 0)			-- Client rows are already processed. We are querying only from apptype now.
						AND (Sec.entityType3 = 0 OR ET.entityType >= 5)											--INSTANCE_ENTITY
						AND (Sec.entityType4 = 0 OR ET.entityType >= 6)											--BACKUPSET_ENTITY
						AND (Sec.entityTYpe5 = 0 OR ET.entityTYpe >= 7)											--SUBCLIENT_ENTITY
					INNER JOIN @userAndGroupId UG
						ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
					INNER JOIN UMRolesWithPermissionsExpanded RPE
						ON RPE.roleId = Sec.roleId
			WHERE
				Sec.roleID > 0
				AND ET.entityType IN (4,5,6,7)																	--APPTYPE_ENTITY,INSTANCE_ENTITY,BACKUPSET_ENTITY,SUBCLIENT_ENTITY
	END
	--Parent
	IF EXISTS
		(
			SELECT TOP 1 1
			FROM App_EntityParentAssociation
			WHERE
				childEntityType IN (SELECT entityType FROM #getPermissionOnEntityType_entityType)
		)
	BEGIN
		INSERT INTO #getPermissionOnEntityType_permissionIdsOutput
			SELECT DISTINCT ET.entityType, permissionId
			FROM UMSecurityAssociations Sec
					INNER JOIN App_EntityParentAssociation PC
						ON Sec.entityType1 = PC.parentEntityType
					INNER JOIN #getPermissionOnEntityType_entityType ET
						ON PC.childEntityType = ET.entityType
					INNER JOIN @userAndGroupId UG
						ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
			WHERE
				Sec.permissionId > 0
		INSERT INTO #getPermissionOnEntityType_permissionIdsOutput
			SELECT DISTINCT ET.entityType, RPE.permissionId
			FROM UMSecurityAssociations Sec
					INNER JOIN App_EntityParentAssociation PC
						ON Sec.entityType1 = PC.parentEntityType
					INNER JOIN #getPermissionOnEntityType_entityType ET
						ON PC.childEntityType = ET.entityType
					INNER JOIN @userAndGroupId UG
						ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
					INNER JOIN UMRolesWithPermissionsExpanded RPE
						ON RPE.roleId = Sec.roleID
			WHERE
				Sec.roleId > 0
	END
END
-- Owners.
DECLARE @isOwner INT = 0
IF OBJECT_ID('tempdb.dbo.#ownerEntities') IS NOT NULL
	DROP TABLE #ownerEntities
CREATE TABLE #ownerEntities (entityType INT, entityId INT)
-- TR 181126-659: Added missing clustered index.
CREATE CLUSTERED INDEX ownerEntities_Idx1 ON #ownerEntities (entityType, entityId)
IF @requestToGetAllPermissionsAcrossCommcell = 0
BEGIN
INSERT INTO #ownerEntities				-- Including only owner of the entity as such. Today we support only client owners.
	SELECT Owners.entityType, entityId
	FROM UMOwners Owners
		INNER JOIN @userAndGroupId UG
			ON Owners.isUser = UG.isUser AND Owners.userOrGroupId = UG.userOrGroupId
		INNER JOIN #getPermissionOnEntityType_entityType ET
			ON Owners.entityType = ET.entityType
END
ELSE
BEGIN
	INSERT INTO #ownerEntities				-- Include all entities for whom this user / group is owner.
		SELECT Owners.entityType, entityId
		FROM UMOwners Owners
			INNER JOIN @userAndGroupId UG
				ON Owners.isUser = UG.isUser AND Owners.userOrGroupId = UG.userOrGroupId
END
IF EXISTS (
			SELECT TOP 1 1
			FROM #ownerEntities
			)
BEGIN
	INSERT INTO #getPermissionOnEntityType_permissionIdsOutput
		SELECT DISTINCT OE.entityType, RPE.permissionId
		FROM UMOwnerRoles R
			INNER JOIN UMRolesWithPermissionsExpanded RPE
				ON R.roleId = RPE.roleId
			INNER JOIN #ownerEntities OE
				ON R.entityType = 1 AND R.entityId = 2										--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
		UNION
		SELECT DISTINCT OE.entityType, RPE.permissionId
		FROM UMOwnerRoles R
			INNER JOIN UMRolesWithPermissionsExpanded RPE
				ON R.roleId = RPE.roleId
			INNER JOIN #ownerEntities OE
				ON R.entityType = OE.entityType AND R.entityId = OE.entityId
	-- TR 181126-659: Not having them in UNION reduces time. We anyways have a DISTINCT before giving final output. So having duplicate here does not affect.
	INSERT INTO #getPermissionOnEntityType_permissionIdsOutput
		SELECT DISTINCT OE.entityType, RPE.permissionId
		FROM UMOwnerRoles R
			INNER JOIN UMRolesWithPermissionsExpanded RPE
				ON R.roleId = RPE.roleId
			INNER JOIN APP_ClientGroupAssoc	CGA		-- We have only client and client  group owner permissions now.
				ON r.entityType = 28 AND R.entityId = CGA.clientGroupId						--CLIENT_GROUP_ENTITY
			INNER JOIN #ownerEntities OE
				ON CGA.clientId = OE.entityId AND OE.entityType = 3							--CLIENT_ENTITY
END
IF @isIdaEntityPresent = 1
BEGIN
	-- Copy permissions like Owners, etc. to iDA entities also.
	INSERT INTO #getPermissionOnEntityType_permissionIdsOutput
			SELECT DISTINCT ET.entityType, P.permissionId
			FROM #getPermissionOnEntityType_permissionIdsOutput P
				INNER JOIN #getPermissionOnEntityType_entityType ET
					ON P.entityTYpe = 3 AND ET.entityType IN (4,5,6,7)						--CLIENT_ENTITY,APPTYPE_ENTITY,INSTANCE_ENTITY,BACKUPSET_ENTITY,SUBCLIENT_ENTITY
END
IF @isIdaEntityPresentWithoutClient = 1
BEGIN
	-- Client was explicitly inserted.
	DELETE
	FROM #getPermissionOnEntityType_permissionIdsOutput
	WHERE
		entityTYpe = 3																		--CLIENT_ENTITY
END
-- Remove unapplicable permissions.
IF @requestToGetAllPermissionsAcrossCommcell = 0				-- If request is for all permissions, then do not bother about unapplicable permissions.
BEGIN
	DELETE P
	FROM #getPermissionOnEntityType_permissionIdsOutput P
			LEFT OUTER JOIN UMPermissionEntityTypeMap PE
			ON  P.permissionId = PE.permissionId
				AND (P.entityTYpe = PE.entityType OR PE.entityType = 0)
	WHERE
		PE.entityType IS NULL
END
IF @extTableProvided = 0
BEGIN
	IF OBJECT_ID('tempdb.dbo.#getPermissionOnEntityType_entityType') IS NOT NULL
		DROP TABLE #getPermissionOnEntityType_entityType
END
SELECT DISTINCT *
FROM #getPermissionOnEntityType_permissionIdsOutput
ORDER BY entityType, permissionId
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getPermissionsOnEntityType')
	delete from GxQscripts where name = 'sec_getPermissionsOnEntityType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getPermissionsOnEntityType')
	delete from GXDBVersions where aliasname = 'sec_getPermissionsOnEntityType'
GO

insert into GXDBVersions values(2, 'sec_getPermissionsOnEntityType',  '00000000000000000000', 'sec_getPermissionsOnEntityType', '00000000000000000000')
GO

