

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getPermissionsOnEntity.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "sec_GetPermissionsOnEntity"
--	|	This Procedure is used to get all permissions for a user on a entity
-- 	+-----------------------------------------------------------------------+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getPermissionsOnEntity')
BEGIN
	print '>>> Drop Stored Procedure: sec_getPermissionsOnEntity <<<'
	drop procedure sec_getPermissionsOnEntity
END
IF EXISTS (select * from GxQscripts where name='sec_getPermissionsOnEntity')
	delete from GxQscripts where name = 'sec_getPermissionsOnEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getPermissionsOnEntity')
	delete from GXDBVersions where aliasname = 'sec_getPermissionsOnEntity'
GO
print '... Creating Procedure: sec_getPermissionsOnEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getPermissionsOnEntity
  @tableOutput NVARCHAR(MAX),
  @userId INTEGER,
  @entityType1 INTEGER,
  @entityId1 INTEGER,
  @entityType2 INTEGER = 0,
  @entityId2 INTEGER = 0,
  @entityType3 INTEGER = 0,
  @entityId3 INTEGER = 0,
  @entityType4 INTEGER = 0,
  @entityId4 INTEGER = 0,
  @entityType5 INTEGER = 0,
  @entityId5 INTEGER = 0,
  @inheritFromChildren INTEGER = 0,
  @includeNotMappedPermission INT = 0,
  @skipClassicPermissions INT = 0,
  @skipOwnerPermissions INT = 0
AS
BEGIN TRY
	declare @os int  = (select simOperatingSystemId from APP_Client with (NOLOCK) where id = 2)
	declare @orientdb int
	select @orientdb = (select cast(value as int) from GXGlobalParam with (NOLOCK) where name = 'OrientDB Enabled')
	declare @orientDBServiceReady int = 0
	set @orientDBServiceReady = (select cast(value as int) from GXGlobalParam with (NOLOCK) where name = 'OrientDB Service Ready')
if (@os = 210 and (@orientdb IS NOT NULL) and @orientdb <> 0 and ((@orientDBServiceReady IS NOT NULL) and @orientDBServiceReady <> 0))
	BEGIN
		exec dbo.GetPermissionsOnEntityWrapper @tableOutput,@userId,@entityType1,@entityId1,@entityType2,@entityId2,@entityType3,@entityId3,@entityType4,@entityId4,@entityType5,@entityId5,@inheritFromChildren,@includeNotMappedPermission,@skipClassicPermissions,@skipOwnerPermissions
	END
	ELSE
	BEGIN
		exec dbo.sec_getPermissionsOnEntity_old @tableOutput,@userId,@entityType1,@entityId1,@entityType2,@entityId2,@entityType3,@entityId3,@entityType4,@entityId4,@entityType5,@entityId5,@inheritFromChildren,@includeNotMappedPermission,@skipClassicPermissions,@skipOwnerPermissions
	END
END try
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR);
	THROW;
END CATCH

IF EXISTS (select * from GxQscripts where name = 'sec_getPermissionsOnEntity')
	delete from GxQscripts where name = 'sec_getPermissionsOnEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getPermissionsOnEntity')
	delete from GXDBVersions where aliasname = 'sec_getPermissionsOnEntity'
GO

insert into GXDBVersions values(2, 'sec_getPermissionsOnEntity',  '00000000000000000000', 'sec_getPermissionsOnEntity', '00000000000000000000')
GO

