

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getPermissionsOnEntities.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- -----------------------------------------------------------------------------------------------
--
--	SP: sec_getPermissionsOnEntities
--
--	Description: This SP gets list of permissions that user has on given entities.
--				 Input should be userId,
--								 entityType,
--								 inheritFromChildren (= 1 means will get from iDA,backupset,subclient)
--								 skipOwners (= 1 means Owner associations will be skipped)
--								 skipClassicSecurity (= 1 means Classic Security will be skipped)
--								 getOnlyIfOwners (= 1 means gets only owned entities)
--								 ownersAlreadyComputed (= 1 means only owned entities are passed, so owner validation will be skipped)
--								 tempTable #getPermissionsOnEntities_InputTable (Refer to comments section)
--								 tempTable #getPermissionsOnEntities_OutputTable (Refer to comments section)
--
--	Author:	jswaminathan
-- ----------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getPermissionsOnEntities <<<'

IF EXISTS (select * from sysobjects where name='sec_getPermissionsOnEntities')
	drop procedure sec_getPermissionsOnEntities
IF EXISTS (select * from GxQscripts where name='sec_getPermissionsOnEntities')
	delete from GxQscripts where name = 'sec_getPermissionsOnEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getPermissionsOnEntities')
	delete from GXDBVersions where aliasname = 'sec_getPermissionsOnEntities'
GO
print '... Creating Procedure: sec_getPermissionsOnEntities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getPermissionsOnEntities
  @userID INT,
  @entityType INT,
  @inheritFromChildren INT = 0,
  @skipOwners INT = 0,
  @skipClassicSecurity INT = 0,
  @getOnlyIfOwners INT = 0,
  @ownersAlreadyComputed INT = 0
AS
--IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_InputTable') IS NOT NULL
--	DROP TABLE #getPermissionsOnEntities_InputTable
--CREATE TABLE #getPermissionsOnEntities_InputTable
--(
--	entityId1 INT,
--	entityId2 INT DEFAULT 0,
--	entityId3 INT DEFAULT 0,
--	entityId4 INT DEFAULT 0,
--	entityId5 INT DEFAULT 0
--)
--IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_OutputTable') IS NOT NULL
--	DROP TABLE #getPermissionsOnEntities_OutputTable
--CREATE TABLE #getPermissionsOnEntities_OutputTable
--(
--	entityId1 INT,
--	entityId2 INT,
--	entityId3 INT,
--	entityId4 INT,
--	entityId5 INT,
--	permissionsString VARCHAR(512),
--	isChildRow BIT DEFAULT 0
--)
--set @userID = 4
--set @entityType = 3
--set @inheritFromChildren = 1
--insert into #getPermissionsOnEntities_InputTable
--	values (3,33,0,0,0)
--	,(4,33,0,0,0)
--	,(2,33,0,0,0)
-- Body
DECLARE @dynamicSQLStr VARCHAR(MAX) = ''
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_TempTable') IS NOT NULL
	DROP TABLE #getPermissionsOnEntities_TempTable
CREATE TABLE #getPermissionsOnEntities_TempTable
(
	entityType INT,
	entityId1 INT,
	entityId2 INT DEFAULT 0,
	entityId3 INT DEFAULT 0,
	entityId4 INT DEFAULT 0,
	entityId5 INT DEFAULT 0,
	roleID INT,
	permissionId INT,
	includeAll INT DEFAULT 0,
	isParentRow BIT DEFAULT 0,
	isIndirectParentRow BIT DEFAULT 0,				-- Indicates commcell,include all,etc.
	isChildRow BIT DEFAULT 0
)
CREATE CLUSTERED INDEX getPermissionsOnEntities_TempTable_Idx1 ON #getPermissionsOnEntities_TempTable (isParentRow, isIndirectParentRow, includeAll)
-- Get user groups for this user.
BEGIN
	IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') IS NOT NULL
		DROP TABLE #getMemberUserGroupsHelperOutputTbl
	CREATE TABLE #getMemberUserGroupsHelperOutputTbl
	(
		isUser INT,
		userOrGroupId INT,
		UNIQUE CLUSTERED (isUser, userOrGroupId)
	)
	EXEC sec_getMemberUserGroupsHelper @userID
END
-- Get metadata for this entity type.
BEGIN
	DECLARE @entityFlags INT = 0,
			@skipCommcellCheck BIT = 0,
			@isIdaEntity BIT = 0
	SELECT @entityFlags = flags
	FROM APP_Entity
	WHERE
		entityType = @entityType
IF @entityFlags & 0x004 <> 0							-- 0x004
		SET @skipCommcellCheck = 1
IF @entityType IN (3, 4, 5, 6, 7)							-- 3,4,5,6,7
		SET @isIdaEntity = 1
END
-- Get the parents of given entities.
BEGIN
DECLARE @childEntityTypeForParentTableComputation INT = CASE WHEN @isIdaEntity = 1 THEN 3 ELSE @entityType END			-- For iDA entities, we need to query APp_EntityParentAssociation table on Client entity.
	IF OBJECT_ID ('tempdb.dbo.#getPermissionsOnEntities_ParentChildTable') IS NOT NULL
		DROP TABLE #getPermissionsOnEntities_ParentChildTable
	CREATE TABLE #getPermissionsOnEntities_ParentChildTable
	(
		parentEntityType INT,
		parentEntityId INT,
		entityId1 INT,
		entityId2 INT DEFAULT 0,
		entityId3 INT DEFAULT 0,
		entityId4 INT DEFAULT 0,
		entityId5 INT DEFAULT 0,
		includeAll INT DEFAULT 0,
		isIndirectParentRow INT DEFAULT 0			-- Indicates commcell,include all,etc.
	)
	CREATE CLUSTERED INDEX getPermissionsOnEntities_ParentChildTable_Idx1 ON #getPermissionsOnEntities_ParentChildTable (isIndirectParentRow, includeAll, parentEntityType, parentEntityId)
	-- Direct parents.
	IF EXISTS (SELECT TOP 1 1
			   FROM App_EntityParentAssociation
			   WHERE
				childEntityType = @childEntityTypeForParentTableComputation)
	BEGIN
		SET @dynamicSQLStr = 'INSERT INTO #getPermissionsOnEntities_parentChildTable (parentEntityType, parentEntityId, entityId1, entityId2, entityId3, entityId4, entityId5)'
								+ CHAR(10)
								+ 'SELECT Tbl.parentEntityType, Tbl.parentId, Input.entityId1, Input.entityId2, Input.entityId3, Input.entityId4, Input.entityId5 '
								+ CHAR(10)
								+ 'FROM ('
								+ CHAR(10)
								+ SUBSTRING
									(
										(
											SELECT			'UNION'
															+ CHAR(10)			-- New line character
															+ CAST(associationQuery AS VARCHAR(MAX))
															+ CHAR(10)
											FROM App_EntityParentAssociation PE
											WHERE
												PE.childEntityType = @childEntityTypeForParentTableComputation
											FOR XML PATH (''), TYPE
										).value('.','NVARCHAR(MAX)'),				-- There may be < or > symbols that are XML encoded into &lt; and &gt; Doing a .value removes that encoding.
										6,				-- Exclude the first UNION
										2147483647		-- MAX
									)
								+ ')Tbl'
								+ CHAR(10)
								+ 'INNER JOIN #getPermissionsOnEntities_InputTable Input
									ON Tbl.childId = Input.entityId1'
		EXEC (@dynamicSQLStr)
	END
END
-- Owners.
IF @skipOwners = 0
BEGIN
	DECLARE @entityTypeForOwnerComputation INT = @childEntityTypeForParentTableComputation -- CASE WHEN @isIdaEntity = 1 THEN 3 ELSE @entityType END				-- For iDA entities, we need to query Owners table on Client entity.
	-- Compute owned entities.
	IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_OwnedEntities') IS NOT NULL
		DROP TABLE #getPermissionsOnEntities_OwnedEntities
	CREATE TABLE #getPermissionsOnEntities_OwnedEntities
	(
		entityId1 INT,
		entityId2 INT,
		entityId3 INT,
		entityId4 INT,
		entityId5 INT
	)
	CREATE CLUSTERED INDEX getPermissionsOnEntities_OwnedEntities_Idx1 ON #getPermissionsOnEntities_OwnedEntities (entityId1)
	IF @ownersAlreadyComputed = 0		-- If this is 1, then this SP is already called with only owner entities. SO no need to check for ownership agian.
	BEGIN
		-- Direct ownership.
		INSERT INTO #getPermissionsOnEntities_OwnedEntities
			SELECT Input.entityId1, Input.entityId2, Input.entityId3, Input.entityId4, Input.entityId5
			FROM UMOwners O
				INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
					ON O.isUser = UG.isUser AND O.userOrGroupId = UG.userOrGroupId
				INNER JOIN #getPermissionsOnEntities_InputTable Input
					ON O.entityId = Input.entityId1
			WHERE
				O.entityType = @entityTypeForOwnerComputation
		-- Owners on parents.
		INSERT INTO #getPermissionsOnEntities_OwnedEntities
			SELECT PC.entityId1, PC.entityId2, PC.entityId3, PC.entityId4, PC.entityId5
			FROM UMOwners O
				INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
					ON O.isUser = UG.isUser AND O.userOrGroupId = UG.userOrGroupId
				INNER JOIN #getPermissionsOnEntities_ParentChildTable PC
					ON O.entityType = PC.parentEntityType AND O.entityId = PC.parentEntityId
	END
	ELSE
	BEGIN
		INSERT INTO #getPermissionsOnEntities_OwnedEntities
			SELECT Input.entityId1, Input.entityId2, Input.entityId3, Input.entityId4, Input.entityId5
			FROM #getPermissionsOnEntities_InputTable Input
	END
	-- This is Nipa's requirement, where she needs only entities owned by this user. For them, she needs both classic+owner associations.
	IF @getOnlyIfOwners = 1
	BEGIN
		DELETE Input
		FROM #getPermissionsOnEntities_InputTable Input
			 LEFT JOIN #getPermissionsOnEntities_OwnedEntities Owners
				ON Input.entityId1 = Owners.entityId1
		WHERE
			Owners.entityId1 IS NULL
		DELETE Input
		FROM #getPermissionsOnEntities_ParentChildTable Input
			 LEFT JOIN #getPermissionsOnEntities_OwnedEntities Owners
				ON Input.entityId1 = Owners.entityId1
		WHERE
			Owners.entityId1 IS NULL
	END
	-- Get owner permissions on these owned entities.
	INSERT INTO #getPermissionsOnEntities_TempTable (entityType, entityId1, entityId2, entityId3, entityId4, entityId5, roleId, permissionId)
		SELECT @entityType, O.entityId1, O.entityId2, O.entityId3, O.entityId4, O.entityId5, R.roleId, R.permissionId
		FROM UMOwnerRoles R
			INNER JOIN #getPermissionsOnEntities_OwnedEntities O
				ON R.entityId = O.entityId1
		WHERE
			R.entityType = @entityTypeForOwnerComputation
	-- Get owner permissions from parents. (Expand them to their children right away).
	INSERT INTO #getPermissionsOnEntities_TempTable (entityType, entityId1, entityId2, entityId3, entityId4, entityId5, roleId, permissionId)
		SELECT @entityType, PC.entityId1, PC.entityId2, PC.entityId3, PC.entityId4, PC.entityId5, R.roleId, R.permissionId
		FROM UMOwnerRoles R
			INNER JOIN #getPermissionsOnEntities_ParentChildTable PC
				ON R.entityType = PC.parentEntityType AND R.entityId = PC.parentEntityId
			INNER JOIN #getPermissionsOnEntities_OwnedEntities O
				ON PC.entityId1 = O.entityID1
	-- Commcell owner role.
	-- Load it separately and then extend it on all @ownerEntities.
	-- This will not be covered in above step. Since childEntityType = 0 and childEntityId = 0 in Parent table for commcell row.
	DECLARE @commcellOwnerRole INT = 0
	SELECT @commcellOwnerRole = roleID
	FROM UMOwnerRoles
	WHERE
		entityType = 1 AND entityId = 2				-- COMMCELL_ENTITY
	IF @commcellOwnerRole <> 0
		INSERT INTO #getPermissionsOnEntities_TempTable (entityType, entityId1, entityId2, entityId3, entityId4, entityId5, roleId, permissionId)
			SELECT @entityType, entityId1, entityId2, entityId3, entityId4, entityId5, @commcellOwnerRole, 0
			FROM #getPermissionsOnEntities_OwnedEntities
END
-- Classic security associations.
IF @skipClassicSecurity = 0
BEGIN
	-- On the entity.
	IF @isIdaEntity = 0
	BEGIN
		INSERT INTO #getPermissionsOnEntities_TempTable (entityType,entityId1,roleId,permissionId)
			SELECT @entityType, Input.entityId1, Sec.roleId, Sec.permissionId
			FROM UMSecurityAssociations Sec
				INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
					ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
				INNER JOIN #getPermissionsOnEntities_InputTable Input
					ON Sec.entityId1 = Input.entityId1
			WHERE
				Sec.entityType1 = @entityType
	END
	ELSE				-- This portion of code will get everything for iDA entities.
	BEGIN				-- It will get parent, on the entity and children.
						-- Since the code will get complex if we try to put it generic, writing individually for each entity type.
IF @entityType = 3
		BEGIN
			IF @inheritFromChildren = 0
			BEGIN
				INSERT INTO #getPermissionsOnEntities_TempTable (entityType, entityId1, entityId2, entityId3, entityId4, entityId5, roleId, permissionId)
					SELECT @entityType, I.entityId1, I.entityId2, I.entityId3, I.entityId4, I.entityId5, Sec.roleId, Sec.permissionID
					FROM UMSecurityAssociations Sec
						INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
							ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
						INNER JOIN #getPermissionsOnEntities_InputTable I
							ON Sec.entityId1 = I.entityId1
							AND (Sec.entityId2 = 0)
							AND (Sec.entityId3 = 0)
							AND (Sec.entityId4 = 0)
							AND (Sec.entityId5 = 0)
					WHERE
Sec.entityType1 = 3
			END
			ELSE
			BEGIN
				INSERT INTO #getPermissionsOnEntities_TempTable (entityType, entityId1, entityId2, entityId3, entityId4, entityId5, roleId, permissionId, isChildRow)
					SELECT @entityType, I.entityId1, I.entityId2, I.entityId3, I.entityId4, I.entityId5, Sec.roleId, Sec.permissionID, CASE WHEN entityType2 > 0 THEN 1 ELSE 0 END
					FROM UMSecurityAssociations Sec
						INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
							ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
						INNER JOIN #getPermissionsOnEntities_InputTable I
							ON Sec.entityId1 = I.entityId1
					WHERE
Sec.entityType1 = 3
			END
		END
ELSE IF @entityType = 4
		BEGIN
			IF @inheritFromChildren = 0
			BEGIN
				INSERT INTO #getPermissionsOnEntities_TempTable (entityType, entityId1, entityId2, entityId3, entityId4, entityId5, roleId, permissionId)
					SELECT @entityType, I.entityId1, I.entityId2, I.entityId3, I.entityId4, I.entityId5, Sec.roleId, Sec.permissionID
					FROM UMSecurityAssociations Sec
						INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
							ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
						INNER JOIN #getPermissionsOnEntities_InputTable I
							ON Sec.entityId1 = I.entityId1
AND ((Sec.entityId2 = 0) OR (Sec.entityType2 = 4 AND Sec.entityId2 = I.entityId2))
							AND (Sec.entityId3 = 0)
							AND (Sec.entityId4 = 0)
							AND (Sec.entityId5 = 0)
					WHERE
Sec.entityType1 = 3
			END
			ELSE
			BEGIN
				INSERT INTO #getPermissionsOnEntities_TempTable (entityType, entityId1, entityId2, entityId3, entityId4, entityId5, roleId, permissionId, isChildRow)
					SELECT @entityType, I.entityId1, I.entityId2, I.entityId3, I.entityId4, I.entityId5, Sec.roleId, Sec.permissionID, CASE WHEN entityType3 > 0 THEN 1 ELSE 0 END
					FROM UMSecurityAssociations Sec
						INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
							ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
						INNER JOIN #getPermissionsOnEntities_InputTable I
							ON Sec.entityId1 = I.entityId1
AND (Sec.entityId2 = 0 OR (Sec.entityType2 = 4 AND Sec.entityId2 = I.entityId2))
					WHERE
Sec.entityType1 = 3
			END
		END
ELSE IF @entityType = 5
		BEGIN
			IF @inheritFromChildren = 0
			BEGIN
				INSERT INTO #getPermissionsOnEntities_TempTable (entityType, entityId1, entityId2, entityId3, entityId4, entityId5, roleId, permissionId)
					SELECT @entityType, I.entityId1, I.entityId2, I.entityId3, I.entityId4, I.entityId5, Sec.roleId, Sec.permissionID
					FROM UMSecurityAssociations Sec
						INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
							ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
						INNER JOIN #getPermissionsOnEntities_InputTable I
							ON Sec.entityId1 = I.entityId1
AND ((Sec.entityId2 = 0) OR (Sec.entityType2 = 4 AND Sec.entityId2 = I.entityId2))
AND ((Sec.entityId3 = 0) OR (Sec.entityType3 = 5 AND Sec.entityId3 = I.entityId3))
							AND (Sec.entityId4 = 0)
							AND (Sec.entityId5 = 0)
					WHERE
Sec.entityType1 = 3
			END
			ELSE
			BEGIN
				INSERT INTO #getPermissionsOnEntities_TempTable (entityType, entityId1, entityId2, entityId3, entityId4, entityId5, roleId, permissionId, isChildRow)
					SELECT @entityType, I.entityId1, I.entityId2, I.entityId3, I.entityId4, I.entityId5, Sec.roleId, Sec.permissionID, CASE WHEN entityType4 > 0 THEN 1 ELSE 0 END
					FROM UMSecurityAssociations Sec
						INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
							ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
						INNER JOIN #getPermissionsOnEntities_InputTable I
							ON Sec.entityId1 = I.entityId1
AND (Sec.entityId2 = 0 OR (Sec.entityType2 = 4 AND Sec.entityId2 = I.entityId2))
AND (Sec.entityId3 = 0 OR (Sec.entityType3 = 5 AND Sec.entityId3 = I.entityId3))
					WHERE
Sec.entityType1 = 3
			END
		END
ELSE IF @entityType = 6
		BEGIN
			IF @inheritFromChildren = 0
			BEGIN
				INSERT INTO #getPermissionsOnEntities_TempTable (entityType, entityId1, entityId2, entityId3, entityId4, entityId5, roleId, permissionId)
					SELECT @entityType, I.entityId1, I.entityId2, I.entityId3, I.entityId4, I.entityId5, Sec.roleId, Sec.permissionID
					FROM UMSecurityAssociations Sec
						INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
							ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
						INNER JOIN #getPermissionsOnEntities_InputTable I
							ON Sec.entityId1 = I.entityId1
AND ((Sec.entityId2 = 0) OR (Sec.entityType2 = 4 AND Sec.entityId2 = I.entityId2))
AND ((Sec.entityId3 = 0) OR (Sec.entityType3 = 5 AND Sec.entityId3 = I.entityId3))
AND ((Sec.entityId4 = 0) OR (Sec.entityType4 = 6 AND Sec.entityId4 = I.entityId4))
							AND (Sec.entityId5 = 0)
					WHERE
Sec.entityType1 = 3
			END
			ELSE
			BEGIN
				INSERT INTO #getPermissionsOnEntities_TempTable (entityType, entityId1, entityId2, entityId3, entityId4, entityId5, roleId, permissionId, isChildRow)
					SELECT @entityType, I.entityId1, I.entityId2, I.entityId3, I.entityId4, I.entityId5, Sec.roleId, Sec.permissionID, CASE WHEN entityType5 > 0 THEN 1 ELSE 0 END
					FROM UMSecurityAssociations Sec
						INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
							ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
						INNER JOIN #getPermissionsOnEntities_InputTable I
							ON Sec.entityId1 = I.entityId1
AND (Sec.entityId2 = 0 OR (Sec.entityType2 = 4 AND Sec.entityId2 = I.entityId2))
AND (Sec.entityId3 = 0 OR (Sec.entityType3 = 5 AND Sec.entityId3 = I.entityId3))
AND (Sec.entityId4 = 0 OR (Sec.entityType4 = 6 AND Sec.entityId4 = I.entityId4))
					WHERE
Sec.entityType1 = 3
			END
		END
ELSE IF @entityType = 7
		BEGIN
			INSERT INTO #getPermissionsOnEntities_TempTable (entityType, entityId1, entityId2, entityId3, entityId4, entityId5, roleId, permissionId)
				SELECT @entityType, I.entityId1, I.entityId2, I.entityId3, I.entityId4, I.entityId5, Sec.roleId, Sec.permissionID
				FROM UMSecurityAssociations Sec
					INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
						ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
					INNER JOIN #getPermissionsOnEntities_InputTable I
						ON Sec.entityId1 = I.entityId1
AND ((Sec.entityId2 = 0) OR (Sec.entityType2 = 4 AND Sec.entityId2 = I.entityId2))
AND ((Sec.entityId3 = 0) OR (Sec.entityType3 = 5 AND Sec.entityId3 = I.entityId3))
AND ((Sec.entityId4 = 0) OR (Sec.entityType4 = 6 AND Sec.entityId4 = I.entityId4))
AND ((Sec.entityId5 = 0) OR (Sec.entityType5 = 7 AND Sec.entityId5 = I.entityId5))
				WHERE
Sec.entityType1 = 3
		END
	END
	-- From parent.
	-- Store the parent association on the parent entity itself. We can expand to child when inserting into output temp table.
	-- A single client group can contain 10000 clients. No need to save the client group associations 10000 times.
	BEGIN
		IF @skipCommcellCheck = 0
			INSERT INTO #getPermissionsOnEntities_ParentChildTable (parentEntityType, parentEntityId, entityID1, isIndirectParentRow)
VALUES (1, 2, 0, 1)
		DECLARE @entityTypeForIncludeAllComputation INT = @childEntityTypeForParentTableComputation		-- CASE WHEN @isIdaEntity = 1 THEN 3 ELSE @entityType END				-- For iDA entities, we need to query UMSecurityAssociations table on Client entity for include all computation.
		INSERT INTO #getPermissionsOnEntities_ParentChildTable (parentEntityType, parentEntityId, entityId1, isIndirectParentRow, includeAll)			-- includeAll parents.
			SELECT DISTINCT parentEntityType,0,0,1,1
			FROM #getPermissionsOnEntities_ParentChildTable
		INSERT INTO #getPermissionsOnEntities_ParentChildTable (parentEntityType, parentEntityId, entityId1, isIndirectParentRow, includeAll)			-- includeAll of this entity type.
			VALUES (@entityTypeForIncludeAllComputation,0,0,1,1)
		INSERT INTO #getPermissionsOnEntities_TempTable (entityType, entityId1, roleId, permissionId, isIndirectParentRow, isParentRow, includeALl)
			SELECT Sec.entityType1, Sec.entityId1, Sec.roleId, Sec.permissionId, PCET.isIndirectParentRow, 1, Sec.includeAll
			FROM (
					SELECT DISTINCT parentEntityType, parentEntityId, isIndirectParentRow, includeAll
					FROM #getPermissionsOnEntities_ParentChildTable PC
				 )PCET
					INNER JOIN UMSecurityAssociations Sec
						ON PCET.parentEntityType = Sec.entityType1 AND PCET.parentEntityId = Sec.entityId1 AND PCET.includeAll = Sec.includeAll
					INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
						ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
	END
END
-- Populate output table.
BEGIN
DECLARE @permissionsSeedString VARCHAR(512) = REPLICATE('0',512)
DECLARE @allEntitiesPermissionsString VARCHAR(512) = @permissionsSeedString,
			@allEntitiesAssociationsExist BIT = 0
	-- Precompute permissions bit mask on Commcell, includeAll entities.
	SELECT @allEntitiesAssociationsExist = 1
	FROM #getPermissionsOnEntities_TempTable T
		LEFT JOIN UMROles R
			ON T.roleId = R.id
	WHERE
		(
			(T.isParentRow = 1 AND T.isIndirectParentRow = 1 AND T.entityType = 1 AND T.entityId1 = 2)				-- Commcell row
			OR (T.isParentRow = 1 AND T.isIndirectParentRow = 1 AND T.includeAll = 1 AND T.entityType = @entityTypeForIncludeAllComputation)		-- Include all
		)
		AND
		(
			T.roleId = 0 OR R.disabled = 0
		)
	-- Now expand direct parents, on the entity and include all parent relations.
	INSERT INTO #getPermissionsOnEntities_OutputTable
		SELECT Tbl.entityId1, Tbl.entityId2, Tbl.entityId3, Tbl.entityId4, Tbl.entityId5, dbo.BitwiseORString(CASE WHEN R.id > 0 THEN R.permissionsString ELSE STUFF(@permissionsSeedString,Tbl.permissionId,1,'1') END), Tbl.isChildRow
		FROM
				(
					SELECT I.entityId1, I.entityId2, I.entityId3, I.entityId4, I.entityId5, T.roleId, T.permissionId, 0 AS isChildRow
					FROM #getPermissionsOnEntities_TempTable T
						INNER JOIN #getPermissionsOnEntities_ParentChildTable I
							ON T.entityType = I.parentEntityType
					WHERE
						T.isParentRow = 1 AND T.isIndirectParentRow = 1 AND T.includeAll = 1 AND I.isIndirectParentRow = 0 			-- Indirect parent expansion from T (include all) to direct parents on I.
					UNION
					SELECT I.entityId1, I.entityId2, I.entityId3, I.entityId4, I.entityId5, T.roleId, T.permissionId, 0 AS isChildRow
					FROM #getPermissionsOnEntities_TempTable T
						INNER JOIN #getPermissionsOnEntities_ParentChildTable I
							ON T.entityType = I.parentEntityType AND T.entityId1 = I.parentEntityId
					WHERE
						T.isParentRow = 1 AND T.isIndirectParentRow = 0 AND I.isIndirectParentRow = 0								-- Direct parent expansion
					UNION
					SELECT I.entityId1, I.entityId2, I.entityId3, I.entityId4, I.entityId5, I.roleId, I.permissionId, isChildRow
					FROM #getPermissionsOnEntities_TempTable I
					WHERE
						I.isParentRow = 0																							-- Direct entity,children.
				)Tbl
		LEFT OUTER JOIN UMRoles R
			ON Tbl.roleId = R.id
		WHERE
			Tbl.roleId = 0 OR R.disabled = 0
		GROUP BY Tbl.entityId1, Tbl.entityId2, Tbl.entityId3, Tbl.entityId4, Tbl.entityId5, Tbl.isChildRow
	IF @allEntitiesAssociationsExist = 1
	BEGIN
		SELECT @allEntitiesPermissionsString = dbo.BitwiseORString(CASE WHEN R.id > 0 THEN R.permissionsString ELSE STUFF(@permissionsSeedString,T.permissionId,1,'1') END)
		FROM #getPermissionsOnEntities_TempTable T
			LEFT JOIN UMROles R
				ON T.roleId = R.id
		WHERE
			(
				(T.isParentRow = 1 AND T.isIndirectParentRow = 1 AND T.entityType = 1 AND T.entityId1 = 2)				-- Commcell row
				OR (T.isParentRow = 1 AND T.isIndirectParentRow = 1 AND T.includeAll = 1 AND T.entityType = @entityTypeForIncludeAllComputation)		-- Include all
			)
			AND
			(
				T.roleId = 0 OR R.disabled = 0
			)
		UPDATE #getPermissionsOnEntities_OutputTable
		SET permissionsString = (
									SELECT dbo.BitwiseORString(t1.permissionsString)
									FROM
										(
											SELECT permissionsString
											UNION ALL
											SELECT @allEntitiesPermissionsString
										)t1
								)
		WHERE
			isChildRow = 0				-- Need to apply commcell permissions only for actual entities.
		INSERT INTO #getPermissionsOnEntities_OutputTable
			SELECT I.entityId1, I.entityId2, I.entityId3, I.entityId4, I.entityId5, @allEntitiesPermissionsString, 0
			FROM #getPermissionsOnEntities_InputTable I
				 LEFT JOIN #getPermissionsOnEntities_OutputTable O
					ON I.entityId1 = O.entityId1
					AND I.entityId2 = O.entityId2
					AND I.entityId3 = O.entityId3
					AND I.entityId4 = O.entityId4
					AND I.entityId5 = O.entityId5
			WHERE
				O.entityId1 IS NULL
	END
END
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_OwnedEntities') IS NOT NULL
	DROP TABLE #getPermissionsOnEntities_OwnedEntities
DROP TABLE #getPermissionsOnEntities_TempTable
DROP TABLE #getPermissionsOnEntities_ParentChildTable
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getPermissionsOnEntities')
	delete from GxQscripts where name = 'sec_getPermissionsOnEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getPermissionsOnEntities')
	delete from GXDBVersions where aliasname = 'sec_getPermissionsOnEntities'
GO

insert into GXDBVersions values(2, 'sec_getPermissionsOnEntities',  '00000000000000000000', 'sec_getPermissionsOnEntities', '00000000000000000000')
GO

