

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getPasswordsToRememberForUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_getPasswordsToRememberForUser.sp,v $ $Id: sec_getPasswordsToRememberForUser.sp,v 1.1.2.2 2018/06/25 01:58:35 mupadhyay Exp $";
--gets the number of passwords to remembered for a user
--passwords to remember can be set at commserv level, usergroup level, organization level
--this sp gives the maximum among the set value
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getPasswordsToRememberForUser <<<'

IF EXISTS (select * from sysobjects where name='sec_getPasswordsToRememberForUser')
	drop procedure sec_getPasswordsToRememberForUser
IF EXISTS (select * from GxQscripts where name='sec_getPasswordsToRememberForUser')
	delete from GxQscripts where name = 'sec_getPasswordsToRememberForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getPasswordsToRememberForUser')
	delete from GXDBVersions where aliasname = 'sec_getPasswordsToRememberForUser'
GO
print '... Creating Procedure: sec_getPasswordsToRememberForUser'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getPasswordsToRememberForUser
  @userId INT,
  @numberOfPasswords INT OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @numberOfPasswords = 0
--if user is an external user, return 0
DECLARE @providerId INT=0
DECLARE @providerType INT=0
SELECT @providerId = umDSproviderId FROM UMUsers WHERE id = @userId
IF @providerId <> 0
BEGIN
	SELECT @providerType = serviceType FROM UMDSProviders WHERE id = @providerId
IF @providerType<>5
		RETURN
END
IF OBJECT_ID('tempdb.dbo.#userGroupId') IS NOT NULL
	DROP TABLE #userGroupId
CREATE TABLE #userGroupId (userGroupId INT)
EXEC sec_getMemberUserGroups @userId
SELECT @numberOfPasswords = MAX(PswdHistoryCnt) FROM (
SELECT ISNULL(attrVal,0) as PswdHistoryCnt
		 FROM UMGroupsProp Prop
INNER JOIN #userGroupId UG ON UG.userGroupId = Prop.componentNameId AND Prop.attrName = 'Password History Count'
		 WHERE Prop.modified=0
UNION
SELECT ISNULL(Prop.attrVal,0) as PswdHistoryCnt
		FROM UMDSProviderProp Prop
WHERE @providerId = Prop.componentNameId AND Prop.attrName = 'Password History Count'
		AND  Prop.modified=0
UNION
SELECT value as PswdHistoryCnt  FROM GxGlobalParam WHERE name = 'Password History Count' AND modified=0
)A
SELECT @numberOfPasswords = ISNULL(@numberOfPasswords,0)
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getPasswordsToRememberForUser')
	delete from GxQscripts where name = 'sec_getPasswordsToRememberForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getPasswordsToRememberForUser')
	delete from GXDBVersions where aliasname = 'sec_getPasswordsToRememberForUser'
GO

insert into GXDBVersions values(2, 'sec_getPasswordsToRememberForUser',  '00010001000200020000', 'sec_getPasswordsToRememberForUser', '00010001000200020000')
GO

