

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getPasswordExpiryTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  | Name:  sec_getPasswordExpiryTime()
--  | Description: determines expiry date of the password of a particular user,
--	|          based on the agePassworddays property of the user and user group
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getPasswordExpiryTime <<<'

IF EXISTS (select * from sysobjects where name='sec_getPasswordExpiryTime')
	drop procedure sec_getPasswordExpiryTime
IF EXISTS (select * from GxQscripts where name='sec_getPasswordExpiryTime')
	delete from GxQscripts where name = 'sec_getPasswordExpiryTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getPasswordExpiryTime')
	delete from GXDBVersions where aliasname = 'sec_getPasswordExpiryTime'
GO
print '... Creating Procedure: sec_getPasswordExpiryTime'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getPasswordExpiryTime
  @i_userId integer,
  @i_localeId integer
AS
SET NOCOUNT ON
  DECLARE @o_expiryDate VARCHAR(64)
DECLARE @isAdmin int = 0
DECLARE @isExternalUser int = 0
DECLARE @agePasswordDays int = 0
DECLARE @agePasswordDaysUserLevel int = 0
DECLARE @passwordSetDate int = 0
DECLARE @secondsPerDay int = 24*60*60
DECLARE @today datetime = convert(date, GETDATE())
DECLARE @UserGroupsForUser table(userGroupId int)
SET @o_expiryDate = ''
IF EXISTS(SELECT 1 FROM APP_AdvanceSettings
  WITH (NOLOCK)					WHERE entityId = 2 -- Commcell level
					AND entityType = 3 --CLIENT_ENTITY
					AND keyName = N'bAuditPasswordExpiryDate'
					AND value LIKE 'true'
					AND relativePath = N'CommServDB.Console'
					AND type = N'BOOLEAN'
					AND enabled = 1
					AND deleted = 0)
BEGIN
SELECT @isExternalUser = umDSProviderId,
	   @agePasswordDaysUserLevel = policy,
	   @passwordSetDate = datePasswordSet,
@isAdmin = flags & 0x040
	   FROM UMUsers WITH(NOLOCK) WHERE id = @i_userId
--password donot age for external users and admin
IF @isExternalUser = 0  and @isAdmin = 0
	BEGIN
		INSERT INTO @UserGroupsForUser
		SELECT groupId FROM UMUserGroup WITH(NOLOCK) WHERE userId = @i_userId
		DELETE UG
		FROM @UserGroupsForUser UG
		INNER JOIN UMGroups  WITH (NOLOCK) ON UG.userGroupId = UMGroups.id
WHERE UMGroups.groupFlags & 0x0001 = 0
		SELECT @agePasswordDays = isnull (MIN(cast (attrval as integer)),0) FROM UMGroupsProp UGProp WITH(NOLOCK)
		INNER JOIN @UserGroupsForUser UGroup ON UGroup.userGroupId=UGProp.componentNameId
AND UGProp.attrname='Age Password in Days'
		WHERE attrVal <> 0 and modified=0
		IF @agePasswordDays = 0 or (@agePasswordDaysUserLevel <> 0 and @agePasswordDaysUserLevel < @agePasswordDays)
			SET @agePasswordDays = @agePasswordDaysUserLevel
		IF @agePasswordDays > 0
		BEGIN
			SET @o_expiryDate = CONVERT(varchar(23),dbo.UTCToCellLocalTime(dbo.getdatetime(@passwordSetDate + @agePasswordDays * @secondsPerDay),2),120)
		END
		ELSE
		BEGIN
SET @o_expiryDate = (select message from EvLocaleMsgs WITH (NOLOCK) Where [messageId] = (1618 | (CAST(POWER(2, 24) AS BIGINT) * 85)) AND [localeId] = @i_localeId )
		END
	END
END
SELECT @o_expiryDate
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getPasswordExpiryTime')
	delete from GxQscripts where name = 'sec_getPasswordExpiryTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getPasswordExpiryTime')
	delete from GXDBVersions where aliasname = 'sec_getPasswordExpiryTime'
GO

insert into GXDBVersions values(2, 'sec_getPasswordExpiryTime',  '00000000000000000000', 'sec_getPasswordExpiryTime', '00000000000000000000')
GO

