

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getOwnerUserGroupsForThisUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  sec_getOwnerUserGroupsForThisUser()
--  |
--  | Description:  Fetches a list of user groups this callerId can select as owner of an entity
--	|
--  |
--  |       Input:  callerId, parentProviderId
--	|			1. If user has 'Change Security Settings' permission on Commcell then we need all user groups
--	|			2. Else we need only member user groups.
--	|			3. If parentProviderId > 0 then retrun groups of that provider only
--	|
--  |      Output:  List of user groups
--  |      Return:  xxx
--  |
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getOwnerUserGroupsForThisUser <<<'

IF EXISTS (select * from sysobjects where name='sec_getOwnerUserGroupsForThisUser')
	drop procedure sec_getOwnerUserGroupsForThisUser
IF EXISTS (select * from GxQscripts where name='sec_getOwnerUserGroupsForThisUser')
	delete from GxQscripts where name = 'sec_getOwnerUserGroupsForThisUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getOwnerUserGroupsForThisUser')
	delete from GXDBVersions where aliasname = 'sec_getOwnerUserGroupsForThisUser'
GO
print '... Creating Procedure: sec_getOwnerUserGroupsForThisUser'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getOwnerUserGroupsForThisUser
  @tableOutput NVARCHAR(MAX),
  @callerId INT, 
  @parentProviderId INT = 0			
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF @callerId = 0
	RETURN
DECLARE @isAdminUser INT = 0
EXEC sec_checkPermissionOnEntity @callerId, 107, @isAdminUser OUTPUT, 1, 2
IF OBJECT_ID('tempdb.dbo.#userGroupId') IS NOT NULL
	DROP TABLE #userGroupId
CREATE TABLE #userGroupId
(
	userGroupId INT
)
DECLARE @isRestrictedViewEnabled INT = ISNULL(CAST( (SELECT TOP (1) value FROM GXGlobalParam WHERE name = 'Restricted View Enabled' AND modified = 0) AS INT), 0)
IF @isAdminUser <> 0
BEGIN
	INSERT INTO #userGroupId
	SELECT id FROM UMGroups
	WHERE groupFlags & 1 = 1
AND groupFlags & 0x0010 = 0
		AND (@isRestrictedViewEnabled > 0 OR name <> 'CV_Restricted_Visibility')
		AND name <> 'Common Outlook Add-Ins'
		AND (@parentProviderId = 0 OR umdsProviderId = @parentProviderId)	-- Filter based on parent providerId if it is not 0
END
ELSE
BEGIN
	EXEC sec_getMemberUserGroups @callerId
	DELETE Tbl
	FROM #userGroupId Tbl
		INNER JOIN UMGroups G
			ON Tbl.userGroupId = G.id
WHERE G.groupFlags & 0x0010 = 0x0010
			OR (@isRestrictedViewEnabled <= 0 AND G.name = 'CV_Restricted_Visibility')
			OR G.name = 'Common Outlook Add-Ins'
			OR (@parentProviderId <> 0 AND G.umdsProviderId <> @parentProviderId)  -- Filter based on parent providerId if it is not 0
END
DECLARE @outputstatement AS NVARCHAR(MAX)
SET @outputstatement = 'INSERT INTO '+ @tableOutput +
					   ' SELECT DISTINCT userGroupId FROM #userGroupId'
EXEC (@outputstatement)
IF OBJECT_ID('tempdb.dbo.#userGroupId') IS NOT NULL
	DROP TABLE #userGroupId
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getOwnerUserGroupsForThisUser')
	delete from GxQscripts where name = 'sec_getOwnerUserGroupsForThisUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getOwnerUserGroupsForThisUser')
	delete from GXDBVersions where aliasname = 'sec_getOwnerUserGroupsForThisUser'
GO

insert into GXDBVersions values(2, 'sec_getOwnerUserGroupsForThisUser',  '00000000000000000000', 'sec_getOwnerUserGroupsForThisUser', '00000000000000000000')
GO

