

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getOwnerPermissionsWrapper.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +====================================================================================================================================+
--  |   Procedure:  sec_getOwnerPermissionsWrapper
--  |
--  | Description: to get owner permissions set on specific entity ( wrapper on sec_getOwnerPermission function )
--  |
--  |   isReturnPermissionIdORMask=0 return permissionIDs integer
--	|							  =1 return capabilityId
--	|
--	|	Authors: saggarwal & jswaminathan
--  +====================================================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getOwnerPermissionsWrapper <<<'

IF EXISTS (select * from sysobjects where name='sec_getOwnerPermissionsWrapper')
	drop procedure sec_getOwnerPermissionsWrapper
IF EXISTS (select * from GxQscripts where name='sec_getOwnerPermissionsWrapper')
	delete from GxQscripts where name = 'sec_getOwnerPermissionsWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getOwnerPermissionsWrapper')
	delete from GXDBVersions where aliasname = 'sec_getOwnerPermissionsWrapper'
GO
print '... Creating Procedure: sec_getOwnerPermissionsWrapper'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getOwnerPermissionsWrapper
  @entityType integer,
  @entityId integer,
  @isReturnPermissionIdORMask integer =0
AS
  DECLARE @permissionId integer
	If(@isReturnPermissionIdORMask=0)
		SELECT permissionId
		FROM dbo.sec_getOwnerPermissions(@entityType,@entityId)
	ELSE
		SELECT  dbo.sec_permissionToCapability(permissionId)
		FROM dbo.sec_getOwnerPermissions(@entityType,@entityId)
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getOwnerPermissionsWrapper')
	delete from GxQscripts where name = 'sec_getOwnerPermissionsWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getOwnerPermissionsWrapper')
	delete from GXDBVersions where aliasname = 'sec_getOwnerPermissionsWrapper'
GO

insert into GXDBVersions values(2, 'sec_getOwnerPermissionsWrapper',  '00000000000000000000', 'sec_getOwnerPermissionsWrapper', '00000000000000000000')
GO

