

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getOwnedObjects.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- -----------------------------------------------------------------------------------------------
--
--	SP: sec_getOwnedObjects
--
--	Description: This SP gets list of objects that user owns of given entity type.
--				 Input should be userId,
--								 entityType,
--								 tempTable #getOwnedObjects_OutputTable (look comments section for definition),
--								 getPermissions (flag).
--				If getPermissions is set, it will go deep and get permissions on these owned entities too.
--				(Getting permissions too would have performance impact. So set it only if you really need permissions).
--
--	Author:	jswaminathan
-- ----------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getOwnedObjects <<<'

IF EXISTS (select * from sysobjects where name='sec_getOwnedObjects')
	drop procedure sec_getOwnedObjects
IF EXISTS (select * from GxQscripts where name='sec_getOwnedObjects')
	delete from GxQscripts where name = 'sec_getOwnedObjects'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getOwnedObjects')
	delete from GXDBVersions where aliasname = 'sec_getOwnedObjects'
GO
print '... Creating Procedure: sec_getOwnedObjects'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getOwnedObjects
  @userID INT,
  @entityType INT,
  @getPermissions INT = 0
AS
--IF OBJECT_ID('tempdb.dbo.#getOwnedObjects_OutputTable') IS NOT NULL
--		DROP TABLE #getOwnedObjects_OutputTable
--CREATE TABLE #getOwnedObjects_OutputTable
--(
--	entityId1 INT,
--	entityId2 INT,
--	entityId3 INT,
--	entityId4 INT,
--	entityId5 INT,
--	permissionsString VARCHAR(512),
--	isChildRow BIT DEFAULT 0
--)
-- Get user groups for this user.
BEGIN
	IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') IS NOT NULL
		DROP TABLE #getMemberUserGroupsHelperOutputTbl
	CREATE TABLE #getMemberUserGroupsHelperOutputTbl
	(
		isUser INT,
		userOrGroupId INT,
		UNIQUE CLUSTERED (isUser, userOrGroupId)
	)
	EXEC sec_getMemberUserGroupsHelper @userID
END
-- Get owned objects.
BEGIN
	DECLARE @isIdaEntity BIT = CASE WHEN @entityType IN (3,4,5,6,7) THEN 1 ELSE 0 END
	DECLARE @childEntityTypeForParentTableComputation INT = CASE WHEN @isIdaEntity = 1 THEN 3 ELSE @entityType END			-- CLIENT_ENTITY = 3; For iDA entities, we need to query APp_EntityParentAssociation table on Client entity.
	DECLARE @entityTypeForOwnerComputation INT = @childEntityTypeForParentTableComputation -- CASE WHEN @isIdaEntity = 1 THEN 3 ELSE @entityType END				-- For iDA entities, we need to query Owners table on Client entity.
	IF OBJECT_ID('tempdb.dbo.#getOwnedObjects_TempTable') IS NOT NULL
		DROP TABLE #getOwnedObjects_TempTable
	CREATE TABLE #getOwnedObjects_TempTable
	(
		entityType INT,
		entityId INT
	)
	CREATE CLUSTERED INDEX getOwnedObjects_TempTable_Idx1 ON #getOwnedObjects_TempTable (entityId);
	-- Get entities on which he is a direct owner.
	INSERT INTO #getOwnedObjects_TempTable
		SELECT U.entityType, U.entityId
		FROM UMOwners U
			INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
				ON U.isUser = UG.isUser AND U.userOrGroupId = UG.userOrGroupId
		WHERE
			entityType = @entityTypeForOwnerComputation
	-- Get entities on which he is owner of parent.
	DECLARE @dynamicSQLStr VARCHAR(MAX) = ''
	SET @dynamicSQLStr = 'INSERT INTO #getOwnedObjects_TempTable'
						+ CHAR (10)
						+ 'SELECT Tbl.childEntityType, Tbl.childId
							FROM UMOwners U
								INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
									ON U.isUser = UG.isUser AND U.userOrGroupId = UG.userOrGroupId
								INNER JOIN ('
						+ CHAR(10)
						+ SUBSTRING
										(
											(
												SELECT			'UNION'
																+ CHAR(10)			-- New line character
																+ CAST(associationQuery AS VARCHAR(MAX))
																+ CHAR(10)
												FROM App_EntityParentAssociation PE
												WHERE
													PE.childEntityType = @childEntityTypeForParentTableComputation
												FOR XML PATH (''), TYPE
											).value('.','NVARCHAR(MAX)'),				-- There may be < or > symbols that are XML encoded into &lt; and &gt; Doing a .value removes that encoding.
											6,				-- Exclude the first UNION
											2147483647		-- MAX
										)
						+ CHAR(10)
						+ ')Tbl
									ON U.entityType = Tbl.parentEntityType AND U.entityId = Tbl.parentId'
	EXEC (@dynamicSQLStr)
END
DROP TABLE #getMemberUserGroupsHelperOutputTbl
-- Fill output table.
BEGIN
	IF @entityType = 4			-- We need to expand clients to appType,instance,backupset or subclient.
		INSERT INTO #getOwnedObjects_OutputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
			SELECT I.clientId, I.appTypeId, 0, 0, 0
			FROM APP_IdaName I
				INNER JOIN #getOwnedObjects_TempTable T
					ON I.clientId = T.entityId
	ELSE IF @entityType = 5
		INSERT INTO #getOwnedObjects_OutputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
			SELECT DISTINCT A.clientId,A.appTypeId,A.instance, 0,0
			FROM APP_Application A
				INNER JOIN #getOwnedObjects_TempTable T
					ON A.clientId = T.entityId
	ELSE IF @entityType = 6
		INSERT INTO #getOwnedObjects_OutputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
			SELECT DISTINCT A.clientId,A.appTypeId,A.instance,A.backupSet,0
			FROM APP_Application A
				INNER JOIN #getOwnedObjects_TempTable T
					ON A.clientId = T.entityId
	ELSE IF @entityType = 7
		INSERT INTO #getOwnedObjects_OutputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
			SELECT A.clientId,A.appTypeId,A.instance,A.backupSet,A.id
			FROM APP_Application A
				INNER JOIN #getOwnedObjects_TempTable T
					ON A.clientId = T.entityId
	ELSE
		INSERT INTO #getOwnedObjects_OutputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
			SELECT entityId, 0, 0, 0, 0
			FROM #getOwnedObjects_TempTable T
END
DROP TABLE #getOwnedObjects_TempTable
-- If caller needs permissions, then we need to call get permissions on entities too. Send output of that to the caller code.
-- This will be a performance killer. Since there are more temp tables involved.
IF @getPermissions = 1
BEGIN
	IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_InputTable') IS NOT NULL
		DROP TABLE #getPermissionsOnEntities_InputTable
	CREATE TABLE #getPermissionsOnEntities_InputTable
	(
		entityId1 INT,
		entityId2 INT DEFAULT 0,
		entityId3 INT DEFAULT 0,
		entityId4 INT DEFAULT 0,
		entityId5 INT DEFAULT 0
	)
	CREATE CLUSTERED INDEX getPermissionsOnEntities_InputTable_Idx1 ON #getPermissionsOnEntities_InputTable (entityId1);
	IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_OutputTable') IS NOT NULL
		DROP TABLE #getPermissionsOnEntities_OutputTable
	CREATE TABLE #getPermissionsOnEntities_OutputTable
	(
		entityId1 INT,
		entityId2 INT,
		entityId3 INT,
		entityId4 INT,
		entityId5 INT,
		permissionsString VARCHAR(512),
		isChildRow BIT DEFAULT 0
	)
	INSERT INTO #getPermissionsOnEntities_InputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
		SELECT entityId1, entityId2, entityId3, entityId4, entityId5
		FROM #getOwnedObjects_OutputTable
	EXEC sec_getPermissionsOnEntities @userId, @entityType, 0, 0, 0, 1, 1
	TRUNCATE TABLE #getOwnedObjects_OutputTable			-- Instead of copying data into this SP's output table, can we ask caller to read from get permissions on entities' output table itself?
	INSERT INTO #getOwnedObjects_OutputTable (entityId1, entityId2, entityId3, entityId4, entityId5, permissionsString, isCHildRow)
		SELECT entityId1 ,
				entityId2 ,
				entityId3 ,
				entityId4 ,
				entityId5 ,
				permissionsString ,
				isChildRow
		FROM #getPermissionsOnEntities_OutputTable
	DROP TABLE #getPermissionsOnEntities_InputTable
	DROP TABLE #getPermissionsOnEntities_OutputTable
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getOwnedObjects')
	delete from GxQscripts where name = 'sec_getOwnedObjects'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getOwnedObjects')
	delete from GXDBVersions where aliasname = 'sec_getOwnedObjects'
GO

insert into GXDBVersions values(2, 'sec_getOwnedObjects',  '00000000000000000000', 'sec_getOwnedObjects', '00000000000000000000')
GO

